/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.decmpfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DecmpfsHeader
implements StructConverter {
    private int compression_magic;
    private int compression_type;
    private long uncompressed_size;
    private byte[] attr_bytes;

    public DecmpfsHeader(BinaryReader reader, int size) throws IOException {
        long index = reader.getPointerIndex();
        this.compression_magic = reader.readNextInt();
        boolean originalEndian = reader.isLittleEndian();
        reader.setLittleEndian(true);
        this.compression_type = reader.readNextInt();
        this.uncompressed_size = reader.readNextLong();
        reader.setLittleEndian(originalEndian);
        long endIndex = index + (long)size + 1L;
        if (endIndex % 2L != 0L) {
            --endIndex;
        }
        long nElements = endIndex - reader.getPointerIndex();
        this.attr_bytes = reader.readNextByteArray((int)nElements);
    }

    public String getCompressionMagic() {
        return StringUtilities.toString((int)this.compression_magic);
    }

    public int getCompressionType() {
        return this.compression_type;
    }

    public long getUncompressedSize() {
        return this.uncompressed_size;
    }

    public byte[] getAttrBytes() {
        return this.attr_bytes;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = StructConverterUtil.parseName(DecmpfsHeader.class);
        StructureDataType struct = new StructureDataType(name + "_" + this.attr_bytes.length, 0);
        struct.add(STRING, 4, "compression_magic", null);
        struct.add(DWORD, "compression_type", null);
        struct.add(QWORD, "uncompressed_size", null);
        if (this.attr_bytes.length > 0) {
            ArrayDataType byteArrayDT = new ArrayDataType(BYTE, this.attr_bytes.length, BYTE.getLength());
            struct.add((DataType)byteArrayDT, "attr_bytes", null);
        }
        return struct;
    }
}

