/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.events.AbstractLocationPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import java.math.BigInteger;

class ByteViewerState {
    private ViewerPosition vp;
    private ByteBlock block;
    private BigInteger offset;
    private Address addr;

    ByteViewerState(ByteBlockSet blockSet, ByteBlockInfo info, ViewerPosition vp) {
        this.block = info.getBlock();
        this.offset = info.getOffset();
        this.vp = vp;
        AbstractLocationPluginEvent event = blockSet.getPluginEvent("", this.block, this.offset, info.getColumn());
        if (event != null && event instanceof ProgramLocationPluginEvent) {
            ProgramLocation loc = ((ProgramLocationPluginEvent)event).getLocation();
            this.addr = loc.getAddress();
        }
    }

    public Address getAddress() {
        return this.addr;
    }

    public String toString() {
        return "ByteViewerState: address=" + String.valueOf(this.addr) + ", view position index==> " + this.vp.getIndexAsInt() + ", view y offset==> " + this.vp.getYOffset();
    }

    ViewerPosition getViewerPosition() {
        return this.vp;
    }

    ByteBlock getBlock() {
        return this.block;
    }

    BigInteger getOffset() {
        return this.offset;
    }
}

