/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GThemeDefaults;
import ghidra.app.util.SymbolInspector;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;

public class VTSymbolRenderer
extends GhidraTableCellRenderer {
    private SymbolInspector inspector;

    public VTSymbolRenderer(ServiceProvider serviceProvider, JComponent repaintComponent) {
        this.inspector = new SymbolInspector(serviceProvider, (Component)repaintComponent);
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        boolean isSelected = data.isSelected();
        this.handleSymbol(value, isSelected);
        return this;
    }

    private void handleSymbol(Object value, boolean isSelected) {
        this.setBold();
        if (!isSelected) {
            Object color = GThemeDefaults.Colors.FOREGROUND;
            if (value instanceof Symbol) {
                Symbol s = (Symbol)value;
                color = this.inspector.getColor(s);
            }
            this.setForeground((Color)color);
        }
    }
}

