/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.parse;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyEOI;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.util.TableEntryKey;
import ghidra.generic.util.datastruct.TreeSetValuedTreeMap;
import java.util.Collection;
import org.apache.commons.collections4.MultiValuedMap;

public class AssemblyParseActionGotoTable {
    protected final MultiValuedMap<TableEntryKey, Action> map = new TreeSetValuedTreeMap();
    protected final MultiValuedMap<Integer, AssemblyTerminal> possibleTerms = new TreeSetValuedTreeMap();

    public boolean put(int fromState, AssemblySymbol next, Action action) {
        if (next instanceof AssemblyTerminal) {
            this.possibleTerms.put((Object)fromState, (Object)((AssemblyTerminal)next));
        }
        return this.map.put((Object)new TableEntryKey(fromState, next), (Object)action);
    }

    public boolean putShift(int fromState, AssemblyTerminal next, int newState) {
        return this.put(fromState, next, new ShiftAction(newState));
    }

    public boolean putReduce(int fromState, AssemblyTerminal next, AssemblyProduction prod) {
        return this.put(fromState, next, new ReduceAction(prod));
    }

    public boolean putGoto(int fromState, AssemblyNonTerminal next, int newState) {
        return this.put(fromState, next, new GotoAction(newState));
    }

    public boolean putAccept(int fromState) {
        return this.put(fromState, AssemblyEOI.EOI, AcceptAction.ACCEPT);
    }

    public Collection<AssemblyTerminal> getExpected(int fromState) {
        return this.possibleTerms.get((Object)fromState);
    }

    public Collection<Action> get(int fromState, AssemblySymbol next) {
        return this.map.get((Object)new TableEntryKey(fromState, next));
    }

    public static class ShiftAction
    extends Action {
        protected int newStateNum;

        public ShiftAction(int newStateNum) {
            this.newStateNum = newStateNum;
        }

        public String toString() {
            return "S" + this.newStateNum;
        }
    }

    public static abstract class Action
    implements Comparable<Action> {
        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            if (!(that instanceof Action)) {
                return false;
            }
            return this.toString().equals(that.toString());
        }

        @Override
        public int compareTo(Action that) {
            return this.toString().compareTo(that.toString());
        }
    }

    public static class ReduceAction
    extends Action {
        protected AssemblyProduction prod;

        public ReduceAction(AssemblyProduction prod) {
            this.prod = prod;
        }

        public String toString() {
            return "R" + this.prod.getIndex();
        }
    }

    public static class GotoAction
    extends Action {
        protected int newStateNum;

        public GotoAction(int newStateNum) {
            this.newStateNum = newStateNum;
        }

        public String toString() {
            return "G" + this.newStateNum;
        }
    }

    public static class AcceptAction
    extends Action {
        public static final AcceptAction ACCEPT = new AcceptAction();

        public String toString() {
            return "acc";
        }
    }
}

