/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.translate;

import docking.action.MenuData;
import ghidra.app.plugin.core.string.translate.AbstractTranslateAction;
import ghidra.app.services.StringTranslationService;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.util.List;

public class TranslateAction
extends AbstractTranslateAction {
    private StringTranslationService service;

    public TranslateAction(String owner, StringTranslationService service) {
        super("Translate with " + service.getTranslationServiceName(), owner, TranslateAction.getCodeViewerMenuData(service), TranslateAction.getDataListMenuData(service));
        this.service = service;
        HelpLocation helpLoc = service.getHelpLocation();
        if (helpLoc != null) {
            this.setHelpLocation(helpLoc);
        }
    }

    private static MenuData getCodeViewerMenuData(StringTranslationService service) {
        return new MenuData(new String[]{"Data", "Translate", service.getTranslationServiceName()}, GROUP);
    }

    private static MenuData getDataListMenuData(StringTranslationService service) {
        return new MenuData(new String[]{"Translate", service.getTranslationServiceName()}, GROUP);
    }

    @Override
    public void actionPerformed(Program program, List<ProgramLocation> dataLocations) {
        this.service.translate(program, dataLocations, StringTranslationService.TranslateOptions.NONE);
    }
}

