/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.asd;

import ghidra.util.Msg;
import java.lang.reflect.Field;

public final class EntryDescriptorID {
    public static final int ENTRY_DATA_FORK = 1;
    public static final int ENTRY_RESOURCE_FORK = 2;
    public static final int ENTRY_REAL_NAME = 3;
    public static final int ENTRY_COMMENT = 4;
    public static final int ENTRY_ICON_BW = 5;
    public static final int ENTRY_ICON_COLOR = 6;
    public static final int ENTRY_FILE_DATE_INFO = 7;
    public static final int ENTRY_FINDER_INFO = 8;
    public static final int ENTRY_MAC_FILE_INFO = 9;
    public static final int ENTRY_PRODOS_FILE_INFO = 10;
    public static final int ENTRY_MSDOS_FILE_INFO = 11;
    public static final int ENTRY_SHORT_NAME = 12;
    public static final int ENTRY_AFP_FILE_INFO = 13;
    public static final int ENTRY_DIRECTORY_ID = 14;

    public static final String convertEntryIdToName(int entryID) {
        Field[] fields;
        for (Field field : fields = EntryDescriptorID.class.getDeclaredFields()) {
            if (!field.getName().startsWith("ENTRY_")) continue;
            try {
                Integer value = (Integer)field.get(null);
                if (value != entryID) continue;
                return field.getName().substring("ENTRY_".length());
            }
            catch (Exception e) {
                Msg.error(EntryDescriptorID.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }
        return "Unrecognized entry id: 0x" + Integer.toHexString(entryID);
    }
}

