/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import generic.stl.Pair;
import ghidra.app.util.Option;
import ghidra.app.util.importer.AutoImporter;
import ghidra.app.util.importer.OptionChooser;
import ghidra.app.util.importer.SingleLoaderFilter;
import ghidra.program.model.address.AddressFactory;
import ghidra.util.Msg;
import java.util.List;

public class LoaderArgsOptionChooser
implements OptionChooser {
    private List<Pair<String, String>> loaderArgs;

    public LoaderArgsOptionChooser(SingleLoaderFilter loaderFilter) {
        this.loaderArgs = loaderFilter.getLoaderArgs();
    }

    @Override
    public List<Option> choose(List<Option> optionChoices, AddressFactory addressFactory) {
        if (this.loaderArgs != null) {
            for (Pair<String, String> pair : this.loaderArgs) {
                String arg = (String)pair.first;
                String val = (String)pair.second;
                boolean foundIt = false;
                for (Option option : optionChoices) {
                    if (option.getArg() == null || !arg.equalsIgnoreCase(option.getArg())) continue;
                    Object oldVal = option.getValue();
                    if (!option.parseAndSetValueByType(val, addressFactory)) {
                        Msg.error(AutoImporter.class, (Object)String.format("Failed to apply \"%s\" to \"%s\" (old: \"%s\", bad: \"%s\")", arg, option.getName(), oldVal, val));
                        return null;
                    }
                    Msg.info(AutoImporter.class, (Object)String.format("Successfully applied \"%s\" to \"%s\" (old: \"%s\", new: \"%s\")", arg, option.getName(), oldVal, val));
                    foundIt = true;
                    break;
                }
                if (foundIt) continue;
                Msg.error(AutoImporter.class, (Object)("Loader does not support " + arg + " argument"));
                return null;
            }
        }
        return optionChoices;
    }
}

