/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import jspecview.common.PanelData;
import jspecview.common.ScriptToken;

public class Parameters {
    public String name;
    public double integralMinY = 0.1;
    public double integralRange = 50.0;
    public double integralOffset = 30.0;
    public boolean integralDrawAll = false;
    public double viewOffset = 0.0;
    public double peakListThreshold = Double.NaN;
    public String peakListInterpolation = "parabolic";
    public int precision = 2;
    protected Map<ScriptToken, Boolean> htBooleans = new Hashtable<ScriptToken, Boolean>();

    public Parameters() {
        this.setBoolean(ScriptToken.TITLEON, true);
        this.setBoolean(ScriptToken.ENABLEZOOM, true);
        this.setBoolean(ScriptToken.DISPLAY2D, true);
        this.setBoolean(ScriptToken.COORDINATESON, true);
        this.setBoolean(ScriptToken.PEAKTABSON, true);
        this.setBoolean(ScriptToken.POINTSONLY, false);
        this.setBoolean(ScriptToken.GRIDON, true);
        this.setBoolean(ScriptToken.XSCALEON, true);
        this.setBoolean(ScriptToken.YSCALEON, true);
        this.setBoolean(ScriptToken.XUNITSON, true);
        this.setBoolean(ScriptToken.YUNITSON, true);
    }

    public Parameters setName(String name) {
        this.name = name;
        return this;
    }

    public Map<ScriptToken, Boolean> getBooleans() {
        return this.htBooleans;
    }

    public boolean setBoolean(ScriptToken st, boolean val) {
        this.htBooleans.put(st, val);
        return val;
    }

    public boolean getBoolean(ScriptToken t) {
        return Boolean.TRUE == this.htBooleans.get((Object)t);
    }

    public static boolean isTrue(String value) {
        return value.length() == 0 || Boolean.parseBoolean(value);
    }

    public static Boolean getTFToggle(String value) {
        return value.equalsIgnoreCase("TOGGLE") ? null : (Parameters.isTrue(value) ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setP(PanelData pd, ScriptToken st, String value) {
        switch (st) {
            default: {
                return;
            }
            case XSCALEON: 
            case YSCALEON: 
            case COORDINATESON: 
            case DISPLAY1D: 
            case DISPLAY2D: 
            case ENABLEZOOM: 
            case GRIDON: 
            case POINTSONLY: 
            case PEAKTABSON: 
            case REVERSEPLOT: 
            case TITLEON: 
            case TITLEBOLDON: 
            case XUNITSON: 
            case YUNITSON: 
        }
        Boolean tfToggle = Parameters.getTFToggle(value);
        if (tfToggle != null) {
            this.setBoolean(st, tfToggle);
        } else {
            if (pd == null) {
                return;
            }
            boolean b = !pd.getBoolean(st);
            switch (st) {
                default: {
                    break;
                }
                case XSCALEON: {
                    this.setBoolean(ScriptToken.XUNITSON, b);
                    pd.setBoolean(ScriptToken.XUNITSON, b);
                    break;
                }
                case YSCALEON: {
                    this.setBoolean(ScriptToken.YUNITSON, b);
                    pd.setBoolean(ScriptToken.YUNITSON, b);
                }
            }
            this.setBoolean(st, b);
        }
        if (pd == null) {
            return;
        }
        pd.setBooleans(this, st);
    }

    public static boolean isMatch(String match, String key) {
        return match == null || key.equalsIgnoreCase(match);
    }

    public static void putInfo(String match, Map<String, Object> info, String key, Object value) {
        if (value != null && Parameters.isMatch(match, key)) {
            info.put(match == null ? key : match, value);
        }
    }
}

