/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowStepProvider;

public class DisableUserStepProvider
implements WorkflowStepProvider {
    private final KeycloakSession session;
    private final Logger log = Logger.getLogger(DisableUserStepProvider.class);

    public DisableUserStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
    }

    public void close() {
    }

    public void run(WorkflowExecutionContext context) {
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, context.getResourceId());
        if (user != null && user.isEnabled()) {
            this.log.debugv("Disabling user {0} ({1})", (Object)user.getUsername(), (Object)user.getId());
            user.setEnabled(false);
        }
    }

    public String getNotificationMessage() {
        return "accountDisableNotificationBody";
    }

    public String getNotificationSubject() {
        return "accountDisableNotificationSubject";
    }
}

