/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.duplicates.statistics;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.gui.duplicates.FilmStatistics;
import mediathek.gui.duplicates.statistics.DuplicateStatisticsTableFormat;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DuplicateStatisticsDialog
extends JDialog {
    private static final String CONFIG_X = "duplicate_statistics_dialog.x";
    private static final String CONFIG_Y = "duplicate_statistics_dialog.y";
    private static final String CONFIG_HEIGHT = "duplicate_statistics_dialog.height";
    private static final String CONFIG_WIDTH = "duplicate_statistics_dialog.width";
    private static final Logger logger = LogManager.getLogger();
    private static final int COL_NUM_WIDTH = 90;
    private static final int IDX_NUM = 1;
    private final AbstractAction action;
    private final DuplicateStatisticsTableFormat tableFormat = new DuplicateStatisticsTableFormat();
    private JTable tblCommon;
    private JLabel lblTotalCommon;
    private JTable tblDuplicates;
    private JLabel lblTotalDuplicates;

    public DuplicateStatisticsDialog(@NotNull Window owner, @NotNull AbstractAction action) {
        super(owner);
        this.action = action;
        this.initComponents();
        this.setupCommonTable();
        this.setupDuplicatesTable();
        this.updateTotalCommonStats();
        this.updateTotalDuplicatesStats();
        this.tblCommon.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.tblDuplicates.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.resizeSenderColumnWidth(this.tblCommon);
        this.resizeSenderColumnWidth(this.tblDuplicates);
        action.setEnabled(false);
        this.restorePosition();
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DuplicateStatisticsDialog this$0;
            {
                DuplicateStatisticsDialog duplicateStatisticsDialog = this$0;
                Objects.requireNonNull(duplicateStatisticsDialog);
                this.this$0 = duplicateStatisticsDialog;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.this$0.savePosition();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePosition() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int x = config.getInt(CONFIG_X);
            int y = config.getInt(CONFIG_Y);
            int width = config.getInt(CONFIG_WIDTH);
            int height = config.getInt(CONFIG_HEIGHT);
            this.setSize(width, height);
            this.setLocation(x, y);
        }
        catch (NoSuchElementException e) {
            this.pack();
        }
        catch (Exception ex) {
            logger.error("Unhandled Exception", (Throwable)ex);
            this.pack();
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePosition() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            Dimension size = this.getSize();
            Point location = this.getLocation();
            config.setProperty(CONFIG_WIDTH, (Object)size.width);
            config.setProperty(CONFIG_HEIGHT, (Object)size.height);
            config.setProperty(CONFIG_X, (Object)location.x);
            config.setProperty(CONFIG_Y, (Object)location.y);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    private void setupDuplicatesTable() {
        EventList<FilmStatistics> dupeStatsList = Daten.getInstance().getDuplicateStatistics();
        SortedList sortedList = new SortedList(dupeStatsList, Comparator.comparing(FilmStatistics::sender));
        AdvancedTableModel model = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)sortedList, (TableFormat)this.tableFormat);
        model.addTableModelListener(e -> this.updateTotalDuplicatesStats());
        this.tblDuplicates.setModel((TableModel)model);
    }

    private void setupCommonTable() {
        EventList<FilmStatistics> commonStats = Daten.getInstance().getCommonStatistics();
        SortedList sortedList = new SortedList(commonStats, Comparator.comparing(FilmStatistics::sender));
        AdvancedTableModel model = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)sortedList, (TableFormat)this.tableFormat);
        model.addTableModelListener(e -> this.updateTotalCommonStats());
        this.tblCommon.setModel((TableModel)model);
    }

    @Override
    public void dispose() {
        this.action.setEnabled(true);
        super.dispose();
    }

    private void resizeSenderColumnWidth(@NotNull JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        int width = 120;
        for (int row = 0; row < table.getRowCount(); ++row) {
            TableCellRenderer renderer = table.getCellRenderer(row, 0);
            Component comp = table.prepareRenderer(renderer, row, 0);
            width = Math.max(comp.getPreferredSize().width + 1, width);
        }
        columnModel.getColumn(0).setPreferredWidth(width);
    }

    private void updateTotalCommonStats() {
        this.resizeSenderColumnWidth(this.tblCommon);
        EventList<FilmStatistics> statisticsList = Daten.getInstance().getCommonStatistics();
        statisticsList.getReadWriteLock().readLock().lock();
        long dupes = 0L;
        for (FilmStatistics item : statisticsList) {
            dupes += item.count();
        }
        statisticsList.getReadWriteLock().readLock().unlock();
        this.lblTotalCommon.setText(String.format("Gesamtanzahl Filme: %d", dupes));
    }

    private void updateTotalDuplicatesStats() {
        this.resizeSenderColumnWidth(this.tblDuplicates);
        EventList<FilmStatistics> statisticsEventList = Daten.getInstance().getDuplicateStatistics();
        statisticsEventList.getReadWriteLock().readLock().lock();
        long dupes = 0L;
        for (FilmStatistics item : statisticsEventList) {
            dupes += item.count();
        }
        statisticsEventList.getReadWriteLock().readLock().unlock();
        this.lblTotalDuplicates.setText(String.format("Gesamtanzahl Duplikate: %d", dupes));
    }

    private void initComponents() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel commonStats = new JPanel();
        JScrollPane scrollPane2 = new JScrollPane();
        this.tblCommon = new JTable();
        this.lblTotalCommon = new JLabel();
        JPanel duplicatePanel = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.tblDuplicates = new JTable();
        this.lblTotalDuplicates = new JLabel();
        this.setTitle("Film-Statistik");
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.UTILITY);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        tabbedPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        commonStats.setBorder(new EmptyBorder(5, 5, 5, 5));
        commonStats.setLayout(new BorderLayout(0, 5));
        this.tblCommon.setAutoResizeMode(0);
        this.tblCommon.setPreferredScrollableViewportSize(new Dimension(250, 400));
        this.tblCommon.setSelectionMode(0);
        this.tblCommon.setShowHorizontalLines(false);
        this.tblCommon.setShowVerticalLines(false);
        scrollPane2.setViewportView(this.tblCommon);
        commonStats.add((Component)scrollPane2, "Center");
        this.lblTotalCommon.setText("Gesamtanzahl Filme:");
        commonStats.add((Component)this.lblTotalCommon, "South");
        tabbedPane.addTab("Allgemein", commonStats);
        duplicatePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        duplicatePanel.setLayout(new BorderLayout(0, 5));
        this.tblDuplicates.setSelectionMode(0);
        this.tblDuplicates.setShowHorizontalLines(false);
        this.tblDuplicates.setShowVerticalLines(false);
        this.tblDuplicates.setAutoResizeMode(0);
        this.tblDuplicates.setPreferredScrollableViewportSize(new Dimension(250, 400));
        scrollPane1.setViewportView(this.tblDuplicates);
        duplicatePanel.add((Component)scrollPane1, "Center");
        this.lblTotalDuplicates.setText("Gesamtanzahl Duplikate:");
        duplicatePanel.add((Component)this.lblTotalDuplicates, "Last");
        tabbedPane.addTab("Duplikate", duplicatePanel);
        contentPane.add((Component)tabbedPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

