/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Header;
import oracle.security.pki.internal.asn1.ASN1Utils;

public class ASN1ConstructedInputStream
extends FilterInputStream {
    private int a;
    private int b = 0;
    private int c = -1;

    public ASN1ConstructedInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        ASN1Header aSN1Header = new ASN1Header(this.in);
        aSN1Header.d(128);
        if (aSN1Header.c() == 0) {
            throw new ASN1FormatException("Constructed encoding expected");
        }
        this.a(aSN1Header);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, 128);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, int n, int n2) throws IOException {
        super(inputStream);
        ASN1Header aSN1Header = new ASN1Header(this.in);
        aSN1Header.e(n);
        aSN1Header.d(n2);
        if (aSN1Header.c() == 0) {
            throw new ASN1FormatException("Constructed encoding expected");
        }
        this.a(aSN1Header);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, ASN1Header aSN1Header) {
        super(inputStream);
        this.a(aSN1Header);
    }

    private void a(ASN1Header aSN1Header) {
        this.a = aSN1Header.d();
    }

    @Override
    public int read() throws IOException {
        if (this.c == -1) {
            if (this.a != -1 && this.b >= this.a) {
                return -1;
            }
            int n = super.read();
            if (n == -1) {
                throw new ASN1FormatException("End of input.");
            }
            ++this.b;
            return n;
        }
        int n = this.c;
        this.c = -1;
        ++this.b;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.a == -1 || this.b + n2 <= this.a) {
            int n3 = 0;
            if (this.c != -1) {
                byArray[n] = (byte)this.c;
                n3 = 1;
            }
            int n4 = n3 + super.read(byArray, n, n2 - n3);
            this.b += n4;
            return n4;
        }
        throw new ASN1FormatException("Contents length exceeded.");
    }

    @Override
    public int available() throws IOException {
        return (this.c != -1 ? 1 : 0) + super.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void b(int n) {
        if (this.c == -1) {
            this.c = n & 0xFF;
            --this.b;
        } else {
            throw new IllegalStateException("Pushback buffer is full.");
        }
    }

    public boolean a() throws IOException {
        if (this.a >= 0) {
            return this.b < this.a;
        }
        int n = this.read();
        if (n == -1) {
            throw new ASN1FormatException("End of input.");
        }
        this.b(n);
        return n != 0;
    }

    public void a(boolean bl) throws IOException {
        if (bl) {
            while (this.a()) {
                ASN1Utils.a(this);
            }
        }
        if (this.a >= 0) {
            if (this.b < this.a) {
                throw new ASN1FormatException("End of constructed encoding expected.");
            }
        } else {
            if (this.read() != 0) {
                throw new ASN1FormatException("First end-of-contents octet expected.");
            }
            if (this.read() != 0) {
                throw new ASN1FormatException("Second end-of-contents octet expected.");
            }
        }
    }

    public void b() throws IOException {
        this.a(false);
    }

    public int c() throws IOException {
        int n = this.read();
        if (n == -1) {
            return -1;
        }
        this.b(n);
        return n;
    }

    public int d() throws IOException {
        int n = this.read();
        if (n == -1) {
            return -1;
        }
        this.b(n);
        int n2 = n & 0x1F;
        return n2;
    }

    public void a(int n) throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        this.b((n2 & 0x20) + n);
    }
}

