/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;

class ONSSubscriberBase
implements Diagnosable {
    static final String CLASS_NAME = ONSSubscriberBase.class.getName();
    static Mocker mocker = new Mocker();
    Subscriber m_subscriber;
    private boolean m_failed;

    @Debug(level=Debug.Level.FINEST)
    ONSSubscriberBase(final ONS currentONS, final String eventStr) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "<init>", "entering args ({0}, {1})", null, null, currentONS, eventStr);
            this.m_subscriber = null;
            this.m_failed = false;
            try {
                this.m_subscriber = mocker.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){

                    @Override
                    public Subscriber run() {
                        try {
                            return mocker.createSubscriber(currentONS, eventStr);
                        }
                        catch (SubscriptionException se) {
                            ONSSubscriberBase.this.trace(Level.WARNING, CLASS_NAME, "ONSSubscriberBase", "", null, se, new Object[0]);
                            ONSSubscriberBase.this.m_failed = true;
                            return null;
                        }
                        catch (ONSException e) {
                            ONSSubscriberBase.this.trace(Level.WARNING, CLASS_NAME, "ONSSubscriberBase", "", null, e, new Object[0]);
                            ONSSubscriberBase.this.m_failed = true;
                            return null;
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.trace(Level.WARNING, CLASS_NAME, "ONSSubscriberBase", "", null, e, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "<init>", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "<init>", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    ONSSubscriberBase(Subscriber subscriber) {
        this.m_subscriber = null;
        this.m_failed = false;
        this.m_subscriber = subscriber;
    }

    boolean isFailed() {
        return this.m_failed;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    Notification receive(long l) throws UniversalConnectionPoolException {
        try {
            Notification notification;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "receive", "entering args ({0})", null, null, l);
            try {
                void timeout;
                Notification event = this.receiveMoker((long)timeout);
                this.trace(Level.FINEST, CLASS_NAME, "receive", "notification received", null, null, new Object[0]);
                notification = event;
            }
            catch (ONSException e) {
                throw new UniversalConnectionPoolException(e);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "receive", "returning {0}", null, null, notification);
            return notification;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "receive", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    Notification receiveMoker(long l) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "receiveMoker", "entering args ({0})", null, null, l);
            if (null != this.m_subscriber) {
                void timeout;
                Notification notification = 0L == timeout ? this.m_subscriber.receive(true) : this.m_subscriber.receive((long)timeout);
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "receiveMoker", "returning {0}", null, null, notification);
                return notification;
            }
            Notification notification = null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "receiveMoker", "returning {0}", null, null, notification);
            return notification;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "receiveMoker", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    public void close() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "close", "entering args ()", null, null, new Object[0]);
            this.closeMocker();
            this.m_subscriber = null;
            this.trace(Level.FINEST, CLASS_NAME, "close", "subscriber closed", null, null, new Object[0]);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "close", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "close", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    void closeMocker() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "closeMocker", "entering args ()", null, null, new Object[0]);
            if (null != this.m_subscriber) {
                this.m_subscriber.close();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "closeMocker", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.ONSSubscriberBase", "closeMocker", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }

    static class Mocker {
        Mocker() {
        }

        Subscriber createSubscriber(ONS currentONS, String eventString) {
            return currentONS != null ? currentONS.createNewSubscriber(eventString, "", 30000L) : new Subscriber(eventString, "", 30000L);
        }

        Subscriber doPrivileged(PrivilegedExceptionAction<Subscriber> action) throws PrivilegedActionException {
            return AccessController.doPrivileged(action);
        }
    }
}

