/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.bucket.GeoTileUtils;
import org.opensearch.search.aggregations.bucket.composite.LongValuesSource;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;

class GeoTileValuesSource
extends LongValuesSource {
    GeoTileValuesSource(BigArrays bigArrays, MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException> docValuesFunc, LongUnaryOperator rounding, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, fieldType, docValuesFunc, rounding, format, missingBucket, missingOrder, size, reverseMul);
    }

    protected void setAfter(Comparable value) {
        if (this.missingBucket && value == null) {
            this.afterValue = null;
        } else if (value instanceof Number) {
            Number number = (Number)((Object)value);
            this.afterValue = Long.valueOf(number.longValue());
        } else {
            this.afterValue = Long.valueOf(GeoTileUtils.longEncode((String)value.toString()));
        }
    }
}

