/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.PredictorCorrector;
import com.amazon.randomcutforest.parkservices.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestState;
import com.amazon.randomcutforest.parkservices.state.preprocessor.PreprocessorMapper;
import com.amazon.randomcutforest.parkservices.state.preprocessor.PreprocessorState;
import com.amazon.randomcutforest.parkservices.state.threshold.BasicThresholderMapper;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.returntypes.DiVectorMapper;

public class ThresholdedRandomCutForestMapper
implements IStateMapper<ThresholdedRandomCutForest, ThresholdedRandomCutForestState> {
    public ThresholdedRandomCutForest toModel(ThresholdedRandomCutForestState state, long seed) {
        RandomCutForestMapper randomCutForestMapper = new RandomCutForestMapper();
        BasicThresholderMapper thresholderMapper = new BasicThresholderMapper();
        PreprocessorMapper preprocessorMapper = new PreprocessorMapper();
        RandomCutForest forest = randomCutForestMapper.toModel(state.getForestState());
        BasicThresholder thresholder = (BasicThresholder)thresholderMapper.toModel(state.getThresholderState());
        Preprocessor preprocessor = (Preprocessor)preprocessorMapper.toModel(state.getPreprocessorStates()[0]);
        ForestMode forestMode = ForestMode.valueOf((String)state.getForestMode());
        TransformMethod transformMethod = TransformMethod.valueOf((String)state.getTransformMethod());
        RCFComputeDescriptor descriptor = new RCFComputeDescriptor(null, 0L);
        descriptor.setRCFScore(state.getLastAnomalyScore());
        descriptor.setInternalTimeStamp(state.getLastAnomalyTimeStamp());
        descriptor.setAttribution((DiVector)new DiVectorMapper().toModel((Object)state.getLastAnomalyAttribution()));
        descriptor.setRCFPoint(state.getLastAnomalyPoint());
        descriptor.setExpectedRCFPoint(state.getLastExpectedPoint());
        descriptor.setRelativeIndex(state.getLastRelativeIndex());
        descriptor.setForestMode(forestMode);
        descriptor.setTransformMethod(transformMethod);
        descriptor.setImputationMethod(ImputationMethod.valueOf((String)state.getPreprocessorStates()[0].getImputationMethod()));
        PredictorCorrector predictorCorrector = new PredictorCorrector(thresholder);
        predictorCorrector.setIgnoreSimilar(state.isIgnoreSimilar());
        predictorCorrector.setIgnoreSimilarFactor(state.getIgnoreSimilarFactor());
        predictorCorrector.setTriggerFactor(state.getTriggerFactor());
        predictorCorrector.setNumberOfAttributors(state.getNumberOfAttributors());
        return new ThresholdedRandomCutForest(forestMode, transformMethod, forest, predictorCorrector, preprocessor, descriptor);
    }

    public ThresholdedRandomCutForestState toState(ThresholdedRandomCutForest model) {
        ThresholdedRandomCutForestState state = new ThresholdedRandomCutForestState();
        RandomCutForestMapper randomCutForestMapper = new RandomCutForestMapper();
        randomCutForestMapper.setPartialTreeStateEnabled(true);
        randomCutForestMapper.setSaveTreeStateEnabled(true);
        randomCutForestMapper.setCompressionEnabled(true);
        randomCutForestMapper.setSaveCoordinatorStateEnabled(true);
        randomCutForestMapper.setSaveExecutorContextEnabled(true);
        state.setForestState(randomCutForestMapper.toState(model.getForest()));
        BasicThresholderMapper thresholderMapper = new BasicThresholderMapper();
        state.setThresholderState(thresholderMapper.toState(model.getThresholder()));
        PreprocessorMapper preprocessorMapper = new PreprocessorMapper();
        state.setPreprocessorStates(new PreprocessorState[]{preprocessorMapper.toState((Preprocessor)model.getPreprocessor())});
        state.setTriggerFactor(model.getPredictorCorrector().getTriggerFactor());
        state.setIgnoreSimilar(model.getPredictorCorrector().isIgnoreSimilar());
        state.setIgnoreSimilarFactor(model.getPredictorCorrector().getIgnoreSimilarFactor());
        state.setNumberOfAttributors(model.getPredictorCorrector().getNumberOfAttributors());
        state.setForestMode(model.getForestMode().name());
        state.setTransformMethod(model.getTransformMethod().name());
        IRCFComputeDescriptor descriptor = model.getLastAnomalyDescriptor();
        state.setLastAnomalyTimeStamp(descriptor.getInternalTimeStamp());
        state.setLastAnomalyScore(descriptor.getRCFScore());
        state.setLastAnomalyAttribution(new DiVectorMapper().toState(descriptor.getAttribution()));
        state.setLastAnomalyPoint(descriptor.getRCFPoint());
        state.setLastExpectedPoint(descriptor.getExpectedRCFPoint());
        state.setLastRelativeIndex(descriptor.getRelativeIndex());
        return state;
    }
}

