/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Capture;
import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.Repetition;
import com.plantuml.ubrex.TextNavigator;

public class ChallengeRepetition
implements Challenge {
    private final Challenge origin;
    private final Repetition repetition;

    public ChallengeRepetition(Repetition repetition, Challenge origin) {
        this.origin = origin;
        this.repetition = repetition;
    }

    @Override
    public ChallengeResult runChallenge(TextNavigator string, int position) {
        Capture capture = Capture.EMPTY;
        int currentPos = position;
        int count = 0;
        while (true) {
            ChallengeResult shallWePass;
            if ((shallWePass = this.origin.runChallenge(string, currentPos)).getFullCaptureLength() < 0) {
                if (currentPos > position && this.repetition.match(count)) {
                    return new ChallengeResult(currentPos - position, capture);
                }
                return new ChallengeResult(Integer.MIN_VALUE);
            }
            if (shallWePass.getFullCaptureLength() == 0) {
                throw new IllegalStateException("infinite loop");
            }
            capture = capture.merge(shallWePass.getCapture());
            currentPos += shallWePass.getFullCaptureLength();
            ++count;
        }
    }
}

