/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.hash;

import java.util.Objects;

public interface EqualityPolicy<T> {
    public static final EqualityPolicy<?> IDENTITY = new EqualityPolicy<Object>(){

        @Override
        public int getHashCode(Object value) {
            return System.identityHashCode(value);
        }

        @Override
        public boolean isEqual(Object val1, Object val2) {
            return val1 == val2;
        }
    };
    public static final EqualityPolicy<?> CANONICAL = new EqualityPolicy<Object>(){

        @Override
        public int getHashCode(Object value) {
            return value != null ? value.hashCode() : 0;
        }

        @Override
        public boolean isEqual(Object val1, Object val2) {
            return Objects.equals(val1, val2);
        }
    };

    public int getHashCode(T var1);

    public boolean isEqual(T var1, T var2);
}

