/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.timeline.thread;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  *\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\u0002\u001f B=\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0016\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/collaboration/ui/codereview/timeline/thread/TimelineThreadCommentsPanel;", "T", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "commentsModel", "Ljavax/swing/ListModel;", "commentComponentFactory", "Lkotlin/Function1;", "Ljavax/swing/JComponent;", "offset", "", "foldButtonOffset", "<init>", "(Ljavax/swing/ListModel;Lkotlin/jvm/functions/Function1;II)V", "foldModel", "Lcom/intellij/collaboration/ui/SingleValueModel;", "", "getFoldModel", "()Lcom/intellij/collaboration/ui/SingleValueModel;", "collapsedCountModel", "unfoldButtonPanel", "foldablePanel", "Lcom/intellij/collaboration/ui/codereview/timeline/thread/TimelineThreadCommentsPanel$FoldablePanel;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "updateFolding", "folded", "createUnfoldPanel", "foldedCount", "FoldablePanel", "Companion", "intellij.platform.collaborationTools"})
public final class TimelineThreadCommentsPanel<T>
extends BorderLayoutPanel
implements UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ListModel<T> commentsModel;
    @NotNull
    private final Function1<T, JComponent> commentComponentFactory;
    private final int foldButtonOffset;
    @NotNull
    private final SingleValueModel<Boolean> foldModel;
    @NotNull
    private final SingleValueModel<Integer> collapsedCountModel;
    @NotNull
    private final JComponent unfoldButtonPanel;
    @NotNull
    private final FoldablePanel foldablePanel;
    public static final int FOLD_THRESHOLD = 3;
    public static final int UNFOLD_BUTTON_VERTICAL_GAP = 18;

    /*
     * WARNING - void declaration
     */
    public TimelineThreadCommentsPanel(@NotNull ListModel<T> commentsModel, @NotNull Function1<? super T, ? extends JComponent> commentComponentFactory, int offset, int foldButtonOffset) {
        FoldablePanel foldablePanel;
        Intrinsics.checkNotNullParameter(commentsModel, (String)"commentsModel");
        Intrinsics.checkNotNullParameter(commentComponentFactory, (String)"commentComponentFactory");
        this.commentsModel = commentsModel;
        this.commentComponentFactory = commentComponentFactory;
        this.foldButtonOffset = foldButtonOffset;
        this.foldModel = new SingleValueModel<Boolean>(true);
        this.collapsedCountModel = new SingleValueModel<Integer>(this.commentsModel.getSize() - 3 - 1);
        this.commentsModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                collapsedCountModel.setValue(commentsModel.getSize() - 3 - 1);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                collapsedCountModel.setValue(commentsModel.getSize() - 3 - 1);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                collapsedCountModel.setValue(commentsModel.getSize() - 3 - 1);
            }
        });
        this.unfoldButtonPanel = this.createUnfoldPanel(this.collapsedCountModel);
        FoldablePanel foldablePanel2 = foldablePanel = new FoldablePanel(this.unfoldButtonPanel, offset);
        TimelineThreadCommentsPanel timelineThreadCommentsPanel = this;
        boolean bl = false;
        int n = this.commentsModel.getSize();
        for (int i = 0; i < n; ++i) {
            void $this$foldablePanel_u24lambda_u240;
            $this$foldablePanel_u24lambda_u240.addComponent((JComponent)this.commentComponentFactory.invoke(this.commentsModel.getElementAt(i)), i);
        }
        timelineThreadCommentsPanel.foldablePanel = foldablePanel;
        this.setOpaque(false);
        this.addToCenter(this.foldablePanel);
        this.commentsModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int i = e.getIndex1();
                int n = e.getIndex0();
                if (n <= i) {
                    while (true) {
                        foldablePanel.removeComponent(i);
                        if (i == n) break;
                        --i;
                    }
                }
                this.updateFolding(this.getFoldModel().getValue());
                foldablePanel.revalidate();
                foldablePanel.repaint();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int i = e.getIndex0();
                int n = e.getIndex1();
                if (i <= n) {
                    while (true) {
                        foldablePanel.addComponent((JComponent)commentComponentFactory.invoke(commentsModel.getElementAt(i)), i);
                        if (i == n) break;
                        ++i;
                    }
                }
                foldablePanel.revalidate();
                foldablePanel.repaint();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int i = e.getIndex1();
                int n = e.getIndex0();
                if (n <= i) {
                    while (true) {
                        foldablePanel.removeComponent(i);
                        if (i == n) break;
                        --i;
                    }
                }
                if ((i = e.getIndex0()) <= (n = e.getIndex1())) {
                    while (true) {
                        foldablePanel.addComponent((JComponent)commentComponentFactory.invoke(commentsModel.getElementAt(i)), i);
                        if (i == n) break;
                        ++i;
                    }
                }
                foldablePanel.validate();
                foldablePanel.repaint();
            }
        });
        this.foldModel.addListener((Function1<Boolean, Unit>)((Function1)arg_0 -> TimelineThreadCommentsPanel._init_$lambda$0(this, arg_0)));
        this.updateFolding(this.foldModel.getValue());
    }

    public /* synthetic */ TimelineThreadCommentsPanel(ListModel listModel, Function1 function1, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = JBUI.scale((int)8);
        }
        if ((n3 & 8) != 0) {
            n2 = 30;
        }
        this(listModel, function1, n, n2);
    }

    @NotNull
    public final SingleValueModel<Boolean> getFoldModel() {
        return this.foldModel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = CommonDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
        sink.setNull(dataKey);
    }

    private final void updateFolding(boolean folded) {
        boolean shouldFold = folded && this.commentsModel.getSize() > 3;
        this.unfoldButtonPanel.setVisible(shouldFold);
        if (this.commentsModel.getSize() == 0) {
            return;
        }
        this.foldablePanel.getModelComponent(0).setVisible(true);
        this.foldablePanel.getModelComponent(this.commentsModel.getSize() - 1).setVisible(true);
        int n = this.commentsModel.getSize() - 1;
        for (int i = 1; i < n; ++i) {
            this.foldablePanel.getModelComponent(i).setVisible(!shouldFold);
        }
    }

    private final JComponent createUnfoldPanel(SingleValueModel<Integer> foldedCount) {
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel $this$createUnfoldPanel_u24lambda_u240 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        $this$createUnfoldPanel_u24lambda_u240.setOpaque(false);
        $this$createUnfoldPanel_u24lambda_u240.setBorder((Border)JBUI.Borders.emptyLeft((int)this.foldButtonOffset));
        $this$createUnfoldPanel_u24lambda_u240.addToLeft((Component)TimelineThreadCommentsPanel.Companion.createUnfoldComponent(foldedCount, (Function1<? super ActionEvent, Unit>)arg_0 -> TimelineThreadCommentsPanel.createUnfoldPanel$lambda$0$0(this, arg_0)));
        return (JComponent)borderLayoutPanel;
    }

    private static final Unit _init_$lambda$0(TimelineThreadCommentsPanel this$0, boolean it) {
        this$0.updateFolding(it);
        return Unit.INSTANCE;
    }

    private static final Unit createUnfoldPanel$lambda$0$0(TimelineThreadCommentsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.foldModel.setValue(this$0.foldModel.getValue() == false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bJ*\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/collaboration/ui/codereview/timeline/thread/TimelineThreadCommentsPanel$Companion;", "", "<init>", "()V", "FOLD_THRESHOLD", "", "UNFOLD_BUTTON_VERTICAL_GAP", "createUnfoldComponent", "Ljavax/swing/JComponent;", "foldedCount", "actionListener", "Lkotlin/Function1;", "Ljava/awt/event/ActionEvent;", "", "Lcom/intellij/collaboration/ui/SingleValueModel;", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JComponent createUnfoldComponent(int foldedCount, @NotNull Function1<? super ActionEvent, Unit> actionListener) {
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            return this.createUnfoldComponent(new SingleValueModel<Integer>(foldedCount), actionListener);
        }

        private final JComponent createUnfoldComponent(SingleValueModel<Integer> foldedCount, Function1<? super ActionEvent, Unit> actionListener) {
            ActionLink actionLink;
            ActionLink $this$createUnfoldComponent_u24lambda_u240 = actionLink = new ActionLink("", actionListener);
            boolean bl = false;
            $this$createUnfoldComponent_u24lambda_u240.setIcon(AllIcons.Actions.MoreHorizontal);
            ActionLink $this$createUnfoldComponent_u24lambda_u241 = actionLink;
            boolean bl2 = false;
            $this$createUnfoldComponent_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)18, (int)0));
            foldedCount.addAndInvokeListener((Function1<Integer, Unit>)((Function1)arg_0 -> Companion.createUnfoldComponent$lambda$1$0($this$createUnfoldComponent_u24lambda_u241, arg_0)));
            return (JComponent)actionLink;
        }

        private static final Unit createUnfoldComponent$lambda$1$0(ActionLink $this_apply, int it) {
            Object[] objectArray = new Object[]{it};
            $this_apply.setText(CollaborationToolsBundle.message("review.thread.more.replies", objectArray));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/collaboration/ui/codereview/timeline/thread/TimelineThreadCommentsPanel$FoldablePanel;", "Ljavax/swing/JPanel;", "unfoldButton", "Ljavax/swing/JComponent;", "offset", "", "<init>", "(Ljavax/swing/JComponent;I)V", "addComponent", "", "component", "index", "removeComponent", "getModelComponent", "Ljava/awt/Component;", "modelIndex", "intellij.platform.collaborationTools"})
    private static final class FoldablePanel
    extends JPanel {
        @NotNull
        private final JComponent unfoldButton;

        public FoldablePanel(@NotNull JComponent unfoldButton, int offset) {
            Intrinsics.checkNotNullParameter((Object)unfoldButton, (String)"unfoldButton");
            super((LayoutManager)ListLayout.Companion.vertical$default((ListLayout.Companion)ListLayout.Companion, (int)offset, null, null, (int)6, null));
            this.unfoldButton = unfoldButton;
            this.setOpaque(false);
            this.add(this.unfoldButton);
        }

        public final void addComponent(@NotNull JComponent component, int index) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.remove(this.unfoldButton);
            this.add(component, null, index);
            this.add(this.unfoldButton, null, 1);
        }

        public final void removeComponent(int index) {
            this.remove(this.unfoldButton);
            this.remove(index);
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            int unfoldButtonIndex = ((Object[])componentArray).length == 0 ? 0 : 1;
            this.add(this.unfoldButton, null, unfoldButtonIndex);
        }

        @NotNull
        public final Component getModelComponent(int modelIndex) {
            Component component;
            if (modelIndex == 0) {
                Component component2 = this.getComponent(0);
                Intrinsics.checkNotNull((Object)component2);
                component = component2;
            } else {
                Component component3 = this.getComponent(modelIndex + 1);
                Intrinsics.checkNotNull((Object)component3);
                component = component3;
            }
            return component;
        }
    }
}

