/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.python.debugger.PyDebugProcess;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AbstractLineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<XBreakpointProperties>> {
    protected final PyDebugProcess myDebugProcess;
    private final Map<XLineBreakpoint<XBreakpointProperties>, XSourcePosition> myBreakPointPositions;

    public AbstractLineBreakpointHandler(Class<? extends XBreakpointType<XLineBreakpoint<XBreakpointProperties>, ?>> breakpointTypeClass, @NotNull PyDebugProcess debugProcess) {
        if (debugProcess == null) {
            AbstractLineBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(breakpointTypeClass);
        this.myBreakPointPositions = Maps.newHashMap();
        this.myDebugProcess = debugProcess;
    }

    public void reregisterBreakpoints() {
        ArrayList breakpoints = Lists.newArrayList(this.myBreakPointPositions.keySet());
        for (XLineBreakpoint breakpoint : breakpoints) {
            this.unregisterBreakpoint((XLineBreakpoint<XBreakpointProperties>)breakpoint, false);
            this.registerBreakpoint((XLineBreakpoint<XBreakpointProperties>)breakpoint);
        }
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        XSourcePosition position;
        if (breakpoint == null) {
            AbstractLineBreakpointHandler.$$$reportNull$$$0(1);
        }
        if ((position = breakpoint.getSourcePosition()) != null && position.getFile().isValid()) {
            this.myDebugProcess.addBreakpoint(this.myDebugProcess.getPositionConverter().convertToPython(position), breakpoint);
            this.myBreakPointPositions.put(breakpoint, position);
        }
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, boolean temporary) {
        XSourcePosition position;
        if (breakpoint == null) {
            AbstractLineBreakpointHandler.$$$reportNull$$$0(2);
        }
        if ((position = this.myBreakPointPositions.get(breakpoint)) != null && position.getFile().isValid()) {
            this.myDebugProcess.removeBreakpoint(this.myDebugProcess.getPositionConverter().convertToPython(position));
            this.myBreakPointPositions.remove(breakpoint);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/AbstractLineBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

