/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLandweberDeconvolutionImageFilter_h
#define sitkLandweberDeconvolutionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class LandweberDeconvolutionImageFilter
\brief Deconvolve an image using the Landweber deconvolution algorithm.

This filter implements the Landweber deconvolution algorithm as defined in Bertero M and Boccacci P, "Introduction to Inverse
Problems in Imaging", 1998. The algorithm assumes that the input image has been formed by a linear shift-invariant system with a known kernel.

The Landweber algorithm converges to a solution that minimizes the sum of squared errors \f$||f \otimes h - g||\f$ where \f$f\f$ is the estimate of the unblurred image, \f$\otimes\f$ is the convolution operator, \f$h\f$ is the blurring kernel, and \f$g\f$ is the blurred input image. As such, it is best suited for images that have zero-mean Gaussian white noise.

This is the base implementation of the Landweber algorithm. It may produce results with negative values. For a version of this algorithm that enforces a positivity constraint on each intermediate solution, see ProjectedLandweberDeconvolutionImageFilter .

This code was adapted from the Insight Journal contribution:

"Deconvolution: infrastructure and reference algorithms" by Gaetan Lehmann https://doi.org/10.54294/tvgfv1 

\author Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France 


\author Cory Quammen, The University of North Carolina at Chapel Hill


\see IterativeDeconvolutionImageFilter 


\see RichardsonLucyDeconvolutionImageFilter 


\see ProjectedLandweberDeconvolutionImageFilter
\sa itk::simple::LandweberDeconvolution for the procedural interface
\sa itk::LandweberDeconvolutionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LandweberDeconvolutionImageFilter : public ImageFilter {
    public:
      using Self = LandweberDeconvolutionImageFilter;

      /** Destructor */
      virtual ~LandweberDeconvolutionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LandweberDeconvolutionImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set/get relaxation factor.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAlpha ( double Alpha ) { this->m_Alpha = Alpha; return *this; }

      /**
       * Set/get relaxation factor.
       */
      double GetAlpha() const { return this->m_Alpha; }\

      /**
       * Set the number of iterations.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNumberOfIterations ( int NumberOfIterations ) { this->m_NumberOfIterations = NumberOfIterations; return *this; }

      /**
       * Get the number of iterations.
       */
      int GetNumberOfIterations() const { return this->m_NumberOfIterations; }\

      /**
       * Normalize the output image by the sum of the kernel components

       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalize ( bool Normalize ) { this->m_Normalize = Normalize; return *this; }

      /** Set the value of Normalize to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOn() { return this->SetNormalize(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOff() { return this->SetNormalize(false); }

      /**
       */
      bool GetNormalize() const { return this->m_Normalize; }

      typedef enum {ZERO_PAD,ZERO_FLUX_NEUMANN_PAD,PERIODIC_PAD} BoundaryConditionType;\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBoundaryCondition ( BoundaryConditionType BoundaryCondition ) { this->m_BoundaryCondition = BoundaryCondition; return *this; }

      /**
       */
      BoundaryConditionType GetBoundaryCondition() const { return this->m_BoundaryCondition; }

      typedef enum {SAME,VALID} OutputRegionModeType;\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputRegionMode ( OutputRegionModeType OutputRegionMode ) { this->m_OutputRegionMode = OutputRegionMode; return *this; }

      /**
       */
      OutputRegionModeType GetOutputRegionMode() const { return this->m_OutputRegionMode; }

      /** Name of this class */
      std::string GetName() const { return std::string ("LandweberDeconvolutionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */

      Image Execute ( const Image& image1, const Image& image2 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_Alpha{0.1};

      int  m_NumberOfIterations{1};

      /*  */
      bool  m_Normalize{false};

      BoundaryConditionType  m_BoundaryCondition{itk::simple::LandweberDeconvolutionImageFilter::ZERO_FLUX_NEUMANN_PAD};

      OutputRegionModeType  m_OutputRegionMode{itk::simple::LandweberDeconvolutionImageFilter::SAME};


    };

    /**\
     * \brief Deconvolve an image using the Landweber deconvolution algorithm.
     *
     * This function directly calls the execute method of LandweberDeconvolutionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LandweberDeconvolutionImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image LandweberDeconvolution ( const Image& image1, const Image& image2, double alpha = 0.1, int numberOfIterations = 1, bool normalize = false, LandweberDeconvolutionImageFilter::BoundaryConditionType boundaryCondition = itk::simple::LandweberDeconvolutionImageFilter::ZERO_FLUX_NEUMANN_PAD, LandweberDeconvolutionImageFilter::OutputRegionModeType outputRegionMode = itk::simple::LandweberDeconvolutionImageFilter::SAME );

     /** @} */
}
#endif
