/*
 * Decompiled with CFR 0.152.
 */
package hughai.packcoordinators;

import hughai.PlayerObjects;
import hughai.packcoordinators.IPackCoordinator;
import hughai.utils.LogFile;
import java.util.ArrayList;

public class PackCoordinatorSelector {
    ArrayList<IPackCoordinator> packcoordinators = new ArrayList();
    LogFile logfile;
    IPackCoordinator activecoordinator = null;

    public PackCoordinatorSelector(PlayerObjects playerObjects) {
        this.logfile = playerObjects.getLogFile();
    }

    public void LoadCoordinator(IPackCoordinator iPackCoordinator) {
        if (!this.packcoordinators.contains(iPackCoordinator)) {
            this.packcoordinators.add(iPackCoordinator);
        }
    }

    public void ActivatePackCoordinator(IPackCoordinator iPackCoordinator) {
        if (!this.packcoordinators.contains(iPackCoordinator)) {
            throw new RuntimeException("PackCoordinatorSelector: pack coordinator " + iPackCoordinator.toString() + " not found");
        }
        if (this.activecoordinator != iPackCoordinator) {
            this.logfile.WriteLine("PackCoordinator selector: changing to coordinator " + iPackCoordinator.toString());
            for (IPackCoordinator iPackCoordinator2 : this.packcoordinators) {
                if (iPackCoordinator2 == iPackCoordinator) continue;
                iPackCoordinator2.Disactivate();
            }
            for (IPackCoordinator iPackCoordinator2 : this.packcoordinators) {
                if (iPackCoordinator2 != iPackCoordinator) continue;
                iPackCoordinator2.Activate();
            }
            this.activecoordinator = iPackCoordinator;
        }
    }

    public void DisactivateAll() {
        if (this.activecoordinator != null) {
            this.logfile.WriteLine("PackCoordinator selector: disactivating all");
            for (IPackCoordinator iPackCoordinator : this.packcoordinators) {
                iPackCoordinator.Disactivate();
            }
            this.activecoordinator = null;
        }
    }
}

