# Dynamic tabstop generation

![gif](https://raw.githubusercontent.com/SirVer/ultisnips/master/doc/examples/tabstop-generation/demo.gif)

UltiSnips at the present day is more than snippet engine. It's more like
constructor, where you can implement some complex features without prior
feature implementation in the snippet by itself.

One of that features is dynamic tabstop generation.

Consider case, where you want set of snippets for inserting latex rows of
various lengths. No-brainer solution is just implement snippet for every
row length you're possible will want, like this:

```
snippet tr9 "LaTeX table row of length nine"
$1 & $2 & $3 & $4 & $5 & $6 & $7 & $8 & $9
endsnippet
```

But soon it becomes a burden to maintain that kind of snippets.

Gladly, tabstops can be generated by using anonymous snippet expansion:

```
global !p
def create_row_placeholders(snip):
    # retrieving singlee line from current string and treat it like tabstops
    # count
    placeholders_amount = int(snip.buffer[snip.line].strip())

    # erase current line
    snip.buffer[snip.line] = ''

    # create anonymous snippet with expected content and number of tabstops
    anon_snippet_body = ' & '.join(['$' + str(i+1)
                                    for i in range(placeholders_amount)])

    # expand anonymous snippet
    snip.expand_anon(anon_snippet_body)
endglobal

post_jump "create_row_placeholders(snip)"
snippet "tr(\d+)" "latex table row variable" br
`!p snip.rv = match.group(1)`
endsnippet
```

Snippet is declared via regular expression and will expand to any required
number of fields in row.
