/* file_menu.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from file_menu.vala, do not modify */

/*
Copyright Buddies of Budgie

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FILE_MENU (file_menu_get_type ())
#define FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_MENU, FileMenu))
#define FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_MENU, FileMenuClass))
#define IS_FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_MENU))
#define IS_FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_MENU))
#define FILE_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_MENU, FileMenuClass))

typedef struct _FileMenu FileMenu;
typedef struct _FileMenuClass FileMenuClass;
typedef struct _FileMenuPrivate FileMenuPrivate;

#define TYPE_UNIFIED_PROPS (unified_props_get_type ())
#define UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIFIED_PROPS, UnifiedProps))
#define UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIFIED_PROPS, UnifiedPropsClass))
#define IS_UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIFIED_PROPS))
#define IS_UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIFIED_PROPS))
#define UNIFIED_PROPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIFIED_PROPS, UnifiedPropsClass))

typedef struct _UnifiedProps UnifiedProps;
typedef struct _UnifiedPropsClass UnifiedPropsClass;

#define TYPE_DESKTOP_ITEM (desktop_item_get_type ())
#define DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_ITEM, DesktopItem))
#define DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_ITEM, DesktopItemClass))
#define IS_DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_ITEM))
#define IS_DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_ITEM))
#define DESKTOP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_ITEM, DesktopItemClass))

typedef struct _DesktopItem DesktopItem;
typedef struct _DesktopItemClass DesktopItemClass;

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;
enum  {
	FILE_MENU_0_PROPERTY,
	FILE_MENU_IS_COPYING_PROPERTY,
	FILE_MENU_SHOW_OPEN_IN_TERMINAL_PROPERTY,
	FILE_MENU_NUM_PROPERTIES
};
static GParamSpec* file_menu_properties[FILE_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DesktopItemPrivate DesktopItemPrivate;
typedef struct _FileItemPrivate FileItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FileMenu {
	GtkMenu parent_instance;
	FileMenuPrivate * priv;
	UnifiedProps* props;
};

struct _FileMenuClass {
	GtkMenuClass parent_class;
};

struct _FileMenuPrivate {
	FileItem* file_item;
	GList* selected_items;
	GtkMenuItem* cancel_copy_item;
	GtkMenuItem* open_item;
	GtkMenuItem* open_in_terminal_item;
	GtkMenuItem* trash_item;
	gboolean _is_copying;
	gboolean _show_open_in_terminal;
};

struct _DesktopItem {
	GtkFlowBoxChild parent_instance;
	DesktopItemPrivate * priv;
	UnifiedProps* props;
	gint _label_width;
	gboolean _copying;
	gboolean _mount;
	gchar* _name;
	gchar* _type;
	gboolean _special_dir;
	GtkImage* image;
	GtkLabel* label;
	GtkEventBox* event_box;
	GtkBox* main_layout;
	GdkPixbuf* original_image_pixbuf;
	GIcon* icon;
};

struct _DesktopItemClass {
	GtkFlowBoxChildClass parent_class;
};

struct _FileItem {
	DesktopItem parent_instance;
	FileItemPrivate * priv;
	GFile* file;
	GFileInfo* info;
	GDesktopAppInfo* app_info;
	GKeyFile* keyfile;
	gboolean exclude_item;
};

struct _FileItemClass {
	DesktopItemClass parent_class;
};

static gint FileMenu_private_offset;
static gpointer file_menu_parent_class = NULL;

VALA_EXTERN GType file_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileMenu, g_object_unref)
VALA_EXTERN GType unified_props_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnifiedProps, g_object_unref)
VALA_EXTERN GType desktop_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopItem, g_object_unref)
VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN FileMenu* file_menu_new (UnifiedProps* p);
VALA_EXTERN FileMenu* file_menu_construct (GType object_type,
                               UnifiedProps* p);
VALA_EXTERN void file_menu_move_to_trash (FileMenu* self);
static void _file_menu_move_to_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                      gpointer self);
static void file_menu_on_open_activated (FileMenu* self);
static void _file_menu_on_open_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self);
static void file_menu_on_open_in_terminal_activated (FileMenu* self);
static void _file_menu_on_open_in_terminal_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                      gpointer self);
VALA_EXTERN void file_menu_set_is_copying (FileMenu* self,
                               gboolean value);
VALA_EXTERN void file_menu_set_show_open_in_terminal (FileMenu* self,
                                          gboolean value);
VALA_EXTERN gboolean desktop_item_get_is_special (DesktopItem* self);
VALA_EXTERN const gchar* desktop_item_get_label_name (DesktopItem* self);
VALA_EXTERN void file_item_move_to_trash (FileItem* self);
VALA_EXTERN gboolean file_menu_get_is_copying (FileMenu* self);
VALA_EXTERN gboolean unified_props_is_copying (UnifiedProps* self,
                                   const gchar* file_name);
VALA_EXTERN void file_item_launch (FileItem* self,
                       gboolean in_terminal);
VALA_EXTERN void file_menu_set_item (FileMenu* self,
                         FileItem* item,
                         GList* selected);
VALA_EXTERN void file_menu_show_menu (FileMenu* self,
                          GdkEventButton* event);
VALA_EXTERN gboolean file_menu_get_show_open_in_terminal (FileMenu* self);
static void file_menu_finalize (GObject * obj);
static GType file_menu_get_type_once (void);
static void _vala_file_menu_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_file_menu_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
file_menu_get_instance_private (FileMenu* self)
{
	return G_STRUCT_MEMBER_P (self, FileMenu_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_file_menu_move_to_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                 gpointer self)
{
	file_menu_move_to_trash ((FileMenu*) self);
}

static void
_file_menu_on_open_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self)
{
	file_menu_on_open_activated ((FileMenu*) self);
}

static void
_file_menu_on_open_in_terminal_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                 gpointer self)
{
	file_menu_on_open_in_terminal_activated ((FileMenu*) self);
}

FileMenu*
file_menu_construct (GType object_type,
                     UnifiedProps* p)
{
	FileMenu * self = NULL;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	g_return_val_if_fail (p != NULL, NULL);
	self = (FileMenu*) g_object_new (object_type, NULL);
	self->props = p;
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Cancel Copy"));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->cancel_copy_item);
	self->priv->cancel_copy_item = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->open_item);
	self->priv->open_item = _tmp1_;
	_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in Terminal"));
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->open_in_terminal_item);
	self->priv->open_in_terminal_item = _tmp2_;
	_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Move to Trash"));
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->trash_item);
	self->priv->trash_item = _tmp3_;
	_tmp4_ = self->priv->cancel_copy_item;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) _file_menu_move_to_trash_gtk_menu_item_activate, self, 0);
	_tmp5_ = self->priv->open_item;
	g_signal_connect_object (_tmp5_, "activate", (GCallback) _file_menu_on_open_activated_gtk_menu_item_activate, self, 0);
	_tmp6_ = self->priv->open_in_terminal_item;
	g_signal_connect_object (_tmp6_, "activate", (GCallback) _file_menu_on_open_in_terminal_activated_gtk_menu_item_activate, self, 0);
	_tmp7_ = self->priv->trash_item;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) _file_menu_move_to_trash_gtk_menu_item_activate, self, 0);
	_tmp8_ = self->priv->open_item;
	gtk_widget_show_all ((GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->open_in_terminal_item;
	gtk_widget_show_all ((GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->cancel_copy_item;
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) _tmp10_, 0);
	_tmp11_ = self->priv->open_item;
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) _tmp11_, 1);
	_tmp12_ = self->priv->open_in_terminal_item;
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) _tmp12_, 2);
	_tmp13_ = self->priv->trash_item;
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) _tmp13_, 4);
	file_menu_set_is_copying (self, FALSE);
	file_menu_set_show_open_in_terminal (self, TRUE);
	return self;
}

FileMenu*
file_menu_new (UnifiedProps* p)
{
	return file_menu_construct (TYPE_FILE_MENU, p);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
file_menu_move_to_trash (FileMenu* self)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	GList* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->selected_items;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GList* _tmp2_;
		_tmp2_ = self->priv->selected_items;
		_tmp0_ = g_list_length (_tmp2_) == ((guint) 0);
	}
	if (_tmp0_) {
		g_warning ("file_menu.vala:111: Move to trash activated but no items selected");
		return;
	}
	_tmp3_ = self->priv->selected_items;
	g_debug ("file_menu.vala:116: Moving %u selected item(s) to trash", g_list_length (_tmp3_));
	_tmp4_ = self->priv->selected_items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp4_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			FileItem* _tmp5_;
			FileItem* item = NULL;
			_tmp5_ = _g_object_ref0 ((FileItem*) item_it->data);
			item = _tmp5_;
			{
				FileItem* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				FileItem* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				FileItem* _tmp15_;
				_tmp6_ = item;
				_tmp7_ = desktop_item_get_is_special ((DesktopItem*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					FileItem* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					_tmp9_ = item;
					_tmp10_ = desktop_item_get_label_name ((DesktopItem*) _tmp9_);
					_tmp11_ = _tmp10_;
					g_debug ("file_menu.vala:121: Skipping special item: %s", _tmp11_);
					_g_object_unref0 (item);
					continue;
				}
				_tmp12_ = item;
				_tmp13_ = desktop_item_get_label_name ((DesktopItem*) _tmp12_);
				_tmp14_ = _tmp13_;
				g_debug ("file_menu.vala:125: Moving to trash: %s", _tmp14_);
				_tmp15_ = item;
				file_item_move_to_trash (_tmp15_);
				_g_object_unref0 (item);
			}
		}
	}
	gtk_menu_popdown ((GtkMenu*) self);
}

static void
file_menu_on_open_activated (FileMenu* self)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->selected_items;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GList* _tmp2_;
		_tmp2_ = self->priv->selected_items;
		_tmp0_ = g_list_length (_tmp2_) == ((guint) 0);
	}
	if (_tmp0_) {
		g_warning ("file_menu.vala:135: Open activated but no items selected");
		return;
	}
	_tmp3_ = file_menu_get_is_copying (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->selected_items;
	g_debug ("file_menu.vala:142: Launching %u selected item(s)", g_list_length (_tmp5_));
	_tmp6_ = self->priv->selected_items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp6_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			FileItem* _tmp7_;
			FileItem* item = NULL;
			_tmp7_ = _g_object_ref0 ((FileItem*) item_it->data);
			item = _tmp7_;
			{
				UnifiedProps* _tmp8_;
				FileItem* _tmp9_;
				GFileInfo* _tmp10_;
				const gchar* _tmp11_;
				_tmp8_ = self->props;
				_tmp9_ = item;
				_tmp10_ = _tmp9_->info;
				_tmp11_ = g_file_info_get_display_name (_tmp10_);
				if (!unified_props_is_copying (_tmp8_, _tmp11_)) {
					FileItem* _tmp12_;
					_tmp12_ = item;
					file_item_launch (_tmp12_, FALSE);
				} else {
					FileItem* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp13_ = item;
					_tmp14_ = desktop_item_get_label_name ((DesktopItem*) _tmp13_);
					_tmp15_ = _tmp14_;
					g_debug ("file_menu.vala:147: Skipping %s - currently copying", _tmp15_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	gtk_menu_popdown ((GtkMenu*) self);
}

static void
file_menu_on_open_in_terminal_activated (FileMenu* self)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GList* _tmp5_;
	FileItem* first_item = NULL;
	GList* _tmp10_;
	gconstpointer _tmp11_;
	FileItem* _tmp12_;
	UnifiedProps* _tmp13_;
	FileItem* _tmp14_;
	GFileInfo* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->selected_items;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GList* _tmp2_;
		_tmp2_ = self->priv->selected_items;
		_tmp0_ = g_list_length (_tmp2_) == ((guint) 0);
	}
	if (_tmp0_) {
		g_warning ("file_menu.vala:157: Open in terminal activated but no items selected");
		return;
	}
	_tmp3_ = file_menu_get_is_copying (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->selected_items;
	if (g_list_length (_tmp5_) > ((guint) 1)) {
		GList* _tmp6_;
		gconstpointer _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = self->priv->selected_items;
		_tmp7_ = g_list_nth_data (_tmp6_, (guint) 0);
		_tmp8_ = desktop_item_get_label_name ((DesktopItem*) ((FileItem*) _tmp7_));
		_tmp9_ = _tmp8_;
		g_debug ("file_menu.vala:166: Multiple items selected, opening first item in ter" \
"minal: %s", _tmp9_);
	}
	_tmp10_ = self->priv->selected_items;
	_tmp11_ = g_list_nth_data (_tmp10_, (guint) 0);
	_tmp12_ = _g_object_ref0 ((FileItem*) _tmp11_);
	first_item = _tmp12_;
	_tmp13_ = self->props;
	_tmp14_ = first_item;
	_tmp15_ = _tmp14_->info;
	_tmp16_ = g_file_info_get_display_name (_tmp15_);
	if (!unified_props_is_copying (_tmp13_, _tmp16_)) {
		FileItem* _tmp17_;
		_tmp17_ = first_item;
		file_item_launch (_tmp17_, TRUE);
	}
	gtk_menu_popdown ((GtkMenu*) self);
	_g_object_unref0 (first_item);
}

void
file_menu_set_item (FileMenu* self,
                    FileItem* item,
                    GList* selected)
{
	FileItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (self->priv->file_item);
	self->priv->file_item = _tmp0_;
	(self->priv->selected_items == NULL) ? NULL : (self->priv->selected_items = (_g_list_free__g_object_unref0_ (self->priv->selected_items), NULL));
	self->priv->selected_items = NULL;
	if (selected != NULL) {
		_tmp1_ = g_list_length (selected) > ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			GList* selected_item_collection = NULL;
			GList* selected_item_it = NULL;
			selected_item_collection = selected;
			for (selected_item_it = selected_item_collection; selected_item_it != NULL; selected_item_it = selected_item_it->next) {
				FileItem* _tmp2_;
				FileItem* selected_item = NULL;
				_tmp2_ = _g_object_ref0 ((FileItem*) selected_item_it->data);
				selected_item = _tmp2_;
				{
					FileItem* _tmp3_;
					FileItem* _tmp4_;
					_tmp3_ = selected_item;
					_tmp4_ = _g_object_ref0 (_tmp3_);
					self->priv->selected_items = g_list_append (self->priv->selected_items, _tmp4_);
					_g_object_unref0 (selected_item);
				}
			}
		}
	} else {
		FileItem* _tmp5_;
		_tmp5_ = _g_object_ref0 (item);
		self->priv->selected_items = g_list_append (self->priv->selected_items, _tmp5_);
	}
	_tmp6_ = self->priv->selected_items;
	if (g_list_length (_tmp6_) > ((guint) 1)) {
		GtkMenuItem* _tmp7_;
		GList* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GtkMenuItem* _tmp11_;
		GList* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp7_ = self->priv->open_item;
		_tmp8_ = self->priv->selected_items;
		_tmp9_ = g_strdup_printf (_ ("Open %u Items"), g_list_length (_tmp8_));
		_tmp10_ = _tmp9_;
		gtk_menu_item_set_label (_tmp7_, _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = self->priv->trash_item;
		_tmp12_ = self->priv->selected_items;
		_tmp13_ = g_strdup_printf (_ ("Move %u Items to Trash"), g_list_length (_tmp12_));
		_tmp14_ = _tmp13_;
		gtk_menu_item_set_label (_tmp11_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		GtkMenuItem* _tmp15_;
		GtkMenuItem* _tmp16_;
		_tmp15_ = self->priv->open_item;
		gtk_menu_item_set_label (_tmp15_, _ ("Open"));
		_tmp16_ = self->priv->trash_item;
		gtk_menu_item_set_label (_tmp16_, _ ("Move to Trash"));
	}
}

void
file_menu_show_menu (FileMenu* self,
                     GdkEventButton* event)
{
	GdkScreen* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = gdk_screen_get_default ();
	gtk_menu_set_screen ((GtkMenu*) self, _tmp0_);
	gtk_menu_popup_at_pointer ((GtkMenu*) self, (GdkEvent*) event);
}

gboolean
file_menu_get_is_copying (FileMenu* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_copying;
	return result;
}

void
file_menu_set_is_copying (FileMenu* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_copying = value;
	if (self->priv->_is_copying) {
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		_tmp0_ = self->priv->cancel_copy_item;
		gtk_widget_show ((GtkWidget*) _tmp0_);
		_tmp1_ = self->priv->open_item;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->open_in_terminal_item;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->trash_item;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	} else {
		GtkMenuItem* _tmp4_;
		GtkMenuItem* _tmp5_;
		GtkMenuItem* _tmp6_;
		FileItem* _tmp7_;
		_tmp4_ = self->priv->cancel_copy_item;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->open_item;
		gtk_widget_show ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->open_in_terminal_item;
		gtk_widget_show ((GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->file_item;
		if (_tmp7_ != NULL) {
			FileItem* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = self->priv->file_item;
			_tmp9_ = desktop_item_get_is_special ((DesktopItem*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				GtkMenuItem* _tmp11_;
				_tmp11_ = self->priv->trash_item;
				gtk_widget_hide ((GtkWidget*) _tmp11_);
			} else {
				GtkMenuItem* _tmp12_;
				_tmp12_ = self->priv->trash_item;
				gtk_widget_show ((GtkWidget*) _tmp12_);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, file_menu_properties[FILE_MENU_IS_COPYING_PROPERTY]);
}

gboolean
file_menu_get_show_open_in_terminal (FileMenu* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_open_in_terminal;
	return result;
}

void
file_menu_set_show_open_in_terminal (FileMenu* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_open_in_terminal = value;
	if (self->priv->_show_open_in_terminal) {
		GtkMenuItem* _tmp0_;
		_tmp0_ = self->priv->open_in_terminal_item;
		gtk_widget_show ((GtkWidget*) _tmp0_);
	} else {
		GtkMenuItem* _tmp1_;
		_tmp1_ = self->priv->open_in_terminal_item;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	g_object_notify_by_pspec ((GObject *) self, file_menu_properties[FILE_MENU_SHOW_OPEN_IN_TERMINAL_PROPERTY]);
}

static void
file_menu_class_init (FileMenuClass * klass,
                      gpointer klass_data)
{
	file_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FileMenu_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_file_menu_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_file_menu_set_property;
	G_OBJECT_CLASS (klass)->finalize = file_menu_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_MENU_IS_COPYING_PROPERTY, file_menu_properties[FILE_MENU_IS_COPYING_PROPERTY] = g_param_spec_boolean ("is-copying", "is-copying", "is-copying", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_MENU_SHOW_OPEN_IN_TERMINAL_PROPERTY, file_menu_properties[FILE_MENU_SHOW_OPEN_IN_TERMINAL_PROPERTY] = g_param_spec_boolean ("show-open-in-terminal", "show-open-in-terminal", "show-open-in-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
file_menu_instance_init (FileMenu * self,
                         gpointer klass)
{
	self->priv = file_menu_get_instance_private (self);
}

static void
file_menu_finalize (GObject * obj)
{
	FileMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_MENU, FileMenu);
	_g_object_unref0 (self->priv->file_item);
	(self->priv->selected_items == NULL) ? NULL : (self->priv->selected_items = (_g_list_free__g_object_unref0_ (self->priv->selected_items), NULL));
	_g_object_unref0 (self->priv->cancel_copy_item);
	_g_object_unref0 (self->priv->open_item);
	_g_object_unref0 (self->priv->open_in_terminal_item);
	_g_object_unref0 (self->priv->trash_item);
	G_OBJECT_CLASS (file_menu_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
file_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileMenu), 0, (GInstanceInitFunc) file_menu_instance_init, NULL };
	GType file_menu_type_id;
	file_menu_type_id = g_type_register_static (gtk_menu_get_type (), "FileMenu", &g_define_type_info, 0);
	FileMenu_private_offset = g_type_add_instance_private (file_menu_type_id, sizeof (FileMenuPrivate));
	return file_menu_type_id;
}

GType
file_menu_get_type (void)
{
	static volatile gsize file_menu_type_id__once = 0;
	if (g_once_init_enter (&file_menu_type_id__once)) {
		GType file_menu_type_id;
		file_menu_type_id = file_menu_get_type_once ();
		g_once_init_leave (&file_menu_type_id__once, file_menu_type_id);
	}
	return file_menu_type_id__once;
}

static void
_vala_file_menu_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	FileMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_MENU, FileMenu);
	switch (property_id) {
		case FILE_MENU_IS_COPYING_PROPERTY:
		g_value_set_boolean (value, file_menu_get_is_copying (self));
		break;
		case FILE_MENU_SHOW_OPEN_IN_TERMINAL_PROPERTY:
		g_value_set_boolean (value, file_menu_get_show_open_in_terminal (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_file_menu_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	FileMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_MENU, FileMenu);
	switch (property_id) {
		case FILE_MENU_IS_COPYING_PROPERTY:
		file_menu_set_is_copying (self, g_value_get_boolean (value));
		break;
		case FILE_MENU_SHOW_OPEN_IN_TERMINAL_PROPERTY:
		file_menu_set_show_open_in_terminal (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

