/* Generated by wayland-scanner 1.24.0 */

#ifndef COSMIC_OVERLAP_NOTIFY_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define COSMIC_OVERLAP_NOTIFY_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_cosmic_overlap_notify_unstable_v1 The cosmic_overlap_notify_unstable_v1 protocol
 * @section page_ifaces_cosmic_overlap_notify_unstable_v1 Interfaces
 * - @subpage page_iface_zcosmic_overlap_notify_v1 - get notifications of other elements overlapping layer surfaces
 * - @subpage page_iface_zcosmic_overlap_notification_v1 - Subscription for overlapping toplevels on a layer-surface
 * @section page_copyright_cosmic_overlap_notify_unstable_v1 Copyright
 * <pre>
 *
 * Copytight © 2024 Victoria Brekenfeld
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct ext_foreign_toplevel_handle_v1;
struct zcosmic_overlap_notification_v1;
struct zcosmic_overlap_notify_v1;
struct zwlr_layer_surface_v1;

#ifndef ZCOSMIC_OVERLAP_NOTIFY_V1_INTERFACE
#define ZCOSMIC_OVERLAP_NOTIFY_V1_INTERFACE
/**
 * @page page_iface_zcosmic_overlap_notify_v1 zcosmic_overlap_notify_v1
 * @section page_iface_zcosmic_overlap_notify_v1_desc Description
 *
 * The purpose of this protocol is to enable layer-shell client to get
 * notifications if part of their surfaces are occluded other elements
 * (currently toplevels and other layer-surfaces).
 *
 * You can request a notification object for any of your zwlr_layer_surface_v1
 * surfaces, which will then emit overlap events.
 * @section page_iface_zcosmic_overlap_notify_v1_api API
 * See @ref iface_zcosmic_overlap_notify_v1.
 */
/**
 * @defgroup iface_zcosmic_overlap_notify_v1 The zcosmic_overlap_notify_v1 interface
 *
 * The purpose of this protocol is to enable layer-shell client to get
 * notifications if part of their surfaces are occluded other elements
 * (currently toplevels and other layer-surfaces).
 *
 * You can request a notification object for any of your zwlr_layer_surface_v1
 * surfaces, which will then emit overlap events.
 */
extern const struct wl_interface zcosmic_overlap_notify_v1_interface;
#endif
#ifndef ZCOSMIC_OVERLAP_NOTIFICATION_V1_INTERFACE
#define ZCOSMIC_OVERLAP_NOTIFICATION_V1_INTERFACE
/**
 * @page page_iface_zcosmic_overlap_notification_v1 zcosmic_overlap_notification_v1
 * @section page_iface_zcosmic_overlap_notification_v1_desc Description
 * @section page_iface_zcosmic_overlap_notification_v1_api API
 * See @ref iface_zcosmic_overlap_notification_v1.
 */
/**
 * @defgroup iface_zcosmic_overlap_notification_v1 The zcosmic_overlap_notification_v1 interface
 */
extern const struct wl_interface zcosmic_overlap_notification_v1_interface;
#endif

#define ZCOSMIC_OVERLAP_NOTIFY_V1_NOTIFY_ON_OVERLAP 0


/**
 * @ingroup iface_zcosmic_overlap_notify_v1
 */
#define ZCOSMIC_OVERLAP_NOTIFY_V1_NOTIFY_ON_OVERLAP_SINCE_VERSION 1

/** @ingroup iface_zcosmic_overlap_notify_v1 */
static inline void
zcosmic_overlap_notify_v1_set_user_data(struct zcosmic_overlap_notify_v1 *zcosmic_overlap_notify_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcosmic_overlap_notify_v1, user_data);
}

/** @ingroup iface_zcosmic_overlap_notify_v1 */
static inline void *
zcosmic_overlap_notify_v1_get_user_data(struct zcosmic_overlap_notify_v1 *zcosmic_overlap_notify_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcosmic_overlap_notify_v1);
}

static inline uint32_t
zcosmic_overlap_notify_v1_get_version(struct zcosmic_overlap_notify_v1 *zcosmic_overlap_notify_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zcosmic_overlap_notify_v1);
}

/** @ingroup iface_zcosmic_overlap_notify_v1 */
static inline void
zcosmic_overlap_notify_v1_destroy(struct zcosmic_overlap_notify_v1 *zcosmic_overlap_notify_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zcosmic_overlap_notify_v1);
}

/**
 * @ingroup iface_zcosmic_overlap_notify_v1
 *
 * Requests notifications for toplevels and layer-surfaces entering and leaving the
 * surface-area of the given zwlr_layer_surface_v1. This can be used e.g. to
 * implement auto-hide functionality.
 *
 * To stop receiving notifications, destroy the returned
 * zcosmic_overlap_notification_v1 object.
 */
static inline struct zcosmic_overlap_notification_v1 *
zcosmic_overlap_notify_v1_notify_on_overlap(struct zcosmic_overlap_notify_v1 *zcosmic_overlap_notify_v1, struct zwlr_layer_surface_v1 *layer_surface)
{
	struct wl_proxy *overlap_notification;

	overlap_notification = wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_overlap_notify_v1,
			 ZCOSMIC_OVERLAP_NOTIFY_V1_NOTIFY_ON_OVERLAP, &zcosmic_overlap_notification_v1_interface, wl_proxy_get_version((struct wl_proxy *) zcosmic_overlap_notify_v1), 0, NULL, layer_surface);

	return (struct zcosmic_overlap_notification_v1 *) overlap_notification;
}

/**
 * @ingroup iface_zcosmic_overlap_notification_v1
 * @struct zcosmic_overlap_notification_v1_listener
 */
struct zcosmic_overlap_notification_v1_listener {
	/**
	 * Toplevel entered the surface area
	 *
	 * A ext_foreign_toplevel_handle_v1 has entered the surface area.
	 *
	 * This event will be emitted once for every
	 * ext_foreign_toplevel_handle_v1 representing this toplevel.
	 *
	 * Compositors are free to update the overlapping area by sending
	 * additional `toplevel_enter` events for the same toplevel without
	 * sending `toplevel_leave` in between.
	 * @param x x coordinate of the upper-left corner of the overlapping area
	 * @param y y coordinate of the upper-left corner of the overlapping area
	 * @param width width of the overlapping area
	 * @param height height of the overlapping area
	 */
	void (*toplevel_enter)(void *data,
			       struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1,
			       struct ext_foreign_toplevel_handle_v1 *toplevel,
			       int32_t x,
			       int32_t y,
			       int32_t width,
			       int32_t height);
	/**
	 * Toplevel entered the surface area
	 *
	 * A ext_foreign_toplevel_handle_v1 has left the surface area.
	 *
	 * This event will be emitted once for every
	 * ext_foreign_toplevel_handle_v1 representing this toplevel.
	 */
	void (*toplevel_leave)(void *data,
			       struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1,
			       struct ext_foreign_toplevel_handle_v1 *toplevel);
	/**
	 * Layer surface entered the surface area
	 *
	 * A zwlr_layer_surface_v1 has entered the surface area.
	 *
	 * Compositors are free to update the overlapping area by sending
	 * additional `layer_enter` events for the same surface without
	 * sending `layer_leave` in between.
	 *
	 * The overlapping region is given surface-relative to the
	 * zwlr_layer_surface_v1 used to create this notification object.
	 * @param identifier unique identifier for the overlapping layer-surface
	 * @param namespace namespace for the layer surface
	 * @param exclusive if the overlapping surface is requesting an exclusive area or not
	 * @param layer layer the overlapping surface sits on
	 * @param x x coordinate of the upper-left corner of the overlapping area
	 * @param y y coordinate of the upper-left corner of the overlapping area
	 * @param width width of the overlapping area
	 * @param height height of the overlapping area
	 */
	void (*layer_enter)(void *data,
			    struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1,
			    const char *identifier,
			    const char *namespace,
			    uint32_t exclusive,
			    uint32_t layer,
			    int32_t x,
			    int32_t y,
			    int32_t width,
			    int32_t height);
	/**
	 * Layer surface left the surface area
	 *
	 * A zwlr_layer_surface_v1 has left the surface area.
	 * @param identifier unique identifier for the overlapping layer-surface
	 */
	void (*layer_leave)(void *data,
			    struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1,
			    const char *identifier);
};

/**
 * @ingroup iface_zcosmic_overlap_notification_v1
 */
static inline int
zcosmic_overlap_notification_v1_add_listener(struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1,
					     const struct zcosmic_overlap_notification_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zcosmic_overlap_notification_v1,
				     (void (**)(void)) listener, data);
}

#define ZCOSMIC_OVERLAP_NOTIFICATION_V1_DESTROY 0

/**
 * @ingroup iface_zcosmic_overlap_notification_v1
 */
#define ZCOSMIC_OVERLAP_NOTIFICATION_V1_TOPLEVEL_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_overlap_notification_v1
 */
#define ZCOSMIC_OVERLAP_NOTIFICATION_V1_TOPLEVEL_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_overlap_notification_v1
 */
#define ZCOSMIC_OVERLAP_NOTIFICATION_V1_LAYER_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_overlap_notification_v1
 */
#define ZCOSMIC_OVERLAP_NOTIFICATION_V1_LAYER_LEAVE_SINCE_VERSION 1

/**
 * @ingroup iface_zcosmic_overlap_notification_v1
 */
#define ZCOSMIC_OVERLAP_NOTIFICATION_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zcosmic_overlap_notification_v1 */
static inline void
zcosmic_overlap_notification_v1_set_user_data(struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcosmic_overlap_notification_v1, user_data);
}

/** @ingroup iface_zcosmic_overlap_notification_v1 */
static inline void *
zcosmic_overlap_notification_v1_get_user_data(struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcosmic_overlap_notification_v1);
}

static inline uint32_t
zcosmic_overlap_notification_v1_get_version(struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zcosmic_overlap_notification_v1);
}

/**
 * @ingroup iface_zcosmic_overlap_notification_v1
 *
 * This request should be called when the client has no interest in overlap
 * notifications anymore.
 */
static inline void
zcosmic_overlap_notification_v1_destroy(struct zcosmic_overlap_notification_v1 *zcosmic_overlap_notification_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_overlap_notification_v1,
			 ZCOSMIC_OVERLAP_NOTIFICATION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_overlap_notification_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
