/*
 * Copyright (C) 2014-2026 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#pragma once

#include <QObject>

/*!
 * @brief This object is used to call operations when a widget is hidden.
 */
class OnWidgetHiddenFilter : public QObject {
	Q_OBJECT

public:
	/*!
	 * @brief Constructor.
	 *
	 * @param[in] func Function to call when hide event is encountered.
	 * @param[in] obj Used as argument of \a func.
	 * @param[in] parent Parent object.
	 */
	explicit OnWidgetHiddenFilter(void (*func)(QObject *), QObject *obj,
	    QObject *parent = Q_NULLPTR);

	/*!
	 * @brief Event filter function.
	 *
	 * @note The function catches the given keys and calls given action
	 *       functions.
	 *
	 * @param[in,out] object View object.
	 * @param[in] event Caught event.
	 * @return True if further processing of event should be blocked.
	 */
	virtual
	bool eventFilter(QObject *object, QEvent *event) Q_DECL_OVERRIDE;

private:
	void (*actionFuncPtr)(QObject *); /*!< Pointer to a function. */
	QObject *actionObj; /*!< Parameter of the action function. */
};
