/* THIS FILE IS AUTOGENERATED FROM CSSColor.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "CSSColorBinding.h"
#include "CSSColorValueBinding.h"
#include "CSSKeywordValueBinding.h"
#include "CSSNumericValueBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_layout.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CSSColor.h"
#include "mozilla/dom/CSSKeywordValue.h"
#include "mozilla/dom/CSSNumericValue.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/ObservableArrayProxyHandler.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace CSSColor_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<CSSColorValue_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_colorSpace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSColor", "colorSpace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSColor*>(void_self);
  OwningUTF8StringOrCSSKeywordValue result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetColorSpace(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetColorSpace(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_colorSpace(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "CSSColor.colorSpace setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSColor", "colorSpace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSColor*>(void_self);
  UTF8StringOrCSSKeywordValue arg0;
  if (!arg0.Init(cx, args[0], "Value being assigned", false)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetColorSpace(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetColorSpace(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSColor.colorSpace setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo colorSpace_getterinfo = {
  { get_colorSpace },
  { prototypes::id::CSSColor },
  { PrototypeTraits<prototypes::id::CSSColor>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo colorSpace_setterinfo = {
  { (JSJitGetterOp)set_colorSpace },
  { prototypes::id::CSSColor },
  { PrototypeTraits<prototypes::id::CSSColor>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

namespace Channels_Binding {
class ObservableArrayProxyHandler : public mozilla::dom::ObservableArrayProxyHandler
{
protected:
  bool
  OnDeleteItem(JSContext* aCx, JS::Handle<JSObject*> aProxy, JS::Handle<JS::Value> aValue, uint32_t aIndex) const override;

  bool
  SetIndexedValue(JSContext* aCx, JS::Handle<JSObject*> aProxy, JS::Handle<JSObject*> aBackingList, uint32_t aIndex, JS::Handle<JS::Value> aValue, JS::ObjectOpResult& aResult) const override;

public:
  static const ObservableArrayProxyHandler*
  getInstance();
};

bool
ObservableArrayProxyHandler::OnDeleteItem(JSContext* aCx, JS::Handle<JSObject*> aProxy, JS::Handle<JS::Value> aValue, uint32_t aIndex) const
{
  MOZ_ASSERT(IsObservableArrayProxy(aProxy));

  BindingCallContext cx(aCx, "ObservableArray OnDeleteItem");
  NonNull<mozilla::dom::CSSNumericValue> decl;
  if (aValue.isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSNumericValue, mozilla::dom::CSSNumericValue>(aValue, decl, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element in ObservableArray backing list", "CSSNumericValue");
        MOZ_ASSERT_UNREACHABLE("The item in ObservableArray backing list is not CSSNumericValue (Wrapper)?");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element in ObservableArray backing list");
    MOZ_ASSERT_UNREACHABLE("The item in ObservableArray backing list is not CSSNumericValue (Wrapper)?");
    return false;
  }

  JS::Value val = js::GetProxyReservedSlot(aProxy, OBSERVABLE_ARRAY_DOM_INTERFACE_SLOT);
  auto* interface = static_cast<mozilla::dom::CSSColor*>(val.toPrivate());
  MOZ_ASSERT(interface);

  ErrorResult rv;
  MOZ_KnownLive(interface)->OnDeleteChannels(decl, aIndex, rv);
  return !rv.MaybeSetPendingException(cx);
}

bool
ObservableArrayProxyHandler::SetIndexedValue(JSContext* aCx, JS::Handle<JSObject*> aProxy, JS::Handle<JSObject*> aBackingList, uint32_t aIndex, JS::Handle<JS::Value> aValue, JS::ObjectOpResult& aResult) const
{
  MOZ_ASSERT(IsObservableArrayProxy(aProxy));
  uint32_t oldLen;
  if (!JS::GetArrayLength(aCx, aBackingList, &oldLen)) {
    return false;
  }

  if (aIndex > oldLen) {
    return aResult.failBadIndex();
  }

  BindingCallContext cx(aCx, "ObservableArray SetIndexedValue");
  NonNull<mozilla::dom::CSSNumericValue> decl;
  if (aValue.isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSNumericValue, mozilla::dom::CSSNumericValue>(aValue, decl, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element in ObservableArray backing list", "CSSNumericValue");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element in ObservableArray backing list");
    return false;
  }

  if (aIndex < oldLen) {
    JS::Rooted<JS::Value> value(aCx);
    if (!JS_GetElement(aCx, aBackingList, aIndex, &value)) {
      return false;
    }

    if (!OnDeleteItem(aCx, aProxy, value, aIndex)) {
      return false;
    }
  }

  JS::Value val = js::GetProxyReservedSlot(aProxy, OBSERVABLE_ARRAY_DOM_INTERFACE_SLOT);
  auto* interface = static_cast<mozilla::dom::CSSColor*>(val.toPrivate());
  MOZ_ASSERT(interface);

  ErrorResult rv;
  MOZ_KnownLive(interface)->OnSetChannels(decl, aIndex, rv);
  if (rv.MaybeSetPendingException(cx)) {
    return false;
  }

  if (!JS_SetElement(aCx, aBackingList, aIndex, aValue)) {
    return false;
  }

  return aResult.succeed();
}

const ObservableArrayProxyHandler*
ObservableArrayProxyHandler::getInstance()
{
  static const ObservableArrayProxyHandler instance;
  return &instance;
}
} // namespace Channels_Binding

namespace ChannelsHelpers {
already_AddRefed<CSSNumericValue>
ElementAt(mozilla::dom::CSSColor* self, uint32_t aIndex, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, Channels_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  if (created) {
    PreserveWrapper(self);
  }
  JS::Rooted<JS::Value> result(cx);
  aRv.MightThrowJSException();
  if (!JS_GetElement(cx, backingObj, aIndex, &result)) {
    aRv.StealExceptionFromJSContext(cx);
    return nullptr;
  }
  if (result.isUndefined()) {
    aRv.Throw(NS_ERROR_NOT_AVAILABLE);
    return nullptr;
  }
  RefPtr<mozilla::dom::CSSNumericValue> rvalDecl;
  static_assert(IsRefcounted<mozilla::dom::CSSNumericValue>::value, "We can only store refcounted classes.");
  {
    // Our JSContext should be in the right global to do unwrapping in.
    nsresult rv = UnwrapObject<prototypes::id::CSSNumericValue, mozilla::dom::CSSNumericValue>(result, rvalDecl, cx);
    if (NS_FAILED(rv)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

void
ReplaceElementAt(mozilla::dom::CSSColor* self, uint32_t aIndex, CSSNumericValue& aValue, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  do {
    if (!GetOrCreateDOMReflector(cx, aValue, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, Channels_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper(self);
  }
  uint32_t length;
  aRv.MightThrowJSException();
  if (!JS::GetArrayLength(cx, backingObj, &length)) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
  if (aIndex > length) {
    aRv.ThrowRangeError("Invalid index");
    return;
  }
  aRv.MightThrowJSException();
  if (!JS_SetElement(cx, backingObj, aIndex, argv[0])) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
}

void
AppendElement(mozilla::dom::CSSColor* self, CSSNumericValue& aValue, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  do {
    if (!GetOrCreateDOMReflector(cx, aValue, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, Channels_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper(self);
  }
  uint32_t length;
  aRv.MightThrowJSException();
  if (!JS::GetArrayLength(cx, backingObj, &length)) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
  aRv.MightThrowJSException();
  if (!JS_SetElement(cx, backingObj, length, argv[0])) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
}

void
RemoveLastElement(mozilla::dom::CSSColor* self, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, Channels_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper(self);
  }
  uint32_t length;
  aRv.MightThrowJSException();
  if (!JS::GetArrayLength(cx, backingObj, &length)) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
  if (length == 0) {
    aRv.Throw(NS_ERROR_NOT_AVAILABLE);
    return;
  }
  aRv.MightThrowJSException();
  if (!JS::SetArrayLength(cx, backingObj, length - 1)) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
}

uint32_t
Length(mozilla::dom::CSSColor* self, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return uint32_t(0);
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return uint32_t(0);
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, Channels_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return uint32_t(0);
  }
  if (created) {
    PreserveWrapper(self);
  }
  uint32_t retVal;
  aRv.MightThrowJSException();
  if (!JS::GetArrayLength(cx, backingObj, &retVal)) {
    aRv.StealExceptionFromJSContext(cx);
    return uint32_t(0);
  }
  return retVal;
}
} // namespace ChannelsHelpers

MOZ_CAN_RUN_SCRIPT static bool
get_channels(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSColor", "channels", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSColor*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, Channels_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    return false;
  }
  if (created) {
    PreserveWrapper(self);
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setObject(*backingObj);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_channels(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "CSSColor.channels setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSColor", "channels", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSColor*>(void_self);
  binding_detail::AutoSequence<OwningNonNull<mozilla::dom::CSSNumericValue>> arg0;
  if (args[0].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[0], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Value being assigned", "observable array");
      return false;
    }
    binding_detail::AutoSequence<OwningNonNull<mozilla::dom::CSSNumericValue>> &arr = arg0;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      OwningNonNull<mozilla::dom::CSSNumericValue>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      OwningNonNull<mozilla::dom::CSSNumericValue>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::dom::CSSNumericValue>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::CSSNumericValue, mozilla::dom::CSSNumericValue>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of value being assigned", "CSSNumericValue");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of value being assigned");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Value being assigned", "observable array");
    return false;
  }
  if (xpc::WrapperFactory::IsXrayWrapper(obj)) {
    JS_ReportErrorASCII(cx, "Accessing from Xray wrapper is not supported.");
    return false;
  }

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, Channels_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    return false;
  }
  if (created) {
    PreserveWrapper(self);
  }

  const ObservableArrayProxyHandler* handler = GetObservableArrayProxyHandler(backingObj);
  if (!handler->SetLength(cx, backingObj, 0)) {
    return false;
  }

  JS::Rooted<JS::Value> val(cx);
  for (size_t i = 0; i < arg0.Length(); i++) {
    if (!GetOrCreateDOMReflector(cx, arg0.ElementAt(i), &val)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!JS_SetElement(cx, backingObj, i, val)) {
      return false;
    }
  }

  return true;
}

static const JSJitInfo channels_getterinfo = {
  { get_channels },
  { prototypes::id::CSSColor },
  { PrototypeTraits<prototypes::id::CSSColor>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  true, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 0)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) < 2, "There is no slot for us");
static const JSJitInfo channels_setterinfo = {
  { (JSJitGetterOp)set_channels },
  { prototypes::id::CSSColor },
  { PrototypeTraits<prototypes::id::CSSColor>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_alpha(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSColor", "alpha", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSColor*>(void_self);
  OwningDoubleOrCSSNumericValue result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAlpha(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAlpha(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_alpha(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "CSSColor.alpha setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSColor", "alpha", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::CSSColor*>(void_self);
  DoubleOrCSSNumericValue arg0;
  if (!arg0.Init(cx, args[0], "Value being assigned", false)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetAlpha(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetAlpha(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSColor.alpha setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo alpha_getterinfo = {
  { get_alpha },
  { prototypes::id::CSSColor },
  { PrototypeTraits<prototypes::id::CSSColor>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo alpha_setterinfo = {
  { (JSJitGetterOp)set_alpha },
  { prototypes::id::CSSColor },
  { PrototypeTraits<prototypes::id::CSSColor>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::CSSColor* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::CSSColor>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    {
      JS::Value val = JS::GetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 0));
      if (!val.isUndefined()) {
        JSObject* obj = &val.toObject();
        js::SetProxyReservedSlot(obj, OBSERVABLE_ARRAY_DOM_INTERFACE_SLOT, JS::UndefinedValue());
      }
    }
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::CSSColor>(self);
  }
}

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("colorSpace", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &colorSpace_getterinfo, GenericSetter<NormalThisPolicy>, &colorSpace_setterinfo),
  JSPropertySpec::nativeAccessors("channels", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &channels_getterinfo, GenericSetter<NormalThisPolicy>, &channels_setterinfo),
  JSPropertySpec::nativeAccessors("alpha", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &alpha_getterinfo, GenericSetter<NormalThisPolicy>, &alpha_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sNativeProperties_propertyInfos[3];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sNativeProperties_sortedPropertyIndices,
  {
    { sAttributes, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &xpc::XrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::CSSColor,
  constructors::id::CSSColor,
  &sXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSSColor constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSSColor", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "CSSColor");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::CSSColor,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "CSSColor constructor", 2)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  UTF8StringOrCSSKeywordValue arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  binding_detail::AutoSequence<OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue> arg1;
  if (args[1].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[1], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
      return false;
    }
    binding_detail::AutoSequence<OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue> &arr = arg1;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      OwningDoubleOrCSSNumericValueOrUTF8StringOrCSSKeywordValue& slot = *slotPtr;
      if (!slot.Init(cx, temp, "Element of argument 2", false)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
    return false;
  }
  DoubleOrCSSNumericValue arg2;
  if (!(args.hasDefined(2))) {
    arg2.RawSetAsDouble() = 1.0;
  } else {
    if (!arg2.Init(cx, args[2], "Argument 3", false)) {
      return false;
    }
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CSSColor>(mozilla::dom::CSSColor::Constructor(global, Constify(arg0), Constify(arg1), Constify(arg2), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSSColor constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  CSSColorValue_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::CSSColor>::Depth,
  prototypes::id::CSSColor,
  true,
  2,
  "CSSColor",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "CSSColorPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::CSSColor,
  PrototypeTraits<prototypes::id::CSSColor>::Depth,
  &sNativePropertyHooks,
  CSSColorValue_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::layout_css_typed_om_enabled();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "CSSColor",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::CSSColor>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::CSSStyleValue, prototypes::id::CSSColorValue, prototypes::id::CSSColor, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::CSSColor>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::CSSColor>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::CSSColor>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::CSSColor>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::CSSColor* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::CSSColor>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::CSSColor*>);
  MOZ_ASSERT(static_cast<mozilla::dom::CSSColorValue*>(aObject) ==
             reinterpret_cast<mozilla::dom::CSSColorValue*>(aObject),
             "Multiple inheritance for mozilla::dom::CSSColorValue is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::CSSStyleValue*>(aObject) ==
             reinterpret_cast<mozilla::dom::CSSStyleValue*>(aObject),
             "Multiple inheritance for mozilla::dom::CSSStyleValue is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::CSSColor> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
ClearCachedChannelsValue(mozilla::dom::CSSColor* aObject)
{
  JSObject* obj;
  obj = aObject->GetWrapper();
  if (!obj) {
    return;
  }
  JS::SetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), JS::UndefinedValue());
  ClearXrayExpandoSlots(RootingCx(), obj, (DOM_EXPANDO_RESERVED_SLOTS + 0));
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::CSSColor);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::CSSColor);

  JS::Handle<JSObject*> parentProto(CSSColorValue_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(CSSColorValue_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 2, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "CSSColor",
                              ShouldExpose<CSSColor_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::CSSColor,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::CSSColor,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace CSSColor_Binding



} // namespace mozilla::dom
