/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-legion-hid-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


static const gchar *
fu_legion_hid_response_status_to_string(FuLegionHidResponseStatus val)
{
    if (val == FU_LEGION_HID_RESPONSE_STATUS_OK)
        return "ok";
    if (val == FU_LEGION_HID_RESPONSE_STATUS_FAIL)
        return "fail";
    if (val == FU_LEGION_HID_RESPONSE_STATUS_BUSY)
        return "busy";
    return NULL;
}

static const gchar *
fu_legion_hid_device_id_to_string(FuLegionHidDeviceId val)
{
    if (val == FU_LEGION_HID_DEVICE_ID_UNKNOWN)
        return "unknown";
    if (val == FU_LEGION_HID_DEVICE_ID_RX)
        return "rx";
    if (val == FU_LEGION_HID_DEVICE_ID_DONGLE)
        return "dongle";
    if (val == FU_LEGION_HID_DEVICE_ID_GAMEPAD_L)
        return "gamepad-l";
    if (val == FU_LEGION_HID_DEVICE_ID_GAMEPAD_R)
        return "gamepad-r";
    if (val == FU_LEGION_HID_DEVICE_ID_GAMEPAD_L2)
        return "gamepad-l2";
    if (val == FU_LEGION_HID_DEVICE_ID_GAMEPAD_R2)
        return "gamepad-r2";
    if (val == FU_LEGION_HID_DEVICE_ID_GAMEPAD_L3)
        return "gamepad-l3";
    if (val == FU_LEGION_HID_DEVICE_ID_GAMEPAD_R3)
        return "gamepad-r3";
    return NULL;
}

/**
 * fu_struct_legion_hid_upgrade_cmd_ref: (skip):
 **/
FuStructLegionHidUpgradeCmd *
fu_struct_legion_hid_upgrade_cmd_ref(FuStructLegionHidUpgradeCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid_upgrade_cmd_unref: (skip):
 **/
void
fu_struct_legion_hid_upgrade_cmd_unref(FuStructLegionHidUpgradeCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHidUpgradeCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_legion_hid_upgrade_cmd_new_internal: (skip):
 **/
static FuStructLegionHidUpgradeCmd *
fu_struct_legion_hid_upgrade_cmd_new_internal(void)
{
    FuStructLegionHidUpgradeCmd *st = g_new0(FuStructLegionHidUpgradeCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_hid_upgrade_cmd_get_report_id: (skip):
 **/
FuLegionHidCmdConstant
fu_struct_legion_hid_upgrade_cmd_get_report_id(const FuStructLegionHidUpgradeCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_legion_hid_upgrade_cmd_get_length: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_cmd_get_length(const FuStructLegionHidUpgradeCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_legion_hid_upgrade_cmd_get_main_id: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_cmd_get_main_id(const FuStructLegionHidUpgradeCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_legion_hid_upgrade_cmd_get_sub_id: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_cmd_get_sub_id(const FuStructLegionHidUpgradeCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_legion_hid_upgrade_cmd_get_device_id: (skip):
 **/
FuLegionHidDeviceId
fu_struct_legion_hid_upgrade_cmd_get_device_id(const FuStructLegionHidUpgradeCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_legion_hid_upgrade_cmd_get_param: (skip):
 **/
FuLegionHidCmdConstant
fu_struct_legion_hid_upgrade_cmd_get_param(const FuStructLegionHidUpgradeCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_legion_hid_upgrade_cmd_get_data: (skip):
 **/
const guint8 *
fu_struct_legion_hid_upgrade_cmd_get_data(const FuStructLegionHidUpgradeCmd *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 58;
    return st->buf->data + 6;
}

/* setters */
/**
 * fu_struct_legion_hid_upgrade_cmd_set_report_id: (skip):
 **/
void
fu_struct_legion_hid_upgrade_cmd_set_report_id(FuStructLegionHidUpgradeCmd *st, FuLegionHidCmdConstant value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_hid_upgrade_cmd_set_length: (skip):
 **/
void
fu_struct_legion_hid_upgrade_cmd_set_length(FuStructLegionHidUpgradeCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_legion_hid_upgrade_cmd_set_main_id: (skip):
 **/
void
fu_struct_legion_hid_upgrade_cmd_set_main_id(FuStructLegionHidUpgradeCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_legion_hid_upgrade_cmd_set_sub_id: (skip):
 **/
void
fu_struct_legion_hid_upgrade_cmd_set_sub_id(FuStructLegionHidUpgradeCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_legion_hid_upgrade_cmd_set_device_id: (skip):
 **/
void
fu_struct_legion_hid_upgrade_cmd_set_device_id(FuStructLegionHidUpgradeCmd *st, FuLegionHidDeviceId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_legion_hid_upgrade_cmd_set_param: (skip):
 **/
void
fu_struct_legion_hid_upgrade_cmd_set_param(FuStructLegionHidUpgradeCmd *st, FuLegionHidCmdConstant value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_legion_hid_upgrade_cmd_set_data: (skip):
 **/
gboolean
fu_struct_legion_hid_upgrade_cmd_set_data(FuStructLegionHidUpgradeCmd *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 6, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_legion_hid_upgrade_cmd_new: (skip):
 **/
FuStructLegionHidUpgradeCmd *
fu_struct_legion_hid_upgrade_cmd_new(void)
{
    FuStructLegionHidUpgradeCmd *st = fu_struct_legion_hid_upgrade_cmd_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    fu_struct_legion_hid_upgrade_cmd_set_report_id(st, FU_LEGION_HID_CMD_CONSTANT_OUTPUT_REPORT_ID);
    fu_struct_legion_hid_upgrade_cmd_set_main_id(st, 0x53);
    fu_struct_legion_hid_upgrade_cmd_set_sub_id(st, 0x11);
    fu_struct_legion_hid_upgrade_cmd_set_param(st, FU_LEGION_HID_CMD_CONSTANT_UPGRADE_SEND_CMD);
    return st;
}
/**
 * fu_struct_legion_hid_upgrade_rsp_ref: (skip):
 **/
FuStructLegionHidUpgradeRsp *
fu_struct_legion_hid_upgrade_rsp_ref(FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid_upgrade_rsp_unref: (skip):
 **/
void
fu_struct_legion_hid_upgrade_rsp_unref(FuStructLegionHidUpgradeRsp *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHidUpgradeRsp refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_legion_hid_upgrade_rsp_new_internal: (skip):
 **/
static FuStructLegionHidUpgradeRsp *
fu_struct_legion_hid_upgrade_rsp_new_internal(void)
{
    FuStructLegionHidUpgradeRsp *st = g_new0(FuStructLegionHidUpgradeRsp, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_hid_upgrade_rsp_get_report_id: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_rsp_get_report_id(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_legion_hid_upgrade_rsp_get_length: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_rsp_get_length(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_legion_hid_upgrade_rsp_get_main_id: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_rsp_get_main_id(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_legion_hid_upgrade_rsp_get_sub_id: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_rsp_get_sub_id(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_legion_hid_upgrade_rsp_get_id: (skip):
 **/
FuLegionHidDeviceId
fu_struct_legion_hid_upgrade_rsp_get_id(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_legion_hid_upgrade_rsp_get_param: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_rsp_get_param(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_legion_hid_upgrade_rsp_get_data_length: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_rsp_get_data_length(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_legion_hid_upgrade_rsp_get_step: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_rsp_get_step(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_legion_hid_upgrade_rsp_get_response: (skip):
 **/
static FuLegionHidResponseStatus
fu_struct_legion_hid_upgrade_rsp_get_response(const FuStructLegionHidUpgradeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}

/* setters */
/**
 * fu_struct_legion_hid_upgrade_rsp_to_string: (skip):
 **/
static gchar *
fu_struct_legion_hid_upgrade_rsp_to_string(const FuStructLegionHidUpgradeRsp *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLegionHidUpgradeRsp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  report_id: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_rsp_get_report_id(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_rsp_get_length(st));
    g_string_append_printf(str, "  main_id: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_rsp_get_main_id(st));
    g_string_append_printf(str, "  sub_id: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_rsp_get_sub_id(st));
    {
        const gchar *tmp = fu_legion_hid_device_id_to_string(fu_struct_legion_hid_upgrade_rsp_get_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  id: 0x%x [%s]\n", (guint) fu_struct_legion_hid_upgrade_rsp_get_id(st), tmp);
        } else {
            g_string_append_printf(str, "  id: 0x%x\n", (guint) fu_struct_legion_hid_upgrade_rsp_get_id(st));
        }
    }
    g_string_append_printf(str, "  param: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_rsp_get_param(st));
    g_string_append_printf(str, "  data_length: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_rsp_get_data_length(st));
    g_string_append_printf(str, "  step: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_rsp_get_step(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_legion_hid_upgrade_rsp_validate_internal(FuStructLegionHidUpgradeRsp *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_legion_hid_upgrade_rsp_get_response(st) != FU_LEGION_HID_RESPONSE_STATUS_OK) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructLegionHidUpgradeRsp.response was not valid, "
                    "expected 'FuLegionHidResponseStatus' and got '%s'",
                    fu_legion_hid_response_status_to_string(fu_struct_legion_hid_upgrade_rsp_get_response(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_legion_hid_upgrade_rsp_parse_internal(FuStructLegionHidUpgradeRsp *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_legion_hid_upgrade_rsp_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_legion_hid_upgrade_rsp_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_legion_hid_upgrade_rsp_parse: (skip):
 **/
FuStructLegionHidUpgradeRsp *
fu_struct_legion_hid_upgrade_rsp_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructLegionHidUpgradeRsp) st = fu_struct_legion_hid_upgrade_rsp_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructLegionHidUpgradeRsp: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 10);
    if (!fu_struct_legion_hid_upgrade_rsp_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_ref: (skip):
 **/
FuStructLegionHidUpgradeQuerySizeRsp *
fu_struct_legion_hid_upgrade_query_size_rsp_ref(FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_unref: (skip):
 **/
void
fu_struct_legion_hid_upgrade_query_size_rsp_unref(FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHidUpgradeQuerySizeRsp refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_new_internal: (skip):
 **/
static FuStructLegionHidUpgradeQuerySizeRsp *
fu_struct_legion_hid_upgrade_query_size_rsp_new_internal(void)
{
    FuStructLegionHidUpgradeQuerySizeRsp *st = g_new0(FuStructLegionHidUpgradeQuerySizeRsp, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_report_id: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_query_size_rsp_get_report_id(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_length: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_query_size_rsp_get_length(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_main_id: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_query_size_rsp_get_main_id(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_sub_id: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_query_size_rsp_get_sub_id(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_id: (skip):
 **/
FuLegionHidDeviceId
fu_struct_legion_hid_upgrade_query_size_rsp_get_id(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_param: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_query_size_rsp_get_param(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_data_length: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_query_size_rsp_get_data_length(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_step: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_query_size_rsp_get_step(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_get_response: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_query_size_rsp_get_response(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}

/* setters */
/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_to_string: (skip):
 **/
static gchar *
fu_struct_legion_hid_upgrade_query_size_rsp_to_string(const FuStructLegionHidUpgradeQuerySizeRsp *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLegionHidUpgradeQuerySizeRsp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  report_id: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_report_id(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_length(st));
    g_string_append_printf(str, "  main_id: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_main_id(st));
    g_string_append_printf(str, "  sub_id: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_sub_id(st));
    {
        const gchar *tmp = fu_legion_hid_device_id_to_string(fu_struct_legion_hid_upgrade_query_size_rsp_get_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  id: 0x%x [%s]\n", (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_id(st), tmp);
        } else {
            g_string_append_printf(str, "  id: 0x%x\n", (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_id(st));
        }
    }
    g_string_append_printf(str, "  param: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_param(st));
    g_string_append_printf(str, "  data_length: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_data_length(st));
    g_string_append_printf(str, "  step: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_step(st));
    g_string_append_printf(str, "  response: 0x%x\n",
                           (guint) fu_struct_legion_hid_upgrade_query_size_rsp_get_response(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_legion_hid_upgrade_query_size_rsp_validate_internal(FuStructLegionHidUpgradeQuerySizeRsp *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_legion_hid_upgrade_query_size_rsp_parse_internal(FuStructLegionHidUpgradeQuerySizeRsp *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_legion_hid_upgrade_query_size_rsp_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_legion_hid_upgrade_query_size_rsp_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_legion_hid_upgrade_query_size_rsp_parse: (skip):
 **/
FuStructLegionHidUpgradeQuerySizeRsp *
fu_struct_legion_hid_upgrade_query_size_rsp_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructLegionHidUpgradeQuerySizeRsp) st = fu_struct_legion_hid_upgrade_query_size_rsp_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructLegionHidUpgradeQuerySizeRsp: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 10);
    if (!fu_struct_legion_hid_upgrade_query_size_rsp_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_legion_hid_upgrade_start_param_ref: (skip):
 **/
FuStructLegionHidUpgradeStartParam *
fu_struct_legion_hid_upgrade_start_param_ref(FuStructLegionHidUpgradeStartParam *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid_upgrade_start_param_unref: (skip):
 **/
void
fu_struct_legion_hid_upgrade_start_param_unref(FuStructLegionHidUpgradeStartParam *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHidUpgradeStartParam refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_legion_hid_upgrade_start_param_new_internal: (skip):
 **/
static FuStructLegionHidUpgradeStartParam *
fu_struct_legion_hid_upgrade_start_param_new_internal(void)
{
    FuStructLegionHidUpgradeStartParam *st = g_new0(FuStructLegionHidUpgradeStartParam, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_hid_upgrade_start_param_get_length: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_start_param_get_length(const FuStructLegionHidUpgradeStartParam *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_legion_hid_upgrade_start_param_get_step: (skip):
 **/
FuLegionHidUpgradeStep
fu_struct_legion_hid_upgrade_start_param_get_step(const FuStructLegionHidUpgradeStartParam *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_legion_hid_upgrade_start_param_get_flag: (skip):
 **/
guint8
fu_struct_legion_hid_upgrade_start_param_get_flag(const FuStructLegionHidUpgradeStartParam *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_legion_hid_upgrade_start_param_get_crc16: (skip):
 **/
guint16
fu_struct_legion_hid_upgrade_start_param_get_crc16(const FuStructLegionHidUpgradeStartParam *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 3, G_BIG_ENDIAN);
}
/**
 * fu_struct_legion_hid_upgrade_start_param_get_size: (skip):
 **/
guint32
fu_struct_legion_hid_upgrade_start_param_get_size(const FuStructLegionHidUpgradeStartParam *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 5, G_BIG_ENDIAN);
}
/**
 * fu_struct_legion_hid_upgrade_start_param_get_sn: (skip):
 **/
FuLegionHidCmdConstant
fu_struct_legion_hid_upgrade_start_param_get_sn(const FuStructLegionHidUpgradeStartParam *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}

/* setters */
/**
 * fu_struct_legion_hid_upgrade_start_param_set_length: (skip):
 **/
void
fu_struct_legion_hid_upgrade_start_param_set_length(FuStructLegionHidUpgradeStartParam *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_hid_upgrade_start_param_set_step: (skip):
 **/
void
fu_struct_legion_hid_upgrade_start_param_set_step(FuStructLegionHidUpgradeStartParam *st, FuLegionHidUpgradeStep value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_legion_hid_upgrade_start_param_set_flag: (skip):
 **/
void
fu_struct_legion_hid_upgrade_start_param_set_flag(FuStructLegionHidUpgradeStartParam *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_legion_hid_upgrade_start_param_set_crc16: (skip):
 **/
void
fu_struct_legion_hid_upgrade_start_param_set_crc16(FuStructLegionHidUpgradeStartParam *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 3, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_legion_hid_upgrade_start_param_set_size: (skip):
 **/
void
fu_struct_legion_hid_upgrade_start_param_set_size(FuStructLegionHidUpgradeStartParam *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->buf->data + 5, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_legion_hid_upgrade_start_param_set_sn: (skip):
 **/
void
fu_struct_legion_hid_upgrade_start_param_set_sn(FuStructLegionHidUpgradeStartParam *st, FuLegionHidCmdConstant value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_legion_hid_upgrade_start_param_new: (skip):
 **/
FuStructLegionHidUpgradeStartParam *
fu_struct_legion_hid_upgrade_start_param_new(void)
{
    FuStructLegionHidUpgradeStartParam *st = fu_struct_legion_hid_upgrade_start_param_new_internal();
    st->buf = g_byte_array_sized_new(9);
    fu_byte_array_set_size(st->buf, 9, 0x0);
    fu_struct_legion_hid_upgrade_start_param_set_length(st, 0x08);
    fu_struct_legion_hid_upgrade_start_param_set_step(st, FU_LEGION_HID_UPGRADE_STEP_START);
    fu_struct_legion_hid_upgrade_start_param_set_flag(st, 0x00);
    fu_struct_legion_hid_upgrade_start_param_set_sn(st, FU_LEGION_HID_CMD_CONSTANT_SN);
    return st;
}
/**
 * fu_struct_legion_hid_upgrade_packet_ref: (skip):
 **/
FuStructLegionHidUpgradePacket *
fu_struct_legion_hid_upgrade_packet_ref(FuStructLegionHidUpgradePacket *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid_upgrade_packet_unref: (skip):
 **/
void
fu_struct_legion_hid_upgrade_packet_unref(FuStructLegionHidUpgradePacket *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHidUpgradePacket refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_legion_hid_upgrade_packet_new_internal: (skip):
 **/
static FuStructLegionHidUpgradePacket *
fu_struct_legion_hid_upgrade_packet_new_internal(void)
{
    FuStructLegionHidUpgradePacket *st = g_new0(FuStructLegionHidUpgradePacket, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_legion_hid_upgrade_packet_set_data: (skip):
 **/
gboolean
fu_struct_legion_hid_upgrade_packet_set_data(FuStructLegionHidUpgradePacket *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_legion_hid_upgrade_packet_set_sn: (skip):
 **/
void
fu_struct_legion_hid_upgrade_packet_set_sn(FuStructLegionHidUpgradePacket *st, FuLegionHidCmdConstant value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[32] = value;
}
/**
 * fu_struct_legion_hid_upgrade_packet_new: (skip):
 **/
FuStructLegionHidUpgradePacket *
fu_struct_legion_hid_upgrade_packet_new(void)
{
    FuStructLegionHidUpgradePacket *st = fu_struct_legion_hid_upgrade_packet_new_internal();
    st->buf = g_byte_array_sized_new(33);
    fu_byte_array_set_size(st->buf, 33, 0x0);
    fu_struct_legion_hid_upgrade_packet_set_sn(st, FU_LEGION_HID_CMD_CONSTANT_SN);
    return st;
}
/**
 * fu_struct_legion_hid_normal_cmd_ref: (skip):
 **/
FuStructLegionHidNormalCmd *
fu_struct_legion_hid_normal_cmd_ref(FuStructLegionHidNormalCmd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid_normal_cmd_unref: (skip):
 **/
void
fu_struct_legion_hid_normal_cmd_unref(FuStructLegionHidNormalCmd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHidNormalCmd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_legion_hid_normal_cmd_new_internal: (skip):
 **/
static FuStructLegionHidNormalCmd *
fu_struct_legion_hid_normal_cmd_new_internal(void)
{
    FuStructLegionHidNormalCmd *st = g_new0(FuStructLegionHidNormalCmd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_hid_normal_cmd_get_report_id: (skip):
 **/
FuLegionHidCmdConstant
fu_struct_legion_hid_normal_cmd_get_report_id(const FuStructLegionHidNormalCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_legion_hid_normal_cmd_get_length: (skip):
 **/
guint8
fu_struct_legion_hid_normal_cmd_get_length(const FuStructLegionHidNormalCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_legion_hid_normal_cmd_get_main_id: (skip):
 **/
guint8
fu_struct_legion_hid_normal_cmd_get_main_id(const FuStructLegionHidNormalCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_legion_hid_normal_cmd_get_sub_id: (skip):
 **/
guint8
fu_struct_legion_hid_normal_cmd_get_sub_id(const FuStructLegionHidNormalCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_legion_hid_normal_cmd_get_device_id: (skip):
 **/
FuLegionHidDeviceId
fu_struct_legion_hid_normal_cmd_get_device_id(const FuStructLegionHidNormalCmd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_legion_hid_normal_cmd_get_data: (skip):
 **/
const guint8 *
fu_struct_legion_hid_normal_cmd_get_data(const FuStructLegionHidNormalCmd *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 59;
    return st->buf->data + 5;
}

/* setters */
/**
 * fu_struct_legion_hid_normal_cmd_set_report_id: (skip):
 **/
void
fu_struct_legion_hid_normal_cmd_set_report_id(FuStructLegionHidNormalCmd *st, FuLegionHidCmdConstant value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_legion_hid_normal_cmd_set_length: (skip):
 **/
void
fu_struct_legion_hid_normal_cmd_set_length(FuStructLegionHidNormalCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_legion_hid_normal_cmd_set_main_id: (skip):
 **/
void
fu_struct_legion_hid_normal_cmd_set_main_id(FuStructLegionHidNormalCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_legion_hid_normal_cmd_set_sub_id: (skip):
 **/
void
fu_struct_legion_hid_normal_cmd_set_sub_id(FuStructLegionHidNormalCmd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_legion_hid_normal_cmd_set_device_id: (skip):
 **/
void
fu_struct_legion_hid_normal_cmd_set_device_id(FuStructLegionHidNormalCmd *st, FuLegionHidDeviceId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_legion_hid_normal_cmd_set_data: (skip):
 **/
gboolean
fu_struct_legion_hid_normal_cmd_set_data(FuStructLegionHidNormalCmd *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 5, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_legion_hid_normal_cmd_new: (skip):
 **/
FuStructLegionHidNormalCmd *
fu_struct_legion_hid_normal_cmd_new(void)
{
    FuStructLegionHidNormalCmd *st = fu_struct_legion_hid_normal_cmd_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    fu_struct_legion_hid_normal_cmd_set_report_id(st, FU_LEGION_HID_CMD_CONSTANT_OUTPUT_REPORT_ID);
    return st;
}
/**
 * fu_struct_legion_hid_bin_header_ref: (skip):
 **/
FuStructLegionHidBinHeader *
fu_struct_legion_hid_bin_header_ref(FuStructLegionHidBinHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_legion_hid_bin_header_unref: (skip):
 **/
void
fu_struct_legion_hid_bin_header_unref(FuStructLegionHidBinHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructLegionHidBinHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_legion_hid_bin_header_new_internal: (skip):
 **/
static FuStructLegionHidBinHeader *
fu_struct_legion_hid_bin_header_new_internal(void)
{
    FuStructLegionHidBinHeader *st = g_new0(FuStructLegionHidBinHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_legion_hid_bin_header_get_mcu_size: (skip):
 **/
guint32
fu_struct_legion_hid_bin_header_get_mcu_size(const FuStructLegionHidBinHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_get_mcu_version: (skip):
 **/
guint32
fu_struct_legion_hid_bin_header_get_mcu_version(const FuStructLegionHidBinHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_get_left_size: (skip):
 **/
guint32
fu_struct_legion_hid_bin_header_get_left_size(const FuStructLegionHidBinHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_get_left_version: (skip):
 **/
guint32
fu_struct_legion_hid_bin_header_get_left_version(const FuStructLegionHidBinHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_get_right_size: (skip):
 **/
guint32
fu_struct_legion_hid_bin_header_get_right_size(const FuStructLegionHidBinHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_get_right_version: (skip):
 **/
guint32
fu_struct_legion_hid_bin_header_get_right_version(const FuStructLegionHidBinHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_legion_hid_bin_header_set_mcu_size: (skip):
 **/
void
fu_struct_legion_hid_bin_header_set_mcu_size(FuStructLegionHidBinHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_set_mcu_version: (skip):
 **/
void
fu_struct_legion_hid_bin_header_set_mcu_version(FuStructLegionHidBinHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_set_left_size: (skip):
 **/
void
fu_struct_legion_hid_bin_header_set_left_size(FuStructLegionHidBinHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_set_left_version: (skip):
 **/
void
fu_struct_legion_hid_bin_header_set_left_version(FuStructLegionHidBinHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_set_right_size: (skip):
 **/
void
fu_struct_legion_hid_bin_header_set_right_size(FuStructLegionHidBinHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_set_right_version: (skip):
 **/
void
fu_struct_legion_hid_bin_header_set_right_version(FuStructLegionHidBinHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_legion_hid_bin_header_to_string: (skip):
 **/
static gchar *
fu_struct_legion_hid_bin_header_to_string(const FuStructLegionHidBinHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructLegionHidBinHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  mcu_size: 0x%x\n",
                           (guint) fu_struct_legion_hid_bin_header_get_mcu_size(st));
    g_string_append_printf(str, "  mcu_version: 0x%x\n",
                           (guint) fu_struct_legion_hid_bin_header_get_mcu_version(st));
    g_string_append_printf(str, "  left_size: 0x%x\n",
                           (guint) fu_struct_legion_hid_bin_header_get_left_size(st));
    g_string_append_printf(str, "  left_version: 0x%x\n",
                           (guint) fu_struct_legion_hid_bin_header_get_left_version(st));
    g_string_append_printf(str, "  right_size: 0x%x\n",
                           (guint) fu_struct_legion_hid_bin_header_get_right_size(st));
    g_string_append_printf(str, "  right_version: 0x%x\n",
                           (guint) fu_struct_legion_hid_bin_header_get_right_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_legion_hid_bin_header_validate_internal(FuStructLegionHidBinHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_legion_hid_bin_header_parse_internal(FuStructLegionHidBinHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_legion_hid_bin_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_legion_hid_bin_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_legion_hid_bin_header_parse_stream: (skip):
 **/
FuStructLegionHidBinHeader *
fu_struct_legion_hid_bin_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructLegionHidBinHeader) st = fu_struct_legion_hid_bin_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 24, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructLegionHidBinHeader failed read of 0x%x: ", (guint) 24);
        return NULL;
    }
    if (st->buf->len != 24) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructLegionHidBinHeader requested 0x%x and got 0x%x",
                    (guint) 24,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_legion_hid_bin_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
