/* gitg-diff-view-file-selectable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-view-file-selectable.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <gtksourceview/gtksource.h>
#include "libgitg.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	GITG_DIFF_SELECTION_MODE_NONE,
	GITG_DIFF_SELECTION_MODE_SELECTING,
	GITG_DIFF_SELECTION_MODE_DESELECTING
} GitgDiffSelectionMode;

#define GITG_TYPE_DIFF_SELECTION_MODE (gitg_diff_selection_mode_get_type ())

#define GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE (gitg_diff_view_file_selectable_get_type ())
#define GITG_DIFF_VIEW_FILE_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE, GitgDiffViewFileSelectable))
#define GITG_DIFF_VIEW_FILE_SELECTABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE, GitgDiffViewFileSelectableClass))
#define GITG_IS_DIFF_VIEW_FILE_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE))
#define GITG_IS_DIFF_VIEW_FILE_SELECTABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE))
#define GITG_DIFF_VIEW_FILE_SELECTABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE, GitgDiffViewFileSelectableClass))

typedef struct _GitgDiffViewFileSelectable GitgDiffViewFileSelectable;
typedef struct _GitgDiffViewFileSelectableClass GitgDiffViewFileSelectableClass;
typedef struct _GitgDiffViewFileSelectablePrivate GitgDiffViewFileSelectablePrivate;
enum  {
	GITG_DIFF_VIEW_FILE_SELECTABLE_0_PROPERTY,
	GITG_DIFF_VIEW_FILE_SELECTABLE_SOURCE_VIEW_PROPERTY,
	GITG_DIFF_VIEW_FILE_SELECTABLE_HAS_SELECTION_PROPERTY,
	GITG_DIFF_VIEW_FILE_SELECTABLE_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_view_file_selectable_properties[GITG_DIFF_VIEW_FILE_SELECTABLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GitgDiffViewFileSelectable {
	GObject parent_instance;
	GitgDiffViewFileSelectablePrivate * priv;
};

struct _GitgDiffViewFileSelectableClass {
	GObjectClass parent_class;
};

struct _GitgDiffViewFileSelectablePrivate {
	gchar* d_selection_category;
	GtkTextTag* d_selection_tag;
	GitgDiffSelectionMode d_selection_mode;
	GtkTextMark* d_start_selection_mark;
	GtkTextMark* d_end_selection_mark;
	GeeHashMap* d_originally_selected;
	GdkCursor* d_cursor_ptr;
	GdkCursor* d_cursor_hand;
	gboolean d_is_rubber_band;
	GtkSourceView* _source_view;
	gboolean _has_selection;
};

static gint GitgDiffViewFileSelectable_private_offset;
static gpointer gitg_diff_view_file_selectable_parent_class = NULL;

VALA_EXTERN GType gitg_diff_selection_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_view_file_selectable_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint* gitg_diff_view_file_selectable_get_selected_lines (GitgDiffViewFileSelectable* self,
                                                         gint* result_length1);
VALA_EXTERN GtkSourceView* gitg_diff_view_file_selectable_get_source_view (GitgDiffViewFileSelectable* self);
static void _vala_array_add6 (gint* * array,
                       gint* length,
                       gint* size,
                       gint value);
VALA_EXTERN GitgDiffViewFileSelectable* gitg_diff_view_file_selectable_new (GtkSourceView* source_view);
VALA_EXTERN GitgDiffViewFileSelectable* gitg_diff_view_file_selectable_construct (GType object_type,
                                                                      GtkSourceView* source_view);
static void gitg_diff_view_file_selectable_update_cursor (GitgDiffViewFileSelectable* self,
                                                   GdkCursor* cursor);
static void gitg_diff_view_file_selectable_update_theme (GitgDiffViewFileSelectable* self);
static gboolean gitg_diff_view_file_selectable_get_line_selected (GitgDiffViewFileSelectable* self,
                                                           GtkTextIter* iter);
static gboolean gitg_diff_view_file_selectable_get_line_is_diff (GitgDiffViewFileSelectable* self,
                                                          GtkTextIter* iter);
static gboolean gitg_diff_view_file_selectable_get_line_is_hunk (GitgDiffViewFileSelectable* self,
                                                          GtkTextIter* iter);
static gboolean gitg_diff_view_file_selectable_get_iter_from_pointer_position (GitgDiffViewFileSelectable* self,
                                                                        GtkTextIter* iter);
static gboolean gitg_diff_view_file_selectable_get_iter_from_event_position (GitgDiffViewFileSelectable* self,
                                                                      GtkTextIter* iter,
                                                                      gint x,
                                                                      gint y);
static void gitg_diff_view_file_selectable_update_selection_range (GitgDiffViewFileSelectable* self,
                                                            GtkTextIter* start,
                                                            GtkTextIter* end,
                                                            gboolean select);
static void gitg_diff_view_file_selectable_clear_original_selection (GitgDiffViewFileSelectable* self,
                                                              GtkTextIter* start,
                                                              GtkTextIter* end,
                                                              gboolean include_end);
static void gitg_diff_view_file_selectable_forward_to_hunk_end (GitgDiffViewFileSelectable* self,
                                                         GtkTextIter* iter);
static gboolean gitg_diff_view_file_selectable_hunk_is_all_selected (GitgDiffViewFileSelectable* self,
                                                              GtkTextIter* iter);
static void gitg_diff_view_file_selectable_update_selection_hunk (GitgDiffViewFileSelectable* self,
                                                           GtkTextIter* iter,
                                                           gboolean select);
static gboolean gitg_diff_view_file_selectable_button_press_event_on_view (GitgDiffViewFileSelectable* self,
                                                                    GdkEventButton* event);
static void gitg_diff_view_file_selectable_update_selection (GitgDiffViewFileSelectable* self,
                                                      GtkTextIter* cursor);
static gboolean gitg_diff_view_file_selectable_update_selection_event (GitgDiffViewFileSelectable* self,
                                                                GdkModifierType state,
                                                                gint x,
                                                                gint y);
static GdkCursor* gitg_diff_view_file_selectable_get_cursor_hand (GitgDiffViewFileSelectable* self);
static GdkCursor* gitg_diff_view_file_selectable_get_cursor_ptr (GitgDiffViewFileSelectable* self);
static gboolean gitg_diff_view_file_selectable_motion_notify_event_on_view (GitgDiffViewFileSelectable* self,
                                                                     GdkEventMotion* event);
static gboolean gitg_diff_view_file_selectable_leave_notify_event_on_view (GitgDiffViewFileSelectable* self,
                                                                    GdkEventCrossing* event);
static gboolean gitg_diff_view_file_selectable_enter_notify_event_on_view (GitgDiffViewFileSelectable* self,
                                                                    GdkEventCrossing* event);
static void gitg_diff_view_file_selectable_update_has_selection (GitgDiffViewFileSelectable* self);
VALA_EXTERN gboolean gitg_diff_view_file_selectable_get_has_selection (GitgDiffViewFileSelectable* self);
static void gitg_diff_view_file_selectable_set_has_selection (GitgDiffViewFileSelectable* self,
                                                       gboolean value);
static gboolean gitg_diff_view_file_selectable_button_release_event_on_view (GitgDiffViewFileSelectable* self,
                                                                      GdkEventButton* event);
VALA_EXTERN void gitg_diff_view_file_selectable_set_source_view (GitgDiffViewFileSelectable* self,
                                                     GtkSourceView* value);
static GObject * gitg_diff_view_file_selectable_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static gboolean _gitg_diff_view_file_selectable_button_press_event_on_view_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                                   GdkEventButton* event,
                                                                                                   gpointer self);
static gboolean _gitg_diff_view_file_selectable_motion_notify_event_on_view_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                                     GdkEventMotion* event,
                                                                                                     gpointer self);
static gboolean _gitg_diff_view_file_selectable_leave_notify_event_on_view_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                                                   GdkEventCrossing* event,
                                                                                                   gpointer self);
static gboolean _gitg_diff_view_file_selectable_enter_notify_event_on_view_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                                                   GdkEventCrossing* event,
                                                                                                   gpointer self);
static gboolean _gitg_diff_view_file_selectable_button_release_event_on_view_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                                       GdkEventButton* event,
                                                                                                       gpointer self);
static void _gitg_diff_view_file_selectable___lambda51_ (GitgDiffViewFileSelectable* self);
static void __gitg_diff_view_file_selectable___lambda51__gtk_widget_realize (GtkWidget* _sender,
                                                                      gpointer self);
static void _gitg_diff_view_file_selectable___lambda52_ (GitgDiffViewFileSelectable* self);
static void __gitg_diff_view_file_selectable___lambda52__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _gitg_diff_view_file_selectable_update_theme_gtk_widget_style_updated (GtkWidget* _sender,
                                                                            gpointer self);
static void gitg_diff_view_file_selectable_finalize (GObject * obj);
static GType gitg_diff_view_file_selectable_get_type_once (void);
static void _vala_gitg_diff_view_file_selectable_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_gitg_diff_view_file_selectable_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

 G_GNUC_NO_INLINE static GType
gitg_diff_selection_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_DIFF_SELECTION_MODE_NONE, "GITG_DIFF_SELECTION_MODE_NONE", "none"}, {GITG_DIFF_SELECTION_MODE_SELECTING, "GITG_DIFF_SELECTION_MODE_SELECTING", "selecting"}, {GITG_DIFF_SELECTION_MODE_DESELECTING, "GITG_DIFF_SELECTION_MODE_DESELECTING", "deselecting"}, {0, NULL, NULL}};
	GType gitg_diff_selection_mode_type_id;
	gitg_diff_selection_mode_type_id = g_enum_register_static ("GitgDiffSelectionMode", values);
	return gitg_diff_selection_mode_type_id;
}

GType
gitg_diff_selection_mode_get_type (void)
{
	static gsize gitg_diff_selection_mode_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_selection_mode_type_id__once)) {
		GType gitg_diff_selection_mode_type_id;
		gitg_diff_selection_mode_type_id = gitg_diff_selection_mode_get_type_once ();
		g_once_init_leave (&gitg_diff_selection_mode_type_id__once, gitg_diff_selection_mode_type_id);
	}
	return gitg_diff_selection_mode_type_id__once;
}

static inline gpointer
gitg_diff_view_file_selectable_get_instance_private (GitgDiffViewFileSelectable* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffViewFileSelectable_private_offset);
}

static void
_vala_array_add6 (gint* * array,
                  gint* length,
                  gint* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

gint*
gitg_diff_view_file_selectable_get_selected_lines (GitgDiffViewFileSelectable* self,
                                                   gint* result_length1)
{
	gint* ret = NULL;
	gint* _tmp0_;
	gint ret_length1;
	gint _ret_size_;
	GtkTextIter iter = {0};
	GtkSourceBuffer* buffer = NULL;
	GtkSourceView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkSourceBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	gint* _tmp9_;
	gint _tmp9__length1;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gint, 0);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = self->priv->_source_view;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp1_);
	_tmp3_ = _tmp2_;
	buffer = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_source_buffer_get_type (), GtkSourceBuffer);
	_tmp4_ = buffer;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	while (TRUE) {
		GtkSourceBuffer* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = buffer;
		_tmp7_ = self->priv->d_selection_category;
		_tmp8_ = gtk_source_buffer_forward_iter_to_source_mark (_tmp6_, &iter, _tmp7_);
		if (!_tmp8_) {
			break;
		}
		_vala_array_add6 (&ret, &ret_length1, &_ret_size_, gtk_text_iter_get_line (&iter));
	}
	_tmp9_ = ret;
	_tmp9__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

GitgDiffViewFileSelectable*
gitg_diff_view_file_selectable_construct (GType object_type,
                                          GtkSourceView* source_view)
{
	GitgDiffViewFileSelectable * self = NULL;
	g_return_val_if_fail (source_view != NULL, NULL);
	self = (GitgDiffViewFileSelectable*) g_object_new (object_type, "source-view", source_view, NULL);
	return self;
}

GitgDiffViewFileSelectable*
gitg_diff_view_file_selectable_new (GtkSourceView* source_view)
{
	return gitg_diff_view_file_selectable_construct (GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE, source_view);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_diff_view_file_selectable_update_cursor (GitgDiffViewFileSelectable* self,
                                              GdkCursor* cursor)
{
	GdkWindow* window = NULL;
	GtkSourceView* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	GdkWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cursor != NULL);
	_tmp0_ = self->priv->_source_view;
	_tmp1_ = gtk_text_view_get_window ((GtkTextView*) _tmp0_, GTK_TEXT_WINDOW_TEXT);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	window = _tmp2_;
	_tmp3_ = window;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	_tmp4_ = window;
	gdk_window_set_cursor (_tmp4_, cursor);
	_g_object_unref0 (window);
}

static void
gitg_diff_view_file_selectable_update_theme (GitgDiffViewFileSelectable* self)
{
	GtkSourceMarkAttributes* selection_attributes = NULL;
	GtkSourceMarkAttributes* _tmp0_;
	GtkStyleContext* context = NULL;
	GtkSourceView* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GdkRGBA theme_selected_bg_color = {0};
	GdkRGBA theme_selected_fg_color = {0};
	GtkStyleContext* _tmp4_;
	GdkRGBA _tmp5_ = {0};
	gboolean _tmp6_;
	GtkStyleContext* _tmp9_;
	GdkRGBA _tmp10_ = {0};
	gboolean _tmp11_;
	GtkSourceView* _tmp14_;
	const gchar* _tmp15_;
	GtkSourceMarkAttributes* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_mark_attributes_new ();
	selection_attributes = _tmp0_;
	_tmp1_ = self->priv->_source_view;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	context = _tmp3_;
	_tmp4_ = context;
	_tmp6_ = gtk_style_context_lookup_color (_tmp4_, "theme_selected_bg_color", &_tmp5_);
	theme_selected_bg_color = _tmp5_;
	if (_tmp6_) {
		GtkSourceMarkAttributes* _tmp7_;
		GdkRGBA _tmp8_;
		_tmp7_ = selection_attributes;
		_tmp8_ = theme_selected_bg_color;
		g_object_set (_tmp7_, "background", &_tmp8_, NULL);
	}
	_tmp9_ = context;
	_tmp11_ = gtk_style_context_lookup_color (_tmp9_, "theme_selected_fg_color", &_tmp10_);
	theme_selected_fg_color = _tmp10_;
	if (_tmp11_) {
		GtkTextTag* _tmp12_;
		GdkRGBA _tmp13_;
		_tmp12_ = self->priv->d_selection_tag;
		_tmp13_ = theme_selected_fg_color;
		g_object_set (_tmp12_, "foreground-rgba", &_tmp13_, NULL);
	}
	_tmp14_ = self->priv->_source_view;
	_tmp15_ = self->priv->d_selection_category;
	_tmp16_ = selection_attributes;
	gtk_source_view_set_mark_attributes (_tmp14_, _tmp15_, _tmp16_, 0);
	_g_object_unref0 (context);
	_g_object_unref0 (selection_attributes);
}

static gboolean
gitg_diff_view_file_selectable_get_line_selected (GitgDiffViewFileSelectable* self,
                                                  GtkTextIter* iter)
{
	GtkTextIter start = {0};
	GtkTextIter _tmp0_;
	GtkSourceBuffer* buffer = NULL;
	GtkSourceView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_;
	const gchar* _tmp5_;
	GSList* _tmp6_;
	GSList* _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	start = _tmp0_;
	gtk_text_iter_set_line_offset (&start, 0);
	_tmp1_ = self->priv->_source_view;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp1_);
	_tmp3_ = _tmp2_;
	buffer = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_source_buffer_get_type (), GtkSourceBuffer);
	_tmp4_ = start;
	_tmp5_ = self->priv->d_selection_category;
	_tmp6_ = gtk_source_buffer_get_source_marks_at_iter (buffer, &_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != NULL;
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (g_slist_free (_tmp7_), NULL));
	result = _tmp8_;
	return result;
}

static gboolean
gitg_diff_view_file_selectable_get_line_is_diff (GitgDiffViewFileSelectable* self,
                                                 GtkTextIter* iter)
{
	GtkTextIter start = {0};
	GtkTextIter _tmp0_;
	GtkSourceBuffer* buffer = NULL;
	GtkSourceView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkSourceBuffer* _tmp5_;
	GtkTextIter _tmp6_;
	GSList* _tmp7_;
	GSList* _tmp8_;
	gboolean _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	start = _tmp0_;
	gtk_text_iter_set_line_offset (&start, 0);
	_tmp1_ = self->priv->_source_view;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp1_);
	_tmp3_ = _tmp2_;
	buffer = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_source_buffer_get_type (), GtkSourceBuffer);
	_tmp5_ = buffer;
	_tmp6_ = start;
	_tmp7_ = gtk_source_buffer_get_source_marks_at_iter (_tmp5_, &_tmp6_, "added");
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (g_slist_free (_tmp8_), NULL));
	if (_tmp9_) {
		_tmp4_ = TRUE;
	} else {
		GtkSourceBuffer* _tmp10_;
		GtkTextIter _tmp11_;
		GSList* _tmp12_;
		GSList* _tmp13_;
		_tmp10_ = buffer;
		_tmp11_ = start;
		_tmp12_ = gtk_source_buffer_get_source_marks_at_iter (_tmp10_, &_tmp11_, "removed");
		_tmp13_ = _tmp12_;
		_tmp4_ = _tmp13_ != NULL;
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (g_slist_free (_tmp13_), NULL));
	}
	result = _tmp4_;
	return result;
}

static gboolean
gitg_diff_view_file_selectable_get_line_is_hunk (GitgDiffViewFileSelectable* self,
                                                 GtkTextIter* iter)
{
	GtkTextIter start = {0};
	GtkTextIter _tmp0_;
	GtkSourceBuffer* buffer = NULL;
	GtkSourceView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_;
	GSList* _tmp5_;
	GSList* _tmp6_;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	start = _tmp0_;
	gtk_text_iter_set_line_offset (&start, 0);
	_tmp1_ = self->priv->_source_view;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp1_);
	_tmp3_ = _tmp2_;
	buffer = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_source_buffer_get_type (), GtkSourceBuffer);
	_tmp4_ = start;
	_tmp5_ = gtk_source_buffer_get_source_marks_at_iter (buffer, &_tmp4_, "header");
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != NULL;
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (g_slist_free (_tmp6_), NULL));
	result = _tmp7_;
	return result;
}

static gboolean
gitg_diff_view_file_selectable_get_iter_from_pointer_position (GitgDiffViewFileSelectable* self,
                                                               GtkTextIter* iter)
{
	GtkTextIter _vala_iter = {0};
	GdkWindow* win = NULL;
	GtkSourceView* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	gint x = 0;
	gint y = 0;
	gint width = 0;
	gint height = 0;
	GtkTextIter dummy_iter = {0};
	GtkTextIter _tmp3_;
	GdkWindow* _tmp4_;
	GdkWindow* _tmp5_;
	GdkDevice* pointer = NULL;
	GdkDisplay* _tmp6_;
	GdkSeat* _tmp7_;
	GdkDevice* _tmp8_;
	GdkDevice* _tmp9_;
	GdkWindow* _tmp10_;
	GdkDevice* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GtkTextIter _tmp17_ = {0};
	gboolean _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_source_view;
	_tmp1_ = gtk_text_view_get_window ((GtkTextView*) _tmp0_, GTK_TEXT_WINDOW_TEXT);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	win = _tmp2_;
	memset (&dummy_iter, 0, sizeof (GtkTextIter));
	_tmp3_ = dummy_iter;
	_vala_iter = _tmp3_;
	_tmp4_ = win;
	width = gdk_window_get_width (_tmp4_);
	_tmp5_ = win;
	height = gdk_window_get_height (_tmp5_);
	_tmp6_ = gdk_display_get_default ();
	_tmp7_ = gdk_display_get_default_seat (_tmp6_);
	_tmp8_ = gdk_seat_get_pointer (_tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	pointer = _tmp9_;
	_tmp10_ = win;
	_tmp11_ = pointer;
	gdk_window_get_device_position (_tmp10_, _tmp11_, &_tmp12_, &_tmp13_, NULL);
	x = _tmp12_;
	y = _tmp13_;
	if (x < 0) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = y < 0;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = x > width;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = y > height;
	}
	if (_tmp14_) {
		result = FALSE;
		_g_object_unref0 (pointer);
		_g_object_unref0 (win);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp18_ = gitg_diff_view_file_selectable_get_iter_from_event_position (self, &_tmp17_, x, y);
	_vala_iter = _tmp17_;
	result = _tmp18_;
	_g_object_unref0 (pointer);
	_g_object_unref0 (win);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
gitg_diff_view_file_selectable_get_iter_from_event_position (GitgDiffViewFileSelectable* self,
                                                             GtkTextIter* iter,
                                                             gint x,
                                                             gint y)
{
	GtkTextIter _vala_iter = {0};
	gint win_x = 0;
	gint win_y = 0;
	GtkSourceView* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkSourceView* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_source_view;
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) _tmp0_, GTK_TEXT_WINDOW_TEXT, x, y, &_tmp1_, &_tmp2_);
	win_x = _tmp1_;
	win_y = _tmp2_;
	_tmp3_ = self->priv->_source_view;
	gtk_text_view_get_line_at_y ((GtkTextView*) _tmp3_, &_tmp4_, win_y, NULL);
	_vala_iter = _tmp4_;
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static void
gitg_diff_view_file_selectable_update_selection_range (GitgDiffViewFileSelectable* self,
                                                       GtkTextIter* start,
                                                       GtkTextIter* end,
                                                       gboolean select)
{
	GtkSourceBuffer* buffer = NULL;
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter real_start = {0};
	GtkTextIter real_end = {0};
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gint start_line = 0;
	gint end_line = 0;
	GtkTextIter current = {0};
	GtkTextIter _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = self->priv->_source_view;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	buffer = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_source_buffer_get_type (), GtkSourceBuffer);
	_tmp3_ = *start;
	real_start = _tmp3_;
	_tmp4_ = *end;
	real_end = _tmp4_;
	_tmp5_ = real_end;
	if (gtk_text_iter_compare (&real_start, &_tmp5_) > 0) {
		GtkTextIter tmp = {0};
		GtkTextIter _tmp6_;
		GtkTextIter _tmp7_;
		GtkTextIter _tmp8_;
		_tmp6_ = real_end;
		tmp = _tmp6_;
		_tmp7_ = real_start;
		real_end = _tmp7_;
		_tmp8_ = tmp;
		real_start = _tmp8_;
	}
	gtk_text_iter_set_line_offset (&real_start, 0);
	if (!gtk_text_iter_ends_line (&real_end)) {
		gtk_text_iter_forward_to_line_end (&real_end);
	}
	start_line = gtk_text_iter_get_line (&real_start);
	end_line = gtk_text_iter_get_line (&real_end);
	_tmp9_ = real_start;
	current = _tmp9_;
	while (TRUE) {
		GtkTextIter _tmp10_;
		gint _tmp22_;
		if (!(start_line <= end_line)) {
			break;
		}
		_tmp10_ = current;
		if (gitg_diff_view_file_selectable_get_line_is_diff (self, &_tmp10_)) {
			GeeHashMap* _tmp11_;
			_tmp11_ = self->priv->d_originally_selected;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp11_, (gpointer) ((gintptr) start_line))) {
				GeeHashMap* _tmp12_;
				GtkTextIter _tmp13_;
				_tmp12_ = self->priv->d_originally_selected;
				_tmp13_ = current;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, (gpointer) ((gintptr) start_line), (gpointer) ((gintptr) gitg_diff_view_file_selectable_get_line_selected (self, &_tmp13_)));
			}
			if (select) {
				GtkSourceBuffer* _tmp14_;
				const gchar* _tmp15_;
				GtkTextIter _tmp16_;
				GtkTextIter line_end = {0};
				GtkTextIter _tmp17_;
				GtkSourceBuffer* _tmp18_;
				GtkTextTag* _tmp19_;
				GtkTextIter _tmp20_;
				GtkTextIter _tmp21_;
				_tmp14_ = buffer;
				_tmp15_ = self->priv->d_selection_category;
				_tmp16_ = current;
				gtk_source_buffer_create_source_mark (_tmp14_, NULL, _tmp15_, &_tmp16_);
				_tmp17_ = current;
				line_end = _tmp17_;
				if (!gtk_text_iter_ends_line (&line_end)) {
					gtk_text_iter_forward_to_line_end (&line_end);
				}
				_tmp18_ = buffer;
				_tmp19_ = self->priv->d_selection_tag;
				_tmp20_ = current;
				_tmp21_ = line_end;
				gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp18_, _tmp19_, &_tmp20_, &_tmp21_);
			}
		}
		if (!gtk_text_iter_forward_line (&current)) {
			break;
		}
		_tmp22_ = start_line;
		start_line = _tmp22_ + 1;
	}
	if (!select) {
		GtkSourceBuffer* _tmp23_;
		GtkTextIter _tmp24_;
		GtkTextIter _tmp25_;
		const gchar* _tmp26_;
		GtkSourceBuffer* _tmp27_;
		GtkTextTag* _tmp28_;
		GtkTextIter _tmp29_;
		GtkTextIter _tmp30_;
		_tmp23_ = buffer;
		_tmp24_ = real_start;
		_tmp25_ = real_end;
		_tmp26_ = self->priv->d_selection_category;
		gtk_source_buffer_remove_source_marks (_tmp23_, &_tmp24_, &_tmp25_, _tmp26_);
		_tmp27_ = buffer;
		_tmp28_ = self->priv->d_selection_tag;
		_tmp29_ = real_start;
		_tmp30_ = real_end;
		gtk_text_buffer_remove_tag ((GtkTextBuffer*) _tmp27_, _tmp28_, &_tmp29_, &_tmp30_);
	}
}

static void
gitg_diff_view_file_selectable_clear_original_selection (GitgDiffViewFileSelectable* self,
                                                         GtkTextIter* start,
                                                         GtkTextIter* end,
                                                         gboolean include_end)
{
	GtkTextIter current = {0};
	GtkTextIter _tmp0_;
	gint end_line = 0;
	gint current_line = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = *start;
	current = _tmp0_;
	gtk_text_iter_set_line_offset (&current, 0);
	end_line = gtk_text_iter_get_line (end);
	current_line = gtk_text_iter_get_line (&current);
	if (include_end) {
		gint _tmp1_;
		_tmp1_ = end_line;
		end_line = _tmp1_ + 1;
	}
	while (TRUE) {
		gboolean originally_selected = FALSE;
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		GtkTextIter _tmp4_;
		GtkTextIter _tmp5_;
		gint _tmp6_;
		if (!(current_line < end_line)) {
			break;
		}
		_tmp2_ = self->priv->d_originally_selected;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) current_line));
		originally_selected = (gboolean) ((gintptr) _tmp3_);
		_tmp4_ = current;
		_tmp5_ = current;
		gitg_diff_view_file_selectable_update_selection_range (self, &_tmp4_, &_tmp5_, originally_selected);
		gtk_text_iter_forward_line (&current);
		_tmp6_ = current_line;
		current_line = _tmp6_ + 1;
	}
}

static void
gitg_diff_view_file_selectable_forward_to_hunk_end (GitgDiffViewFileSelectable* self,
                                                    GtkTextIter* iter)
{
	GtkSourceBuffer* buffer = NULL;
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	gtk_text_iter_forward_line (iter);
	_tmp0_ = self->priv->_source_view;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	buffer = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_source_buffer_get_type (), GtkSourceBuffer);
	_tmp3_ = buffer;
	_tmp4_ = gtk_source_buffer_forward_iter_to_source_mark (_tmp3_, iter, "header");
	if (!_tmp4_) {
		gtk_text_iter_forward_to_end (iter);
	}
}

static gboolean
gitg_diff_view_file_selectable_hunk_is_all_selected (GitgDiffViewFileSelectable* self,
                                                     GtkTextIter* iter)
{
	GtkTextIter start = {0};
	GtkTextIter _tmp0_;
	GtkTextIter end = {0};
	GtkTextIter _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	start = _tmp0_;
	gtk_text_iter_forward_line (&start);
	_tmp1_ = *iter;
	end = _tmp1_;
	gitg_diff_view_file_selectable_forward_to_hunk_end (self, &end);
	while (TRUE) {
		GtkTextIter _tmp2_;
		gboolean _tmp3_ = FALSE;
		GtkTextIter _tmp4_;
		_tmp2_ = end;
		if (!(gtk_text_iter_compare (&start, &_tmp2_) <= 0)) {
			break;
		}
		_tmp4_ = start;
		if (gitg_diff_view_file_selectable_get_line_is_diff (self, &_tmp4_)) {
			GtkTextIter _tmp5_;
			_tmp5_ = start;
			_tmp3_ = !gitg_diff_view_file_selectable_get_line_selected (self, &_tmp5_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = FALSE;
			return result;
		}
		if (!gtk_text_iter_forward_line (&start)) {
			break;
		}
	}
	result = TRUE;
	return result;
}

static void
gitg_diff_view_file_selectable_update_selection_hunk (GitgDiffViewFileSelectable* self,
                                                      GtkTextIter* iter,
                                                      gboolean select)
{
	GtkTextIter end = {0};
	GtkTextIter _tmp0_;
	GtkTextIter _tmp1_;
	GtkTextIter _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	end = _tmp0_;
	gitg_diff_view_file_selectable_forward_to_hunk_end (self, &end);
	_tmp1_ = *iter;
	_tmp2_ = end;
	gitg_diff_view_file_selectable_update_selection_range (self, &_tmp1_, &_tmp2_, select);
}

static gboolean
gitg_diff_view_file_selectable_button_press_event_on_view (GitgDiffViewFileSelectable* self,
                                                           GdkEventButton* event)
{
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTextBuffer* buffer = NULL;
	GtkSourceView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextIter _tmp7_;
	gboolean select = FALSE;
	GtkTextIter _tmp10_;
	GeeHashMap* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextMark* _tmp13_;
	GtkTextIter _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextMark* _tmp16_;
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gitg_diff_view_file_selectable_get_iter_from_pointer_position (self, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_source_view;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	buffer = _tmp5_;
	if ((event->state & GDK_SHIFT_MASK) != 0) {
		GtkTextIter _tmp6_;
		_tmp6_ = iter;
		gitg_diff_view_file_selectable_update_selection (self, &_tmp6_);
		result = TRUE;
		_g_object_unref0 (buffer);
		return result;
	}
	_tmp7_ = iter;
	if (gitg_diff_view_file_selectable_get_line_is_hunk (self, &_tmp7_)) {
		GtkTextIter _tmp8_;
		GtkTextIter _tmp9_;
		_tmp8_ = iter;
		_tmp9_ = iter;
		gitg_diff_view_file_selectable_update_selection_hunk (self, &_tmp8_, !gitg_diff_view_file_selectable_hunk_is_all_selected (self, &_tmp9_));
		result = TRUE;
		_g_object_unref0 (buffer);
		return result;
	}
	self->priv->d_is_rubber_band = TRUE;
	_tmp10_ = iter;
	select = !gitg_diff_view_file_selectable_get_line_selected (self, &_tmp10_);
	if (select) {
		self->priv->d_selection_mode = GITG_DIFF_SELECTION_MODE_SELECTING;
	} else {
		self->priv->d_selection_mode = GITG_DIFF_SELECTION_MODE_DESELECTING;
	}
	_tmp11_ = self->priv->d_originally_selected;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp11_);
	_tmp12_ = buffer;
	_tmp13_ = self->priv->d_start_selection_mark;
	_tmp14_ = iter;
	gtk_text_buffer_move_mark (_tmp12_, _tmp13_, &_tmp14_);
	_tmp15_ = buffer;
	_tmp16_ = self->priv->d_end_selection_mark;
	_tmp17_ = iter;
	gtk_text_buffer_move_mark (_tmp15_, _tmp16_, &_tmp17_);
	_tmp18_ = iter;
	gitg_diff_view_file_selectable_update_selection (self, &_tmp18_);
	result = TRUE;
	_g_object_unref0 (buffer);
	return result;
}

static void
gitg_diff_view_file_selectable_update_selection (GitgDiffViewFileSelectable* self,
                                                 GtkTextIter* cursor)
{
	GtkTextBuffer* buffer = NULL;
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextMark* _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextBuffer* _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_;
	GtkTextBuffer* _tmp19_;
	GtkTextMark* _tmp20_;
	GtkTextIter _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cursor != NULL);
	_tmp0_ = self->priv->_source_view;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	_tmp5_ = self->priv->d_start_selection_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp6_, _tmp5_);
	start = _tmp6_;
	_tmp7_ = buffer;
	_tmp8_ = self->priv->d_end_selection_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp7_, &_tmp9_, _tmp8_);
	end = _tmp9_;
	if (gtk_text_iter_get_line (&start) < gtk_text_iter_get_line (&end)) {
		GtkTextIter _tmp10_ = {0};
		GtkTextIter next = {0};
		GtkTextIter _tmp13_;
		GtkTextIter _tmp14_;
		if (gtk_text_iter_get_line (&start) < gtk_text_iter_get_line (cursor)) {
			GtkTextIter _tmp11_;
			_tmp11_ = *cursor;
			_tmp10_ = _tmp11_;
		} else {
			GtkTextIter _tmp12_;
			_tmp12_ = start;
			_tmp10_ = _tmp12_;
		}
		next = _tmp10_;
		gtk_text_iter_forward_line (&next);
		_tmp13_ = next;
		_tmp14_ = end;
		gitg_diff_view_file_selectable_clear_original_selection (self, &_tmp13_, &_tmp14_, TRUE);
	} else {
		GtkTextIter _tmp15_;
		GtkTextIter _tmp16_;
		_tmp15_ = end;
		_tmp16_ = *cursor;
		gitg_diff_view_file_selectable_clear_original_selection (self, &_tmp15_, &_tmp16_, FALSE);
	}
	_tmp17_ = start;
	_tmp18_ = *cursor;
	gitg_diff_view_file_selectable_update_selection_range (self, &_tmp17_, &_tmp18_, self->priv->d_selection_mode == GITG_DIFF_SELECTION_MODE_SELECTING);
	_tmp19_ = buffer;
	_tmp20_ = self->priv->d_end_selection_mark;
	_tmp21_ = *cursor;
	gtk_text_buffer_move_mark (_tmp19_, _tmp20_, &_tmp21_);
	_g_object_unref0 (buffer);
}

static gboolean
gitg_diff_view_file_selectable_update_selection_event (GitgDiffViewFileSelectable* self,
                                                       GdkModifierType state,
                                                       gint x,
                                                       gint y)
{
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTextIter _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = gitg_diff_view_file_selectable_get_iter_from_event_position (self, &_tmp0_, x, y);
	iter = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	if (self->priv->d_is_rubber_band) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		GtkTextIter _tmp4_;
		_tmp4_ = iter;
		if (gitg_diff_view_file_selectable_get_line_is_diff (self, &_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			GtkTextIter _tmp5_;
			_tmp5_ = iter;
			_tmp3_ = gitg_diff_view_file_selectable_get_line_is_hunk (self, &_tmp5_);
		}
		_tmp2_ = _tmp3_;
	}
	if (_tmp2_) {
		GdkCursor* _tmp6_;
		GdkCursor* _tmp7_;
		GdkCursor* _tmp8_;
		_tmp6_ = gitg_diff_view_file_selectable_get_cursor_hand (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		gitg_diff_view_file_selectable_update_cursor (self, _tmp8_);
		_g_object_unref0 (_tmp8_);
	} else {
		GdkCursor* _tmp9_;
		GdkCursor* _tmp10_;
		GdkCursor* _tmp11_;
		_tmp9_ = gitg_diff_view_file_selectable_get_cursor_ptr (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		gitg_diff_view_file_selectable_update_cursor (self, _tmp11_);
		_g_object_unref0 (_tmp11_);
	}
	if (!self->priv->d_is_rubber_band) {
		result = FALSE;
		return result;
	}
	_tmp12_ = iter;
	gitg_diff_view_file_selectable_update_selection (self, &_tmp12_);
	result = TRUE;
	return result;
}

static gboolean
gitg_diff_view_file_selectable_motion_notify_event_on_view (GitgDiffViewFileSelectable* self,
                                                            GdkEventMotion* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	result = gitg_diff_view_file_selectable_update_selection_event (self, event->state, (gint) event->x, (gint) event->y);
	return result;
}

static gboolean
gitg_diff_view_file_selectable_leave_notify_event_on_view (GitgDiffViewFileSelectable* self,
                                                           GdkEventCrossing* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	result = gitg_diff_view_file_selectable_update_selection_event (self, event->state, (gint) event->x, (gint) event->y);
	return result;
}

static gboolean
gitg_diff_view_file_selectable_enter_notify_event_on_view (GitgDiffViewFileSelectable* self,
                                                           GdkEventCrossing* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	result = gitg_diff_view_file_selectable_update_selection_event (self, event->state, (gint) event->x, (gint) event->y);
	return result;
}

static void
gitg_diff_view_file_selectable_update_has_selection (GitgDiffViewFileSelectable* self)
{
	GtkSourceBuffer* buffer = NULL;
	GtkSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter iter = {0};
	GtkSourceBuffer* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gboolean something_selected = FALSE;
	GtkTextIter _tmp5_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_view;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	buffer = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_source_buffer_get_type (), GtkSourceBuffer);
	_tmp3_ = buffer;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp3_, &_tmp4_);
	iter = _tmp4_;
	something_selected = FALSE;
	_tmp5_ = iter;
	if (gitg_diff_view_file_selectable_get_line_selected (self, &_tmp5_)) {
		something_selected = TRUE;
	} else {
		GtkSourceBuffer* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = buffer;
		_tmp7_ = self->priv->d_selection_category;
		_tmp8_ = gtk_source_buffer_forward_iter_to_source_mark (_tmp6_, &iter, _tmp7_);
		something_selected = _tmp8_;
	}
	_tmp9_ = self->priv->_has_selection;
	if (something_selected != _tmp9_) {
		gitg_diff_view_file_selectable_set_has_selection (self, something_selected);
	}
}

static gboolean
gitg_diff_view_file_selectable_button_release_event_on_view (GitgDiffViewFileSelectable* self,
                                                             GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->d_is_rubber_band = FALSE;
	if (event->button != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	gitg_diff_view_file_selectable_update_has_selection (self);
	result = TRUE;
	return result;
}

GtkSourceView*
gitg_diff_view_file_selectable_get_source_view (GitgDiffViewFileSelectable* self)
{
	GtkSourceView* result;
	GtkSourceView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_view;
	result = _tmp0_;
	return result;
}

void
gitg_diff_view_file_selectable_set_source_view (GitgDiffViewFileSelectable* self,
                                                GtkSourceView* value)
{
	GtkSourceView* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_file_selectable_get_source_view (self);
	if (old_value != value) {
		GtkSourceView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source_view);
		self->priv->_source_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_selectable_properties[GITG_DIFF_VIEW_FILE_SELECTABLE_SOURCE_VIEW_PROPERTY]);
	}
}

gboolean
gitg_diff_view_file_selectable_get_has_selection (GitgDiffViewFileSelectable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_selection;
	return result;
}

static void
gitg_diff_view_file_selectable_set_has_selection (GitgDiffViewFileSelectable* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_file_selectable_get_has_selection (self);
	if (old_value != value) {
		self->priv->_has_selection = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_selectable_properties[GITG_DIFF_VIEW_FILE_SELECTABLE_HAS_SELECTION_PROPERTY]);
	}
}

static GdkCursor*
gitg_diff_view_file_selectable_get_cursor_ptr (GitgDiffViewFileSelectable* self)
{
	GdkCursor* result;
	GdkCursor* _tmp0_;
	GdkCursor* _tmp4_;
	GdkCursor* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_cursor_ptr;
	if (_tmp0_ == NULL) {
		GtkSourceView* _tmp1_;
		GdkDisplay* _tmp2_;
		GdkCursor* _tmp3_;
		_tmp1_ = self->priv->_source_view;
		_tmp2_ = gtk_widget_get_display ((GtkWidget*) _tmp1_);
		_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_LEFT_PTR);
		_g_object_unref0 (self->priv->d_cursor_ptr);
		self->priv->d_cursor_ptr = _tmp3_;
	}
	_tmp4_ = self->priv->d_cursor_ptr;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}

static GdkCursor*
gitg_diff_view_file_selectable_get_cursor_hand (GitgDiffViewFileSelectable* self)
{
	GdkCursor* result;
	GdkCursor* _tmp0_;
	GdkCursor* _tmp4_;
	GdkCursor* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_cursor_hand;
	if (_tmp0_ == NULL) {
		GtkSourceView* _tmp1_;
		GdkDisplay* _tmp2_;
		GdkCursor* _tmp3_;
		_tmp1_ = self->priv->_source_view;
		_tmp2_ = gtk_widget_get_display ((GtkWidget*) _tmp1_);
		_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_HAND1);
		_g_object_unref0 (self->priv->d_cursor_hand);
		self->priv->d_cursor_hand = _tmp3_;
	}
	_tmp4_ = self->priv->d_cursor_hand;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}

static gboolean
_gitg_diff_view_file_selectable_button_press_event_on_view_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                          GdkEventButton* event,
                                                                                          gpointer self)
{
	gboolean result;
	result = gitg_diff_view_file_selectable_button_press_event_on_view ((GitgDiffViewFileSelectable*) self, event);
	return result;
}

static gboolean
_gitg_diff_view_file_selectable_motion_notify_event_on_view_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                            GdkEventMotion* event,
                                                                                            gpointer self)
{
	gboolean result;
	result = gitg_diff_view_file_selectable_motion_notify_event_on_view ((GitgDiffViewFileSelectable*) self, event);
	return result;
}

static gboolean
_gitg_diff_view_file_selectable_leave_notify_event_on_view_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                                          GdkEventCrossing* event,
                                                                                          gpointer self)
{
	gboolean result;
	result = gitg_diff_view_file_selectable_leave_notify_event_on_view ((GitgDiffViewFileSelectable*) self, event);
	return result;
}

static gboolean
_gitg_diff_view_file_selectable_enter_notify_event_on_view_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                                          GdkEventCrossing* event,
                                                                                          gpointer self)
{
	gboolean result;
	result = gitg_diff_view_file_selectable_enter_notify_event_on_view ((GitgDiffViewFileSelectable*) self, event);
	return result;
}

static gboolean
_gitg_diff_view_file_selectable_button_release_event_on_view_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                              GdkEventButton* event,
                                                                                              gpointer self)
{
	gboolean result;
	result = gitg_diff_view_file_selectable_button_release_event_on_view ((GitgDiffViewFileSelectable*) self, event);
	return result;
}

static void
_gitg_diff_view_file_selectable___lambda51_ (GitgDiffViewFileSelectable* self)
{
	GdkCursor* _tmp0_;
	GdkCursor* _tmp1_;
	GdkCursor* _tmp2_;
	_tmp0_ = gitg_diff_view_file_selectable_get_cursor_ptr (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	gitg_diff_view_file_selectable_update_cursor (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
__gitg_diff_view_file_selectable___lambda51__gtk_widget_realize (GtkWidget* _sender,
                                                                 gpointer self)
{
	_gitg_diff_view_file_selectable___lambda51_ ((GitgDiffViewFileSelectable*) self);
}

static void
_gitg_diff_view_file_selectable___lambda52_ (GitgDiffViewFileSelectable* self)
{
	GdkCursor* _tmp0_;
	GdkCursor* _tmp1_;
	GdkCursor* _tmp2_;
	_tmp0_ = gitg_diff_view_file_selectable_get_cursor_ptr (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	gitg_diff_view_file_selectable_update_cursor (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
__gitg_diff_view_file_selectable___lambda52__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	_gitg_diff_view_file_selectable___lambda52_ ((GitgDiffViewFileSelectable*) self);
}

static void
_gitg_diff_view_file_selectable_update_theme_gtk_widget_style_updated (GtkWidget* _sender,
                                                                       gpointer self)
{
	gitg_diff_view_file_selectable_update_theme ((GitgDiffViewFileSelectable*) self);
}

static GObject *
gitg_diff_view_file_selectable_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgDiffViewFileSelectable * self;
	GtkSourceView* _tmp0_;
	GtkSourceView* _tmp1_;
	GtkSourceView* _tmp2_;
	GtkSourceView* _tmp3_;
	GtkSourceView* _tmp4_;
	GtkSourceView* _tmp5_;
	GtkSourceView* _tmp6_;
	GtkSourceView* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextTag* _tmp10_;
	GtkTextTag* _tmp11_;
	GtkSourceView* _tmp12_;
	GeeHashMap* _tmp13_;
	GtkTextIter start = {0};
	GtkSourceView* _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* _tmp16_;
	GtkTextIter _tmp17_ = {0};
	GtkSourceView* _tmp18_;
	GtkTextBuffer* _tmp19_;
	GtkTextBuffer* _tmp20_;
	GtkTextIter _tmp21_;
	GtkTextMark* _tmp22_;
	GtkTextMark* _tmp23_;
	GtkSourceView* _tmp24_;
	GtkTextBuffer* _tmp25_;
	GtkTextBuffer* _tmp26_;
	GtkTextIter _tmp27_;
	GtkTextMark* _tmp28_;
	GtkTextMark* _tmp29_;
	parent_class = G_OBJECT_CLASS (gitg_diff_view_file_selectable_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE, GitgDiffViewFileSelectable);
	_tmp0_ = self->priv->_source_view;
	g_signal_connect_object ((GtkWidget*) _tmp0_, "button-press-event", (GCallback) _gitg_diff_view_file_selectable_button_press_event_on_view_gtk_widget_button_press_event, self, 0);
	_tmp1_ = self->priv->_source_view;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "motion-notify-event", (GCallback) _gitg_diff_view_file_selectable_motion_notify_event_on_view_gtk_widget_motion_notify_event, self, 0);
	_tmp2_ = self->priv->_source_view;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "leave-notify-event", (GCallback) _gitg_diff_view_file_selectable_leave_notify_event_on_view_gtk_widget_leave_notify_event, self, 0);
	_tmp3_ = self->priv->_source_view;
	g_signal_connect_object ((GtkWidget*) _tmp3_, "enter-notify-event", (GCallback) _gitg_diff_view_file_selectable_enter_notify_event_on_view_gtk_widget_enter_notify_event, self, 0);
	_tmp4_ = self->priv->_source_view;
	g_signal_connect_object ((GtkWidget*) _tmp4_, "button-release-event", (GCallback) _gitg_diff_view_file_selectable_button_release_event_on_view_gtk_widget_button_release_event, self, 0);
	_tmp5_ = self->priv->_source_view;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "realize", (GCallback) __gitg_diff_view_file_selectable___lambda51__gtk_widget_realize, self, 0);
	_tmp6_ = self->priv->_source_view;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::state-flags", (GCallback) __gitg_diff_view_file_selectable___lambda52__g_object_notify, self, 0);
	_tmp7_ = self->priv->_source_view;
	_tmp8_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_text_buffer_create_tag (_tmp9_, "selection", NULL);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->d_selection_tag);
	self->priv->d_selection_tag = _tmp11_;
	_tmp12_ = self->priv->_source_view;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "style-updated", (GCallback) _gitg_diff_view_file_selectable_update_theme_gtk_widget_style_updated, self, 0);
	gitg_diff_view_file_selectable_update_theme (self);
	_tmp13_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_originally_selected);
	self->priv->d_originally_selected = _tmp13_;
	_tmp14_ = self->priv->_source_view;
	_tmp15_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp14_);
	_tmp16_ = _tmp15_;
	gtk_text_buffer_get_start_iter (_tmp16_, &_tmp17_);
	start = _tmp17_;
	_tmp18_ = self->priv->_source_view;
	_tmp19_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = start;
	_tmp22_ = gtk_text_buffer_create_mark (_tmp20_, NULL, &_tmp21_, FALSE);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->priv->d_start_selection_mark);
	self->priv->d_start_selection_mark = _tmp23_;
	_tmp24_ = self->priv->_source_view;
	_tmp25_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = start;
	_tmp28_ = gtk_text_buffer_create_mark (_tmp26_, NULL, &_tmp27_, FALSE);
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (self->priv->d_end_selection_mark);
	self->priv->d_end_selection_mark = _tmp29_;
	return obj;
}

static void
gitg_diff_view_file_selectable_class_init (GitgDiffViewFileSelectableClass * klass,
                                           gpointer klass_data)
{
	gitg_diff_view_file_selectable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffViewFileSelectable_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_file_selectable_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_file_selectable_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_diff_view_file_selectable_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_file_selectable_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_SELECTABLE_SOURCE_VIEW_PROPERTY, gitg_diff_view_file_selectable_properties[GITG_DIFF_VIEW_FILE_SELECTABLE_SOURCE_VIEW_PROPERTY] = g_param_spec_object ("source-view", "source-view", "source-view", gtk_source_view_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_SELECTABLE_HAS_SELECTION_PROPERTY, gitg_diff_view_file_selectable_properties[GITG_DIFF_VIEW_FILE_SELECTABLE_HAS_SELECTION_PROPERTY] = g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_diff_view_file_selectable_instance_init (GitgDiffViewFileSelectable * self,
                                              gpointer klass)
{
	gchar* _tmp0_;
	self->priv = gitg_diff_view_file_selectable_get_instance_private (self);
	_tmp0_ = g_strdup ("selection");
	self->priv->d_selection_category = _tmp0_;
}

static void
gitg_diff_view_file_selectable_finalize (GObject * obj)
{
	GitgDiffViewFileSelectable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE, GitgDiffViewFileSelectable);
	_g_free0 (self->priv->d_selection_category);
	_g_object_unref0 (self->priv->d_selection_tag);
	_g_object_unref0 (self->priv->d_start_selection_mark);
	_g_object_unref0 (self->priv->d_end_selection_mark);
	_g_object_unref0 (self->priv->d_originally_selected);
	_g_object_unref0 (self->priv->d_cursor_ptr);
	_g_object_unref0 (self->priv->d_cursor_hand);
	_g_object_unref0 (self->priv->_source_view);
	G_OBJECT_CLASS (gitg_diff_view_file_selectable_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_file_selectable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewFileSelectableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_file_selectable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffViewFileSelectable), 0, (GInstanceInitFunc) gitg_diff_view_file_selectable_instance_init, NULL };
	GType gitg_diff_view_file_selectable_type_id;
	gitg_diff_view_file_selectable_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgDiffViewFileSelectable", &g_define_type_info, 0);
	GitgDiffViewFileSelectable_private_offset = g_type_add_instance_private (gitg_diff_view_file_selectable_type_id, sizeof (GitgDiffViewFileSelectablePrivate));
	return gitg_diff_view_file_selectable_type_id;
}

GType
gitg_diff_view_file_selectable_get_type (void)
{
	static gsize gitg_diff_view_file_selectable_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_file_selectable_type_id__once)) {
		GType gitg_diff_view_file_selectable_type_id;
		gitg_diff_view_file_selectable_type_id = gitg_diff_view_file_selectable_get_type_once ();
		g_once_init_leave (&gitg_diff_view_file_selectable_type_id__once, gitg_diff_view_file_selectable_type_id);
	}
	return gitg_diff_view_file_selectable_type_id__once;
}

static void
_vala_gitg_diff_view_file_selectable_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GitgDiffViewFileSelectable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE, GitgDiffViewFileSelectable);
	switch (property_id) {
		case GITG_DIFF_VIEW_FILE_SELECTABLE_SOURCE_VIEW_PROPERTY:
		g_value_set_object (value, gitg_diff_view_file_selectable_get_source_view (self));
		break;
		case GITG_DIFF_VIEW_FILE_SELECTABLE_HAS_SELECTION_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_file_selectable_get_has_selection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_view_file_selectable_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GitgDiffViewFileSelectable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_FILE_SELECTABLE, GitgDiffViewFileSelectable);
	switch (property_id) {
		case GITG_DIFF_VIEW_FILE_SELECTABLE_SOURCE_VIEW_PROPERTY:
		gitg_diff_view_file_selectable_set_source_view (self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_FILE_SELECTABLE_HAS_SELECTION_PROPERTY:
		gitg_diff_view_file_selectable_set_has_selection (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

