/* gameinfo-doc.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gameinfo-doc.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_XML_DOC (games_xml_doc_get_type ())
#define GAMES_XML_DOC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_XML_DOC, GamesXmlDoc))
#define GAMES_XML_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_XML_DOC, GamesXmlDocClass))
#define GAMES_IS_XML_DOC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_XML_DOC))
#define GAMES_IS_XML_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_XML_DOC))
#define GAMES_XML_DOC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_XML_DOC, GamesXmlDocClass))

typedef struct _GamesXmlDoc GamesXmlDoc;
typedef struct _GamesXmlDocClass GamesXmlDocClass;
enum  {
	GAMES_GAMEINFO_DOC_0_PROPERTY,
	GAMES_GAMEINFO_DOC_NUM_PROPERTIES
};
static GParamSpec* games_gameinfo_doc_properties[GAMES_GAMEINFO_DOC_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_GAMEINFO_ERROR (games_gameinfo_error_get_type ())

struct _GamesGameinfoDocPrivate {
	GamesXmlDoc* xml_doc;
};

typedef enum  {
	GAMES_GAMEINFO_ERROR_DISC_NOT_FOUND
} GamesGameinfoError;
#define GAMES_GAMEINFO_ERROR games_gameinfo_error_quark ()

static gint GamesGameinfoDoc_private_offset;
static gpointer games_gameinfo_doc_parent_class = NULL;

VALA_EXTERN GType games_xml_doc_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesXmlDoc* games_xml_doc_new_from_data (guint8* data,
                                          gint data_length1,
                                          GError** error);
VALA_EXTERN GamesXmlDoc* games_xml_doc_construct_from_data (GType object_type,
                                                guint8* data,
                                                gint data_length1,
                                                GError** error);
VALA_EXTERN gchar* games_xml_doc_get_content (GamesXmlDoc* self,
                                  const gchar* xpath,
                                  xmlNode* current_node);
VALA_EXTERN GQuark games_gameinfo_error_quark (void);
VALA_EXTERN GType games_gameinfo_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar** games_xml_doc_get_contents (GamesXmlDoc* self,
                                    const gchar* xpath,
                                    xmlNode* current_node,
                                    gint* result_length1);
VALA_EXTERN gint games_xml_doc_count_nodes (GamesXmlDoc* self,
                                const gchar* xpath,
                                xmlNode* from_node);
static void games_gameinfo_doc_finalize (GObject * obj);
static GType games_gameinfo_doc_get_type_once (void);

static inline gpointer
games_gameinfo_doc_get_instance_private (GamesGameinfoDoc* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGameinfoDoc_private_offset);
}

GamesGameinfoDoc*
games_gameinfo_doc_construct_from_data (GType object_type,
                                        guint8* data,
                                        gint data_length1,
                                        GError** error)
{
	GamesGameinfoDoc * self = NULL;
	GamesXmlDoc* _tmp0_ = NULL;
	GamesXmlDoc* _tmp1_;
	GamesXmlDoc* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (GamesGameinfoDoc*) g_object_new (object_type, NULL);
	_tmp1_ = games_xml_doc_new_from_data (data, data_length1, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->xml_doc);
	self->priv->xml_doc = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return self;
}

GamesGameinfoDoc*
games_gameinfo_doc_new_from_data (guint8* data,
                                  gint data_length1,
                                  GError** error)
{
	return games_gameinfo_doc_construct_from_data (GAMES_TYPE_GAMEINFO_DOC, data, data_length1, error);
}

gchar*
games_gameinfo_doc_get_game_title_for_disc_id (GamesGameinfoDoc* self,
                                               const gchar* disc_id,
                                               GError** error)
{
	gchar* expr = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* title = NULL;
	GamesXmlDoc* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (disc_id != NULL, NULL);
	_tmp0_ = g_strconcat ("/gameinfo/games/game[discs/disc[@id = \"", disc_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\"]]/title", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	expr = _tmp3_;
	_tmp4_ = self->priv->xml_doc;
	_tmp5_ = expr;
	_tmp6_ = games_xml_doc_get_content (_tmp4_, _tmp5_, NULL);
	title = _tmp6_;
	_tmp7_ = title;
	if (_tmp7_ == NULL) {
		GError* _tmp8_;
		_tmp8_ = g_error_new (GAMES_GAMEINFO_ERROR, GAMES_GAMEINFO_ERROR_DISC_NOT_FOUND, "No game title found for disc ID “%s”.", disc_id);
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (title);
		_g_free0 (expr);
		return NULL;
	}
	result = title;
	_g_free0 (expr);
	return result;
}

gchar**
games_gameinfo_doc_get_game_controllers_for_disc_id (GamesGameinfoDoc* self,
                                                     const gchar* disc_id,
                                                     gint* result_length1,
                                                     GError** error)
{
	gchar* expr = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GamesXmlDoc* _tmp4_;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (disc_id != NULL, NULL);
	_tmp0_ = g_strconcat ("/gameinfo/games/game[discs/disc[@id = \"", disc_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\"]]/controllers/controller/@type", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	expr = _tmp3_;
	_tmp4_ = self->priv->xml_doc;
	_tmp6_ = games_xml_doc_get_contents (_tmp4_, expr, NULL, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_free0 (expr);
	return result;
}

gchar*
games_gameinfo_doc_get_disc_title_for_disc_id (GamesGameinfoDoc* self,
                                               const gchar* disc_id,
                                               GError** error)
{
	gchar* expr = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* title = NULL;
	GamesXmlDoc* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (disc_id != NULL, NULL);
	_tmp0_ = g_strconcat ("/gameinfo/games/game/discs/disc[@id = \"", disc_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\"]/title", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	expr = _tmp3_;
	_tmp4_ = self->priv->xml_doc;
	_tmp5_ = expr;
	_tmp6_ = games_xml_doc_get_content (_tmp4_, _tmp5_, NULL);
	title = _tmp6_;
	_tmp7_ = title;
	if (_tmp7_ == NULL) {
		GError* _tmp8_;
		_tmp8_ = g_error_new (GAMES_GAMEINFO_ERROR, GAMES_GAMEINFO_ERROR_DISC_NOT_FOUND, "No disc title found for disc ID “%s”.", disc_id);
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (title);
		_g_free0 (expr);
		return NULL;
	}
	result = title;
	_g_free0 (expr);
	return result;
}

gchar*
games_gameinfo_doc_get_disc_set_id_for_disc_id (GamesGameinfoDoc* self,
                                                const gchar* disc_id,
                                                GError** error)
{
	gchar* expr = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* title = NULL;
	GamesXmlDoc* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (disc_id != NULL, NULL);
	_tmp0_ = g_strconcat ("/gameinfo/games/game/discs[disc[@id = \"", disc_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\"]]/disc[1]/@id", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	expr = _tmp3_;
	_tmp4_ = self->priv->xml_doc;
	_tmp5_ = expr;
	_tmp6_ = games_xml_doc_get_content (_tmp4_, _tmp5_, NULL);
	title = _tmp6_;
	_tmp7_ = title;
	if (_tmp7_ == NULL) {
		GError* _tmp8_;
		_tmp8_ = g_error_new (GAMES_GAMEINFO_ERROR, GAMES_GAMEINFO_ERROR_DISC_NOT_FOUND, "No disc set ID found for disc ID “%s”.", disc_id);
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (title);
		_g_free0 (expr);
		return NULL;
	}
	result = title;
	_g_free0 (expr);
	return result;
}

gint
games_gameinfo_doc_get_disc_set_index_for_disc_id (GamesGameinfoDoc* self,
                                                   const gchar* disc_id,
                                                   GError** error)
{
	gchar* test_expr = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GamesXmlDoc* _tmp4_;
	const gchar* _tmp5_;
	gchar* expr = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GamesXmlDoc* _tmp12_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (disc_id != NULL, 0);
	_tmp0_ = g_strconcat ("/gameinfo/games/game/discs/disc[@id = \"", disc_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\"]", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	test_expr = _tmp3_;
	_tmp4_ = self->priv->xml_doc;
	_tmp5_ = test_expr;
	if (games_xml_doc_count_nodes (_tmp4_, _tmp5_, NULL) == 0) {
		GError* _tmp6_;
		gint _tmp7_ = -1;
		_tmp6_ = g_error_new (GAMES_GAMEINFO_ERROR, GAMES_GAMEINFO_ERROR_DISC_NOT_FOUND, "No disc found for disc ID “%s”.", disc_id);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (test_expr);
		return _tmp7_;
	}
	_tmp8_ = g_strconcat ("/gameinfo/games/game/discs/disc[@id = \"", disc_id, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "\"]/preceding-sibling::disc", NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	expr = _tmp11_;
	_tmp12_ = self->priv->xml_doc;
	result = games_xml_doc_count_nodes (_tmp12_, expr, NULL);
	_g_free0 (expr);
	_g_free0 (test_expr);
	return result;
}

gint
games_gameinfo_doc_get_disc_set_size_for_disc_id (GamesGameinfoDoc* self,
                                                  const gchar* disc_id,
                                                  GError** error)
{
	gchar* test_expr = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GamesXmlDoc* _tmp4_;
	const gchar* _tmp5_;
	gchar* expr = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GamesXmlDoc* _tmp12_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (disc_id != NULL, 0);
	_tmp0_ = g_strconcat ("/gameinfo/games/game/discs/disc[@id = \"", disc_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\"]", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	test_expr = _tmp3_;
	_tmp4_ = self->priv->xml_doc;
	_tmp5_ = test_expr;
	if (games_xml_doc_count_nodes (_tmp4_, _tmp5_, NULL) == 0) {
		GError* _tmp6_;
		gint _tmp7_ = -1;
		_tmp6_ = g_error_new (GAMES_GAMEINFO_ERROR, GAMES_GAMEINFO_ERROR_DISC_NOT_FOUND, "No disc found for disc ID “%s”.", disc_id);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (test_expr);
		return _tmp7_;
	}
	_tmp8_ = g_strconcat ("/gameinfo/games/game/discs[disc[@id = \"", disc_id, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "\"]]/disc", NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	expr = _tmp11_;
	_tmp12_ = self->priv->xml_doc;
	result = games_xml_doc_count_nodes (_tmp12_, expr, NULL);
	_g_free0 (expr);
	_g_free0 (test_expr);
	return result;
}

gchar**
games_gameinfo_doc_get_disc_set_ids_for_disc_id (GamesGameinfoDoc* self,
                                                 const gchar* disc_id,
                                                 gint* result_length1,
                                                 GError** error)
{
	gchar* expr = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GamesXmlDoc* _tmp4_;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (disc_id != NULL, NULL);
	_tmp0_ = g_strconcat ("/gameinfo/games/game/discs[disc[@id = \"", disc_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\"]]/disc/@id", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	expr = _tmp3_;
	_tmp4_ = self->priv->xml_doc;
	_tmp6_ = games_xml_doc_get_contents (_tmp4_, expr, NULL, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_free0 (expr);
	return result;
}

GamesGameinfoDoc*
games_gameinfo_doc_construct (GType object_type)
{
	GamesGameinfoDoc * self = NULL;
	self = (GamesGameinfoDoc*) g_object_new (object_type, NULL);
	return self;
}

GamesGameinfoDoc*
games_gameinfo_doc_new (void)
{
	return games_gameinfo_doc_construct (GAMES_TYPE_GAMEINFO_DOC);
}

static void
games_gameinfo_doc_class_init (GamesGameinfoDocClass * klass,
                               gpointer klass_data)
{
	games_gameinfo_doc_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGameinfoDoc_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_gameinfo_doc_finalize;
}

static void
games_gameinfo_doc_instance_init (GamesGameinfoDoc * self,
                                  gpointer klass)
{
	self->priv = games_gameinfo_doc_get_instance_private (self);
}

static void
games_gameinfo_doc_finalize (GObject * obj)
{
	GamesGameinfoDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEINFO_DOC, GamesGameinfoDoc);
	_g_object_unref0 (self->priv->xml_doc);
	G_OBJECT_CLASS (games_gameinfo_doc_parent_class)->finalize (obj);
}

static GType
games_gameinfo_doc_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGameinfoDocClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gameinfo_doc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGameinfoDoc), 0, (GInstanceInitFunc) games_gameinfo_doc_instance_init, NULL };
	GType games_gameinfo_doc_type_id;
	games_gameinfo_doc_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGameinfoDoc", &g_define_type_info, 0);
	GamesGameinfoDoc_private_offset = g_type_add_instance_private (games_gameinfo_doc_type_id, sizeof (GamesGameinfoDocPrivate));
	return games_gameinfo_doc_type_id;
}

GType
games_gameinfo_doc_get_type (void)
{
	static volatile gsize games_gameinfo_doc_type_id__once = 0;
	if (g_once_init_enter (&games_gameinfo_doc_type_id__once)) {
		GType games_gameinfo_doc_type_id;
		games_gameinfo_doc_type_id = games_gameinfo_doc_get_type_once ();
		g_once_init_leave (&games_gameinfo_doc_type_id__once, games_gameinfo_doc_type_id);
	}
	return games_gameinfo_doc_type_id__once;
}

