{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A freestanding toplevel surface.
-- 
-- The @GdkToplevel@ interface provides useful APIs for interacting with
-- the windowing system, such as controlling maximization and size of the
-- surface, setting icons and transient parents for dialogs.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Interfaces.Toplevel
    ( 

-- * Exported types
    Toplevel(..)                            ,
    IsToplevel                              ,
    toToplevel                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beep]("GI.Gdk.Objects.Surface#g:method:beep"), [beginMove]("GI.Gdk.Interfaces.Toplevel#g:method:beginMove"), [beginResize]("GI.Gdk.Interfaces.Toplevel#g:method:beginResize"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [createCairoContext]("GI.Gdk.Objects.Surface#g:method:createCairoContext"), [createGlContext]("GI.Gdk.Objects.Surface#g:method:createGlContext"), [createSimilarSurface]("GI.Gdk.Objects.Surface#g:method:createSimilarSurface"), [createVulkanContext]("GI.Gdk.Objects.Surface#g:method:createVulkanContext"), [destroy]("GI.Gdk.Objects.Surface#g:method:destroy"), [focus]("GI.Gdk.Interfaces.Toplevel#g:method:focus"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hide]("GI.Gdk.Objects.Surface#g:method:hide"), [inhibitSystemShortcuts]("GI.Gdk.Interfaces.Toplevel#g:method:inhibitSystemShortcuts"), [isDestroyed]("GI.Gdk.Objects.Surface#g:method:isDestroyed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [lower]("GI.Gdk.Interfaces.Toplevel#g:method:lower"), [minimize]("GI.Gdk.Interfaces.Toplevel#g:method:minimize"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [present]("GI.Gdk.Interfaces.Toplevel#g:method:present"), [queueRender]("GI.Gdk.Objects.Surface#g:method:queueRender"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [requestLayout]("GI.Gdk.Objects.Surface#g:method:requestLayout"), [restoreSystemShortcuts]("GI.Gdk.Interfaces.Toplevel#g:method:restoreSystemShortcuts"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [showWindowMenu]("GI.Gdk.Interfaces.Toplevel#g:method:showWindowMenu"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [supportsEdgeConstraints]("GI.Gdk.Interfaces.Toplevel#g:method:supportsEdgeConstraints"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [titlebarGesture]("GI.Gdk.Interfaces.Toplevel#g:method:titlebarGesture"), [translateCoordinates]("GI.Gdk.Objects.Surface#g:method:translateCoordinates"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCapabilities]("GI.Gdk.Interfaces.Toplevel#g:method:getCapabilities"), [getCursor]("GI.Gdk.Objects.Surface#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDeviceCursor]("GI.Gdk.Objects.Surface#g:method:getDeviceCursor"), [getDevicePosition]("GI.Gdk.Objects.Surface#g:method:getDevicePosition"), [getDisplay]("GI.Gdk.Objects.Surface#g:method:getDisplay"), [getFrameClock]("GI.Gdk.Objects.Surface#g:method:getFrameClock"), [getGravity]("GI.Gdk.Interfaces.Toplevel#g:method:getGravity"), [getHeight]("GI.Gdk.Objects.Surface#g:method:getHeight"), [getMapped]("GI.Gdk.Objects.Surface#g:method:getMapped"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScale]("GI.Gdk.Objects.Surface#g:method:getScale"), [getScaleFactor]("GI.Gdk.Objects.Surface#g:method:getScaleFactor"), [getState]("GI.Gdk.Interfaces.Toplevel#g:method:getState"), [getWidth]("GI.Gdk.Objects.Surface#g:method:getWidth").
-- 
-- ==== Setters
-- [setCursor]("GI.Gdk.Objects.Surface#g:method:setCursor"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorated]("GI.Gdk.Interfaces.Toplevel#g:method:setDecorated"), [setDeletable]("GI.Gdk.Interfaces.Toplevel#g:method:setDeletable"), [setDeviceCursor]("GI.Gdk.Objects.Surface#g:method:setDeviceCursor"), [setGravity]("GI.Gdk.Interfaces.Toplevel#g:method:setGravity"), [setIconList]("GI.Gdk.Interfaces.Toplevel#g:method:setIconList"), [setInputRegion]("GI.Gdk.Objects.Surface#g:method:setInputRegion"), [setModal]("GI.Gdk.Interfaces.Toplevel#g:method:setModal"), [setOpaqueRegion]("GI.Gdk.Objects.Surface#g:method:setOpaqueRegion"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStartupId]("GI.Gdk.Interfaces.Toplevel#g:method:setStartupId"), [setTitle]("GI.Gdk.Interfaces.Toplevel#g:method:setTitle"), [setTransientFor]("GI.Gdk.Interfaces.Toplevel#g:method:setTransientFor").

#if defined(ENABLE_OVERLOADING)
    ResolveToplevelMethod                   ,
#endif

-- ** beginMove #method:beginMove#

#if defined(ENABLE_OVERLOADING)
    ToplevelBeginMoveMethodInfo             ,
#endif
    toplevelBeginMove                       ,


-- ** beginResize #method:beginResize#

#if defined(ENABLE_OVERLOADING)
    ToplevelBeginResizeMethodInfo           ,
#endif
    toplevelBeginResize                     ,


-- ** focus #method:focus#

#if defined(ENABLE_OVERLOADING)
    ToplevelFocusMethodInfo                 ,
#endif
    toplevelFocus                           ,


-- ** getCapabilities #method:getCapabilities#

#if defined(ENABLE_OVERLOADING)
    ToplevelGetCapabilitiesMethodInfo       ,
#endif
    toplevelGetCapabilities                 ,


-- ** getGravity #method:getGravity#

#if defined(ENABLE_OVERLOADING)
    ToplevelGetGravityMethodInfo            ,
#endif
    toplevelGetGravity                      ,


-- ** getState #method:getState#

#if defined(ENABLE_OVERLOADING)
    ToplevelGetStateMethodInfo              ,
#endif
    toplevelGetState                        ,


-- ** inhibitSystemShortcuts #method:inhibitSystemShortcuts#

#if defined(ENABLE_OVERLOADING)
    ToplevelInhibitSystemShortcutsMethodInfo,
#endif
    toplevelInhibitSystemShortcuts          ,


-- ** lower #method:lower#

#if defined(ENABLE_OVERLOADING)
    ToplevelLowerMethodInfo                 ,
#endif
    toplevelLower                           ,


-- ** minimize #method:minimize#

#if defined(ENABLE_OVERLOADING)
    ToplevelMinimizeMethodInfo              ,
#endif
    toplevelMinimize                        ,


-- ** present #method:present#

#if defined(ENABLE_OVERLOADING)
    ToplevelPresentMethodInfo               ,
#endif
    toplevelPresent                         ,


-- ** restoreSystemShortcuts #method:restoreSystemShortcuts#

#if defined(ENABLE_OVERLOADING)
    ToplevelRestoreSystemShortcutsMethodInfo,
#endif
    toplevelRestoreSystemShortcuts          ,


-- ** setDecorated #method:setDecorated#

#if defined(ENABLE_OVERLOADING)
    ToplevelSetDecoratedMethodInfo          ,
#endif
    toplevelSetDecorated                    ,


-- ** setDeletable #method:setDeletable#

#if defined(ENABLE_OVERLOADING)
    ToplevelSetDeletableMethodInfo          ,
#endif
    toplevelSetDeletable                    ,


-- ** setGravity #method:setGravity#

#if defined(ENABLE_OVERLOADING)
    ToplevelSetGravityMethodInfo            ,
#endif
    toplevelSetGravity                      ,


-- ** setIconList #method:setIconList#

#if defined(ENABLE_OVERLOADING)
    ToplevelSetIconListMethodInfo           ,
#endif
    toplevelSetIconList                     ,


-- ** setModal #method:setModal#

#if defined(ENABLE_OVERLOADING)
    ToplevelSetModalMethodInfo              ,
#endif
    toplevelSetModal                        ,


-- ** setStartupId #method:setStartupId#

#if defined(ENABLE_OVERLOADING)
    ToplevelSetStartupIdMethodInfo          ,
#endif
    toplevelSetStartupId                    ,


-- ** setTitle #method:setTitle#

#if defined(ENABLE_OVERLOADING)
    ToplevelSetTitleMethodInfo              ,
#endif
    toplevelSetTitle                        ,


-- ** setTransientFor #method:setTransientFor#

#if defined(ENABLE_OVERLOADING)
    ToplevelSetTransientForMethodInfo       ,
#endif
    toplevelSetTransientFor                 ,


-- ** showWindowMenu #method:showWindowMenu#

#if defined(ENABLE_OVERLOADING)
    ToplevelShowWindowMenuMethodInfo        ,
#endif
    toplevelShowWindowMenu                  ,


-- ** supportsEdgeConstraints #method:supportsEdgeConstraints#

#if defined(ENABLE_OVERLOADING)
    ToplevelSupportsEdgeConstraintsMethodInfo,
#endif
    toplevelSupportsEdgeConstraints         ,


-- ** titlebarGesture #method:titlebarGesture#

#if defined(ENABLE_OVERLOADING)
    ToplevelTitlebarGestureMethodInfo       ,
#endif
    toplevelTitlebarGesture                 ,




 -- * Properties


-- ** capabilities #attr:capabilities#
-- | The capabilities that are available for this toplevel.
-- 
-- /Since: 4.20/

#if defined(ENABLE_OVERLOADING)
    ToplevelCapabilitiesPropertyInfo        ,
#endif
    getToplevelCapabilities                 ,
#if defined(ENABLE_OVERLOADING)
    toplevelCapabilities                    ,
#endif


-- ** decorated #attr:decorated#
-- | Whether the window manager should add decorations.

#if defined(ENABLE_OVERLOADING)
    ToplevelDecoratedPropertyInfo           ,
#endif
    constructToplevelDecorated              ,
    getToplevelDecorated                    ,
    setToplevelDecorated                    ,
#if defined(ENABLE_OVERLOADING)
    toplevelDecorated                       ,
#endif


-- ** deletable #attr:deletable#
-- | Whether the window manager should allow to close the surface.

#if defined(ENABLE_OVERLOADING)
    ToplevelDeletablePropertyInfo           ,
#endif
    constructToplevelDeletable              ,
    getToplevelDeletable                    ,
    setToplevelDeletable                    ,
#if defined(ENABLE_OVERLOADING)
    toplevelDeletable                       ,
#endif


-- ** fullscreenMode #attr:fullscreenMode#
-- | The fullscreen mode of the surface.

#if defined(ENABLE_OVERLOADING)
    ToplevelFullscreenModePropertyInfo      ,
#endif
    constructToplevelFullscreenMode         ,
    getToplevelFullscreenMode               ,
    setToplevelFullscreenMode               ,
#if defined(ENABLE_OVERLOADING)
    toplevelFullscreenMode                  ,
#endif


-- ** gravity #attr:gravity#
-- | The gravity to use when resizing a surface programmatically.
-- 
-- Gravity describes which point of the surface we want to keep
-- fixed (meaning that the surface will grow in the opposite direction).
-- For example, a gravity of @GDK_GRAVITY_NORTH_EAST@ means that we
-- want to fix top right corner of the surface.
-- 
-- This property is just a hint that may affect the result when negotiating
-- toplevel sizes with the windowing system. It does not affect interactive
-- resizes started with 'GI.Gdk.Interfaces.Toplevel.toplevelBeginResize'.
-- 
-- /Since: 4.20/

#if defined(ENABLE_OVERLOADING)
    ToplevelGravityPropertyInfo             ,
#endif
    constructToplevelGravity                ,
    getToplevelGravity                      ,
    setToplevelGravity                      ,
#if defined(ENABLE_OVERLOADING)
    toplevelGravity                         ,
#endif


-- ** iconList #attr:iconList#
-- | A list of textures to use as icon.

#if defined(ENABLE_OVERLOADING)
    ToplevelIconListPropertyInfo            ,
#endif
    constructToplevelIconList               ,
    getToplevelIconList                     ,
    setToplevelIconList                     ,
#if defined(ENABLE_OVERLOADING)
    toplevelIconList                        ,
#endif


-- ** modal #attr:modal#
-- | Whether the surface is modal.

#if defined(ENABLE_OVERLOADING)
    ToplevelModalPropertyInfo               ,
#endif
    constructToplevelModal                  ,
    getToplevelModal                        ,
    setToplevelModal                        ,
#if defined(ENABLE_OVERLOADING)
    toplevelModal                           ,
#endif


-- ** shortcutsInhibited #attr:shortcutsInhibited#
-- | Whether the surface should inhibit keyboard shortcuts.

#if defined(ENABLE_OVERLOADING)
    ToplevelShortcutsInhibitedPropertyInfo  ,
#endif
    getToplevelShortcutsInhibited           ,
#if defined(ENABLE_OVERLOADING)
    toplevelShortcutsInhibited              ,
#endif


-- ** startupId #attr:startupId#
-- | The startup ID of the surface.
-- 
-- See t'GI.Gdk.Objects.AppLaunchContext.AppLaunchContext' for more information about
-- startup feedback.

#if defined(ENABLE_OVERLOADING)
    ToplevelStartupIdPropertyInfo           ,
#endif
    constructToplevelStartupId              ,
    getToplevelStartupId                    ,
    setToplevelStartupId                    ,
#if defined(ENABLE_OVERLOADING)
    toplevelStartupId                       ,
#endif


-- ** state #attr:state#
-- | The state of the toplevel.

#if defined(ENABLE_OVERLOADING)
    ToplevelStatePropertyInfo               ,
#endif
    getToplevelState                        ,
#if defined(ENABLE_OVERLOADING)
    toplevelState                           ,
#endif


-- ** title #attr:title#
-- | The title of the surface.

#if defined(ENABLE_OVERLOADING)
    ToplevelTitlePropertyInfo               ,
#endif
    constructToplevelTitle                  ,
    getToplevelTitle                        ,
    setToplevelTitle                        ,
#if defined(ENABLE_OVERLOADING)
    toplevelTitle                           ,
#endif


-- ** transientFor #attr:transientFor#
-- | The transient parent of the surface.

#if defined(ENABLE_OVERLOADING)
    ToplevelTransientForPropertyInfo        ,
#endif
    constructToplevelTransientFor           ,
    getToplevelTransientFor                 ,
    setToplevelTransientFor                 ,
#if defined(ENABLE_OVERLOADING)
    toplevelTransientFor                    ,
#endif




 -- * Signals


-- ** computeSize #signal:computeSize#

    ToplevelComputeSizeCallback             ,
#if defined(ENABLE_OVERLOADING)
    ToplevelComputeSizeSignalInfo           ,
#endif
    afterToplevelComputeSize                ,
    onToplevelComputeSize                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import {-# SOURCE #-} qualified GI.Gdk.Structs.ToplevelLayout as Gdk.ToplevelLayout
import {-# SOURCE #-} qualified GI.Gdk.Structs.ToplevelSize as Gdk.ToplevelSize
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.ToplevelLayout as Gdk.ToplevelLayout
import {-# SOURCE #-} qualified GI.Gdk.Structs.ToplevelSize as Gdk.ToplevelSize

#endif

-- interface Toplevel 
-- | Memory-managed wrapper type.
newtype Toplevel = Toplevel (SP.ManagedPtr Toplevel)
    deriving (Eq)

instance SP.ManagedPtrNewtype Toplevel where
    toManagedPtr (Toplevel p) = p

foreign import ccall "gdk_toplevel_get_type"
    c_gdk_toplevel_get_type :: IO B.Types.GType

instance B.Types.TypedObject Toplevel where
    glibType = c_gdk_toplevel_get_type

instance B.Types.GObject Toplevel

-- | Type class for types which can be safely cast to t'Toplevel', for instance with `toToplevel`.
class (SP.GObject o, O.IsDescendantOf Toplevel o) => IsToplevel o
instance (SP.GObject o, O.IsDescendantOf Toplevel o) => IsToplevel o

instance O.HasParentTypes Toplevel
type instance O.ParentTypes Toplevel = '[GObject.Object.Object, Gdk.Surface.Surface]

-- | Cast to t'Toplevel', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toToplevel :: (MIO.MonadIO m, IsToplevel o) => o -> m Toplevel
toToplevel = MIO.liftIO . B.ManagedPtr.unsafeCastTo Toplevel

-- | Convert t'Toplevel' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Toplevel) where
    gvalueGType_ = c_gdk_toplevel_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Toplevel)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Toplevel)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Toplevel ptr
        else return P.Nothing
        
    

-- VVV Prop "capabilities"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ToplevelCapabilities"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@capabilities@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #capabilities
-- @
getToplevelCapabilities :: (MonadIO m, IsToplevel o) => o -> m [Gdk.Flags.ToplevelCapabilities]
getToplevelCapabilities obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "capabilities"

#if defined(ENABLE_OVERLOADING)
data ToplevelCapabilitiesPropertyInfo
instance AttrInfo ToplevelCapabilitiesPropertyInfo where
    type AttrAllowedOps ToplevelCapabilitiesPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ToplevelCapabilitiesPropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelCapabilitiesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ToplevelCapabilitiesPropertyInfo = (~) ()
    type AttrTransferType ToplevelCapabilitiesPropertyInfo = ()
    type AttrGetType ToplevelCapabilitiesPropertyInfo = [Gdk.Flags.ToplevelCapabilities]
    type AttrLabel ToplevelCapabilitiesPropertyInfo = "capabilities"
    type AttrOrigin ToplevelCapabilitiesPropertyInfo = Toplevel
    attrGet = getToplevelCapabilities
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.capabilities"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:capabilities"
        })
#endif

-- VVV Prop "decorated"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@decorated@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #decorated
-- @
getToplevelDecorated :: (MonadIO m, IsToplevel o) => o -> m Bool
getToplevelDecorated obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "decorated"

-- | Set the value of the “@decorated@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #decorated 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelDecorated :: (MonadIO m, IsToplevel o) => o -> Bool -> m ()
setToplevelDecorated obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "decorated" val

-- | Construct a t'GValueConstruct' with valid value for the “@decorated@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelDecorated :: (IsToplevel o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructToplevelDecorated val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "decorated" val

#if defined(ENABLE_OVERLOADING)
data ToplevelDecoratedPropertyInfo
instance AttrInfo ToplevelDecoratedPropertyInfo where
    type AttrAllowedOps ToplevelDecoratedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ToplevelDecoratedPropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelDecoratedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ToplevelDecoratedPropertyInfo = (~) Bool
    type AttrTransferType ToplevelDecoratedPropertyInfo = Bool
    type AttrGetType ToplevelDecoratedPropertyInfo = Bool
    type AttrLabel ToplevelDecoratedPropertyInfo = "decorated"
    type AttrOrigin ToplevelDecoratedPropertyInfo = Toplevel
    attrGet = getToplevelDecorated
    attrSet = setToplevelDecorated
    attrPut = setToplevelDecorated
    attrTransfer _ v = do
        return v
    attrConstruct = constructToplevelDecorated
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.decorated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:decorated"
        })
#endif

-- VVV Prop "deletable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@deletable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #deletable
-- @
getToplevelDeletable :: (MonadIO m, IsToplevel o) => o -> m Bool
getToplevelDeletable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "deletable"

-- | Set the value of the “@deletable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #deletable 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelDeletable :: (MonadIO m, IsToplevel o) => o -> Bool -> m ()
setToplevelDeletable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "deletable" val

-- | Construct a t'GValueConstruct' with valid value for the “@deletable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelDeletable :: (IsToplevel o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructToplevelDeletable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "deletable" val

#if defined(ENABLE_OVERLOADING)
data ToplevelDeletablePropertyInfo
instance AttrInfo ToplevelDeletablePropertyInfo where
    type AttrAllowedOps ToplevelDeletablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ToplevelDeletablePropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelDeletablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ToplevelDeletablePropertyInfo = (~) Bool
    type AttrTransferType ToplevelDeletablePropertyInfo = Bool
    type AttrGetType ToplevelDeletablePropertyInfo = Bool
    type AttrLabel ToplevelDeletablePropertyInfo = "deletable"
    type AttrOrigin ToplevelDeletablePropertyInfo = Toplevel
    attrGet = getToplevelDeletable
    attrSet = setToplevelDeletable
    attrPut = setToplevelDeletable
    attrTransfer _ v = do
        return v
    attrConstruct = constructToplevelDeletable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.deletable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:deletable"
        })
#endif

-- VVV Prop "fullscreen-mode"
   -- Type: TInterface (Name {namespace = "Gdk", name = "FullscreenMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@fullscreen-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #fullscreenMode
-- @
getToplevelFullscreenMode :: (MonadIO m, IsToplevel o) => o -> m Gdk.Enums.FullscreenMode
getToplevelFullscreenMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "fullscreen-mode"

-- | Set the value of the “@fullscreen-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #fullscreenMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelFullscreenMode :: (MonadIO m, IsToplevel o) => o -> Gdk.Enums.FullscreenMode -> m ()
setToplevelFullscreenMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "fullscreen-mode" val

-- | Construct a t'GValueConstruct' with valid value for the “@fullscreen-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelFullscreenMode :: (IsToplevel o, MIO.MonadIO m) => Gdk.Enums.FullscreenMode -> m (GValueConstruct o)
constructToplevelFullscreenMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "fullscreen-mode" val

#if defined(ENABLE_OVERLOADING)
data ToplevelFullscreenModePropertyInfo
instance AttrInfo ToplevelFullscreenModePropertyInfo where
    type AttrAllowedOps ToplevelFullscreenModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ToplevelFullscreenModePropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelFullscreenModePropertyInfo = (~) Gdk.Enums.FullscreenMode
    type AttrTransferTypeConstraint ToplevelFullscreenModePropertyInfo = (~) Gdk.Enums.FullscreenMode
    type AttrTransferType ToplevelFullscreenModePropertyInfo = Gdk.Enums.FullscreenMode
    type AttrGetType ToplevelFullscreenModePropertyInfo = Gdk.Enums.FullscreenMode
    type AttrLabel ToplevelFullscreenModePropertyInfo = "fullscreen-mode"
    type AttrOrigin ToplevelFullscreenModePropertyInfo = Toplevel
    attrGet = getToplevelFullscreenMode
    attrSet = setToplevelFullscreenMode
    attrPut = setToplevelFullscreenMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructToplevelFullscreenMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.fullscreenMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:fullscreenMode"
        })
#endif

-- VVV Prop "gravity"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Gravity"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@gravity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #gravity
-- @
getToplevelGravity :: (MonadIO m, IsToplevel o) => o -> m Gdk.Enums.Gravity
getToplevelGravity obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "gravity"

-- | Set the value of the “@gravity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #gravity 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelGravity :: (MonadIO m, IsToplevel o) => o -> Gdk.Enums.Gravity -> m ()
setToplevelGravity obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "gravity" val

-- | Construct a t'GValueConstruct' with valid value for the “@gravity@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelGravity :: (IsToplevel o, MIO.MonadIO m) => Gdk.Enums.Gravity -> m (GValueConstruct o)
constructToplevelGravity val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "gravity" val

#if defined(ENABLE_OVERLOADING)
data ToplevelGravityPropertyInfo
instance AttrInfo ToplevelGravityPropertyInfo where
    type AttrAllowedOps ToplevelGravityPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ToplevelGravityPropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelGravityPropertyInfo = (~) Gdk.Enums.Gravity
    type AttrTransferTypeConstraint ToplevelGravityPropertyInfo = (~) Gdk.Enums.Gravity
    type AttrTransferType ToplevelGravityPropertyInfo = Gdk.Enums.Gravity
    type AttrGetType ToplevelGravityPropertyInfo = Gdk.Enums.Gravity
    type AttrLabel ToplevelGravityPropertyInfo = "gravity"
    type AttrOrigin ToplevelGravityPropertyInfo = Toplevel
    attrGet = getToplevelGravity
    attrSet = setToplevelGravity
    attrPut = setToplevelGravity
    attrTransfer _ v = do
        return v
    attrConstruct = constructToplevelGravity
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.gravity"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:gravity"
        })
#endif

-- VVV Prop "icon-list"
   -- Type: TBasicType TPtr
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@icon-list@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #iconList
-- @
getToplevelIconList :: (MonadIO m, IsToplevel o) => o -> m (Ptr ())
getToplevelIconList obj = MIO.liftIO $ B.Properties.getObjectPropertyPtr obj "icon-list"

-- | Set the value of the “@icon-list@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #iconList 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelIconList :: (MonadIO m, IsToplevel o) => o -> Ptr () -> m ()
setToplevelIconList obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyPtr obj "icon-list" val

-- | Construct a t'GValueConstruct' with valid value for the “@icon-list@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelIconList :: (IsToplevel o, MIO.MonadIO m) => Ptr () -> m (GValueConstruct o)
constructToplevelIconList val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyPtr "icon-list" val

#if defined(ENABLE_OVERLOADING)
data ToplevelIconListPropertyInfo
instance AttrInfo ToplevelIconListPropertyInfo where
    type AttrAllowedOps ToplevelIconListPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ToplevelIconListPropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelIconListPropertyInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint ToplevelIconListPropertyInfo = (~) (Ptr ())
    type AttrTransferType ToplevelIconListPropertyInfo = Ptr ()
    type AttrGetType ToplevelIconListPropertyInfo = (Ptr ())
    type AttrLabel ToplevelIconListPropertyInfo = "icon-list"
    type AttrOrigin ToplevelIconListPropertyInfo = Toplevel
    attrGet = getToplevelIconList
    attrSet = setToplevelIconList
    attrPut = setToplevelIconList
    attrTransfer _ v = do
        return v
    attrConstruct = constructToplevelIconList
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.iconList"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:iconList"
        })
#endif

-- VVV Prop "modal"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #modal
-- @
getToplevelModal :: (MonadIO m, IsToplevel o) => o -> m Bool
getToplevelModal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "modal"

-- | Set the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #modal 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelModal :: (MonadIO m, IsToplevel o) => o -> Bool -> m ()
setToplevelModal obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "modal" val

-- | Construct a t'GValueConstruct' with valid value for the “@modal@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelModal :: (IsToplevel o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructToplevelModal val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "modal" val

#if defined(ENABLE_OVERLOADING)
data ToplevelModalPropertyInfo
instance AttrInfo ToplevelModalPropertyInfo where
    type AttrAllowedOps ToplevelModalPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ToplevelModalPropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelModalPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ToplevelModalPropertyInfo = (~) Bool
    type AttrTransferType ToplevelModalPropertyInfo = Bool
    type AttrGetType ToplevelModalPropertyInfo = Bool
    type AttrLabel ToplevelModalPropertyInfo = "modal"
    type AttrOrigin ToplevelModalPropertyInfo = Toplevel
    attrGet = getToplevelModal
    attrSet = setToplevelModal
    attrPut = setToplevelModal
    attrTransfer _ v = do
        return v
    attrConstruct = constructToplevelModal
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.modal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:modal"
        })
#endif

-- VVV Prop "shortcuts-inhibited"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@shortcuts-inhibited@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #shortcutsInhibited
-- @
getToplevelShortcutsInhibited :: (MonadIO m, IsToplevel o) => o -> m Bool
getToplevelShortcutsInhibited obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "shortcuts-inhibited"

#if defined(ENABLE_OVERLOADING)
data ToplevelShortcutsInhibitedPropertyInfo
instance AttrInfo ToplevelShortcutsInhibitedPropertyInfo where
    type AttrAllowedOps ToplevelShortcutsInhibitedPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ToplevelShortcutsInhibitedPropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelShortcutsInhibitedPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ToplevelShortcutsInhibitedPropertyInfo = (~) ()
    type AttrTransferType ToplevelShortcutsInhibitedPropertyInfo = ()
    type AttrGetType ToplevelShortcutsInhibitedPropertyInfo = Bool
    type AttrLabel ToplevelShortcutsInhibitedPropertyInfo = "shortcuts-inhibited"
    type AttrOrigin ToplevelShortcutsInhibitedPropertyInfo = Toplevel
    attrGet = getToplevelShortcutsInhibited
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.shortcutsInhibited"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:shortcutsInhibited"
        })
#endif

-- VVV Prop "startup-id"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@startup-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #startupId
-- @
getToplevelStartupId :: (MonadIO m, IsToplevel o) => o -> m (Maybe T.Text)
getToplevelStartupId obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "startup-id"

-- | Set the value of the “@startup-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #startupId 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelStartupId :: (MonadIO m, IsToplevel o) => o -> T.Text -> m ()
setToplevelStartupId obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "startup-id" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@startup-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelStartupId :: (IsToplevel o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructToplevelStartupId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "startup-id" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ToplevelStartupIdPropertyInfo
instance AttrInfo ToplevelStartupIdPropertyInfo where
    type AttrAllowedOps ToplevelStartupIdPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ToplevelStartupIdPropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelStartupIdPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ToplevelStartupIdPropertyInfo = (~) T.Text
    type AttrTransferType ToplevelStartupIdPropertyInfo = T.Text
    type AttrGetType ToplevelStartupIdPropertyInfo = (Maybe T.Text)
    type AttrLabel ToplevelStartupIdPropertyInfo = "startup-id"
    type AttrOrigin ToplevelStartupIdPropertyInfo = Toplevel
    attrGet = getToplevelStartupId
    attrSet = setToplevelStartupId
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructToplevelStartupId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.startupId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:startupId"
        })
#endif

-- VVV Prop "state"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ToplevelState"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #state
-- @
getToplevelState :: (MonadIO m, IsToplevel o) => o -> m [Gdk.Flags.ToplevelState]
getToplevelState obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "state"

#if defined(ENABLE_OVERLOADING)
data ToplevelStatePropertyInfo
instance AttrInfo ToplevelStatePropertyInfo where
    type AttrAllowedOps ToplevelStatePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ToplevelStatePropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelStatePropertyInfo = (~) ()
    type AttrTransferTypeConstraint ToplevelStatePropertyInfo = (~) ()
    type AttrTransferType ToplevelStatePropertyInfo = ()
    type AttrGetType ToplevelStatePropertyInfo = [Gdk.Flags.ToplevelState]
    type AttrLabel ToplevelStatePropertyInfo = "state"
    type AttrOrigin ToplevelStatePropertyInfo = Toplevel
    attrGet = getToplevelState
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:state"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #title
-- @
getToplevelTitle :: (MonadIO m, IsToplevel o) => o -> m (Maybe T.Text)
getToplevelTitle obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "title"

-- | Set the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelTitle :: (MonadIO m, IsToplevel o) => o -> T.Text -> m ()
setToplevelTitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "title" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelTitle :: (IsToplevel o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructToplevelTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ToplevelTitlePropertyInfo
instance AttrInfo ToplevelTitlePropertyInfo where
    type AttrAllowedOps ToplevelTitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ToplevelTitlePropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ToplevelTitlePropertyInfo = (~) T.Text
    type AttrTransferType ToplevelTitlePropertyInfo = T.Text
    type AttrGetType ToplevelTitlePropertyInfo = (Maybe T.Text)
    type AttrLabel ToplevelTitlePropertyInfo = "title"
    type AttrOrigin ToplevelTitlePropertyInfo = Toplevel
    attrGet = getToplevelTitle
    attrSet = setToplevelTitle
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructToplevelTitle
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:title"
        })
#endif

-- VVV Prop "transient-for"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Surface"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@transient-for@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' toplevel #transientFor
-- @
getToplevelTransientFor :: (MonadIO m, IsToplevel o) => o -> m (Maybe Gdk.Surface.Surface)
getToplevelTransientFor obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "transient-for" Gdk.Surface.Surface

-- | Set the value of the “@transient-for@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' toplevel [ #transientFor 'Data.GI.Base.Attributes.:=' value ]
-- @
setToplevelTransientFor :: (MonadIO m, IsToplevel o, Gdk.Surface.IsSurface a) => o -> a -> m ()
setToplevelTransientFor obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "transient-for" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@transient-for@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructToplevelTransientFor :: (IsToplevel o, MIO.MonadIO m, Gdk.Surface.IsSurface a) => a -> m (GValueConstruct o)
constructToplevelTransientFor val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "transient-for" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ToplevelTransientForPropertyInfo
instance AttrInfo ToplevelTransientForPropertyInfo where
    type AttrAllowedOps ToplevelTransientForPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ToplevelTransientForPropertyInfo = IsToplevel
    type AttrSetTypeConstraint ToplevelTransientForPropertyInfo = Gdk.Surface.IsSurface
    type AttrTransferTypeConstraint ToplevelTransientForPropertyInfo = Gdk.Surface.IsSurface
    type AttrTransferType ToplevelTransientForPropertyInfo = Gdk.Surface.Surface
    type AttrGetType ToplevelTransientForPropertyInfo = (Maybe Gdk.Surface.Surface)
    type AttrLabel ToplevelTransientForPropertyInfo = "transient-for"
    type AttrOrigin ToplevelTransientForPropertyInfo = Toplevel
    attrGet = getToplevelTransientFor
    attrSet = setToplevelTransientFor
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Surface.Surface v
    attrConstruct = constructToplevelTransientFor
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.transientFor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:attr:transientFor"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Toplevel
type instance O.AttributeList Toplevel = ToplevelAttributeList
type ToplevelAttributeList = ('[ '("capabilities", ToplevelCapabilitiesPropertyInfo), '("cursor", Gdk.Surface.SurfaceCursorPropertyInfo), '("decorated", ToplevelDecoratedPropertyInfo), '("deletable", ToplevelDeletablePropertyInfo), '("display", Gdk.Surface.SurfaceDisplayPropertyInfo), '("frameClock", Gdk.Surface.SurfaceFrameClockPropertyInfo), '("fullscreenMode", ToplevelFullscreenModePropertyInfo), '("gravity", ToplevelGravityPropertyInfo), '("height", Gdk.Surface.SurfaceHeightPropertyInfo), '("iconList", ToplevelIconListPropertyInfo), '("mapped", Gdk.Surface.SurfaceMappedPropertyInfo), '("modal", ToplevelModalPropertyInfo), '("scale", Gdk.Surface.SurfaceScalePropertyInfo), '("scaleFactor", Gdk.Surface.SurfaceScaleFactorPropertyInfo), '("shortcutsInhibited", ToplevelShortcutsInhibitedPropertyInfo), '("startupId", ToplevelStartupIdPropertyInfo), '("state", ToplevelStatePropertyInfo), '("title", ToplevelTitlePropertyInfo), '("transientFor", ToplevelTransientForPropertyInfo), '("width", Gdk.Surface.SurfaceWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
toplevelCapabilities :: AttrLabelProxy "capabilities"
toplevelCapabilities = AttrLabelProxy

toplevelDecorated :: AttrLabelProxy "decorated"
toplevelDecorated = AttrLabelProxy

toplevelDeletable :: AttrLabelProxy "deletable"
toplevelDeletable = AttrLabelProxy

toplevelFullscreenMode :: AttrLabelProxy "fullscreenMode"
toplevelFullscreenMode = AttrLabelProxy

toplevelGravity :: AttrLabelProxy "gravity"
toplevelGravity = AttrLabelProxy

toplevelIconList :: AttrLabelProxy "iconList"
toplevelIconList = AttrLabelProxy

toplevelModal :: AttrLabelProxy "modal"
toplevelModal = AttrLabelProxy

toplevelShortcutsInhibited :: AttrLabelProxy "shortcutsInhibited"
toplevelShortcutsInhibited = AttrLabelProxy

toplevelStartupId :: AttrLabelProxy "startupId"
toplevelStartupId = AttrLabelProxy

toplevelState :: AttrLabelProxy "state"
toplevelState = AttrLabelProxy

toplevelTitle :: AttrLabelProxy "title"
toplevelTitle = AttrLabelProxy

toplevelTransientFor :: AttrLabelProxy "transientFor"
toplevelTransientFor = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveToplevelMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveToplevelMethod "beep" o = Gdk.Surface.SurfaceBeepMethodInfo
    ResolveToplevelMethod "beginMove" o = ToplevelBeginMoveMethodInfo
    ResolveToplevelMethod "beginResize" o = ToplevelBeginResizeMethodInfo
    ResolveToplevelMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveToplevelMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveToplevelMethod "createCairoContext" o = Gdk.Surface.SurfaceCreateCairoContextMethodInfo
    ResolveToplevelMethod "createGlContext" o = Gdk.Surface.SurfaceCreateGlContextMethodInfo
    ResolveToplevelMethod "createSimilarSurface" o = Gdk.Surface.SurfaceCreateSimilarSurfaceMethodInfo
    ResolveToplevelMethod "createVulkanContext" o = Gdk.Surface.SurfaceCreateVulkanContextMethodInfo
    ResolveToplevelMethod "destroy" o = Gdk.Surface.SurfaceDestroyMethodInfo
    ResolveToplevelMethod "focus" o = ToplevelFocusMethodInfo
    ResolveToplevelMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveToplevelMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveToplevelMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveToplevelMethod "hide" o = Gdk.Surface.SurfaceHideMethodInfo
    ResolveToplevelMethod "inhibitSystemShortcuts" o = ToplevelInhibitSystemShortcutsMethodInfo
    ResolveToplevelMethod "isDestroyed" o = Gdk.Surface.SurfaceIsDestroyedMethodInfo
    ResolveToplevelMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveToplevelMethod "lower" o = ToplevelLowerMethodInfo
    ResolveToplevelMethod "minimize" o = ToplevelMinimizeMethodInfo
    ResolveToplevelMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveToplevelMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveToplevelMethod "present" o = ToplevelPresentMethodInfo
    ResolveToplevelMethod "queueRender" o = Gdk.Surface.SurfaceQueueRenderMethodInfo
    ResolveToplevelMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveToplevelMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveToplevelMethod "requestLayout" o = Gdk.Surface.SurfaceRequestLayoutMethodInfo
    ResolveToplevelMethod "restoreSystemShortcuts" o = ToplevelRestoreSystemShortcutsMethodInfo
    ResolveToplevelMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveToplevelMethod "showWindowMenu" o = ToplevelShowWindowMenuMethodInfo
    ResolveToplevelMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveToplevelMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveToplevelMethod "supportsEdgeConstraints" o = ToplevelSupportsEdgeConstraintsMethodInfo
    ResolveToplevelMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveToplevelMethod "titlebarGesture" o = ToplevelTitlebarGestureMethodInfo
    ResolveToplevelMethod "translateCoordinates" o = Gdk.Surface.SurfaceTranslateCoordinatesMethodInfo
    ResolveToplevelMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveToplevelMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveToplevelMethod "getCapabilities" o = ToplevelGetCapabilitiesMethodInfo
    ResolveToplevelMethod "getCursor" o = Gdk.Surface.SurfaceGetCursorMethodInfo
    ResolveToplevelMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveToplevelMethod "getDeviceCursor" o = Gdk.Surface.SurfaceGetDeviceCursorMethodInfo
    ResolveToplevelMethod "getDevicePosition" o = Gdk.Surface.SurfaceGetDevicePositionMethodInfo
    ResolveToplevelMethod "getDisplay" o = Gdk.Surface.SurfaceGetDisplayMethodInfo
    ResolveToplevelMethod "getFrameClock" o = Gdk.Surface.SurfaceGetFrameClockMethodInfo
    ResolveToplevelMethod "getGravity" o = ToplevelGetGravityMethodInfo
    ResolveToplevelMethod "getHeight" o = Gdk.Surface.SurfaceGetHeightMethodInfo
    ResolveToplevelMethod "getMapped" o = Gdk.Surface.SurfaceGetMappedMethodInfo
    ResolveToplevelMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveToplevelMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveToplevelMethod "getScale" o = Gdk.Surface.SurfaceGetScaleMethodInfo
    ResolveToplevelMethod "getScaleFactor" o = Gdk.Surface.SurfaceGetScaleFactorMethodInfo
    ResolveToplevelMethod "getState" o = ToplevelGetStateMethodInfo
    ResolveToplevelMethod "getWidth" o = Gdk.Surface.SurfaceGetWidthMethodInfo
    ResolveToplevelMethod "setCursor" o = Gdk.Surface.SurfaceSetCursorMethodInfo
    ResolveToplevelMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveToplevelMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveToplevelMethod "setDecorated" o = ToplevelSetDecoratedMethodInfo
    ResolveToplevelMethod "setDeletable" o = ToplevelSetDeletableMethodInfo
    ResolveToplevelMethod "setDeviceCursor" o = Gdk.Surface.SurfaceSetDeviceCursorMethodInfo
    ResolveToplevelMethod "setGravity" o = ToplevelSetGravityMethodInfo
    ResolveToplevelMethod "setIconList" o = ToplevelSetIconListMethodInfo
    ResolveToplevelMethod "setInputRegion" o = Gdk.Surface.SurfaceSetInputRegionMethodInfo
    ResolveToplevelMethod "setModal" o = ToplevelSetModalMethodInfo
    ResolveToplevelMethod "setOpaqueRegion" o = Gdk.Surface.SurfaceSetOpaqueRegionMethodInfo
    ResolveToplevelMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveToplevelMethod "setStartupId" o = ToplevelSetStartupIdMethodInfo
    ResolveToplevelMethod "setTitle" o = ToplevelSetTitleMethodInfo
    ResolveToplevelMethod "setTransientFor" o = ToplevelSetTransientForMethodInfo
    ResolveToplevelMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveToplevelMethod t Toplevel, O.OverloadedMethod info Toplevel p) => OL.IsLabel t (Toplevel -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveToplevelMethod t Toplevel, O.OverloadedMethod info Toplevel p, R.HasField t Toplevel p) => R.HasField t Toplevel p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveToplevelMethod t Toplevel, O.OverloadedMethodInfo info Toplevel) => OL.IsLabel t (O.MethodProxy info Toplevel) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Toplevel::begin_move
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device used for the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the button being used to drag, or 0 for a keyboard-initiated drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "surface X coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "surface Y coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "timestamp of mouse click that began the drag (use\n  [method@Gdk.Event.get_time])"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_begin_move" gdk_toplevel_begin_move :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Int32 ->                                -- button : TBasicType TInt
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | Begins an interactive move operation.
-- 
-- You might use this function to implement draggable titlebars.
toplevelBeginMove ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> b
    -- ^ /@device@/: the device used for the operation
    -> Int32
    -- ^ /@button@/: the button being used to drag, or 0 for a keyboard-initiated drag
    -> Double
    -- ^ /@x@/: surface X coordinate of mouse click that began the drag
    -> Double
    -- ^ /@y@/: surface Y coordinate of mouse click that began the drag
    -> Word32
    -- ^ /@timestamp@/: timestamp of mouse click that began the drag (use
    --   'GI.Gdk.Objects.Event.eventGetTime')
    -> m ()
toplevelBeginMove toplevel device button x y timestamp = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    device' <- unsafeManagedPtrCastPtr device
    let x' = realToFrac x
    let y' = realToFrac y
    gdk_toplevel_begin_move toplevel' device' button x' y' timestamp
    touchManagedPtr toplevel
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelBeginMoveMethodInfo
instance (signature ~ (b -> Int32 -> Double -> Double -> Word32 -> m ()), MonadIO m, IsToplevel a, Gdk.Device.IsDevice b) => O.OverloadedMethod ToplevelBeginMoveMethodInfo a signature where
    overloadedMethod = toplevelBeginMove

instance O.OverloadedMethodInfo ToplevelBeginMoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelBeginMove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelBeginMove"
        })


#endif

-- method Toplevel::begin_resize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "edge"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "SurfaceEdge" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the edge or corner from which the drag is started"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device used for the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the button being used to drag, or 0 for a keyboard-initiated drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "surface X coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "surface Y coordinate of mouse click that began the drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "timestamp of mouse click that began the drag (use\n  [method@Gdk.Event.get_time])"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_begin_resize" gdk_toplevel_begin_resize :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    CUInt ->                                -- edge : TInterface (Name {namespace = "Gdk", name = "SurfaceEdge"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Int32 ->                                -- button : TBasicType TInt
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | Begins an interactive resize operation.
-- 
-- You might use this function to implement a “window resize grip.”
toplevelBeginResize ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> Gdk.Enums.SurfaceEdge
    -- ^ /@edge@/: the edge or corner from which the drag is started
    -> Maybe (b)
    -- ^ /@device@/: the device used for the operation
    -> Int32
    -- ^ /@button@/: the button being used to drag, or 0 for a keyboard-initiated drag
    -> Double
    -- ^ /@x@/: surface X coordinate of mouse click that began the drag
    -> Double
    -- ^ /@y@/: surface Y coordinate of mouse click that began the drag
    -> Word32
    -- ^ /@timestamp@/: timestamp of mouse click that began the drag (use
    --   'GI.Gdk.Objects.Event.eventGetTime')
    -> m ()
toplevelBeginResize toplevel edge device button x y timestamp = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    let edge' = (fromIntegral . fromEnum) edge
    maybeDevice <- case device of
        Nothing -> return FP.nullPtr
        Just jDevice -> do
            jDevice' <- unsafeManagedPtrCastPtr jDevice
            return jDevice'
    let x' = realToFrac x
    let y' = realToFrac y
    gdk_toplevel_begin_resize toplevel' edge' maybeDevice button x' y' timestamp
    touchManagedPtr toplevel
    whenJust device touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelBeginResizeMethodInfo
instance (signature ~ (Gdk.Enums.SurfaceEdge -> Maybe (b) -> Int32 -> Double -> Double -> Word32 -> m ()), MonadIO m, IsToplevel a, Gdk.Device.IsDevice b) => O.OverloadedMethod ToplevelBeginResizeMethodInfo a signature where
    overloadedMethod = toplevelBeginResize

instance O.OverloadedMethodInfo ToplevelBeginResizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelBeginResize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelBeginResize"
        })


#endif

-- method Toplevel::focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "timestamp of the event triggering the surface focus"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_focus" gdk_toplevel_focus :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | Sets keyboard focus to /@surface@/.
-- 
-- In most cases, <http://developer.gnome.org/gdk/stable/../gtk4/method.Window.present_with_time.html gtk_window_present_with_time()>
-- should be used on a <http://developer.gnome.org/gdk/stable/../gtk4/class.Window.html GtkWindow>, rather than
-- calling this function.
toplevelFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> Word32
    -- ^ /@timestamp@/: timestamp of the event triggering the surface focus
    -> m ()
toplevelFocus toplevel timestamp = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    gdk_toplevel_focus toplevel' timestamp
    touchManagedPtr toplevel
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelFocusMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelFocusMethodInfo a signature where
    overloadedMethod = toplevelFocus

instance O.OverloadedMethodInfo ToplevelFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelFocus"
        })


#endif

-- method Toplevel::get_capabilities
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gdk" , name = "ToplevelCapabilities" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_get_capabilities" gdk_toplevel_get_capabilities :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    IO CUInt

-- | The capabilities that are available for this toplevel.
-- 
-- /Since: 4.20/
toplevelGetCapabilities ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> m [Gdk.Flags.ToplevelCapabilities]
toplevelGetCapabilities toplevel = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    result <- gdk_toplevel_get_capabilities toplevel'
    let result' = wordToGFlags result
    touchManagedPtr toplevel
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelGetCapabilitiesMethodInfo
instance (signature ~ (m [Gdk.Flags.ToplevelCapabilities]), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelGetCapabilitiesMethodInfo a signature where
    overloadedMethod = toplevelGetCapabilities

instance O.OverloadedMethodInfo ToplevelGetCapabilitiesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelGetCapabilities",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelGetCapabilities"
        })


#endif

-- method Toplevel::get_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Gravity" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_get_gravity" gdk_toplevel_get_gravity :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    IO CUInt

-- | Returns the gravity that is used when changing the toplevel
-- size programmatically.
-- 
-- /Since: 4.20/
toplevelGetGravity ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a toplevel
    -> m Gdk.Enums.Gravity
    -- ^ __Returns:__ the gravity
toplevelGetGravity toplevel = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    result <- gdk_toplevel_get_gravity toplevel'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr toplevel
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelGetGravityMethodInfo
instance (signature ~ (m Gdk.Enums.Gravity), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelGetGravityMethodInfo a signature where
    overloadedMethod = toplevelGetGravity

instance O.OverloadedMethodInfo ToplevelGetGravityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelGetGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelGetGravity"
        })


#endif

-- method Toplevel::get_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ToplevelState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_get_state" gdk_toplevel_get_state :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    IO CUInt

-- | Gets the bitwise or of the currently active surface state flags,
-- from the @GdkToplevelState@ enumeration.
toplevelGetState ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> m [Gdk.Flags.ToplevelState]
    -- ^ __Returns:__ surface state bitfield
toplevelGetState toplevel = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    result <- gdk_toplevel_get_state toplevel'
    let result' = wordToGFlags result
    touchManagedPtr toplevel
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelGetStateMethodInfo
instance (signature ~ (m [Gdk.Flags.ToplevelState]), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelGetStateMethodInfo a signature where
    overloadedMethod = toplevelGetState

instance O.OverloadedMethodInfo ToplevelGetStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelGetState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelGetState"
        })


#endif

-- method Toplevel::inhibit_system_shortcuts
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GdkEvent` that is triggering the inhibit\n  request, or %NULL if none is available"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_inhibit_system_shortcuts" gdk_toplevel_inhibit_system_shortcuts :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO ()

-- | Requests that the /@toplevel@/ inhibit the system shortcuts.
-- 
-- This is asking the desktop environment\/windowing system to let all
-- keyboard events reach the surface, as long as it is focused, instead
-- of triggering system actions.
-- 
-- If granted, the rerouting remains active until the default shortcuts
-- processing is restored with 'GI.Gdk.Interfaces.Toplevel.toplevelRestoreSystemShortcuts',
-- or the request is revoked by the desktop environment, windowing system
-- or the user.
-- 
-- A typical use case for this API is remote desktop or virtual machine
-- viewers which need to inhibit the default system keyboard shortcuts
-- so that the remote session or virtual host gets those instead of the
-- local environment.
-- 
-- The windowing system or desktop environment may ask the user to grant
-- or deny the request or even choose to ignore the request entirely.
-- 
-- The caller can be notified whenever the request is granted or revoked
-- by listening to the [Toplevel:shortcutsInhibited]("GI.Gdk.Interfaces.Toplevel#g:attr:shortcutsInhibited") property.
toplevelInhibitSystemShortcuts ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a, Gdk.Event.IsEvent b) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> Maybe (b)
    -- ^ /@event@/: the @GdkEvent@ that is triggering the inhibit
    --   request, or 'P.Nothing' if none is available
    -> m ()
toplevelInhibitSystemShortcuts toplevel event = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    maybeEvent <- case event of
        Nothing -> return FP.nullPtr
        Just jEvent -> do
            jEvent' <- unsafeManagedPtrCastPtr jEvent
            return jEvent'
    gdk_toplevel_inhibit_system_shortcuts toplevel' maybeEvent
    touchManagedPtr toplevel
    whenJust event touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelInhibitSystemShortcutsMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsToplevel a, Gdk.Event.IsEvent b) => O.OverloadedMethod ToplevelInhibitSystemShortcutsMethodInfo a signature where
    overloadedMethod = toplevelInhibitSystemShortcuts

instance O.OverloadedMethodInfo ToplevelInhibitSystemShortcutsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelInhibitSystemShortcuts",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelInhibitSystemShortcuts"
        })


#endif

-- method Toplevel::lower
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_lower" gdk_toplevel_lower :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    IO CInt

-- | Asks to lower the /@toplevel@/ below other windows.
-- 
-- The windowing system may choose to ignore the request.
toplevelLower ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the surface was lowered
toplevelLower toplevel = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    result <- gdk_toplevel_lower toplevel'
    let result' = (/= 0) result
    touchManagedPtr toplevel
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelLowerMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelLowerMethodInfo a signature where
    overloadedMethod = toplevelLower

instance O.OverloadedMethodInfo ToplevelLowerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelLower",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelLower"
        })


#endif

-- method Toplevel::minimize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_minimize" gdk_toplevel_minimize :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    IO CInt

-- | Asks to minimize the /@toplevel@/.
-- 
-- The windowing system may choose to ignore the request.
toplevelMinimize ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the surface was minimized
toplevelMinimize toplevel = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    result <- gdk_toplevel_minimize toplevel'
    let result' = (/= 0) result
    touchManagedPtr toplevel
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelMinimizeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelMinimizeMethodInfo a signature where
    overloadedMethod = toplevelMinimize

instance O.OverloadedMethodInfo ToplevelMinimizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelMinimize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelMinimize"
        })


#endif

-- method Toplevel::present
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkToplevel` to show"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkToplevelLayout` object used to layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_present" gdk_toplevel_present :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    Ptr Gdk.ToplevelLayout.ToplevelLayout -> -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    IO ()

-- | Present /@toplevel@/ after having processed the @GdkToplevelLayout@ rules.
-- 
-- If the toplevel was previously not showing, it will be showed,
-- otherwise it will change layout according to /@layout@/.
-- 
-- GDK may emit the [Toplevel::computeSize]("GI.Gdk.Interfaces.Toplevel#g:signal:computeSize") signal to let
-- the user of this toplevel compute the preferred size of the toplevel
-- surface.
-- 
-- Presenting is asynchronous and the specified layout parameters are not
-- guaranteed to be respected.
toplevelPresent ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: the @GdkToplevel@ to show
    -> Gdk.ToplevelLayout.ToplevelLayout
    -- ^ /@layout@/: the @GdkToplevelLayout@ object used to layout
    -> m ()
toplevelPresent toplevel layout = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    layout' <- unsafeManagedPtrGetPtr layout
    gdk_toplevel_present toplevel' layout'
    touchManagedPtr toplevel
    touchManagedPtr layout
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelPresentMethodInfo
instance (signature ~ (Gdk.ToplevelLayout.ToplevelLayout -> m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelPresentMethodInfo a signature where
    overloadedMethod = toplevelPresent

instance O.OverloadedMethodInfo ToplevelPresentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelPresent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelPresent"
        })


#endif

-- method Toplevel::restore_system_shortcuts
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_restore_system_shortcuts" gdk_toplevel_restore_system_shortcuts :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    IO ()

-- | Restore default system keyboard shortcuts which were previously
-- inhibited.
-- 
-- This undoes the effect of 'GI.Gdk.Interfaces.Toplevel.toplevelInhibitSystemShortcuts'.
toplevelRestoreSystemShortcuts ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> m ()
toplevelRestoreSystemShortcuts toplevel = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    gdk_toplevel_restore_system_shortcuts toplevel'
    touchManagedPtr toplevel
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelRestoreSystemShortcutsMethodInfo
instance (signature ~ (m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelRestoreSystemShortcutsMethodInfo a signature where
    overloadedMethod = toplevelRestoreSystemShortcuts

instance O.OverloadedMethodInfo ToplevelRestoreSystemShortcutsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelRestoreSystemShortcuts",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelRestoreSystemShortcuts"
        })


#endif

-- method Toplevel::set_decorated
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "decorated"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to request decorations"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_set_decorated" gdk_toplevel_set_decorated :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    CInt ->                                 -- decorated : TBasicType TBoolean
    IO ()

-- | Sets the toplevel to be decorated.
-- 
-- Setting /@decorated@/ to 'P.False' hints the desktop environment
-- that the surface has its own, client-side decorations and
-- does not need to have window decorations added.
toplevelSetDecorated ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> Bool
    -- ^ /@decorated@/: 'P.True' to request decorations
    -> m ()
toplevelSetDecorated toplevel decorated = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    let decorated' = (P.fromIntegral . P.fromEnum) decorated
    gdk_toplevel_set_decorated toplevel' decorated'
    touchManagedPtr toplevel
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSetDecoratedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelSetDecoratedMethodInfo a signature where
    overloadedMethod = toplevelSetDecorated

instance O.OverloadedMethodInfo ToplevelSetDecoratedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSetDecorated",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSetDecorated"
        })


#endif

-- method Toplevel::set_deletable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "deletable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to request a delete button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_set_deletable" gdk_toplevel_set_deletable :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    CInt ->                                 -- deletable : TBasicType TBoolean
    IO ()

-- | Sets the toplevel to be deletable.
-- 
-- Setting /@deletable@/ to 'P.True' hints the desktop environment
-- that it should offer the user a way to close the surface.
toplevelSetDeletable ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> Bool
    -- ^ /@deletable@/: 'P.True' to request a delete button
    -> m ()
toplevelSetDeletable toplevel deletable = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    let deletable' = (P.fromIntegral . P.fromEnum) deletable
    gdk_toplevel_set_deletable toplevel' deletable'
    touchManagedPtr toplevel
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSetDeletableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelSetDeletableMethodInfo a signature where
    overloadedMethod = toplevelSetDeletable

instance O.OverloadedMethodInfo ToplevelSetDeletableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSetDeletable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSetDeletable"
        })


#endif

-- method Toplevel::set_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "gravity"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Gravity" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new gravity" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_set_gravity" gdk_toplevel_set_gravity :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    CUInt ->                                -- gravity : TInterface (Name {namespace = "Gdk", name = "Gravity"})
    IO ()

-- | Sets the gravity that is used when changing the toplevel
-- size programmatically.
-- 
-- /Since: 4.20/
toplevelSetGravity ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a toplevel
    -> Gdk.Enums.Gravity
    -- ^ /@gravity@/: the new gravity
    -> m ()
toplevelSetGravity toplevel gravity = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    let gravity' = (fromIntegral . fromEnum) gravity
    gdk_toplevel_set_gravity toplevel' gravity'
    touchManagedPtr toplevel
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSetGravityMethodInfo
instance (signature ~ (Gdk.Enums.Gravity -> m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelSetGravityMethodInfo a signature where
    overloadedMethod = toplevelSetGravity

instance O.OverloadedMethodInfo ToplevelSetGravityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSetGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSetGravity"
        })


#endif

-- method Toplevel::set_icon_list
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "surfaces"
--           , argType =
--               TGList (TInterface Name { namespace = "Gdk" , name = "Texture" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "\n  A list of textures to use as icon, of different sizes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_set_icon_list" gdk_toplevel_set_icon_list :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    Ptr (GList (Ptr Gdk.Texture.Texture)) -> -- surfaces : TGList (TInterface (Name {namespace = "Gdk", name = "Texture"}))
    IO ()

-- | Sets a list of icons for the surface.
-- 
-- One of these will be used to represent the surface in iconic form.
-- The icon may be shown in window lists or task bars. Which icon
-- size is shown depends on the window manager. The window manager
-- can scale the icon but setting several size icons can give better
-- image quality.
-- 
-- Note that some platforms don\'t support surface icons.
toplevelSetIconList ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a, Gdk.Texture.IsTexture b) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> [b]
    -- ^ /@surfaces@/: 
    --   A list of textures to use as icon, of different sizes
    -> m ()
toplevelSetIconList toplevel surfaces = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    surfaces' <- mapM unsafeManagedPtrCastPtr surfaces
    surfaces'' <- packGList surfaces'
    gdk_toplevel_set_icon_list toplevel' surfaces''
    touchManagedPtr toplevel
    mapM_ touchManagedPtr surfaces
    g_list_free surfaces''
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSetIconListMethodInfo
instance (signature ~ ([b] -> m ()), MonadIO m, IsToplevel a, Gdk.Texture.IsTexture b) => O.OverloadedMethod ToplevelSetIconListMethodInfo a signature where
    overloadedMethod = toplevelSetIconList

instance O.OverloadedMethodInfo ToplevelSetIconListMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSetIconList",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSetIconList"
        })


#endif

-- method Toplevel::set_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modal"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the surface is modal, %FALSE otherwise."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_set_modal" gdk_toplevel_set_modal :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    CInt ->                                 -- modal : TBasicType TBoolean
    IO ()

-- | Sets the toplevel to be modal.
-- 
-- The application can use this hint to tell the
-- window manager that a certain surface has modal
-- behaviour. The window manager can use this information
-- to handle modal surfaces in a special way.
-- 
-- You should only use this on surfaces for which you have
-- previously called 'GI.Gdk.Interfaces.Toplevel.toplevelSetTransientFor'.
toplevelSetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> Bool
    -- ^ /@modal@/: 'P.True' if the surface is modal, 'P.False' otherwise.
    -> m ()
toplevelSetModal toplevel modal = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    let modal' = (P.fromIntegral . P.fromEnum) modal
    gdk_toplevel_set_modal toplevel' modal'
    touchManagedPtr toplevel
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSetModalMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelSetModalMethodInfo a signature where
    overloadedMethod = toplevelSetModal

instance O.OverloadedMethodInfo ToplevelSetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSetModal"
        })


#endif

-- method Toplevel::set_startup_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "startup_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string with startup-notification identifier"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_set_startup_id" gdk_toplevel_set_startup_id :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    CString ->                              -- startup_id : TBasicType TUTF8
    IO ()

-- | Sets the startup notification ID.
-- 
-- When using GTK, typically you should use
-- <http://developer.gnome.org/gdk/stable/../gtk4/method.Window.set_startup_id.html gtk_window_set_startup_id()>
-- instead of this low-level function.
toplevelSetStartupId ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> T.Text
    -- ^ /@startupId@/: a string with startup-notification identifier
    -> m ()
toplevelSetStartupId toplevel startupId = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    startupId' <- textToCString startupId
    gdk_toplevel_set_startup_id toplevel' startupId'
    touchManagedPtr toplevel
    freeMem startupId'
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSetStartupIdMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelSetStartupIdMethodInfo a signature where
    overloadedMethod = toplevelSetStartupId

instance O.OverloadedMethodInfo ToplevelSetStartupIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSetStartupId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSetStartupId"
        })


#endif

-- method Toplevel::set_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "title of @surface" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_set_title" gdk_toplevel_set_title :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    CString ->                              -- title : TBasicType TUTF8
    IO ()

-- | Sets the title of a toplevel surface.
-- 
-- The title maybe be displayed in the titlebar,
-- in lists of windows, etc.
toplevelSetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> T.Text
    -- ^ /@title@/: title of /@surface@/
    -> m ()
toplevelSetTitle toplevel title = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    title' <- textToCString title
    gdk_toplevel_set_title toplevel' title'
    touchManagedPtr toplevel
    freeMem title'
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSetTitleMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelSetTitleMethodInfo a signature where
    overloadedMethod = toplevelSetTitle

instance O.OverloadedMethodInfo ToplevelSetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSetTitle"
        })


#endif

-- method Toplevel::set_transient_for
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another toplevel `GdkSurface`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_set_transient_for" gdk_toplevel_set_transient_for :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    Ptr Gdk.Surface.Surface ->              -- parent : TInterface (Name {namespace = "Gdk", name = "Surface"})
    IO ()

-- | Sets a transient-for parent.
-- 
-- Indicates to the window manager that /@surface@/ is a transient
-- dialog associated with the application surface /@parent@/. This
-- allows the window manager to do things like center /@surface@/
-- on /@parent@/ and keep /@surface@/ above /@parent@/.
-- 
-- See <http://developer.gnome.org/gdk/stable/../gtk4/method.Window.set_transient_for.html gtk_window_set_transient_for()>
-- if you’re using <http://developer.gnome.org/gdk/stable/../gtk4/class.Window.html GtkWindow>.
toplevelSetTransientFor ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a, Gdk.Surface.IsSurface b) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> b
    -- ^ /@parent@/: another toplevel @GdkSurface@
    -> m ()
toplevelSetTransientFor toplevel parent = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    parent' <- unsafeManagedPtrCastPtr parent
    gdk_toplevel_set_transient_for toplevel' parent'
    touchManagedPtr toplevel
    touchManagedPtr parent
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelSetTransientForMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsToplevel a, Gdk.Surface.IsSurface b) => O.OverloadedMethod ToplevelSetTransientForMethodInfo a signature where
    overloadedMethod = toplevelSetTransientFor

instance O.OverloadedMethodInfo ToplevelSetTransientForMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSetTransientFor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSetTransientFor"
        })


#endif

-- method Toplevel::show_window_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkEvent` to show the menu for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_show_window_menu" gdk_toplevel_show_window_menu :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO CInt

-- | Asks the windowing system to show the window menu.
-- 
-- The window menu is the menu shown when right-clicking the titlebar
-- on traditional windows managed by the window manager. This is useful
-- for windows using client-side decorations, activating it with a
-- right-click on the window decorations.
toplevelShowWindowMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a, Gdk.Event.IsEvent b) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> b
    -- ^ /@event@/: a @GdkEvent@ to show the menu for
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window menu was shown and 'P.False' otherwise.
toplevelShowWindowMenu toplevel event = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_toplevel_show_window_menu toplevel' event'
    let result' = (/= 0) result
    touchManagedPtr toplevel
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelShowWindowMenuMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsToplevel a, Gdk.Event.IsEvent b) => O.OverloadedMethod ToplevelShowWindowMenuMethodInfo a signature where
    overloadedMethod = toplevelShowWindowMenu

instance O.OverloadedMethodInfo ToplevelShowWindowMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelShowWindowMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelShowWindowMenu"
        })


#endif

-- method Toplevel::supports_edge_constraints
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_supports_edge_constraints" gdk_toplevel_supports_edge_constraints :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    IO CInt

-- | Returns whether the desktop environment supports
-- tiled window states.
toplevelSupportsEdgeConstraints ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the desktop environment supports tiled window states
toplevelSupportsEdgeConstraints toplevel = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    result <- gdk_toplevel_supports_edge_constraints toplevel'
    let result' = (/= 0) result
    touchManagedPtr toplevel
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelSupportsEdgeConstraintsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelSupportsEdgeConstraintsMethodInfo a signature where
    overloadedMethod = toplevelSupportsEdgeConstraints

instance O.OverloadedMethodInfo ToplevelSupportsEdgeConstraintsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelSupportsEdgeConstraints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelSupportsEdgeConstraints"
        })


#endif

-- method Toplevel::titlebar_gesture
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "toplevel"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Toplevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkToplevel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "gesture"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "TitlebarGesture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkTitlebarGesture`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_titlebar_gesture" gdk_toplevel_titlebar_gesture :: 
    Ptr Toplevel ->                         -- toplevel : TInterface (Name {namespace = "Gdk", name = "Toplevel"})
    CUInt ->                                -- gesture : TInterface (Name {namespace = "Gdk", name = "TitlebarGesture"})
    IO CInt

-- | Performs a title bar gesture.
-- 
-- /Since: 4.4/
toplevelTitlebarGesture ::
    (B.CallStack.HasCallStack, MonadIO m, IsToplevel a) =>
    a
    -- ^ /@toplevel@/: a @GdkToplevel@
    -> Gdk.Enums.TitlebarGesture
    -- ^ /@gesture@/: a @GdkTitlebarGesture@
    -> m Bool
    -- ^ __Returns:__ whether the gesture was performed
toplevelTitlebarGesture toplevel gesture = liftIO $ do
    toplevel' <- unsafeManagedPtrCastPtr toplevel
    let gesture' = (fromIntegral . fromEnum) gesture
    result <- gdk_toplevel_titlebar_gesture toplevel' gesture'
    let result' = (/= 0) result
    touchManagedPtr toplevel
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelTitlebarGestureMethodInfo
instance (signature ~ (Gdk.Enums.TitlebarGesture -> m Bool), MonadIO m, IsToplevel a) => O.OverloadedMethod ToplevelTitlebarGestureMethodInfo a signature where
    overloadedMethod = toplevelTitlebarGesture

instance O.OverloadedMethodInfo ToplevelTitlebarGestureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel.toplevelTitlebarGesture",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#v:toplevelTitlebarGesture"
        })


#endif

-- signal Toplevel::compute-size
-- | Emitted when the size for the surface needs to be computed, when
-- it is present.
-- 
-- This signal will normally be emitted during or after a call to
-- 'GI.Gdk.Interfaces.Toplevel.toplevelPresent', depending on the configuration
-- received by the windowing system. It may also be emitted at any
-- other point in time, in response to the windowing system
-- spontaneously changing the configuration of the toplevel surface.
-- 
-- It is the responsibility of the toplevel user to handle this signal
-- and compute the desired size of the toplevel, given the information
-- passed via the t'GI.Gdk.Structs.ToplevelSize.ToplevelSize' object. Failing to do so
-- will result in an arbitrary size being used as a result.
type ToplevelComputeSizeCallback =
    Gdk.ToplevelSize.ToplevelSize
    -- ^ /@size@/: a @GdkToplevelSize@
    -> IO ()

type C_ToplevelComputeSizeCallback =
    Ptr Toplevel ->                         -- object
    Ptr Gdk.ToplevelSize.ToplevelSize ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ToplevelComputeSizeCallback`.
foreign import ccall "wrapper"
    mk_ToplevelComputeSizeCallback :: C_ToplevelComputeSizeCallback -> IO (FunPtr C_ToplevelComputeSizeCallback)

wrap_ToplevelComputeSizeCallback :: 
    GObject a => (a -> ToplevelComputeSizeCallback) ->
    C_ToplevelComputeSizeCallback
wrap_ToplevelComputeSizeCallback gi'cb gi'selfPtr size _ = do
    size' <- (newPtr Gdk.ToplevelSize.ToplevelSize) size
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  size'


-- | Connect a signal handler for the [computeSize](#signal:computeSize) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' toplevel #computeSize callback
-- @
-- 
-- 
onToplevelComputeSize :: (IsToplevel a, MonadIO m) => a -> ((?self :: a) => ToplevelComputeSizeCallback) -> m SignalHandlerId
onToplevelComputeSize obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ToplevelComputeSizeCallback wrapped
    wrapped'' <- mk_ToplevelComputeSizeCallback wrapped'
    connectSignalFunPtr obj "compute-size" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [computeSize](#signal:computeSize) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' toplevel #computeSize callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterToplevelComputeSize :: (IsToplevel a, MonadIO m) => a -> ((?self :: a) => ToplevelComputeSizeCallback) -> m SignalHandlerId
afterToplevelComputeSize obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ToplevelComputeSizeCallback wrapped
    wrapped'' <- mk_ToplevelComputeSizeCallback wrapped'
    connectSignalFunPtr obj "compute-size" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ToplevelComputeSizeSignalInfo
instance SignalInfo ToplevelComputeSizeSignalInfo where
    type HaskellCallbackType ToplevelComputeSizeSignalInfo = ToplevelComputeSizeCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ToplevelComputeSizeCallback cb
        cb'' <- mk_ToplevelComputeSizeCallback cb'
        connectSignalFunPtr obj "compute-size" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.Toplevel::compute-size"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-Toplevel.html#g:signal:computeSize"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Toplevel = ToplevelSignalList
type ToplevelSignalList = ('[ '("computeSize", ToplevelComputeSizeSignalInfo), '("enterMonitor", Gdk.Surface.SurfaceEnterMonitorSignalInfo), '("event", Gdk.Surface.SurfaceEventSignalInfo), '("layout", Gdk.Surface.SurfaceLayoutSignalInfo), '("leaveMonitor", Gdk.Surface.SurfaceLeaveMonitorSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("render", Gdk.Surface.SurfaceRenderSignalInfo)] :: [(Symbol, DK.Type)])

#endif


