{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GDBusObjectManagerServer@ is used to export t'GI.Gio.Interfaces.DBusObject.DBusObject' instances
-- using the standardized
-- <http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager `org.freedesktop.DBus.ObjectManager`>
-- interface. For example, remote D-Bus clients can get all objects
-- and properties in a single call. Additionally, any change in the
-- object hierarchy is broadcast using signals. This means that D-Bus
-- clients can keep caches up to date by only listening to D-Bus
-- signals.
-- 
-- The recommended path to export an object manager at is the path form of the
-- well-known name of a D-Bus service, or below. For example, if a D-Bus service
-- is available at the well-known name @net.example.ExampleService1@, the object
-- manager should typically be exported at @\/net\/example\/ExampleService1@, or
-- below (to allow for multiple object managers in a service).
-- 
-- It is supported, but not recommended, to export an object manager at the root
-- path, @\/@.
-- 
-- See t'GI.Gio.Objects.DBusObjectManagerClient.DBusObjectManagerClient' for the client-side code that is
-- intended to be used with @GDBusObjectManagerServer@ or any D-Bus
-- object implementing the @org.freedesktop.DBus.ObjectManager@ interface.
-- 
-- /Since: 2.30/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.DBusObjectManagerServer
    ( 

-- * Exported types
    DBusObjectManagerServer(..)             ,
    IsDBusObjectManagerServer               ,
    toDBusObjectManagerServer               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [export]("GI.Gio.Objects.DBusObjectManagerServer#g:method:export"), [exportUniquely]("GI.Gio.Objects.DBusObjectManagerServer#g:method:exportUniquely"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isExported]("GI.Gio.Objects.DBusObjectManagerServer#g:method:isExported"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unexport]("GI.Gio.Objects.DBusObjectManagerServer#g:method:unexport"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getConnection]("GI.Gio.Objects.DBusObjectManagerServer#g:method:getConnection"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getInterface]("GI.Gio.Interfaces.DBusObjectManager#g:method:getInterface"), [getObject]("GI.Gio.Interfaces.DBusObjectManager#g:method:getObject"), [getObjectPath]("GI.Gio.Interfaces.DBusObjectManager#g:method:getObjectPath"), [getObjects]("GI.Gio.Interfaces.DBusObjectManager#g:method:getObjects"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setConnection]("GI.Gio.Objects.DBusObjectManagerServer#g:method:setConnection"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDBusObjectManagerServerMethod    ,
#endif

-- ** export #method:export#

#if defined(ENABLE_OVERLOADING)
    DBusObjectManagerServerExportMethodInfo ,
#endif
    dBusObjectManagerServerExport           ,


-- ** exportUniquely #method:exportUniquely#

#if defined(ENABLE_OVERLOADING)
    DBusObjectManagerServerExportUniquelyMethodInfo,
#endif
    dBusObjectManagerServerExportUniquely   ,


-- ** getConnection #method:getConnection#

#if defined(ENABLE_OVERLOADING)
    DBusObjectManagerServerGetConnectionMethodInfo,
#endif
    dBusObjectManagerServerGetConnection    ,


-- ** isExported #method:isExported#

#if defined(ENABLE_OVERLOADING)
    DBusObjectManagerServerIsExportedMethodInfo,
#endif
    dBusObjectManagerServerIsExported       ,


-- ** new #method:new#

    dBusObjectManagerServerNew              ,


-- ** setConnection #method:setConnection#

#if defined(ENABLE_OVERLOADING)
    DBusObjectManagerServerSetConnectionMethodInfo,
#endif
    dBusObjectManagerServerSetConnection    ,


-- ** unexport #method:unexport#

#if defined(ENABLE_OVERLOADING)
    DBusObjectManagerServerUnexportMethodInfo,
#endif
    dBusObjectManagerServerUnexport         ,




 -- * Properties


-- ** connection #attr:connection#
-- | The t'GI.Gio.Objects.DBusConnection.DBusConnection' to export objects on.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    DBusObjectManagerServerConnectionPropertyInfo,
#endif
    clearDBusObjectManagerServerConnection  ,
    constructDBusObjectManagerServerConnection,
#if defined(ENABLE_OVERLOADING)
    dBusObjectManagerServerConnection       ,
#endif
    getDBusObjectManagerServerConnection    ,
    setDBusObjectManagerServerConnection    ,


-- ** objectPath #attr:objectPath#
-- | The object path to register the manager object at.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    DBusObjectManagerServerObjectPathPropertyInfo,
#endif
    constructDBusObjectManagerServerObjectPath,
#if defined(ENABLE_OVERLOADING)
    dBusObjectManagerServerObjectPath       ,
#endif
    getDBusObjectManagerServerObjectPath    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncInitable as Gio.AsyncInitable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusInterface as Gio.DBusInterface
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObject as Gio.DBusObject
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObjectManager as Gio.DBusObjectManager
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusAuthObserver as Gio.DBusAuthObserver
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusInterfaceSkeleton as Gio.DBusInterfaceSkeleton
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMessage as Gio.DBusMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMethodInvocation as Gio.DBusMethodInvocation
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusObjectSkeleton as Gio.DBusObjectSkeleton
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuLinkIter as Gio.MenuLinkIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.UnixFDList as Gio.UnixFDList
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceVTable as Gio.DBusInterfaceVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSubtreeVTable as Gio.DBusSubtreeVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObjectManager as Gio.DBusObjectManager
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusObjectSkeleton as Gio.DBusObjectSkeleton

#endif

-- | Memory-managed wrapper type.
newtype DBusObjectManagerServer = DBusObjectManagerServer (SP.ManagedPtr DBusObjectManagerServer)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusObjectManagerServer where
    toManagedPtr (DBusObjectManagerServer p) = p

foreign import ccall "g_dbus_object_manager_server_get_type"
    c_g_dbus_object_manager_server_get_type :: IO B.Types.GType

instance B.Types.TypedObject DBusObjectManagerServer where
    glibType = c_g_dbus_object_manager_server_get_type

instance B.Types.GObject DBusObjectManagerServer

-- | Type class for types which can be safely cast to t'DBusObjectManagerServer', for instance with `toDBusObjectManagerServer`.
class (SP.GObject o, O.IsDescendantOf DBusObjectManagerServer o) => IsDBusObjectManagerServer o
instance (SP.GObject o, O.IsDescendantOf DBusObjectManagerServer o) => IsDBusObjectManagerServer o

instance O.HasParentTypes DBusObjectManagerServer
type instance O.ParentTypes DBusObjectManagerServer = '[GObject.Object.Object, Gio.DBusObjectManager.DBusObjectManager]

-- | Cast to t'DBusObjectManagerServer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDBusObjectManagerServer :: (MIO.MonadIO m, IsDBusObjectManagerServer o) => o -> m DBusObjectManagerServer
toDBusObjectManagerServer = MIO.liftIO . B.ManagedPtr.unsafeCastTo DBusObjectManagerServer

-- | Convert t'DBusObjectManagerServer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusObjectManagerServer) where
    gvalueGType_ = c_g_dbus_object_manager_server_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DBusObjectManagerServer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DBusObjectManagerServer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DBusObjectManagerServer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusObjectManagerServerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusObjectManagerServerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDBusObjectManagerServerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDBusObjectManagerServerMethod "export" o = DBusObjectManagerServerExportMethodInfo
    ResolveDBusObjectManagerServerMethod "exportUniquely" o = DBusObjectManagerServerExportUniquelyMethodInfo
    ResolveDBusObjectManagerServerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDBusObjectManagerServerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDBusObjectManagerServerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDBusObjectManagerServerMethod "isExported" o = DBusObjectManagerServerIsExportedMethodInfo
    ResolveDBusObjectManagerServerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDBusObjectManagerServerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDBusObjectManagerServerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDBusObjectManagerServerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDBusObjectManagerServerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDBusObjectManagerServerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDBusObjectManagerServerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDBusObjectManagerServerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDBusObjectManagerServerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDBusObjectManagerServerMethod "unexport" o = DBusObjectManagerServerUnexportMethodInfo
    ResolveDBusObjectManagerServerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDBusObjectManagerServerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDBusObjectManagerServerMethod "getConnection" o = DBusObjectManagerServerGetConnectionMethodInfo
    ResolveDBusObjectManagerServerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDBusObjectManagerServerMethod "getInterface" o = Gio.DBusObjectManager.DBusObjectManagerGetInterfaceMethodInfo
    ResolveDBusObjectManagerServerMethod "getObject" o = Gio.DBusObjectManager.DBusObjectManagerGetObjectMethodInfo
    ResolveDBusObjectManagerServerMethod "getObjectPath" o = Gio.DBusObjectManager.DBusObjectManagerGetObjectPathMethodInfo
    ResolveDBusObjectManagerServerMethod "getObjects" o = Gio.DBusObjectManager.DBusObjectManagerGetObjectsMethodInfo
    ResolveDBusObjectManagerServerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDBusObjectManagerServerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDBusObjectManagerServerMethod "setConnection" o = DBusObjectManagerServerSetConnectionMethodInfo
    ResolveDBusObjectManagerServerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDBusObjectManagerServerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDBusObjectManagerServerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDBusObjectManagerServerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusObjectManagerServerMethod t DBusObjectManagerServer, O.OverloadedMethod info DBusObjectManagerServer p) => OL.IsLabel t (DBusObjectManagerServer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusObjectManagerServerMethod t DBusObjectManagerServer, O.OverloadedMethod info DBusObjectManagerServer p, R.HasField t DBusObjectManagerServer p) => R.HasField t DBusObjectManagerServer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusObjectManagerServerMethod t DBusObjectManagerServer, O.OverloadedMethodInfo info DBusObjectManagerServer) => OL.IsLabel t (O.MethodProxy info DBusObjectManagerServer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "connection"
   -- Type: TInterface (Name {namespace = "Gio", name = "DBusConnection"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@connection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusObjectManagerServer #connection
-- @
getDBusObjectManagerServerConnection :: (MonadIO m, IsDBusObjectManagerServer o) => o -> m (Maybe Gio.DBusConnection.DBusConnection)
getDBusObjectManagerServerConnection obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "connection" Gio.DBusConnection.DBusConnection

-- | Set the value of the “@connection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusObjectManagerServer [ #connection 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusObjectManagerServerConnection :: (MonadIO m, IsDBusObjectManagerServer o, Gio.DBusConnection.IsDBusConnection a) => o -> a -> m ()
setDBusObjectManagerServerConnection obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "connection" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@connection@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDBusObjectManagerServerConnection :: (IsDBusObjectManagerServer o, MIO.MonadIO m, Gio.DBusConnection.IsDBusConnection a) => a -> m (GValueConstruct o)
constructDBusObjectManagerServerConnection val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "connection" (P.Just val)

-- | Set the value of the “@connection@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #connection
-- @
clearDBusObjectManagerServerConnection :: (MonadIO m, IsDBusObjectManagerServer o) => o -> m ()
clearDBusObjectManagerServerConnection obj = liftIO $ B.Properties.setObjectPropertyObject obj "connection" (Nothing :: Maybe Gio.DBusConnection.DBusConnection)

#if defined(ENABLE_OVERLOADING)
data DBusObjectManagerServerConnectionPropertyInfo
instance AttrInfo DBusObjectManagerServerConnectionPropertyInfo where
    type AttrAllowedOps DBusObjectManagerServerConnectionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DBusObjectManagerServerConnectionPropertyInfo = IsDBusObjectManagerServer
    type AttrSetTypeConstraint DBusObjectManagerServerConnectionPropertyInfo = Gio.DBusConnection.IsDBusConnection
    type AttrTransferTypeConstraint DBusObjectManagerServerConnectionPropertyInfo = Gio.DBusConnection.IsDBusConnection
    type AttrTransferType DBusObjectManagerServerConnectionPropertyInfo = Gio.DBusConnection.DBusConnection
    type AttrGetType DBusObjectManagerServerConnectionPropertyInfo = (Maybe Gio.DBusConnection.DBusConnection)
    type AttrLabel DBusObjectManagerServerConnectionPropertyInfo = "connection"
    type AttrOrigin DBusObjectManagerServerConnectionPropertyInfo = DBusObjectManagerServer
    attrGet = getDBusObjectManagerServerConnection
    attrSet = setDBusObjectManagerServerConnection
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.DBusConnection.DBusConnection v
    attrConstruct = constructDBusObjectManagerServerConnection
    attrClear = clearDBusObjectManagerServerConnection
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectManagerServer.connection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectManagerServer.html#g:attr:connection"
        })
#endif

-- VVV Prop "object-path"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@object-path@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusObjectManagerServer #objectPath
-- @
getDBusObjectManagerServerObjectPath :: (MonadIO m, IsDBusObjectManagerServer o) => o -> m (Maybe T.Text)
getDBusObjectManagerServerObjectPath obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "object-path"

-- | Construct a t'GValueConstruct' with valid value for the “@object-path@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDBusObjectManagerServerObjectPath :: (IsDBusObjectManagerServer o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDBusObjectManagerServerObjectPath val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "object-path" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DBusObjectManagerServerObjectPathPropertyInfo
instance AttrInfo DBusObjectManagerServerObjectPathPropertyInfo where
    type AttrAllowedOps DBusObjectManagerServerObjectPathPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DBusObjectManagerServerObjectPathPropertyInfo = IsDBusObjectManagerServer
    type AttrSetTypeConstraint DBusObjectManagerServerObjectPathPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DBusObjectManagerServerObjectPathPropertyInfo = (~) T.Text
    type AttrTransferType DBusObjectManagerServerObjectPathPropertyInfo = T.Text
    type AttrGetType DBusObjectManagerServerObjectPathPropertyInfo = (Maybe T.Text)
    type AttrLabel DBusObjectManagerServerObjectPathPropertyInfo = "object-path"
    type AttrOrigin DBusObjectManagerServerObjectPathPropertyInfo = DBusObjectManagerServer
    attrGet = getDBusObjectManagerServerObjectPath
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDBusObjectManagerServerObjectPath
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectManagerServer.objectPath"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectManagerServer.html#g:attr:objectPath"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusObjectManagerServer
type instance O.AttributeList DBusObjectManagerServer = DBusObjectManagerServerAttributeList
type DBusObjectManagerServerAttributeList = ('[ '("connection", DBusObjectManagerServerConnectionPropertyInfo), '("objectPath", DBusObjectManagerServerObjectPathPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dBusObjectManagerServerConnection :: AttrLabelProxy "connection"
dBusObjectManagerServerConnection = AttrLabelProxy

dBusObjectManagerServerObjectPath :: AttrLabelProxy "objectPath"
dBusObjectManagerServerObjectPath = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DBusObjectManagerServer = DBusObjectManagerServerSignalList
type DBusObjectManagerServerSignalList = ('[ '("interfaceAdded", Gio.DBusObjectManager.DBusObjectManagerInterfaceAddedSignalInfo), '("interfaceRemoved", Gio.DBusObjectManager.DBusObjectManagerInterfaceRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("objectAdded", Gio.DBusObjectManager.DBusObjectManagerObjectAddedSignalInfo), '("objectRemoved", Gio.DBusObjectManager.DBusObjectManagerObjectRemovedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DBusObjectManagerServer::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The object path to export the manager object at."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DBusObjectManagerServer" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_manager_server_new" g_dbus_object_manager_server_new :: 
    CString ->                              -- object_path : TBasicType TUTF8
    IO (Ptr DBusObjectManagerServer)

-- | Creates a new t'GI.Gio.Objects.DBusObjectManagerServer.DBusObjectManagerServer' object.
-- 
-- The returned server isn\'t yet exported on any connection. To do so,
-- use 'GI.Gio.Objects.DBusObjectManagerServer.dBusObjectManagerServerSetConnection'. Normally you
-- want to export all of your objects before doing so to avoid
-- <http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager InterfacesAdded>
-- signals being emitted.
-- 
-- /Since: 2.30/
dBusObjectManagerServerNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@objectPath@/: The object path to export the manager object at.
    -> m DBusObjectManagerServer
    -- ^ __Returns:__ A t'GI.Gio.Objects.DBusObjectManagerServer.DBusObjectManagerServer' object. Free with 'GI.GObject.Objects.Object.objectUnref'.
dBusObjectManagerServerNew objectPath = liftIO $ do
    objectPath' <- textToCString objectPath
    result <- g_dbus_object_manager_server_new objectPath'
    checkUnexpectedReturnNULL "dBusObjectManagerServerNew" result
    result' <- (wrapObject DBusObjectManagerServer) result
    freeMem objectPath'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method DBusObjectManagerServer::export
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusObjectManagerServer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectManagerServer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectSkeleton."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_manager_server_export" g_dbus_object_manager_server_export :: 
    Ptr DBusObjectManagerServer ->          -- manager : TInterface (Name {namespace = "Gio", name = "DBusObjectManagerServer"})
    Ptr Gio.DBusObjectSkeleton.DBusObjectSkeleton -> -- object : TInterface (Name {namespace = "Gio", name = "DBusObjectSkeleton"})
    IO ()

-- | Exports /@object@/ on /@manager@/.
-- 
-- If there is already a t'GI.Gio.Interfaces.DBusObject.DBusObject' exported at the object path,
-- then the old object is removed.
-- 
-- The object path for /@object@/ must be in the hierarchy rooted by the
-- object path for /@manager@/.
-- 
-- Note that /@manager@/ will take a reference on /@object@/ for as long as
-- it is exported.
-- 
-- /Since: 2.30/
dBusObjectManagerServerExport ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectManagerServer a, Gio.DBusObjectSkeleton.IsDBusObjectSkeleton b) =>
    a
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerServer.DBusObjectManagerServer'.
    -> b
    -- ^ /@object@/: A t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton'.
    -> m ()
dBusObjectManagerServerExport manager object = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    object' <- unsafeManagedPtrCastPtr object
    g_dbus_object_manager_server_export manager' object'
    touchManagedPtr manager
    touchManagedPtr object
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusObjectManagerServerExportMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDBusObjectManagerServer a, Gio.DBusObjectSkeleton.IsDBusObjectSkeleton b) => O.OverloadedMethod DBusObjectManagerServerExportMethodInfo a signature where
    overloadedMethod = dBusObjectManagerServerExport

instance O.OverloadedMethodInfo DBusObjectManagerServerExportMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectManagerServer.dBusObjectManagerServerExport",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectManagerServer.html#v:dBusObjectManagerServerExport"
        })


#endif

-- method DBusObjectManagerServer::export_uniquely
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusObjectManagerServer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectManagerServer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An object." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_manager_server_export_uniquely" g_dbus_object_manager_server_export_uniquely :: 
    Ptr DBusObjectManagerServer ->          -- manager : TInterface (Name {namespace = "Gio", name = "DBusObjectManagerServer"})
    Ptr Gio.DBusObjectSkeleton.DBusObjectSkeleton -> -- object : TInterface (Name {namespace = "Gio", name = "DBusObjectSkeleton"})
    IO ()

-- | Like 'GI.Gio.Objects.DBusObjectManagerServer.dBusObjectManagerServerExport' but appends a string of
-- the form _N (with N being a natural number) to /@object@/\'s object path
-- if an object with the given path already exists. As such, the
-- [DBusObjectProxy:gObjectPath]("GI.Gio.Objects.DBusObjectProxy#g:attr:gObjectPath") property of /@object@/ may be modified.
-- 
-- /Since: 2.30/
dBusObjectManagerServerExportUniquely ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectManagerServer a, Gio.DBusObjectSkeleton.IsDBusObjectSkeleton b) =>
    a
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerServer.DBusObjectManagerServer'.
    -> b
    -- ^ /@object@/: An object.
    -> m ()
dBusObjectManagerServerExportUniquely manager object = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    object' <- unsafeManagedPtrCastPtr object
    g_dbus_object_manager_server_export_uniquely manager' object'
    touchManagedPtr manager
    touchManagedPtr object
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusObjectManagerServerExportUniquelyMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDBusObjectManagerServer a, Gio.DBusObjectSkeleton.IsDBusObjectSkeleton b) => O.OverloadedMethod DBusObjectManagerServerExportUniquelyMethodInfo a signature where
    overloadedMethod = dBusObjectManagerServerExportUniquely

instance O.OverloadedMethodInfo DBusObjectManagerServerExportUniquelyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectManagerServer.dBusObjectManagerServerExportUniquely",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectManagerServer.html#v:dBusObjectManagerServerExportUniquely"
        })


#endif

-- method DBusObjectManagerServer::get_connection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusObjectManagerServer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectManagerServer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusConnection" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_manager_server_get_connection" g_dbus_object_manager_server_get_connection :: 
    Ptr DBusObjectManagerServer ->          -- manager : TInterface (Name {namespace = "Gio", name = "DBusObjectManagerServer"})
    IO (Ptr Gio.DBusConnection.DBusConnection)

-- | Gets the t'GI.Gio.Objects.DBusConnection.DBusConnection' used by /@manager@/.
-- 
-- /Since: 2.30/
dBusObjectManagerServerGetConnection ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectManagerServer a) =>
    a
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerServer.DBusObjectManagerServer'
    -> m (Maybe Gio.DBusConnection.DBusConnection)
    -- ^ __Returns:__ A t'GI.Gio.Objects.DBusConnection.DBusConnection' object or 'P.Nothing' if
    --   /@manager@/ isn\'t exported on a connection. The returned object should
    --   be freed with 'GI.GObject.Objects.Object.objectUnref'.
dBusObjectManagerServerGetConnection manager = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    result <- g_dbus_object_manager_server_get_connection manager'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.DBusConnection.DBusConnection) result'
        return result''
    touchManagedPtr manager
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DBusObjectManagerServerGetConnectionMethodInfo
instance (signature ~ (m (Maybe Gio.DBusConnection.DBusConnection)), MonadIO m, IsDBusObjectManagerServer a) => O.OverloadedMethod DBusObjectManagerServerGetConnectionMethodInfo a signature where
    overloadedMethod = dBusObjectManagerServerGetConnection

instance O.OverloadedMethodInfo DBusObjectManagerServerGetConnectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectManagerServer.dBusObjectManagerServerGetConnection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectManagerServer.html#v:dBusObjectManagerServerGetConnection"
        })


#endif

-- method DBusObjectManagerServer::is_exported
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusObjectManagerServer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectManagerServer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An object." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_manager_server_is_exported" g_dbus_object_manager_server_is_exported :: 
    Ptr DBusObjectManagerServer ->          -- manager : TInterface (Name {namespace = "Gio", name = "DBusObjectManagerServer"})
    Ptr Gio.DBusObjectSkeleton.DBusObjectSkeleton -> -- object : TInterface (Name {namespace = "Gio", name = "DBusObjectSkeleton"})
    IO CInt

-- | Returns whether /@object@/ is currently exported on /@manager@/.
-- 
-- /Since: 2.34/
dBusObjectManagerServerIsExported ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectManagerServer a, Gio.DBusObjectSkeleton.IsDBusObjectSkeleton b) =>
    a
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerServer.DBusObjectManagerServer'.
    -> b
    -- ^ /@object@/: An object.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@object@/ is exported
dBusObjectManagerServerIsExported manager object = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    object' <- unsafeManagedPtrCastPtr object
    result <- g_dbus_object_manager_server_is_exported manager' object'
    let result' = (/= 0) result
    touchManagedPtr manager
    touchManagedPtr object
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusObjectManagerServerIsExportedMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsDBusObjectManagerServer a, Gio.DBusObjectSkeleton.IsDBusObjectSkeleton b) => O.OverloadedMethod DBusObjectManagerServerIsExportedMethodInfo a signature where
    overloadedMethod = dBusObjectManagerServerIsExported

instance O.OverloadedMethodInfo DBusObjectManagerServerIsExportedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectManagerServer.dBusObjectManagerServerIsExported",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectManagerServer.html#v:dBusObjectManagerServerIsExported"
        })


#endif

-- method DBusObjectManagerServer::set_connection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusObjectManagerServer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectManagerServer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_manager_server_set_connection" g_dbus_object_manager_server_set_connection :: 
    Ptr DBusObjectManagerServer ->          -- manager : TInterface (Name {namespace = "Gio", name = "DBusObjectManagerServer"})
    Ptr Gio.DBusConnection.DBusConnection -> -- connection : TInterface (Name {namespace = "Gio", name = "DBusConnection"})
    IO ()

-- | Exports all objects managed by /@manager@/ on /@connection@/. If
-- /@connection@/ is 'P.Nothing', stops exporting objects.
dBusObjectManagerServerSetConnection ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectManagerServer a, Gio.DBusConnection.IsDBusConnection b) =>
    a
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerServer.DBusObjectManagerServer'.
    -> Maybe (b)
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection' or 'P.Nothing'.
    -> m ()
dBusObjectManagerServerSetConnection manager connection = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    maybeConnection <- case connection of
        Nothing -> return FP.nullPtr
        Just jConnection -> do
            jConnection' <- unsafeManagedPtrCastPtr jConnection
            return jConnection'
    g_dbus_object_manager_server_set_connection manager' maybeConnection
    touchManagedPtr manager
    whenJust connection touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusObjectManagerServerSetConnectionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsDBusObjectManagerServer a, Gio.DBusConnection.IsDBusConnection b) => O.OverloadedMethod DBusObjectManagerServerSetConnectionMethodInfo a signature where
    overloadedMethod = dBusObjectManagerServerSetConnection

instance O.OverloadedMethodInfo DBusObjectManagerServerSetConnectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectManagerServer.dBusObjectManagerServerSetConnection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectManagerServer.html#v:dBusObjectManagerServerSetConnection"
        })


#endif

-- method DBusObjectManagerServer::unexport
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusObjectManagerServer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectManagerServer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An object path." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_manager_server_unexport" g_dbus_object_manager_server_unexport :: 
    Ptr DBusObjectManagerServer ->          -- manager : TInterface (Name {namespace = "Gio", name = "DBusObjectManagerServer"})
    CString ->                              -- object_path : TBasicType TUTF8
    IO CInt

-- | If /@manager@/ has an object at /@path@/, removes the object. Otherwise
-- does nothing.
-- 
-- Note that /@objectPath@/ must be in the hierarchy rooted by the
-- object path for /@manager@/.
-- 
-- /Since: 2.30/
dBusObjectManagerServerUnexport ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectManagerServer a) =>
    a
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerServer.DBusObjectManagerServer'.
    -> T.Text
    -- ^ /@objectPath@/: An object path.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if object at /@objectPath@/ was removed, 'P.False' otherwise.
dBusObjectManagerServerUnexport manager objectPath = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    objectPath' <- textToCString objectPath
    result <- g_dbus_object_manager_server_unexport manager' objectPath'
    let result' = (/= 0) result
    touchManagedPtr manager
    freeMem objectPath'
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusObjectManagerServerUnexportMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsDBusObjectManagerServer a) => O.OverloadedMethod DBusObjectManagerServerUnexportMethodInfo a signature where
    overloadedMethod = dBusObjectManagerServerUnexport

instance O.OverloadedMethodInfo DBusObjectManagerServerUnexportMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectManagerServer.dBusObjectManagerServerUnexport",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectManagerServer.html#v:dBusObjectManagerServerUnexport"
        })


#endif


