{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoGlyphItem@ is a pair of a @PangoItem@ and the glyphs
-- resulting from shaping the items text.
-- 
-- As an example of the usage of @PangoGlyphItem@, the results
-- of shaping text with @PangoLayout@ is a list of @PangoLayoutLine@,
-- each of which contains a list of @PangoGlyphItem@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.GlyphItem
    ( 

-- * Exported types
    GlyphItem(..)                           ,
    newZeroGlyphItem                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [applyAttrs]("GI.Pango.Structs.GlyphItem#g:method:applyAttrs"), [copy]("GI.Pango.Structs.GlyphItem#g:method:copy"), [free]("GI.Pango.Structs.GlyphItem#g:method:free"), [letterSpace]("GI.Pango.Structs.GlyphItem#g:method:letterSpace"), [split]("GI.Pango.Structs.GlyphItem#g:method:split").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveGlyphItemMethod                  ,
#endif

-- ** applyAttrs #method:applyAttrs#

#if defined(ENABLE_OVERLOADING)
    GlyphItemApplyAttrsMethodInfo           ,
#endif
    glyphItemApplyAttrs                     ,


-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    GlyphItemCopyMethodInfo                 ,
#endif
    glyphItemCopy                           ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    GlyphItemFreeMethodInfo                 ,
#endif
    glyphItemFree                           ,


-- ** letterSpace #method:letterSpace#

#if defined(ENABLE_OVERLOADING)
    GlyphItemLetterSpaceMethodInfo          ,
#endif
    glyphItemLetterSpace                    ,


-- ** split #method:split#

#if defined(ENABLE_OVERLOADING)
    GlyphItemSplitMethodInfo                ,
#endif
    glyphItemSplit                          ,




 -- * Properties


-- ** endXOffset #attr:endXOffset#
-- | horizontal displacement to apply after th
--   glyph item. Positive values shift right

    getGlyphItemEndXOffset                  ,
#if defined(ENABLE_OVERLOADING)
    glyphItem_endXOffset                    ,
#endif
    setGlyphItemEndXOffset                  ,


-- ** glyphs #attr:glyphs#
-- | corresponding @PangoGlyphString@

    clearGlyphItemGlyphs                    ,
    getGlyphItemGlyphs                      ,
#if defined(ENABLE_OVERLOADING)
    glyphItem_glyphs                        ,
#endif
    setGlyphItemGlyphs                      ,


-- ** item #attr:item#
-- | corresponding @PangoItem@

    clearGlyphItemItem                      ,
    getGlyphItemItem                        ,
#if defined(ENABLE_OVERLOADING)
    glyphItem_item                          ,
#endif
    setGlyphItemItem                        ,


-- ** startXOffset #attr:startXOffset#
-- | horizontal displacement to apply before the
--   glyph item. Positive values shift right

    getGlyphItemStartXOffset                ,
#if defined(ENABLE_OVERLOADING)
    glyphItem_startXOffset                  ,
#endif
    setGlyphItemStartXOffset                ,


-- ** yOffset #attr:yOffset#
-- | shift of the baseline, relative to the baseline
--   of the containing line. Positive values shift upwards

    getGlyphItemYOffset                     ,
#if defined(ENABLE_OVERLOADING)
    glyphItem_yOffset                       ,
#endif
    setGlyphItemYOffset                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.Analysis as Pango.Analysis
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrIterator as Pango.AttrIterator
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrList as Pango.AttrList
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphString as Pango.GlyphString
import {-# SOURCE #-} qualified GI.Pango.Structs.Item as Pango.Item
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.LogAttr as Pango.LogAttr
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrList as Pango.AttrList
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphString as Pango.GlyphString
import {-# SOURCE #-} qualified GI.Pango.Structs.Item as Pango.Item
import {-# SOURCE #-} qualified GI.Pango.Structs.LogAttr as Pango.LogAttr

#endif

-- | Memory-managed wrapper type.
newtype GlyphItem = GlyphItem (SP.ManagedPtr GlyphItem)
    deriving (Eq)

instance SP.ManagedPtrNewtype GlyphItem where
    toManagedPtr (GlyphItem p) = p

foreign import ccall "pango_glyph_item_get_type" c_pango_glyph_item_get_type :: 
    IO GType

type instance O.ParentTypes GlyphItem = '[]
instance O.HasParentTypes GlyphItem

instance B.Types.TypedObject GlyphItem where
    glibType = c_pango_glyph_item_get_type

instance B.Types.GBoxed GlyphItem

-- | Convert t'GlyphItem' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GlyphItem) where
    gvalueGType_ = c_pango_glyph_item_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr GlyphItem)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr GlyphItem)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed GlyphItem ptr
        else return P.Nothing
        
    

-- | Construct a t'GlyphItem' struct initialized to zero.
newZeroGlyphItem :: MonadIO m => m GlyphItem
newZeroGlyphItem = liftIO $ callocBoxedBytes 32 >>= wrapBoxed GlyphItem

instance tag ~ 'AttrSet => Constructible GlyphItem tag where
    new _ attrs = do
        o <- newZeroGlyphItem
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@item@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphItem #item
-- @
getGlyphItemItem :: MonadIO m => GlyphItem -> m (Maybe Pango.Item.Item)
getGlyphItemItem s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr Pango.Item.Item)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newBoxed Pango.Item.Item) val'
        return val''
    return result

-- | Set the value of the “@item@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphItem [ #item 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphItemItem :: MonadIO m => GlyphItem -> Ptr Pango.Item.Item -> m ()
setGlyphItemItem s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr Pango.Item.Item)

-- | Set the value of the “@item@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #item
-- @
clearGlyphItemItem :: MonadIO m => GlyphItem -> m ()
clearGlyphItemItem s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr Pango.Item.Item)

#if defined(ENABLE_OVERLOADING)
data GlyphItemItemFieldInfo
instance AttrInfo GlyphItemItemFieldInfo where
    type AttrBaseTypeConstraint GlyphItemItemFieldInfo = (~) GlyphItem
    type AttrAllowedOps GlyphItemItemFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint GlyphItemItemFieldInfo = (~) (Ptr Pango.Item.Item)
    type AttrTransferTypeConstraint GlyphItemItemFieldInfo = (~)(Ptr Pango.Item.Item)
    type AttrTransferType GlyphItemItemFieldInfo = (Ptr Pango.Item.Item)
    type AttrGetType GlyphItemItemFieldInfo = Maybe Pango.Item.Item
    type AttrLabel GlyphItemItemFieldInfo = "item"
    type AttrOrigin GlyphItemItemFieldInfo = GlyphItem
    attrGet = getGlyphItemItem
    attrSet = setGlyphItemItem
    attrConstruct = undefined
    attrClear = clearGlyphItemItem
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.item"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#g:attr:item"
        })

glyphItem_item :: AttrLabelProxy "item"
glyphItem_item = AttrLabelProxy

#endif


-- | Get the value of the “@glyphs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphItem #glyphs
-- @
getGlyphItemGlyphs :: MonadIO m => GlyphItem -> m (Maybe Pango.GlyphString.GlyphString)
getGlyphItemGlyphs s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Pango.GlyphString.GlyphString)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newBoxed Pango.GlyphString.GlyphString) val'
        return val''
    return result

-- | Set the value of the “@glyphs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphItem [ #glyphs 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphItemGlyphs :: MonadIO m => GlyphItem -> Ptr Pango.GlyphString.GlyphString -> m ()
setGlyphItemGlyphs s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Pango.GlyphString.GlyphString)

-- | Set the value of the “@glyphs@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #glyphs
-- @
clearGlyphItemGlyphs :: MonadIO m => GlyphItem -> m ()
clearGlyphItemGlyphs s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Pango.GlyphString.GlyphString)

#if defined(ENABLE_OVERLOADING)
data GlyphItemGlyphsFieldInfo
instance AttrInfo GlyphItemGlyphsFieldInfo where
    type AttrBaseTypeConstraint GlyphItemGlyphsFieldInfo = (~) GlyphItem
    type AttrAllowedOps GlyphItemGlyphsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint GlyphItemGlyphsFieldInfo = (~) (Ptr Pango.GlyphString.GlyphString)
    type AttrTransferTypeConstraint GlyphItemGlyphsFieldInfo = (~)(Ptr Pango.GlyphString.GlyphString)
    type AttrTransferType GlyphItemGlyphsFieldInfo = (Ptr Pango.GlyphString.GlyphString)
    type AttrGetType GlyphItemGlyphsFieldInfo = Maybe Pango.GlyphString.GlyphString
    type AttrLabel GlyphItemGlyphsFieldInfo = "glyphs"
    type AttrOrigin GlyphItemGlyphsFieldInfo = GlyphItem
    attrGet = getGlyphItemGlyphs
    attrSet = setGlyphItemGlyphs
    attrConstruct = undefined
    attrClear = clearGlyphItemGlyphs
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.glyphs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#g:attr:glyphs"
        })

glyphItem_glyphs :: AttrLabelProxy "glyphs"
glyphItem_glyphs = AttrLabelProxy

#endif


-- | Get the value of the “@y_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphItem #yOffset
-- @
getGlyphItemYOffset :: MonadIO m => GlyphItem -> m Int32
getGlyphItemYOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int32
    return val

-- | Set the value of the “@y_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphItem [ #yOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphItemYOffset :: MonadIO m => GlyphItem -> Int32 -> m ()
setGlyphItemYOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphItemYOffsetFieldInfo
instance AttrInfo GlyphItemYOffsetFieldInfo where
    type AttrBaseTypeConstraint GlyphItemYOffsetFieldInfo = (~) GlyphItem
    type AttrAllowedOps GlyphItemYOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphItemYOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphItemYOffsetFieldInfo = (~)Int32
    type AttrTransferType GlyphItemYOffsetFieldInfo = Int32
    type AttrGetType GlyphItemYOffsetFieldInfo = Int32
    type AttrLabel GlyphItemYOffsetFieldInfo = "y_offset"
    type AttrOrigin GlyphItemYOffsetFieldInfo = GlyphItem
    attrGet = getGlyphItemYOffset
    attrSet = setGlyphItemYOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.yOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#g:attr:yOffset"
        })

glyphItem_yOffset :: AttrLabelProxy "yOffset"
glyphItem_yOffset = AttrLabelProxy

#endif


-- | Get the value of the “@start_x_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphItem #startXOffset
-- @
getGlyphItemStartXOffset :: MonadIO m => GlyphItem -> m Int32
getGlyphItemStartXOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Int32
    return val

-- | Set the value of the “@start_x_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphItem [ #startXOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphItemStartXOffset :: MonadIO m => GlyphItem -> Int32 -> m ()
setGlyphItemStartXOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphItemStartXOffsetFieldInfo
instance AttrInfo GlyphItemStartXOffsetFieldInfo where
    type AttrBaseTypeConstraint GlyphItemStartXOffsetFieldInfo = (~) GlyphItem
    type AttrAllowedOps GlyphItemStartXOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphItemStartXOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphItemStartXOffsetFieldInfo = (~)Int32
    type AttrTransferType GlyphItemStartXOffsetFieldInfo = Int32
    type AttrGetType GlyphItemStartXOffsetFieldInfo = Int32
    type AttrLabel GlyphItemStartXOffsetFieldInfo = "start_x_offset"
    type AttrOrigin GlyphItemStartXOffsetFieldInfo = GlyphItem
    attrGet = getGlyphItemStartXOffset
    attrSet = setGlyphItemStartXOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.startXOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#g:attr:startXOffset"
        })

glyphItem_startXOffset :: AttrLabelProxy "startXOffset"
glyphItem_startXOffset = AttrLabelProxy

#endif


-- | Get the value of the “@end_x_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphItem #endXOffset
-- @
getGlyphItemEndXOffset :: MonadIO m => GlyphItem -> m Int32
getGlyphItemEndXOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Int32
    return val

-- | Set the value of the “@end_x_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphItem [ #endXOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphItemEndXOffset :: MonadIO m => GlyphItem -> Int32 -> m ()
setGlyphItemEndXOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphItemEndXOffsetFieldInfo
instance AttrInfo GlyphItemEndXOffsetFieldInfo where
    type AttrBaseTypeConstraint GlyphItemEndXOffsetFieldInfo = (~) GlyphItem
    type AttrAllowedOps GlyphItemEndXOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphItemEndXOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphItemEndXOffsetFieldInfo = (~)Int32
    type AttrTransferType GlyphItemEndXOffsetFieldInfo = Int32
    type AttrGetType GlyphItemEndXOffsetFieldInfo = Int32
    type AttrLabel GlyphItemEndXOffsetFieldInfo = "end_x_offset"
    type AttrOrigin GlyphItemEndXOffsetFieldInfo = GlyphItem
    attrGet = getGlyphItemEndXOffset
    attrSet = setGlyphItemEndXOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.endXOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#g:attr:endXOffset"
        })

glyphItem_endXOffset :: AttrLabelProxy "endXOffset"
glyphItem_endXOffset = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GlyphItem
type instance O.AttributeList GlyphItem = GlyphItemAttributeList
type GlyphItemAttributeList = ('[ '("item", GlyphItemItemFieldInfo), '("glyphs", GlyphItemGlyphsFieldInfo), '("yOffset", GlyphItemYOffsetFieldInfo), '("startXOffset", GlyphItemStartXOffsetFieldInfo), '("endXOffset", GlyphItemEndXOffsetFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method GlyphItem::apply_attrs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyph_item"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a shaped item" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text that @list applies to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrList`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGSList
--                  (TInterface Name { namespace = "Pango" , name = "GlyphItem" }))
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_item_apply_attrs" pango_glyph_item_apply_attrs :: 
    Ptr GlyphItem ->                        -- glyph_item : TInterface (Name {namespace = "Pango", name = "GlyphItem"})
    CString ->                              -- text : TBasicType TUTF8
    Ptr Pango.AttrList.AttrList ->          -- list : TInterface (Name {namespace = "Pango", name = "AttrList"})
    IO (Ptr (GSList (Ptr GlyphItem)))

-- | Splits a shaped item (@PangoGlyphItem@) into multiple items based
-- on an attribute list.
-- 
-- The idea is that if you have attributes that don\'t affect shaping,
-- such as color or underline, to avoid affecting shaping, you filter
-- them out ('GI.Pango.Structs.AttrList.attrListFilter'), apply the shaping process
-- and then reapply them to the result using this function.
-- 
-- All attributes that start or end inside a cluster are applied
-- to that cluster; for instance, if half of a cluster is underlined
-- and the other-half strikethrough, then the cluster will end
-- up with both underline and strikethrough attributes. In these
-- cases, it may happen that /@item@/->extra_attrs for some of the
-- result items can have multiple attributes of the same type.
-- 
-- This function takes ownership of /@glyphItem@/; it will be reused
-- as one of the elements in the list.
-- 
-- /Since: 1.2/
glyphItemApplyAttrs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GlyphItem
    -- ^ /@glyphItem@/: a shaped item
    -> T.Text
    -- ^ /@text@/: text that /@list@/ applies to
    -> Pango.AttrList.AttrList
    -- ^ /@list@/: a @PangoAttrList@
    -> m [GlyphItem]
    -- ^ __Returns:__ a
    --   list of glyph items resulting from splitting /@glyphItem@/. Free
    --   the elements using 'GI.Pango.Structs.GlyphItem.glyphItemFree', the list using
    --   @/g_slist_free()/@.
glyphItemApplyAttrs glyphItem text list = liftIO $ do
    glyphItem' <- B.ManagedPtr.disownBoxed glyphItem
    text' <- textToCString text
    list' <- unsafeManagedPtrGetPtr list
    result <- pango_glyph_item_apply_attrs glyphItem' text' list'
    result' <- unpackGSList result
    result'' <- mapM (wrapBoxed GlyphItem) result'
    g_slist_free result
    touchManagedPtr glyphItem
    touchManagedPtr list
    freeMem text'
    return result''

#if defined(ENABLE_OVERLOADING)
data GlyphItemApplyAttrsMethodInfo
instance (signature ~ (T.Text -> Pango.AttrList.AttrList -> m [GlyphItem]), MonadIO m) => O.OverloadedMethod GlyphItemApplyAttrsMethodInfo GlyphItem signature where
    overloadedMethod = glyphItemApplyAttrs

instance O.OverloadedMethodInfo GlyphItemApplyAttrsMethodInfo GlyphItem where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.glyphItemApplyAttrs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#v:glyphItemApplyAttrs"
        })


#endif

-- method GlyphItem::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "orig"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphItem" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphItem`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "GlyphItem" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_item_copy" pango_glyph_item_copy :: 
    Ptr GlyphItem ->                        -- orig : TInterface (Name {namespace = "Pango", name = "GlyphItem"})
    IO (Ptr GlyphItem)

-- | Make a deep copy of an existing @PangoGlyphItem@ structure.
-- 
-- /Since: 1.20/
glyphItemCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (GlyphItem)
    -- ^ /@orig@/: a @PangoGlyphItem@
    -> m (Maybe GlyphItem)
    -- ^ __Returns:__ the newly allocated @PangoGlyphItem@
glyphItemCopy orig = liftIO $ do
    maybeOrig <- case orig of
        Nothing -> return FP.nullPtr
        Just jOrig -> do
            jOrig' <- unsafeManagedPtrGetPtr jOrig
            return jOrig'
    result <- pango_glyph_item_copy maybeOrig
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed GlyphItem) result'
        return result''
    whenJust orig touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GlyphItemCopyMethodInfo
instance (signature ~ (m (Maybe GlyphItem)), MonadIO m) => O.OverloadedMethod GlyphItemCopyMethodInfo GlyphItem signature where
    overloadedMethod i = glyphItemCopy (Just i)

instance O.OverloadedMethodInfo GlyphItemCopyMethodInfo GlyphItem where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.glyphItemCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#v:glyphItemCopy"
        })


#endif

-- method GlyphItem::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyph_item"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphItem" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphItem`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_item_free" pango_glyph_item_free :: 
    Ptr GlyphItem ->                        -- glyph_item : TInterface (Name {namespace = "Pango", name = "GlyphItem"})
    IO ()

-- | Frees a @PangoGlyphItem@ and resources to which it points.
-- 
-- /Since: 1.6/
glyphItemFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (GlyphItem)
    -- ^ /@glyphItem@/: a @PangoGlyphItem@
    -> m ()
glyphItemFree glyphItem = liftIO $ do
    maybeGlyphItem <- case glyphItem of
        Nothing -> return FP.nullPtr
        Just jGlyphItem -> do
            jGlyphItem' <- unsafeManagedPtrGetPtr jGlyphItem
            return jGlyphItem'
    pango_glyph_item_free maybeGlyphItem
    whenJust glyphItem touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GlyphItemFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod GlyphItemFreeMethodInfo GlyphItem signature where
    overloadedMethod i = glyphItemFree (Just i)

instance O.OverloadedMethodInfo GlyphItemFreeMethodInfo GlyphItem where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.glyphItemFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#v:glyphItemFree"
        })


#endif

-- XXX Could not generate method GlyphItem::get_logical_widths
-- Not implemented: Don't know how to allocate "logical_widths" of type TCArray False (-1) (-1) (TBasicType TInt)
-- method GlyphItem::letter_space
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyph_item"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphItem`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "text that @glyph_item corresponds to\n  (glyph_item->item->offset is an offset from the\n  start of @text)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_attrs"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 (-1)
--                 (TInterface Name { namespace = "Pango" , name = "LogAttr" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "logical attributes for the item\n  (the first logical attribute refers to the position\n  before the first character in the item)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "letter_spacing"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "amount of letter spacing to add\n  in Pango units. May be negative, though too large\n  negative values will give ugly results."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_item_letter_space" pango_glyph_item_letter_space :: 
    Ptr GlyphItem ->                        -- glyph_item : TInterface (Name {namespace = "Pango", name = "GlyphItem"})
    CString ->                              -- text : TBasicType TUTF8
    Ptr Pango.LogAttr.LogAttr ->            -- log_attrs : TCArray False (-1) (-1) (TInterface (Name {namespace = "Pango", name = "LogAttr"}))
    Int32 ->                                -- letter_spacing : TBasicType TInt
    IO ()

-- | Adds spacing between the graphemes of /@glyphItem@/ to
-- give the effect of typographic letter spacing.
-- 
-- /Since: 1.6/
glyphItemLetterSpace ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GlyphItem
    -- ^ /@glyphItem@/: a @PangoGlyphItem@
    -> T.Text
    -- ^ /@text@/: text that /@glyphItem@/ corresponds to
    --   (glyph_item->item->offset is an offset from the
    --   start of /@text@/)
    -> [Pango.LogAttr.LogAttr]
    -- ^ /@logAttrs@/: logical attributes for the item
    --   (the first logical attribute refers to the position
    --   before the first character in the item)
    -> Int32
    -- ^ /@letterSpacing@/: amount of letter spacing to add
    --   in Pango units. May be negative, though too large
    --   negative values will give ugly results.
    -> m ()
glyphItemLetterSpace glyphItem text logAttrs letterSpacing = liftIO $ do
    glyphItem' <- unsafeManagedPtrGetPtr glyphItem
    text' <- textToCString text
    logAttrs' <- mapM unsafeManagedPtrGetPtr logAttrs
    logAttrs'' <- packBlockArray 64 logAttrs'
    pango_glyph_item_letter_space glyphItem' text' logAttrs'' letterSpacing
    touchManagedPtr glyphItem
    mapM_ touchManagedPtr logAttrs
    freeMem text'
    freeMem logAttrs''
    return ()

#if defined(ENABLE_OVERLOADING)
data GlyphItemLetterSpaceMethodInfo
instance (signature ~ (T.Text -> [Pango.LogAttr.LogAttr] -> Int32 -> m ()), MonadIO m) => O.OverloadedMethod GlyphItemLetterSpaceMethodInfo GlyphItem signature where
    overloadedMethod = glyphItemLetterSpace

instance O.OverloadedMethodInfo GlyphItemLetterSpaceMethodInfo GlyphItem where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.glyphItemLetterSpace",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#v:glyphItemLetterSpace"
        })


#endif

-- method GlyphItem::split
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "orig"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoItem`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text to which positions in @orig apply"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "split_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "byte index of position to split item, relative to the\n  start of the item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "GlyphItem" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_item_split" pango_glyph_item_split :: 
    Ptr GlyphItem ->                        -- orig : TInterface (Name {namespace = "Pango", name = "GlyphItem"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- split_index : TBasicType TInt
    IO (Ptr GlyphItem)

-- | Modifies /@orig@/ to cover only the text after /@splitIndex@/, and
-- returns a new item that covers the text before /@splitIndex@/ that
-- used to be in /@orig@/.
-- 
-- You can think of /@splitIndex@/ as the length of the returned item.
-- /@splitIndex@/ may not be 0, and it may not be greater than or equal
-- to the length of /@orig@/ (that is, there must be at least one byte
-- assigned to each item, you can\'t create a zero-length item).
-- 
-- This function is similar in function to 'GI.Pango.Structs.Item.itemSplit' (and uses
-- it internally.)
-- 
-- /Since: 1.2/
glyphItemSplit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GlyphItem
    -- ^ /@orig@/: a @PangoItem@
    -> T.Text
    -- ^ /@text@/: text to which positions in /@orig@/ apply
    -> Int32
    -- ^ /@splitIndex@/: byte index of position to split item, relative to the
    --   start of the item
    -> m (Maybe GlyphItem)
    -- ^ __Returns:__ the newly allocated item
    --   representing text before /@splitIndex@/, which should be freed
    --   with 'GI.Pango.Structs.GlyphItem.glyphItemFree'.
glyphItemSplit orig text splitIndex = liftIO $ do
    orig' <- unsafeManagedPtrGetPtr orig
    text' <- textToCString text
    result <- pango_glyph_item_split orig' text' splitIndex
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed GlyphItem) result'
        return result''
    touchManagedPtr orig
    freeMem text'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GlyphItemSplitMethodInfo
instance (signature ~ (T.Text -> Int32 -> m (Maybe GlyphItem)), MonadIO m) => O.OverloadedMethod GlyphItemSplitMethodInfo GlyphItem signature where
    overloadedMethod = glyphItemSplit

instance O.OverloadedMethodInfo GlyphItemSplitMethodInfo GlyphItem where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphItem.glyphItemSplit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphItem.html#v:glyphItemSplit"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGlyphItemMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGlyphItemMethod "applyAttrs" o = GlyphItemApplyAttrsMethodInfo
    ResolveGlyphItemMethod "copy" o = GlyphItemCopyMethodInfo
    ResolveGlyphItemMethod "free" o = GlyphItemFreeMethodInfo
    ResolveGlyphItemMethod "letterSpace" o = GlyphItemLetterSpaceMethodInfo
    ResolveGlyphItemMethod "split" o = GlyphItemSplitMethodInfo
    ResolveGlyphItemMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGlyphItemMethod t GlyphItem, O.OverloadedMethod info GlyphItem p) => OL.IsLabel t (GlyphItem -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGlyphItemMethod t GlyphItem, O.OverloadedMethod info GlyphItem p, R.HasField t GlyphItem p) => R.HasField t GlyphItem p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGlyphItemMethod t GlyphItem, O.OverloadedMethodInfo info GlyphItem) => OL.IsLabel t (O.MethodProxy info GlyphItem) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


