
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kprocesslist_wrapper.h"

// inner classes
#include "kprocesslist_kprocessinfo_wrapper.h"

// Argument includes
#include <QList>
#include <kprocesslist.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KProcessList_Type = nullptr;
static PyTypeObject *Sbk_KProcessList_TypeF(void)
{
    return _Sbk_KProcessList_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KProcessList_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KProcessList");
    return -1;
}

static PyObject *Sbk_KProcessListFunc_processInfo(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KProcessList::processInfo(qint64)->KProcessList::KProcessInfo
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // processInfo(qint64)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "processInfo", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKProcessList_IDX]);

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processInfo(qint64)
            KProcessList::KProcessInfo cppResult = ::KProcessList::processInfo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessListFunc_processInfoList(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // processInfoList()
        QList<KProcessList::KProcessInfo> cppResult = ::KProcessList::processInfoList();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KProcessList_KProcessInfo_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KProcessList_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KProcessList_methods[] = {
    {"processInfo", reinterpret_cast<PyCFunction>(Sbk_KProcessListFunc_processInfo), METH_O|METH_STATIC, nullptr},
    {"processInfoList", reinterpret_cast<PyCFunction>(Sbk_KProcessListFunc_processInfoList), METH_NOARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KProcessList_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KProcessList_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KProcessList_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KProcessList_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KProcessList_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KProcessList_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KProcessList_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KProcessList_spec = {
    "1:KCoreAddons.KProcessList",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KProcessList_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKProcessList_SignatureStrings[] = {
    "KCoreAddons.KProcessList.processInfo(pid:qint64)->KCoreAddons.KProcessList.KProcessInfo",
    "KCoreAddons.KProcessList.processInfoList()->QList[KCoreAddons.KProcessList.KProcessInfo]",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKProcessList_SignatureByteSize = 78;
static constexpr uint8_t KCoreAddonsKProcessList_SignatureBytes[78] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x0e,
    0x28, 0xca, 0x4f, 0x4e, 0x2d, 0x2e, 0xf6, 0xc9, 0x2c, 0x2e, 0xd1, 0x2b, 0x80, 0xb0, 0x3d, 0xf3,
    0xd2, 0xf2, 0x35, 0x0a, 0x32, 0x53, 0xac, 0x0a, 0x33, 0xf3, 0x4a, 0xcc, 0x4c, 0x34, 0x75, 0xed,
    0xbc, 0x71, 0xe9, 0x80, 0x71, 0x40, 0x5a, 0xb8, 0xbc, 0x89, 0x30, 0x17, 0xc4, 0xd7, 0x00, 0x9a,
    0x18, 0x08, 0x62, 0x44, 0x13, 0x65, 0x6e, 0x2c, 0x17, 0x00, 0xad, 0xba, 0x41, 0x29
};
#endif

PyTypeObject *init_KCoreAddonsKProcessList(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKProcessList_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKProcessList_IDX].type;

    Shiboken::AutoDecRef Sbk_KProcessList_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KProcessList_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KProcessList",
        "KProcessList",
        &Sbk_KProcessList_spec,
        nullptr,
        Sbk_KProcessList_Type_bases.object(),
        0);
    auto *pyType = Sbk_KProcessList_TypeF(); // references _Sbk_KProcessList_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKProcessList_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKProcessList_SignatureBytes, KCoreAddonsKProcessList_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KProcessList_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKProcessList_IDX].type = pyType;



    return pyType;
}
