#include "nv_push_clc56f.h"

#include <stdio.h>





const char *P_PARSE_NVC46F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC46F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC56F_MTHD(uint16_t idx)
{
    switch (idx) {

  
        
    case NVC56F_SET_OBJECT:

        
    case NVC56F_ILLEGAL:

        
    case NVC56F_NOP:

        
    case NVC56F_SEMAPHOREA:

        
    case NVC56F_SEMAPHOREB:

        
    case NVC56F_SEMAPHOREC:

        
    case NVC56F_SEMAPHORED:

        
    case NVC56F_NON_STALL_INTERRUPT:

        
    case NVC56F_FB_FLUSH:

        
    case NVC56F_MEM_OP_B:

        
    case NVC56F_MEM_OP_C:

        
    case NVC56F_MEM_OP_D:

        
    case NVC56F_SET_REFERENCE:

        
    case NVC56F_SEM_ADDR_LO:

        
    case NVC56F_SEM_ADDR_HI:

        
    case NVC56F_SEM_PAYLOAD_LO:

        
    case NVC56F_SEM_PAYLOAD_HI:

        
    case NVC56F_SEM_EXECUTE:

        
    case NVC56F_WFI:

        
    case NVC56F_CLEAR_FAULTED:


    return P_PARSE_NVC46F_MTHD(idx);

                                        case NVC56F_MEM_OP_A:
        return "NVC56F_MEM_OP_A";
                                            case NVC56F_YIELD:
        return "NVC56F_YIELD";
    
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVC56F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
        
    case NVC56F_SET_OBJECT:

        
    case NVC56F_ILLEGAL:

        
    case NVC56F_NOP:

        
    case NVC56F_SEMAPHOREA:

        
    case NVC56F_SEMAPHOREB:

        
    case NVC56F_SEMAPHOREC:

        
    case NVC56F_SEMAPHORED:

        
    case NVC56F_NON_STALL_INTERRUPT:

        
    case NVC56F_FB_FLUSH:

        
    case NVC56F_MEM_OP_B:

        
    case NVC56F_MEM_OP_C:

        
    case NVC56F_MEM_OP_D:

        
    case NVC56F_SET_REFERENCE:

        
    case NVC56F_SEM_ADDR_LO:

        
    case NVC56F_SEM_ADDR_HI:

        
    case NVC56F_SEM_PAYLOAD_LO:

        
    case NVC56F_SEM_PAYLOAD_HI:

        
    case NVC56F_SEM_EXECUTE:

        
    case NVC56F_WFI:

        
    case NVC56F_CLEAR_FAULTED:


    P_DUMP_NVC46F_MTHD_DATA(fp, idx, data, prefix);
    break;

                                      
    case NVC56F_MEM_OP_A:

    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_CLIENT_UNIT_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVALIDATION_SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 5) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_GPC_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVAL_SCOPE = ", prefix);
        switch (parsed) {
        case NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_ALL_TLBS:
            fprintf(fp, "ALL_TLBS\n");
            break;
        case NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_LINK_TLBS:
            fprintf(fp, "LINK_TLBS\n");
            break;
        case NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS:
            fprintf(fp, "NON_LINK_TLBS\n");
            break;
        case NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_RSVRVD:
            fprintf(fp, "RSVRVD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 7) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_MMU_ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_SYSMEMBAR = ", prefix);
        switch (parsed) {
        case NVC56F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN:
            fprintf(fp, "EN\n");
            break;
        case NVC56F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                          
    case NVC56F_YIELD:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NVC56F_YIELD_OP_NOP:
            fprintf(fp, "NOP\n");
            break;
        case NVC56F_YIELD_OP_TSG:
            fprintf(fp, "TSG\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
        default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
