/* ExtendedProperties.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ExtendedProperties.vala, do not modify */

/*
* Copyright (c) 2011-2014 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define EXTENDED_PROPERTIES_NO_VALUE ""
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_EXTENDED_PROPERTIES (extended_properties_get_type ())
#define EXTENDED_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTENDED_PROPERTIES, ExtendedProperties))
#define EXTENDED_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesClass))
#define IS_EXTENDED_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTENDED_PROPERTIES))
#define IS_EXTENDED_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTENDED_PROPERTIES))
#define EXTENDED_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesClass))

typedef struct _ExtendedProperties ExtendedProperties;
typedef struct _ExtendedPropertiesClass ExtendedPropertiesClass;
typedef struct _ExtendedPropertiesPrivate ExtendedPropertiesPrivate;
enum  {
	EXTENDED_PROPERTIES_0_PROPERTY,
	EXTENDED_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* extended_properties_properties[EXTENDED_PROPERTIES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ExtendedProperties {
	Properties parent_instance;
	ExtendedPropertiesPrivate * priv;
};

struct _ExtendedPropertiesClass {
	PropertiesClass parent_class;
};

struct _ExtendedPropertiesPrivate {
	gchar* file_path;
	gchar* artist;
	gchar* copyright;
	gchar* exposure_date;
	gchar* exposure_time;
	gboolean is_raw;
	gchar* development_path;
	gchar* comment;
};

static gint ExtendedProperties_private_offset;
static gpointer extended_properties_parent_class = NULL;

VALA_EXTERN GType extended_properties_get_type (void) G_GNUC_CONST ;
static void extended_properties_real_clear_properties (Properties* base);
static void extended_properties_real_get_single_properties (Properties* base,
                                                     DataView* view);
static void extended_properties_real_internal_update_properties (Properties* base,
                                                          Page* page);
VALA_EXTERN ExtendedProperties* extended_properties_new (void);
VALA_EXTERN ExtendedProperties* extended_properties_construct (GType object_type);
static void extended_properties_finalize (GObject * obj);
static GType extended_properties_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
extended_properties_get_instance_private (ExtendedProperties* self)
{
	return G_STRUCT_MEMBER_P (self, ExtendedProperties_private_offset);
}

static void
extended_properties_real_clear_properties (Properties* base)
{
	ExtendedProperties * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	self = (ExtendedProperties*) base;
	PROPERTIES_CLASS (extended_properties_parent_class)->clear_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties));
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->file_path);
	self->priv->file_path = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->development_path);
	self->priv->development_path = _tmp1_;
	self->priv->is_raw = FALSE;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->artist);
	self->priv->artist = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->copyright);
	self->priv->copyright = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->exposure_date);
	self->priv->exposure_date = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->exposure_time);
	self->priv->exposure_time = _tmp5_;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->comment);
	self->priv->comment = _tmp6_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
extended_properties_real_get_single_properties (Properties* base,
                                                DataView* view)
{
	ExtendedProperties * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	DataSource* _tmp3_;
	DataSource* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (ExtendedProperties*) base;
	g_return_if_fail (view != NULL);
	PROPERTIES_CLASS (extended_properties_parent_class)->get_single_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), view);
	_tmp0_ = data_view_get_source (view);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	source = _tmp2_;
	_tmp3_ = source;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (source);
		return;
	}
	_tmp4_ = source;
	if (IS_MEDIA_SOURCE (_tmp4_)) {
		MediaSource* media = NULL;
		DataSource* _tmp5_;
		MediaSource* _tmp6_;
		MediaSource* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		MediaSource* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		Photo* photo = NULL;
		MediaSource* _tmp15_;
		Photo* _tmp16_;
		Photo* _tmp17_;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp24_;
		PhotoMetadata* _tmp25_;
		MetadataDateTime* _tmp26_;
		MetadataDateTime* _tmp27_;
		gboolean _tmp28_;
		Photo* _tmp33_;
		PhotoMetadata* _tmp34_;
		gchar* _tmp35_;
		PhotoMetadata* _tmp36_;
		gchar* _tmp37_;
		gint64 exposure_time_obj = 0LL;
		PhotoMetadata* _tmp38_;
		MetadataDateTime* _tmp39_;
		MetadataDateTime* _tmp40_;
		gint64 _tmp41_;
		GDateTime* exposure_dt = NULL;
		GDateTime* _tmp42_;
		GDateTime* _tmp43_;
		gchar* _tmp44_;
		GDateTime* _tmp45_;
		gchar* _tmp46_;
		MediaSource* _tmp47_;
		gchar* _tmp48_;
		_tmp5_ = source;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE, MediaSource));
		media = _tmp6_;
		_tmp7_ = media;
		_tmp8_ = media_source_get_master_file (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_path (_tmp9_);
		_g_free0 (self->priv->file_path);
		self->priv->file_path = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_tmp11_ = media;
		_tmp12_ = media_source_get_file (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_file_get_path (_tmp13_);
		_g_free0 (self->priv->development_path);
		self->priv->development_path = _tmp14_;
		_g_object_unref0 (_tmp13_);
		_tmp15_ = media;
		_tmp16_ = _g_object_ref0 (IS_PHOTO (_tmp15_) ? ((Photo*) _tmp15_) : NULL);
		photo = _tmp16_;
		_tmp17_ = photo;
		if (_tmp17_ == NULL) {
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
			_g_object_unref0 (source);
			return;
		}
		{
			PhotoMetadata* _tmp18_ = NULL;
			Photo* _tmp19_;
			PhotoMetadata* _tmp20_;
			PhotoMetadata* _tmp21_;
			_tmp19_ = photo;
			_tmp20_ = photo_get_master_metadata (_tmp19_, &_inner_error0_);
			_tmp18_ = _tmp20_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp21_ = _tmp18_;
			_tmp18_ = NULL;
			_media_metadata_unref0 (metadata);
			metadata = _tmp21_;
			_media_metadata_unref0 (_tmp18_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			Photo* _tmp22_;
			PhotoMetadata* _tmp23_;
			g_clear_error (&_inner_error0_);
			_tmp22_ = photo;
			_tmp23_ = photo_source_get_metadata ((PhotoSource*) _tmp22_);
			_media_metadata_unref0 (metadata);
			metadata = _tmp23_;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
			_g_object_unref0 (source);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp24_ = metadata;
		if (_tmp24_ == NULL) {
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
			_g_object_unref0 (source);
			return;
		}
		_tmp25_ = metadata;
		_tmp26_ = photo_metadata_get_exposure_date_time (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_ == NULL;
		_metadata_date_time_unref0 (_tmp27_);
		if (_tmp28_) {
			PhotoMetadata* _tmp29_;
			Photo* _tmp30_;
			MetadataDateTime* _tmp31_;
			MetadataDateTime* _tmp32_;
			_tmp29_ = metadata;
			_tmp30_ = photo;
			_tmp31_ = metadata_date_time_new (media_source_get_timestamp ((MediaSource*) _tmp30_));
			_tmp32_ = _tmp31_;
			photo_metadata_set_exposure_date_time (_tmp29_, _tmp32_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
			_metadata_date_time_unref0 (_tmp32_);
		}
		_tmp33_ = photo;
		self->priv->is_raw = photo_get_master_file_format (_tmp33_) == PHOTO_FILE_FORMAT_RAW;
		_tmp34_ = metadata;
		_tmp35_ = photo_metadata_get_artist (_tmp34_);
		_g_free0 (self->priv->artist);
		self->priv->artist = _tmp35_;
		_tmp36_ = metadata;
		_tmp37_ = photo_metadata_get_copyright (_tmp36_);
		_g_free0 (self->priv->copyright);
		self->priv->copyright = _tmp37_;
		_tmp38_ = metadata;
		_tmp39_ = photo_metadata_get_exposure_date_time (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = metadata_date_time_get_timestamp (_tmp40_);
		_metadata_date_time_unref0 (_tmp40_);
		exposure_time_obj = _tmp41_;
		_tmp42_ = g_date_time_new_from_unix_local (exposure_time_obj);
		exposure_dt = _tmp42_;
		_tmp43_ = exposure_dt;
		_tmp44_ = properties_get_prettyprint_date ((Properties*) self, _tmp43_);
		_g_free0 (self->priv->exposure_date);
		self->priv->exposure_date = _tmp44_;
		_tmp45_ = exposure_dt;
		_tmp46_ = properties_get_prettyprint_time_with_seconds ((Properties*) self, _tmp45_);
		_g_free0 (self->priv->exposure_time);
		self->priv->exposure_time = _tmp46_;
		_tmp47_ = media;
		_tmp48_ = media_source_get_comment (_tmp47_);
		_g_free0 (self->priv->comment);
		self->priv->comment = _tmp48_;
		_g_date_time_unref0 (exposure_dt);
		_media_metadata_unref0 (metadata);
		_g_object_unref0 (photo);
		_g_object_unref0 (media);
	} else {
		DataSource* _tmp49_;
		_tmp49_ = source;
		if (IS_EVENT_SOURCE (_tmp49_)) {
			Event* event = NULL;
			DataSource* _tmp50_;
			Event* _tmp51_;
			Event* _tmp52_;
			gchar* _tmp53_;
			_tmp50_ = source;
			_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_EVENT, Event));
			event = _tmp51_;
			_tmp52_ = event;
			_tmp53_ = event_source_get_comment ((EventSource*) _tmp52_);
			_g_free0 (self->priv->comment);
			self->priv->comment = _tmp53_;
			_g_object_unref0 (event);
		}
	}
	_g_object_unref0 (source);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
extended_properties_real_internal_update_properties (Properties* base,
                                                     Page* page)
{
	ExtendedProperties * self;
	self = (ExtendedProperties*) base;
	g_return_if_fail (page != NULL);
	PROPERTIES_CLASS (extended_properties_parent_class)->internal_update_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), page);
	if (IS_EVENTS_DIRECTORY_PAGE (page)) {
	} else {
		gchar* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		const gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_;
		const gchar* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		const gchar* _tmp25_;
		_tmp2_ = self->priv->file_path;
		if (g_strcmp0 (_tmp2_, "") != 0) {
			const gchar* _tmp3_;
			_tmp3_ = self->priv->file_path;
			_tmp1_ = _tmp3_ != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->file_path;
			_tmp5_ = string_replace (_tmp4_, "&", "&amp;");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp5_;
		} else {
			gchar* _tmp6_;
			_tmp6_ = g_strdup (EXTENDED_PROPERTIES_NO_VALUE);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp6_;
		}
		properties_add_line ((Properties*) self, _ ("Location:"), _tmp0_);
		if (self->priv->is_raw) {
			const gchar* _tmp7_;
			_tmp7_ = self->priv->development_path;
			properties_add_line ((Properties*) self, _ ("Developer:"), _tmp7_);
		}
		_tmp10_ = self->priv->exposure_date;
		if (g_strcmp0 (_tmp10_, "") != 0) {
			const gchar* _tmp11_;
			_tmp11_ = self->priv->exposure_date;
			_tmp9_ = _tmp11_ != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp12_;
			_tmp12_ = self->priv->exposure_date;
			_tmp8_ = _tmp12_;
		} else {
			_tmp8_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line ((Properties*) self, _ ("Exposure date:"), _tmp8_);
		_tmp15_ = self->priv->exposure_time;
		if (g_strcmp0 (_tmp15_, "") != 0) {
			const gchar* _tmp16_;
			_tmp16_ = self->priv->exposure_time;
			_tmp14_ = _tmp16_ != NULL;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			const gchar* _tmp17_;
			_tmp17_ = self->priv->exposure_time;
			_tmp13_ = _tmp17_;
		} else {
			_tmp13_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line ((Properties*) self, _ ("Exposure time:"), _tmp13_);
		_tmp20_ = self->priv->artist;
		if (g_strcmp0 (_tmp20_, "") != 0) {
			const gchar* _tmp21_;
			_tmp21_ = self->priv->artist;
			_tmp19_ = _tmp21_ != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			const gchar* _tmp22_;
			_tmp22_ = self->priv->artist;
			_tmp18_ = _tmp22_;
		} else {
			_tmp18_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line ((Properties*) self, _ ("Artist:"), _tmp18_);
		_tmp25_ = self->priv->copyright;
		if (g_strcmp0 (_tmp25_, "") != 0) {
			const gchar* _tmp26_;
			_tmp26_ = self->priv->copyright;
			_tmp24_ = _tmp26_ != NULL;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			const gchar* _tmp27_;
			_tmp27_ = self->priv->copyright;
			_tmp23_ = _tmp27_;
		} else {
			_tmp23_ = EXTENDED_PROPERTIES_NO_VALUE;
		}
		properties_add_line ((Properties*) self, _ ("Copyright:"), _tmp23_);
		_g_free0 (_tmp0_);
	}
}

ExtendedProperties*
extended_properties_construct (GType object_type)
{
	ExtendedProperties * self = NULL;
	self = (ExtendedProperties*) properties_construct (object_type);
	return self;
}

ExtendedProperties*
extended_properties_new (void)
{
	return extended_properties_construct (TYPE_EXTENDED_PROPERTIES);
}

static void
extended_properties_class_init (ExtendedPropertiesClass * klass,
                                gpointer klass_data)
{
	extended_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ExtendedProperties_private_offset);
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties*)) extended_properties_real_clear_properties;
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties*, DataView*)) extended_properties_real_get_single_properties;
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties*, Page*)) extended_properties_real_internal_update_properties;
	G_OBJECT_CLASS (klass)->finalize = extended_properties_finalize;
}

static void
extended_properties_instance_init (ExtendedProperties * self,
                                   gpointer klass)
{
	self->priv = extended_properties_get_instance_private (self);
}

static void
extended_properties_finalize (GObject * obj)
{
	ExtendedProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXTENDED_PROPERTIES, ExtendedProperties);
	_g_free0 (self->priv->file_path);
	_g_free0 (self->priv->artist);
	_g_free0 (self->priv->copyright);
	_g_free0 (self->priv->exposure_date);
	_g_free0 (self->priv->exposure_time);
	_g_free0 (self->priv->development_path);
	_g_free0 (self->priv->comment);
	G_OBJECT_CLASS (extended_properties_parent_class)->finalize (obj);
}

static GType
extended_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExtendedPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) extended_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExtendedProperties), 0, (GInstanceInitFunc) extended_properties_instance_init, NULL };
	GType extended_properties_type_id;
	extended_properties_type_id = g_type_register_static (TYPE_PROPERTIES, "ExtendedProperties", &g_define_type_info, 0);
	ExtendedProperties_private_offset = g_type_add_instance_private (extended_properties_type_id, sizeof (ExtendedPropertiesPrivate));
	return extended_properties_type_id;
}

GType
extended_properties_get_type (void)
{
	static volatile gsize extended_properties_type_id__once = 0;
	if (g_once_init_enter (&extended_properties_type_id__once)) {
		GType extended_properties_type_id;
		extended_properties_type_id = extended_properties_get_type_once ();
		g_once_init_leave (&extended_properties_type_id__once, extended_properties_type_id);
	}
	return extended_properties_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

