/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct FareProduct {
    /// The name of the fare product as displayed to riders.
    #[serde(rename = "name")]
    pub name: String,
    /// The cost of the fare product. May be negative to represent transfer discounts. May be zero to represent a fare product that is free.
    #[serde(rename = "amount")]
    pub amount: f64,
    /// ISO 4217 currency code. The currency of the cost of the fare product.
    #[serde(rename = "currency")]
    pub currency: String,
    #[serde(rename = "riderCategory", skip_serializing_if = "Option::is_none")]
    pub rider_category: Option<Box<models::RiderCategory>>,
    #[serde(rename = "media", skip_serializing_if = "Option::is_none")]
    pub media: Option<Box<models::FareMedia>>,
}

impl FareProduct {
    pub fn new(name: String, amount: f64, currency: String) -> FareProduct {
        FareProduct {
            name,
            amount,
            currency,
            rider_category: None,
            media: None,
        }
    }
}

