/* rygel-gst-data-source.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-gst-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include "rygel-server.h"
#include <gee.h>
#include <gst/gst.h>
#include <gst/base/base.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "rygel-media-engine-gst.h"

#define RYGEL_GST_SINK_NAME "http-gst-sink"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_GST_DATA_SOURCE_ERROR (rygel_gst_data_source_error_get_type ())

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;

#define RYGEL_TYPE_GST_SINK (rygel_gst_sink_get_type ())
#define RYGEL_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_SINK, RygelGstSink))
#define RYGEL_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))
#define RYGEL_IS_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_SINK))
#define RYGEL_IS_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_SINK))
#define RYGEL_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))

typedef struct _RygelGstSink RygelGstSink;
typedef struct _RygelGstSinkClass RygelGstSinkClass;
enum  {
	RYGEL_GST_DATA_SOURCE_0_PROPERTY,
	RYGEL_GST_DATA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* rygel_gst_data_source_properties[RYGEL_GST_DATA_SOURCE_NUM_PROPERTIES];
typedef struct _RygelGstSinkPrivate RygelGstSinkPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_GST_ERROR (rygel_gst_error_get_type ())
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE
} RygelGstDataSourceError;
#define RYGEL_GST_DATA_SOURCE_ERROR rygel_gst_data_source_error_quark ()

struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
	RygelMediaResource* res;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
	GeeList* (*preroll) (RygelGstDataSource* self, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error);
	gboolean (*perform_seek) (RygelGstDataSource* self);
};

struct _RygelGstDataSourcePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeekRequest* seek;
	RygelGstSink* sink;
	guint bus_watch_id;
	gchar* uri;
};

struct _RygelGstSink {
	GstBaseSink parent_instance;
	RygelGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelGstSinkClass {
	GstBaseSinkClass parent_class;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()

static gint RygelGstDataSource_private_offset;
static gpointer rygel_gst_data_source_parent_class = NULL;
static RygelDataSourceIface * rygel_gst_data_source_rygel_data_source_parent_iface = NULL;

VALA_EXTERN GQuark rygel_gst_data_source_error_quark (void);
VALA_EXTERN GType rygel_gst_data_source_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_gst_data_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_gst_sink_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeList* rygel_gst_data_source_preroll (RygelGstDataSource* self,
                                        RygelHTTPSeekRequest* seek_request,
                                        RygelPlaySpeedRequest* playspeed_request,
                                        GError** error);
VALA_EXTERN gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri,
                                               RygelMediaResource* resource,
                                               GError** error);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_construct (GType object_type,
                                                     const gchar* uri,
                                                     RygelMediaResource* resource,
                                                     GError** error);
VALA_EXTERN GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type,
                                                                  GstElement* element);
VALA_EXTERN gchar* rygel_gst_data_source_get_uri (RygelGstDataSource* self);
static GeeList* rygel_gst_data_source_real_preroll (RygelGstDataSource* self,
                                             RygelHTTPSeekRequest* seek_request,
                                             RygelPlaySpeedRequest* playspeed_request,
                                             GError** error);
static void rygel_gst_data_source_real_start (RygelDataSource* base,
                                       GError** error);
static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self,
                                             const gchar* name,
                                             GstElement* src,
                                             GError** error);
static void rygel_gst_data_source_real_freeze (RygelDataSource* base);
VALA_EXTERN void rygel_gst_sink_freeze (RygelGstSink* self);
static void rygel_gst_data_source_real_thaw (RygelDataSource* base);
VALA_EXTERN void rygel_gst_sink_thaw (RygelGstSink* self);
static void rygel_gst_data_source_real_stop (RygelDataSource* base);
static gboolean __lambda6_ (RygelGstDataSource* self);
static gboolean ___lambda6__gsource_func (gpointer self);
VALA_EXTERN RygelGstSink* rygel_gst_sink_new (RygelDataSource* source,
                                  RygelHTTPSeekRequest* offsets);
VALA_EXTERN RygelGstSink* rygel_gst_sink_construct (GType object_type,
                                        RygelDataSource* source,
                                        RygelHTTPSeekRequest* offsets);
static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self,
                                          GstElement* src,
                                          GstPad* src_pad);
static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender,
                                                                 GstPad* pad,
                                                                 gpointer self);
VALA_EXTERN GQuark rygel_gst_error_quark (void);
VALA_EXTERN GType rygel_gst_error_get_type (void) G_GNUC_CONST ;
static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self,
                                            GstBus* bus,
                                            GstMessage* message);
static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus,
                                                          GstMessage* message,
                                                          gpointer self);
VALA_EXTERN GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static gboolean ___lambda5_ (RygelGstDataSource* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static gboolean rygel_gst_data_source_real_perform_seek (RygelGstDataSource* self);
static void rygel_gst_data_source_finalize (GObject * obj);
static GType rygel_gst_data_source_get_type_once (void);

GQuark
rygel_gst_data_source_error_quark (void)
{
	return g_quark_from_static_string ("rygel-gst-data-source-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_gst_data_source_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE, "RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE", "not-compatible"}, {0, NULL, NULL}};
	GType rygel_gst_data_source_error_type_id;
	rygel_gst_data_source_error_type_id = g_enum_register_static ("RygelGstDataSourceError", values);
	return rygel_gst_data_source_error_type_id;
}

GType
rygel_gst_data_source_error_get_type (void)
{
	static volatile gsize rygel_gst_data_source_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_gst_data_source_error_type_id__once)) {
		GType rygel_gst_data_source_error_type_id;
		rygel_gst_data_source_error_type_id = rygel_gst_data_source_error_get_type_once ();
		g_once_init_leave (&rygel_gst_data_source_error_type_id__once, rygel_gst_data_source_error_type_id);
	}
	return rygel_gst_data_source_error_type_id__once;
}

static inline gpointer
rygel_gst_data_source_get_instance_private (RygelGstDataSource* self)
{
	return G_STRUCT_MEMBER_P (self, RygelGstDataSource_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelGstDataSource*
rygel_gst_data_source_construct (GType object_type,
                                 const gchar* uri,
                                 RygelMediaResource* resource,
                                 GError** error)
{
	RygelGstDataSource * self = NULL;
	gchar* _tmp0_;
	RygelMediaResource* _tmp1_;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp0_;
	_tmp1_ = _g_object_ref0 (resource);
	_g_object_unref0 (self->res);
	self->res = _tmp1_;
	_tmp2_ = rygel_gst_utils_create_source_for_uri (uri);
	_g_object_unref0 (self->src);
	self->src = _tmp2_;
	_tmp3_ = self->src;
	if (_tmp3_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp4_ = g_strdup (_ ("Could not create GstElement for URI %s"));
		msg = _tmp4_;
		_tmp5_ = msg;
		_tmp6_ = g_error_new (RYGEL_GST_DATA_SOURCE_ERROR, RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE, _tmp5_, uri);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

RygelGstDataSource*
rygel_gst_data_source_new (const gchar* uri,
                           RygelMediaResource* resource,
                           GError** error)
{
	return rygel_gst_data_source_construct (RYGEL_TYPE_GST_DATA_SOURCE, uri, resource, error);
}

RygelGstDataSource*
rygel_gst_data_source_construct_from_element (GType object_type,
                                              GstElement* element)
{
	RygelGstDataSource * self = NULL;
	GstElement* _tmp0_;
	g_return_val_if_fail (element != NULL, NULL);
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (element);
	_g_object_unref0 (self->src);
	self->src = _tmp0_;
	return self;
}

RygelGstDataSource*
rygel_gst_data_source_new_from_element (GstElement* element)
{
	return rygel_gst_data_source_construct_from_element (RYGEL_TYPE_GST_DATA_SOURCE, element);
}

gchar*
rygel_gst_data_source_get_uri (RygelGstDataSource* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static GeeList*
rygel_gst_data_source_real_preroll (RygelGstDataSource* self,
                                    RygelHTTPSeekRequest* seek_request,
                                    RygelPlaySpeedRequest* playspeed_request,
                                    GError** error)
{
	GeeArrayList* response_list = NULL;
	GeeArrayList* _tmp0_;
	RygelHTTPSeekRequest* _tmp25_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	response_list = _tmp0_;
	if (playspeed_request != NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED, _ ("Playspeed not supported"));
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (response_list);
		return NULL;
	}
	if (seek_request == NULL) {
		g_debug ("rygel-gst-data-source.vala:82: No seek requested - sending entire bina" \
"ry");
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
			RygelHTTPByteSeekResponse* seek_response = NULL;
			RygelHTTPByteSeekResponse* _tmp2_;
			RygelHTTPByteSeekResponse* _tmp3_;
			gint64 _tmp4_;
			gint64 _tmp5_;
			RygelHTTPByteSeekResponse* _tmp6_;
			gint64 _tmp7_;
			gint64 _tmp8_;
			RygelHTTPByteSeekResponse* _tmp9_;
			_tmp2_ = rygel_http_byte_seek_response_new_from_request (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) seek_request) : NULL);
			seek_response = _tmp2_;
			_tmp3_ = seek_response;
			_tmp4_ = rygel_http_byte_seek_response_get_start_byte (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = seek_response;
			_tmp7_ = rygel_http_byte_seek_response_get_end_byte (_tmp6_);
			_tmp8_ = _tmp7_;
			g_debug ("rygel-gst-data-source.vala:87: Processing byte seek request for bytes " \
"%lld-%lld", _tmp5_, _tmp8_);
			_tmp9_ = seek_response;
			gee_abstract_collection_add ((GeeAbstractCollection*) response_list, (RygelHTTPResponseElement*) _tmp9_);
			_g_object_unref0 (seek_response);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST)) {
				RygelHTTPTimeSeekRequest* time_seek = NULL;
				RygelHTTPTimeSeekRequest* _tmp10_;
				RygelHTTPTimeSeekResponse* seek_response = NULL;
				RygelHTTPTimeSeekRequest* _tmp11_;
				RygelMediaResource* _tmp12_;
				glong _tmp13_;
				glong _tmp14_;
				RygelHTTPTimeSeekResponse* _tmp15_;
				RygelHTTPTimeSeekResponse* _tmp16_;
				gint64 _tmp17_;
				gint64 _tmp18_;
				RygelHTTPTimeSeekResponse* _tmp19_;
				gint64 _tmp20_;
				gint64 _tmp21_;
				RygelHTTPTimeSeekResponse* _tmp22_;
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST) ? ((RygelHTTPTimeSeekRequest*) seek_request) : NULL);
				time_seek = _tmp10_;
				_tmp11_ = time_seek;
				_tmp12_ = self->res;
				_tmp13_ = rygel_media_resource_get_duration (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = rygel_http_time_seek_response_new_from_request (_tmp11_, (gint64) (_tmp14_ * G_TIME_SPAN_SECOND));
				seek_response = _tmp15_;
				_tmp16_ = seek_response;
				_tmp17_ = rygel_http_time_seek_response_get_start_time (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = seek_response;
				_tmp20_ = rygel_http_time_seek_response_get_end_time (_tmp19_);
				_tmp21_ = _tmp20_;
				g_debug ("rygel-gst-data-source.vala:101: Processing time seek request for %lldm" \
"s-%lldms", _tmp18_, _tmp21_);
				_tmp22_ = seek_response;
				gee_abstract_collection_add ((GeeAbstractCollection*) response_list, (RygelHTTPResponseElement*) _tmp22_);
				_g_object_unref0 (seek_response);
				_g_object_unref0 (time_seek);
			} else {
				const gchar* _tmp23_;
				GError* _tmp24_;
				_tmp23_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) seek_request));
				_tmp24_ = g_error_new (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _ ("HTTPSeekRequest type %s unsupported"), _tmp23_);
				_inner_error0_ = _tmp24_;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (response_list);
				return NULL;
			}
		}
	}
	_tmp25_ = _g_object_ref0 (seek_request);
	_g_object_unref0 (self->priv->seek);
	self->priv->seek = _tmp25_;
	result = (GeeList*) response_list;
	return result;
}

GeeList*
rygel_gst_data_source_preroll (RygelGstDataSource* self,
                               RygelHTTPSeekRequest* seek_request,
                               RygelPlaySpeedRequest* playspeed_request,
                               GError** error)
{
	RygelGstDataSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_GST_DATA_SOURCE_GET_CLASS (self);
	if (_klass_->preroll) {
		return _klass_->preroll (self, seek_request, playspeed_request, error);
	}
	return NULL;
}

static void
rygel_gst_data_source_real_start (RygelDataSource* base,
                                  GError** error)
{
	RygelGstDataSource * self;
	GstElement* _tmp0_;
	RygelHTTPSeekRequest* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->src;
	rygel_gst_data_source_prepare_pipeline (self, "RygelGstDataSource", _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->seek;
	if (_tmp1_ != NULL) {
		GstPipeline* _tmp2_;
		_tmp2_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_PAUSED);
	} else {
		GstPipeline* _tmp3_;
		_tmp3_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp3_, GST_STATE_PLAYING);
	}
}

static void
rygel_gst_data_source_real_freeze (RygelDataSource* base)
{
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	rygel_gst_sink_freeze (_tmp0_);
}

static void
rygel_gst_data_source_real_thaw (RygelDataSource* base)
{
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	rygel_gst_sink_thaw (_tmp0_);
}

static gboolean
__lambda6_ (RygelGstDataSource* self)
{
	gboolean result;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((RygelGstDataSource*) self);
	return result;
}

static void
rygel_gst_data_source_real_stop (RygelDataSource* base)
{
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	GCancellable* _tmp1_;
	GstPipeline* _tmp2_;
	self = (RygelGstDataSource*) base;
	_tmp0_ = self->priv->sink;
	_tmp1_ = _tmp0_->cancellable;
	g_cancellable_cancel (_tmp1_);
	_tmp2_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_NULL);
	if (self->priv->bus_watch_id != ((guint) 0)) {
		g_source_remove (self->priv->bus_watch_id);
		self->priv->bus_watch_id = (guint) 0;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}

static void
_rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender,
                                                            GstPad* pad,
                                                            gpointer self)
{
	rygel_gst_data_source_src_pad_added ((RygelGstDataSource*) self, _sender, pad);
}

static gboolean
_rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus,
                                                 GstMessage* message,
                                                 gpointer self)
{
	gboolean result;
	result = rygel_gst_data_source_bus_handler ((RygelGstDataSource*) self, bus, message);
	return result;
}

static void
rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self,
                                        const gchar* name,
                                        GstElement* src,
                                        GError** error)
{
	RygelHTTPSeekRequest* _tmp0_;
	RygelGstSink* _tmp1_;
	GstPipeline* _tmp2_;
	GstPipeline* _tmp3_;
	GstPipeline* _tmp5_;
	RygelGstSink* _tmp6_;
	GstBus* bus = NULL;
	GstPipeline* _tmp17_;
	GstBus* _tmp18_;
	GstBus* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = self->priv->seek;
	_tmp1_ = rygel_gst_sink_new ((RygelDataSource*) self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->sink);
	self->priv->sink = _tmp1_;
	_tmp2_ = (GstPipeline*) gst_pipeline_new (name);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp2_;
	_tmp3_ = self->priv->pipeline;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _ ("Failed to create pipeline"));
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp5_ = self->priv->pipeline;
	_tmp6_ = self->priv->sink;
	gst_bin_add_many ((GstBin*) _tmp5_, src, (GstElement*) _tmp6_, NULL);
	if (((gint) src->numsrcpads) == 0) {
		g_signal_connect_object (src, "pad-added", (GCallback) _rygel_gst_data_source_src_pad_added_gst_element_pad_added, self, 0);
	} else {
		RygelGstSink* _tmp7_;
		_tmp7_ = self->priv->sink;
		if (!gst_element_link (src, (GstElement*) _tmp7_)) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			RygelGstSink* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GError* _tmp15_;
			GError* _tmp16_;
			_tmp8_ = gst_object_get_name ((GstObject*) src);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->sink;
			_tmp12_ = gst_object_get_name ((GstObject*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _ ("Failed to link %s to %s"), _tmp10_, _tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			_g_free0 (_tmp10_);
			_inner_error0_ = _tmp16_;
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	_tmp17_ = self->priv->pipeline;
	_tmp18_ = gst_pipeline_get_bus (_tmp17_);
	bus = _tmp18_;
	_tmp19_ = bus;
	self->priv->bus_watch_id = gst_bus_add_watch_full (_tmp19_, G_PRIORITY_DEFAULT, _rygel_gst_data_source_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (bus);
}

static void
rygel_gst_data_source_src_pad_added (RygelGstDataSource* self,
                                     GstElement* src,
                                     GstPad* src_pad)
{
	GstCaps* caps = NULL;
	GstCaps* _tmp0_;
	GstElement* sink = NULL;
	GstPipeline* _tmp1_;
	GstElement* _tmp2_;
	GstPad* sink_pad = NULL;
	GstElement* depay = NULL;
	GstCaps* _tmp3_;
	GstElement* _tmp4_;
	GstElement* _tmp5_;
	GstPad* _tmp24_;
	GstElement* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (src_pad != NULL);
	_tmp0_ = gst_pad_query_caps (src_pad, NULL);
	caps = _tmp0_;
	_tmp1_ = self->priv->pipeline;
	_tmp2_ = gst_bin_get_by_name ((GstBin*) _tmp1_, RYGEL_GST_SINK_NAME);
	sink = _tmp2_;
	_tmp3_ = caps;
	_tmp4_ = rygel_gst_utils_get_rtp_depayloader (_tmp3_);
	depay = _tmp4_;
	_tmp5_ = depay;
	if (_tmp5_ != NULL) {
		GstPipeline* _tmp6_;
		GstElement* _tmp7_;
		GstElement* _tmp8_;
		GstElement* _tmp9_;
		GstElement* _tmp18_;
		GstCaps* _tmp19_;
		GstPad* _tmp20_;
		_tmp6_ = self->priv->pipeline;
		_tmp7_ = depay;
		gst_bin_add ((GstBin*) _tmp6_, _tmp7_);
		_tmp8_ = depay;
		_tmp9_ = sink;
		if (!gst_element_link (_tmp8_, _tmp9_)) {
			GstElement* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GstElement* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = depay;
			_tmp11_ = gst_object_get_name ((GstObject*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp14_ = sink;
			_tmp15_ = gst_object_get_name ((GstObject*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			g_critical (_ ("Failed to link %s to %s"), _tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			g_signal_emit_by_name ((RygelDataSource*) self, "done");
			_g_object_unref0 (depay);
			_g_object_unref0 (sink_pad);
			_g_object_unref0 (sink);
			_gst_caps_unref0 (caps);
			return;
		}
		_tmp18_ = depay;
		_tmp19_ = caps;
		_tmp20_ = gst_element_get_compatible_pad (_tmp18_, src_pad, _tmp19_);
		_g_object_unref0 (sink_pad);
		sink_pad = _tmp20_;
	} else {
		GstElement* _tmp21_;
		GstCaps* _tmp22_;
		GstPad* _tmp23_;
		_tmp21_ = sink;
		_tmp22_ = caps;
		_tmp23_ = gst_element_get_compatible_pad (_tmp21_, src_pad, _tmp22_);
		_g_object_unref0 (sink_pad);
		sink_pad = _tmp23_;
	}
	_tmp24_ = sink_pad;
	if (gst_pad_link_full (src_pad, _tmp24_, GST_PAD_LINK_CHECK_DEFAULT) != GST_PAD_LINK_OK) {
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GstPad* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp25_ = gst_object_get_name ((GstObject*) src_pad);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = sink_pad;
		_tmp29_ = gst_object_get_name ((GstObject*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		g_critical (_ ("Failed to link pad %s to %s"), _tmp27_, _tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp27_);
		g_signal_emit_by_name ((RygelDataSource*) self, "done");
		_g_object_unref0 (depay);
		_g_object_unref0 (sink_pad);
		_g_object_unref0 (sink);
		_gst_caps_unref0 (caps);
		return;
	}
	_tmp32_ = depay;
	if (_tmp32_ != NULL) {
		GstElement* _tmp33_;
		_tmp33_ = depay;
		gst_element_sync_state_with_parent (_tmp33_);
	}
	_g_object_unref0 (depay);
	_g_object_unref0 (sink_pad);
	_g_object_unref0 (sink);
	_gst_caps_unref0 (caps);
}

static gboolean
___lambda5_ (RygelGstDataSource* self)
{
	gboolean result;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ ((RygelGstDataSource*) self);
	return result;
}

static gboolean
rygel_gst_data_source_bus_handler (RygelGstDataSource* self,
                                   GstBus* bus,
                                   GstMessage* message)
{
	gboolean ret = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	ret = TRUE;
	if (message->type == GST_MESSAGE_EOS) {
		ret = FALSE;
	} else {
		if (message->type == GST_MESSAGE_STATE_CHANGED) {
			GstObject* _tmp0_;
			GstPipeline* _tmp1_;
			GstState old_state = 0;
			GstState new_state = 0;
			GstState _tmp2_ = 0;
			GstState _tmp3_ = 0;
			gboolean _tmp4_ = FALSE;
			gchar* filename = NULL;
			gchar* _tmp14_;
			GstPipeline* _tmp15_;
			const gchar* _tmp16_;
			RygelHTTPSeekRequest* _tmp17_;
			_tmp0_ = message->src;
			_tmp1_ = self->priv->pipeline;
			if (_tmp0_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gst_object_get_type (), GstObject)) {
				result = TRUE;
				return result;
			}
			gst_message_parse_state_changed (message, &_tmp2_, &_tmp3_, NULL);
			old_state = _tmp2_;
			new_state = _tmp3_;
			if (old_state == GST_STATE_NULL) {
				_tmp4_ = new_state == GST_STATE_READY;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				GstElement* element = NULL;
				GstPipeline* _tmp5_;
				GstElement* _tmp6_;
				GstElement* _tmp7_;
				_tmp5_ = self->priv->pipeline;
				_tmp6_ = gst_bin_get_by_name ((GstBin*) _tmp5_, "muxer");
				element = _tmp6_;
				_tmp7_ = element;
				if (_tmp7_ != NULL) {
					gchar* name = NULL;
					GstElement* _tmp8_;
					GstElementFactory* _tmp9_;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					_tmp8_ = element;
					_tmp9_ = gst_element_get_factory (_tmp8_);
					_tmp10_ = gst_object_get_name ((GstObject*) _tmp9_);
					name = _tmp10_;
					_tmp11_ = name;
					if (g_strcmp0 (_tmp11_, "mp4mux") == 0) {
						GstElement* _tmp12_;
						GstElement* _tmp13_;
						_tmp12_ = element;
						g_object_set (_tmp12_, "streamable", TRUE, NULL);
						_tmp13_ = element;
						g_object_set (_tmp13_, "fragment-duration", 1000, NULL);
					}
					_g_free0 (name);
				}
				_g_object_unref0 (element);
			}
			_tmp14_ = g_strdup_printf ("rygel_media_engine_%d_%d", (gint) old_state, (gint) new_state);
			filename = _tmp14_;
			_tmp15_ = self->priv->pipeline;
			_tmp16_ = filename;
			gst_debug_bin_to_dot_file_with_ts ((GstBin*) _tmp15_, GST_DEBUG_GRAPH_SHOW_ALL, _tmp16_);
			_tmp17_ = self->priv->seek;
			if (_tmp17_ != NULL) {
				gboolean _tmp18_ = FALSE;
				if (old_state == GST_STATE_READY) {
					_tmp18_ = new_state == GST_STATE_PAUSED;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					if (rygel_gst_data_source_perform_seek (self)) {
						GstPipeline* _tmp19_;
						_tmp19_ = self->priv->pipeline;
						gst_element_set_state ((GstElement*) _tmp19_, GST_STATE_PLAYING);
					}
				}
			}
			_g_free0 (filename);
		} else {
			GError* err = NULL;
			gchar* err_msg = NULL;
			if (message->type == GST_MESSAGE_ERROR) {
				GstPipeline* _tmp20_;
				GError* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				GstPipeline* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp20_ = self->priv->pipeline;
				gst_debug_bin_to_dot_file_with_ts ((GstBin*) _tmp20_, GST_DEBUG_GRAPH_SHOW_ALL, "rygel_media_engine_error");
				gst_message_parse_error (message, &_tmp21_, &_tmp22_);
				_g_error_free0 (err);
				err = _tmp21_;
				_g_free0 (err_msg);
				err_msg = _tmp22_;
				_tmp23_ = self->priv->pipeline;
				_tmp24_ = gst_object_get_name ((GstObject*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = _tmp25_;
				_tmp27_ = err_msg;
				g_critical (_ ("Error from pipeline %s: %s"), _tmp26_, _tmp27_);
				_g_free0 (_tmp26_);
				ret = FALSE;
			} else {
				if (message->type == GST_MESSAGE_WARNING) {
					GError* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					GstPipeline* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					const gchar* _tmp34_;
					gst_message_parse_warning (message, &_tmp28_, &_tmp29_);
					_g_error_free0 (err);
					err = _tmp28_;
					_g_free0 (err_msg);
					err_msg = _tmp29_;
					_tmp30_ = self->priv->pipeline;
					_tmp31_ = gst_object_get_name ((GstObject*) _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = _tmp32_;
					_tmp34_ = err_msg;
					g_warning (_ ("Warning from pipeline %s: %s"), _tmp33_, _tmp34_);
					_g_free0 (_tmp33_);
				}
			}
			_g_free0 (err_msg);
			_g_error_free0 (err);
		}
	}
	if (!ret) {
		g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->bus_watch_id = (guint) 0;
	}
	result = ret;
	return result;
}

static gboolean
rygel_gst_data_source_real_perform_seek (RygelGstDataSource* self)
{
	GstSeekType stop_type = 0;
	GstFormat format = 0;
	GstSeekFlags flags = 0U;
	gint64 start = 0LL;
	gint64 stop = 0LL;
	RygelHTTPSeekRequest* _tmp0_;
	GstPipeline* _tmp28_;
	gboolean result;
	stop_type = GST_SEEK_TYPE_NONE;
	flags = GST_SEEK_FLAG_FLUSH;
	_tmp0_ = self->priv->seek;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST)) {
		RygelHTTPTimeSeekRequest* time_seek = NULL;
		RygelHTTPSeekRequest* _tmp1_;
		RygelHTTPTimeSeekRequest* _tmp2_;
		RygelHTTPTimeSeekRequest* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GstElement* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		RygelHTTPTimeSeekRequest* _tmp10_;
		_tmp1_ = self->priv->seek;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST) ? ((RygelHTTPTimeSeekRequest*) _tmp1_) : NULL);
		time_seek = _tmp2_;
		format = GST_FORMAT_TIME;
		flags |= GST_SEEK_FLAG_KEY_UNIT;
		_tmp3_ = time_seek;
		start = _tmp3_->start_time * GST_USECOND;
		_tmp5_ = self->src;
		_tmp6_ = gst_object_get_name ((GstObject*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strcmp0 (_tmp8_, "dvdreadsrc") == 0;
		_g_free0 (_tmp8_);
		if (_tmp9_) {
			_tmp4_ = start == ((gint64) 0);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			start += (gint64) (1 * GST_SECOND);
		}
		_tmp10_ = time_seek;
		stop = _tmp10_->end_time * GST_USECOND;
		g_debug ("rygel-gst-data-source.vala:305: Performing time-range seek: %lldns to " \
"%lldns", start, stop);
		_g_object_unref0 (time_seek);
	} else {
		RygelHTTPSeekRequest* _tmp11_;
		_tmp11_ = self->priv->seek;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
			RygelHTTPByteSeekRequest* byte_seek = NULL;
			RygelHTTPSeekRequest* _tmp12_;
			RygelHTTPByteSeekRequest* _tmp13_;
			RygelHTTPByteSeekRequest* _tmp14_;
			gint64 _tmp15_;
			gint64 _tmp16_;
			RygelHTTPByteSeekRequest* _tmp17_;
			gint64 _tmp18_;
			gint64 _tmp19_;
			RygelHTTPByteSeekRequest* _tmp20_;
			gint64 _tmp21_;
			gint64 _tmp22_;
			RygelHTTPByteSeekRequest* _tmp23_;
			gint64 _tmp24_;
			gint64 _tmp25_;
			_tmp12_ = self->priv->seek;
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp12_) : NULL);
			byte_seek = _tmp13_;
			_tmp14_ = byte_seek;
			_tmp15_ = rygel_http_byte_seek_request_get_range_length (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = byte_seek;
			_tmp18_ = rygel_http_byte_seek_request_get_total_size (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp16_ >= _tmp19_) {
				result = TRUE;
				_g_object_unref0 (byte_seek);
				return result;
			}
			format = GST_FORMAT_BYTES;
			flags |= GST_SEEK_FLAG_ACCURATE;
			_tmp20_ = byte_seek;
			_tmp21_ = rygel_http_byte_seek_request_get_start_byte (_tmp20_);
			_tmp22_ = _tmp21_;
			start = _tmp22_;
			_tmp23_ = byte_seek;
			_tmp24_ = rygel_http_byte_seek_request_get_end_byte (_tmp23_);
			_tmp25_ = _tmp24_;
			stop = _tmp25_;
			g_debug ("rygel-gst-data-source.vala:318: Performing byte-range seek: bytes %lld" \
" to %lld", start, stop);
			_g_object_unref0 (byte_seek);
		} else {
			GError* _result_ = NULL;
			GError* _tmp26_;
			GError* _tmp27_;
			_tmp26_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _ ("Unsupported seek type"));
			_result_ = _tmp26_;
			_tmp27_ = _result_;
			g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp27_);
			result = FALSE;
			_g_error_free0 (_result_);
			return result;
		}
	}
	if (stop > ((gint64) 0)) {
		stop_type = GST_SEEK_TYPE_SET;
	}
	_tmp28_ = self->priv->pipeline;
	if (!gst_element_seek ((GstElement*) _tmp28_, 1.0, format, flags, GST_SEEK_TYPE_SET, start, stop_type, stop + 1)) {
		GError* _tmp29_;
		GError* _tmp30_;
		g_warning (_ ("Failed to seek to offsets %lld:%lld"), start, stop);
		_tmp29_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _ ("Failed to seek"));
		_tmp30_ = _tmp29_;
		g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp30_);
		_g_error_free0 (_tmp30_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
rygel_gst_data_source_perform_seek (RygelGstDataSource* self)
{
	RygelGstDataSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = RYGEL_GST_DATA_SOURCE_GET_CLASS (self);
	if (_klass_->perform_seek) {
		return _klass_->perform_seek (self);
	}
	return FALSE;
}

static void
rygel_gst_data_source_class_init (RygelGstDataSourceClass * klass,
                                  gpointer klass_data)
{
	rygel_gst_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelGstDataSource_private_offset);
	((RygelGstDataSourceClass *) klass)->preroll = (GeeList* (*) (RygelGstDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_gst_data_source_real_preroll;
	((RygelGstDataSourceClass *) klass)->perform_seek = (gboolean (*) (RygelGstDataSource*)) rygel_gst_data_source_real_perform_seek;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_data_source_finalize;
}

static void
rygel_gst_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface,
                                                        gpointer iface_data)
{
	rygel_gst_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->preroll = (GeeList* (*) (RygelDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_gst_data_source_preroll;
	iface->start = (void (*) (RygelDataSource*, GError**)) rygel_gst_data_source_real_start;
	iface->freeze = (void (*) (RygelDataSource*)) rygel_gst_data_source_real_freeze;
	iface->thaw = (void (*) (RygelDataSource*)) rygel_gst_data_source_real_thaw;
	iface->stop = (void (*) (RygelDataSource*)) rygel_gst_data_source_real_stop;
}

static void
rygel_gst_data_source_instance_init (RygelGstDataSource * self,
                                     gpointer klass)
{
	self->priv = rygel_gst_data_source_get_instance_private (self);
	self->priv->seek = NULL;
	self->priv->uri = NULL;
}

static void
rygel_gst_data_source_finalize (GObject * obj)
{
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_;
	GstPipeline* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource);
	_tmp0_ = self->priv->sink;
	if (_tmp0_ != NULL) {
		RygelGstSink* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->sink;
		_tmp2_ = _tmp1_->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_tmp3_ = self->priv->pipeline;
	if (_tmp3_ != NULL) {
		GstPipeline* _tmp4_;
		_tmp4_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_NULL);
	}
	_g_object_unref0 (self->src);
	_g_object_unref0 (self->res);
	_g_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->seek);
	_g_object_unref0 (self->priv->sink);
	_g_free0 (self->priv->uri);
	G_OBJECT_CLASS (rygel_gst_data_source_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_gst_data_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelGstDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstDataSource), 0, (GInstanceInitFunc) rygel_gst_data_source_instance_init, NULL };
	static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_gst_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_gst_data_source_type_id;
	rygel_gst_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstDataSource", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_gst_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
	RygelGstDataSource_private_offset = g_type_add_instance_private (rygel_gst_data_source_type_id, sizeof (RygelGstDataSourcePrivate));
	return rygel_gst_data_source_type_id;
}

GType
rygel_gst_data_source_get_type (void)
{
	static volatile gsize rygel_gst_data_source_type_id__once = 0;
	if (g_once_init_enter (&rygel_gst_data_source_type_id__once)) {
		GType rygel_gst_data_source_type_id;
		rygel_gst_data_source_type_id = rygel_gst_data_source_get_type_once ();
		g_once_init_leave (&rygel_gst_data_source_type_id__once, rygel_gst_data_source_type_id);
	}
	return rygel_gst_data_source_type_id__once;
}

