
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_dnsserver.h"
#include "bin/default/librpc/gen_ndr/ndr_dnsserver_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/dnsp.h"
static PyTypeObject DNS_RPC_BUFFER_Type;
static PyTypeObject DNS_RPC_UTF8_STRING_LIST_Type;
static PyTypeObject DNS_RPC_NAME_AND_PARAM_Type;
static PyTypeObject DNS_RPC_NAME_Type;
static PyTypeObject DNS_RPC_NODE_Type;
static PyTypeObject DNS_RPC_RECORD_SOA_Type;
static PyTypeObject DNS_RPC_RECORD_NAME_PREFERENCE_Type;
static PyTypeObject DNS_RPC_RECORD_STRING_Type;
static PyTypeObject DNS_RPC_RECORD_SRV_Type;
static PyTypeObject DNS_RPC_RECORD_DATA_Type;
static PyTypeObject DNS_RPC_RECORD_Type;
static PyTypeObject DNS_RPC_RECORD_BUF_Type;
static PyTypeObject IP4_ARRAY_Type;
static PyTypeObject DNS_ADDR_Type;
static PyTypeObject DNS_ADDR_ARRAY_Type;
static PyTypeObject DNS_RPC_IP_VALIDATE_Type;
static PyTypeObject DNS_RPC_SERVER_INFO_W2K_Type;
static PyTypeObject DNS_EXTENSION_Type;
static PyTypeObject DNS_RPC_SERVER_INFO_DOTNET_Type;
static PyTypeObject DNS_RPC_SERVER_INFO_LONGHORN_Type;
static PyTypeObject DNS_RPC_DP_REPLICA_Type;
static PyTypeObject DNS_RPC_DP_INFO_Type;
static PyTypeObject DNS_RPC_DP_ENUM_Type;
static PyTypeObject DNS_RPC_DP_LIST_Type;
static PyTypeObject DNS_RPC_ENLIST_DP_Type;
static PyTypeObject DNS_RPC_ZONE_CHANGE_DP_Type;
static PyTypeObject DNS_RPC_ZONE_W2K_Type;
static PyTypeObject DNS_RPC_ZONE_DOTNET_Type;
static PyTypeObject DNS_RPC_ZONE_LIST_W2K_Type;
static PyTypeObject DNS_RPC_ZONE_LIST_DOTNET_Type;
static PyTypeObject DNS_RPC_ZONE_INFO_W2K_Type;
static PyTypeObject DNS_RPC_ZONE_INFO_DOTNET_Type;
static PyTypeObject DNS_RPC_ZONE_INFO_LONGHORN_Type;
static PyTypeObject DNS_RPC_ZONE_SECONDARIES_W2K_Type;
static PyTypeObject DNS_RPC_ZONE_SECONDARIES_DOTNET_Type;
static PyTypeObject DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type;
static PyTypeObject DNS_RPC_ZONE_DATABASE_W2K_Type;
static PyTypeObject DNS_RPC_ZONE_DATABASE_DOTNET_Type;
static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_W2K_Type;
static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type;
static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type;
static PyTypeObject DNS_RPC_ZONE_EXPORT_INFO_Type;
static PyTypeObject DNS_RPC_ENUM_ZONES_FILTER_Type;
static PyTypeObject DNS_RPC_FORWARDERS_W2K_Type;
static PyTypeObject DNS_RPC_FORWARDERS_DOTNET_Type;
static PyTypeObject DNS_RPC_FORWARDERS_LONGHORN_Type;
static PyTypeObject DNS_RPC_AUTOCONFIGURE_Type;
static PyTypeObject DNSSRV_STAT_HEADER_Type;
static PyTypeObject DNSSRV_STAT_Type;
static PyTypeObject DNSSRV_RPC_UNION_Type;
static PyTypeObject DNS_RPC_RECORDS_Type;
static PyTypeObject DNS_RPC_RECORDS_ARRAY_Type;
static PyTypeObject dnsserver_InterfaceType;
static PyTypeObject DnssrvOperation_Type;
static PyTypeObject DnssrvQuery_Type;
static PyTypeObject DnssrvComplexOperation_Type;
static PyTypeObject DnssrvEnumRecords_Type;
static PyTypeObject DnssrvUpdateRecord_Type;
static PyTypeObject DnssrvOperation2_Type;
static PyTypeObject DnssrvQuery2_Type;
static PyTypeObject DnssrvComplexOperation2_Type;
static PyTypeObject DnssrvEnumRecords2_Type;
static PyTypeObject DnssrvUpdateRecord2_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_DNS_RPC_BUFFER_get_dwLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_BUFFER *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLength;
	py_dwLength = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLength));
	return py_dwLength;
}

static int py_DNS_RPC_BUFFER_set_dwLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_BUFFER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_BUFFER_get_Buffer(PyObject *obj, void *closure)
{
	struct DNS_RPC_BUFFER *object = pytalloc_get_ptr(obj);
	PyObject *py_Buffer;
	py_Buffer = PyList_New(object->dwLength);
	if (py_Buffer == NULL) {
		return NULL;
	}
	{
		int Buffer_cntr_0;
		for (Buffer_cntr_0 = 0; Buffer_cntr_0 < (object->dwLength); Buffer_cntr_0++) {
			PyObject *py_Buffer_0;
			py_Buffer_0 = PyLong_FromLong((uint16_t)((object->Buffer)[Buffer_cntr_0]));
			PyList_SetItem(py_Buffer, Buffer_cntr_0, py_Buffer_0);
		}
	}
	return py_Buffer;
}

static int py_DNS_RPC_BUFFER_set_Buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_BUFFER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Buffer");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Buffer_cntr_0;
		object->Buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->Buffer, PyList_GET_SIZE(value));
		if (!object->Buffer) { return -1; }
		talloc_set_name_const(object->Buffer, "ARRAY: object->Buffer");
		for (Buffer_cntr_0 = 0; Buffer_cntr_0 < PyList_GET_SIZE(value); Buffer_cntr_0++) {
			if (PyList_GET_ITEM(value, Buffer_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Buffer)[Buffer_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Buffer)[Buffer_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Buffer_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Buffer_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Buffer)[Buffer_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_BUFFER_getsetters[] = {
	{
		.name = discard_const_p(char, "dwLength"),
		.get = py_DNS_RPC_BUFFER_get_dwLength,
		.set = py_DNS_RPC_BUFFER_set_dwLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Buffer"),
		.get = py_DNS_RPC_BUFFER_get_Buffer,
		.set = py_DNS_RPC_BUFFER_set_Buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_BUFFER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_BUFFER, type);
}


static PyTypeObject DNS_RPC_BUFFER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_BUFFER",
	.tp_getset = py_DNS_RPC_BUFFER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_BUFFER_new,
};


static PyObject *py_DNS_RPC_UTF8_STRING_LIST_get_dwCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_UTF8_STRING_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_dwCount;
	py_dwCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwCount));
	return py_dwCount;
}

static int py_DNS_RPC_UTF8_STRING_LIST_set_dwCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_UTF8_STRING_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_UTF8_STRING_LIST_get_pszStrings(PyObject *obj, void *closure)
{
	struct DNS_RPC_UTF8_STRING_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_pszStrings;
	py_pszStrings = PyList_New(object->dwCount);
	if (py_pszStrings == NULL) {
		return NULL;
	}
	{
		int pszStrings_cntr_0;
		for (pszStrings_cntr_0 = 0; pszStrings_cntr_0 < (object->dwCount); pszStrings_cntr_0++) {
			PyObject *py_pszStrings_0;
			if ((object->pszStrings)[pszStrings_cntr_0] == NULL) {
				py_pszStrings_0 = Py_None;
				Py_INCREF(py_pszStrings_0);
			} else {
				if ((object->pszStrings)[pszStrings_cntr_0] == NULL) {
					py_pszStrings_0 = Py_None;
					Py_INCREF(py_pszStrings_0);
				} else {
					py_pszStrings_0 = PyUnicode_Decode((object->pszStrings)[pszStrings_cntr_0], strlen((object->pszStrings)[pszStrings_cntr_0]), "utf-8", "ignore");
				}
			}
			PyList_SetItem(py_pszStrings, pszStrings_cntr_0, py_pszStrings_0);
		}
	}
	return py_pszStrings;
}

static int py_DNS_RPC_UTF8_STRING_LIST_set_pszStrings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_UTF8_STRING_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszStrings");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pszStrings_cntr_0;
		object->pszStrings = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pszStrings, PyList_GET_SIZE(value));
		if (!object->pszStrings) { return -1; }
		talloc_set_name_const(object->pszStrings, "ARRAY: object->pszStrings");
		for (pszStrings_cntr_0 = 0; pszStrings_cntr_0 < PyList_GET_SIZE(value); pszStrings_cntr_0++) {
			if (PyList_GET_ITEM(value, pszStrings_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->pszStrings)[pszStrings_cntr_0]");
				return -1;
			}
			if (PyList_GET_ITEM(value, pszStrings_cntr_0) == Py_None) {
				(object->pszStrings)[pszStrings_cntr_0] = NULL;
			} else {
				(object->pszStrings)[pszStrings_cntr_0] = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(PyList_GET_ITEM(value, pszStrings_cntr_0))) {
						unicode = PyUnicode_AsEncodedString(PyList_GET_ITEM(value, pszStrings_cntr_0), "utf-8", "ignore");
						if (unicode == NULL) {
							return -1;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(PyList_GET_ITEM(value, pszStrings_cntr_0))) {
						test_str = PyBytes_AS_STRING(PyList_GET_ITEM(value, pszStrings_cntr_0));
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(PyList_GET_ITEM(value, pszStrings_cntr_0))->tp_name);
						return -1;
					}
					talloc_str = talloc_strdup(object->pszStrings, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						return -1;
					}
					(object->pszStrings)[pszStrings_cntr_0] = talloc_str;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_UTF8_STRING_LIST_getsetters[] = {
	{
		.name = discard_const_p(char, "dwCount"),
		.get = py_DNS_RPC_UTF8_STRING_LIST_get_dwCount,
		.set = py_DNS_RPC_UTF8_STRING_LIST_set_dwCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszStrings"),
		.get = py_DNS_RPC_UTF8_STRING_LIST_get_pszStrings,
		.set = py_DNS_RPC_UTF8_STRING_LIST_set_pszStrings,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_UTF8_STRING_LIST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_UTF8_STRING_LIST, type);
}


static PyTypeObject DNS_RPC_UTF8_STRING_LIST_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_UTF8_STRING_LIST",
	.tp_getset = py_DNS_RPC_UTF8_STRING_LIST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_UTF8_STRING_LIST_new,
};


static PyObject *py_DNS_RPC_NAME_AND_PARAM_get_dwParam(PyObject *obj, void *closure)
{
	struct DNS_RPC_NAME_AND_PARAM *object = pytalloc_get_ptr(obj);
	PyObject *py_dwParam;
	py_dwParam = PyLong_FromUnsignedLongLong((uint32_t)(object->dwParam));
	return py_dwParam;
}

static int py_DNS_RPC_NAME_AND_PARAM_set_dwParam(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NAME_AND_PARAM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwParam");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwParam));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwParam = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_NAME_AND_PARAM_get_pszNodeName(PyObject *obj, void *closure)
{
	struct DNS_RPC_NAME_AND_PARAM *object = pytalloc_get_ptr(obj);
	PyObject *py_pszNodeName;
	if (object->pszNodeName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszNodeName == NULL) {
		py_pszNodeName = Py_None;
		Py_INCREF(py_pszNodeName);
	} else {
		if (object->pszNodeName == NULL) {
			py_pszNodeName = Py_None;
			Py_INCREF(py_pszNodeName);
		} else {
			py_pszNodeName = PyUnicode_Decode(object->pszNodeName, strlen(object->pszNodeName), "utf-8", "ignore");
		}
	}
	return py_pszNodeName;
}

static int py_DNS_RPC_NAME_AND_PARAM_set_pszNodeName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NAME_AND_PARAM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszNodeName");
		return -1;
	}
	if (value == Py_None) {
		object->pszNodeName = NULL;
	} else {
		object->pszNodeName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszNodeName = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_NAME_AND_PARAM_getsetters[] = {
	{
		.name = discard_const_p(char, "dwParam"),
		.get = py_DNS_RPC_NAME_AND_PARAM_get_dwParam,
		.set = py_DNS_RPC_NAME_AND_PARAM_set_dwParam,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszNodeName"),
		.get = py_DNS_RPC_NAME_AND_PARAM_get_pszNodeName,
		.set = py_DNS_RPC_NAME_AND_PARAM_set_pszNodeName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_NAME_AND_PARAM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_NAME_AND_PARAM, type);
}


static PyTypeObject DNS_RPC_NAME_AND_PARAM_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_NAME_AND_PARAM",
	.tp_getset = py_DNS_RPC_NAME_AND_PARAM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_NAME_AND_PARAM_new,
};


static PyObject *py_DNS_RPC_NAME_get_len(PyObject *obj, void *closure)
{
	struct DNS_RPC_NAME *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromLong((uint16_t)(object->len));
	return py_len;
}

static int py_DNS_RPC_NAME_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_NAME_get_str(PyObject *obj, void *closure)
{
	struct DNS_RPC_NAME *object = pytalloc_get_ptr(obj);
	PyObject *py_str;
	if (object->str == NULL) {
		py_str = Py_None;
		Py_INCREF(py_str);
	} else {
		py_str = PyUnicode_Decode(object->str, strlen(object->str), "utf-8", "ignore");
	}
	return py_str;
}

static int py_DNS_RPC_NAME_set_str(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NAME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->str");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->str = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_NAME_getsetters[] = {
	{
		.name = discard_const_p(char, "len"),
		.get = py_DNS_RPC_NAME_get_len,
		.set = py_DNS_RPC_NAME_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "str"),
		.get = py_DNS_RPC_NAME_get_str,
		.set = py_DNS_RPC_NAME_set_str,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_NAME_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_NAME, type);
}

static PyObject *py_DNS_RPC_NAME_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct DNS_RPC_NAME *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_NAME);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_DNS_RPC_NAME_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_NAME *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_NAME);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_NAME);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_NAME_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_NAME *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_NAME, "DNS_RPC_NAME", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_NAME, "DNS_RPC_NAME", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_NAME_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_NAME_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_NAME_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_NAME_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_NAME_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_NAME",
	.tp_getset = py_DNS_RPC_NAME_getsetters,
	.tp_methods = py_DNS_RPC_NAME_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_NAME_new,
};


static PyObject *py_DNS_RPC_NODE_get_wLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(obj);
	PyObject *py_wLength;
	py_wLength = PyLong_FromLong((uint16_t)(object->wLength));
	return py_wLength;
}

static int py_DNS_RPC_NODE_set_wLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_NODE_get_wRecordCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(obj);
	PyObject *py_wRecordCount;
	py_wRecordCount = PyLong_FromLong((uint16_t)(object->wRecordCount));
	return py_wRecordCount;
}

static int py_DNS_RPC_NODE_set_wRecordCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wRecordCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wRecordCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wRecordCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_NODE_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFlags));
	return py_dwFlags;
}

static int py_DNS_RPC_NODE_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_NODE_get_dwChildCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwChildCount;
	py_dwChildCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwChildCount));
	return py_dwChildCount;
}

static int py_DNS_RPC_NODE_set_dwChildCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwChildCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwChildCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwChildCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_NODE_get_dnsNodeName(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(obj);
	PyObject *py_dnsNodeName;
	py_dnsNodeName = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->dnsNodeName);
	return py_dnsNodeName;
}

static int py_DNS_RPC_NODE_set_dnsNodeName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dnsNodeName");
		return -1;
	}
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dnsNodeName = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_NODE_getsetters[] = {
	{
		.name = discard_const_p(char, "wLength"),
		.get = py_DNS_RPC_NODE_get_wLength,
		.set = py_DNS_RPC_NODE_set_wLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wRecordCount"),
		.get = py_DNS_RPC_NODE_get_wRecordCount,
		.set = py_DNS_RPC_NODE_set_wRecordCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dwFlags"),
		.get = py_DNS_RPC_NODE_get_dwFlags,
		.set = py_DNS_RPC_NODE_set_dwFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwChildCount"),
		.get = py_DNS_RPC_NODE_get_dwChildCount,
		.set = py_DNS_RPC_NODE_set_dwChildCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dnsNodeName"),
		.get = py_DNS_RPC_NODE_get_dnsNodeName,
		.set = py_DNS_RPC_NODE_set_dnsNodeName,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_NAME")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_NODE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_NODE, type);
}


static PyTypeObject DNS_RPC_NODE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_NODE",
	.tp_getset = py_DNS_RPC_NODE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_NODE_new,
};


static PyObject *py_DNS_RPC_RECORD_SOA_get_dwSerialNo(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(obj);
	PyObject *py_dwSerialNo;
	py_dwSerialNo = PyLong_FromUnsignedLongLong((uint32_t)(object->dwSerialNo));
	return py_dwSerialNo;
}

static int py_DNS_RPC_RECORD_SOA_set_dwSerialNo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwSerialNo");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwSerialNo));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwSerialNo = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_dwRefresh(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRefresh;
	py_dwRefresh = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRefresh));
	return py_dwRefresh;
}

static int py_DNS_RPC_RECORD_SOA_set_dwRefresh(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRefresh");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRefresh));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRefresh = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_dwRetry(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRetry;
	py_dwRetry = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRetry));
	return py_dwRetry;
}

static int py_DNS_RPC_RECORD_SOA_set_dwRetry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRetry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRetry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRetry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_dwExpire(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(obj);
	PyObject *py_dwExpire;
	py_dwExpire = PyLong_FromUnsignedLongLong((uint32_t)(object->dwExpire));
	return py_dwExpire;
}

static int py_DNS_RPC_RECORD_SOA_set_dwExpire(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwExpire");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwExpire));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwExpire = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_dwMinimumTtl(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(obj);
	PyObject *py_dwMinimumTtl;
	py_dwMinimumTtl = PyLong_FromUnsignedLongLong((uint32_t)(object->dwMinimumTtl));
	return py_dwMinimumTtl;
}

static int py_DNS_RPC_RECORD_SOA_set_dwMinimumTtl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwMinimumTtl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwMinimumTtl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwMinimumTtl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_NamePrimaryServer(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(obj);
	PyObject *py_NamePrimaryServer;
	py_NamePrimaryServer = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->NamePrimaryServer);
	return py_NamePrimaryServer;
}

static int py_DNS_RPC_RECORD_SOA_set_NamePrimaryServer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NamePrimaryServer");
		return -1;
	}
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->NamePrimaryServer = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_ZoneAdministratorEmail(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(obj);
	PyObject *py_ZoneAdministratorEmail;
	py_ZoneAdministratorEmail = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->ZoneAdministratorEmail);
	return py_ZoneAdministratorEmail;
}

static int py_DNS_RPC_RECORD_SOA_set_ZoneAdministratorEmail(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ZoneAdministratorEmail");
		return -1;
	}
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ZoneAdministratorEmail = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_SOA_getsetters[] = {
	{
		.name = discard_const_p(char, "dwSerialNo"),
		.get = py_DNS_RPC_RECORD_SOA_get_dwSerialNo,
		.set = py_DNS_RPC_RECORD_SOA_set_dwSerialNo,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRefresh"),
		.get = py_DNS_RPC_RECORD_SOA_get_dwRefresh,
		.set = py_DNS_RPC_RECORD_SOA_set_dwRefresh,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRetry"),
		.get = py_DNS_RPC_RECORD_SOA_get_dwRetry,
		.set = py_DNS_RPC_RECORD_SOA_set_dwRetry,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwExpire"),
		.get = py_DNS_RPC_RECORD_SOA_get_dwExpire,
		.set = py_DNS_RPC_RECORD_SOA_set_dwExpire,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwMinimumTtl"),
		.get = py_DNS_RPC_RECORD_SOA_get_dwMinimumTtl,
		.set = py_DNS_RPC_RECORD_SOA_set_dwMinimumTtl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "NamePrimaryServer"),
		.get = py_DNS_RPC_RECORD_SOA_get_NamePrimaryServer,
		.set = py_DNS_RPC_RECORD_SOA_set_NamePrimaryServer,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_NAME")
	},
	{
		.name = discard_const_p(char, "ZoneAdministratorEmail"),
		.get = py_DNS_RPC_RECORD_SOA_get_ZoneAdministratorEmail,
		.set = py_DNS_RPC_RECORD_SOA_set_ZoneAdministratorEmail,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_NAME")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_RECORD_SOA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_SOA, type);
}


static PyTypeObject DNS_RPC_RECORD_SOA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORD_SOA",
	.tp_getset = py_DNS_RPC_RECORD_SOA_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORD_SOA_new,
};


static PyObject *py_DNS_RPC_RECORD_NAME_PREFERENCE_get_wPreference(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_NAME_PREFERENCE *object = pytalloc_get_ptr(obj);
	PyObject *py_wPreference;
	py_wPreference = PyLong_FromLong((uint16_t)(object->wPreference));
	return py_wPreference;
}

static int py_DNS_RPC_RECORD_NAME_PREFERENCE_set_wPreference(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_NAME_PREFERENCE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wPreference");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wPreference));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wPreference = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_NAME_PREFERENCE_get_nameExchange(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_NAME_PREFERENCE *object = pytalloc_get_ptr(obj);
	PyObject *py_nameExchange;
	py_nameExchange = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->nameExchange);
	return py_nameExchange;
}

static int py_DNS_RPC_RECORD_NAME_PREFERENCE_set_nameExchange(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_NAME_PREFERENCE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nameExchange");
		return -1;
	}
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nameExchange = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_NAME_PREFERENCE_getsetters[] = {
	{
		.name = discard_const_p(char, "wPreference"),
		.get = py_DNS_RPC_RECORD_NAME_PREFERENCE_get_wPreference,
		.set = py_DNS_RPC_RECORD_NAME_PREFERENCE_set_wPreference,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nameExchange"),
		.get = py_DNS_RPC_RECORD_NAME_PREFERENCE_get_nameExchange,
		.set = py_DNS_RPC_RECORD_NAME_PREFERENCE_set_nameExchange,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_NAME")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_RECORD_NAME_PREFERENCE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_NAME_PREFERENCE, type);
}


static PyTypeObject DNS_RPC_RECORD_NAME_PREFERENCE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORD_NAME_PREFERENCE",
	.tp_getset = py_DNS_RPC_RECORD_NAME_PREFERENCE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORD_NAME_PREFERENCE_new,
};


static PyObject *py_DNS_RPC_RECORD_STRING_get_count(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_STRING *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromLong((uint16_t)(object->count));
	return py_count;
}

static int py_DNS_RPC_RECORD_STRING_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_STRING *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_STRING_get_str(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_STRING *object = pytalloc_get_ptr(obj);
	PyObject *py_str;
	py_str = PyList_New(object->count);
	if (py_str == NULL) {
		return NULL;
	}
	{
		int str_cntr_0;
		for (str_cntr_0 = 0; str_cntr_0 < (object->count); str_cntr_0++) {
			PyObject *py_str_0;
			py_str_0 = pytalloc_reference_ex(&DNS_RPC_NAME_Type, object->str, &(object->str)[str_cntr_0]);
			PyList_SetItem(py_str, str_cntr_0, py_str_0);
		}
	}
	return py_str;
}

static int py_DNS_RPC_RECORD_STRING_set_str(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_STRING *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->str");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int str_cntr_0;
		object->str = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->str, PyList_GET_SIZE(value));
		if (!object->str) { return -1; }
		talloc_set_name_const(object->str, "ARRAY: object->str");
		for (str_cntr_0 = 0; str_cntr_0 < PyList_GET_SIZE(value); str_cntr_0++) {
			if (PyList_GET_ITEM(value, str_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->str)[str_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, PyList_GET_ITEM(value, str_cntr_0), return -1;);
			if (talloc_reference(object->str, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, str_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->str)[str_cntr_0] = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(PyList_GET_ITEM(value, str_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_STRING_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_DNS_RPC_RECORD_STRING_get_count,
		.set = py_DNS_RPC_RECORD_STRING_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "str"),
		.get = py_DNS_RPC_RECORD_STRING_get_str,
		.set = py_DNS_RPC_RECORD_STRING_set_str,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_NAME")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_RECORD_STRING_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_STRING, type);
}


static PyTypeObject DNS_RPC_RECORD_STRING_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORD_STRING",
	.tp_getset = py_DNS_RPC_RECORD_STRING_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORD_STRING_new,
};


static PyObject *py_DNS_RPC_RECORD_SRV_get_wPriority(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = pytalloc_get_ptr(obj);
	PyObject *py_wPriority;
	py_wPriority = PyLong_FromLong((uint16_t)(object->wPriority));
	return py_wPriority;
}

static int py_DNS_RPC_RECORD_SRV_set_wPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wPriority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wPriority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wPriority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SRV_get_wWeight(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = pytalloc_get_ptr(obj);
	PyObject *py_wWeight;
	py_wWeight = PyLong_FromLong((uint16_t)(object->wWeight));
	return py_wWeight;
}

static int py_DNS_RPC_RECORD_SRV_set_wWeight(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wWeight");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wWeight));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wWeight = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SRV_get_wPort(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = pytalloc_get_ptr(obj);
	PyObject *py_wPort;
	py_wPort = PyLong_FromLong((uint16_t)(object->wPort));
	return py_wPort;
}

static int py_DNS_RPC_RECORD_SRV_set_wPort(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wPort");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wPort));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wPort = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SRV_get_nameTarget(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = pytalloc_get_ptr(obj);
	PyObject *py_nameTarget;
	py_nameTarget = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->nameTarget);
	return py_nameTarget;
}

static int py_DNS_RPC_RECORD_SRV_set_nameTarget(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nameTarget");
		return -1;
	}
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nameTarget = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_SRV_getsetters[] = {
	{
		.name = discard_const_p(char, "wPriority"),
		.get = py_DNS_RPC_RECORD_SRV_get_wPriority,
		.set = py_DNS_RPC_RECORD_SRV_set_wPriority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wWeight"),
		.get = py_DNS_RPC_RECORD_SRV_get_wWeight,
		.set = py_DNS_RPC_RECORD_SRV_set_wWeight,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wPort"),
		.get = py_DNS_RPC_RECORD_SRV_get_wPort,
		.set = py_DNS_RPC_RECORD_SRV_set_wPort,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nameTarget"),
		.get = py_DNS_RPC_RECORD_SRV_get_nameTarget,
		.set = py_DNS_RPC_RECORD_SRV_set_nameTarget,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_NAME")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_RECORD_SRV_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_SRV, type);
}


static PyTypeObject DNS_RPC_RECORD_SRV_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORD_SRV",
	.tp_getset = py_DNS_RPC_RECORD_SRV_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORD_SRV_new,
};

static PyObject *py_import_DNS_RPC_RECORD_DATA(TALLOC_CTX *mem_ctx, int level, union DNS_RPC_RECORD_DATA *in)
{
	PyObject *ret;

	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			ret = PyLong_FromUnsignedLongLong(in->EntombedTime);
			return ret;

		case DNS_TYPE_A:
			ret = PyString_FromStringOrNULL(in->ipv4);
			return ret;

		case DNS_TYPE_NS:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_MD:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_MF:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_CNAME:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_SOA:
			ret = pytalloc_reference_ex(&DNS_RPC_RECORD_SOA_Type, mem_ctx, &in->soa);
			return ret;

		case DNS_TYPE_MB:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_MG:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_MR:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_PTR:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->ptr);
			return ret;

		case DNS_TYPE_HINFO:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->hinfo);
			return ret;

		case DNS_TYPE_MX:
			ret = pytalloc_reference_ex(&DNS_RPC_RECORD_NAME_PREFERENCE_Type, mem_ctx, &in->mx);
			return ret;

		case DNS_TYPE_TXT:
			ret = pytalloc_reference_ex(&DNS_RPC_RECORD_STRING_Type, mem_ctx, &in->txt);
			return ret;

		case DNS_TYPE_AAAA:
			ret = PyString_FromStringOrNULL(in->ipv6);
			return ret;

		case DNS_TYPE_SRV:
			ret = pytalloc_reference_ex(&DNS_RPC_RECORD_SRV_Type, mem_ctx, &in->srv);
			return ret;

		case DNS_TYPE_DNAME:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union DNS_RPC_RECORD_DATA *py_export_DNS_RPC_RECORD_DATA(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union DNS_RPC_RECORD_DATA *ret = talloc_zero(mem_ctx, union DNS_RPC_RECORD_DATA);
	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->EntombedTime");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->EntombedTime));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->EntombedTime = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DNS_TYPE_A:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ipv4");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ipv4 = talloc_str;
			}
			break;

		case DNS_TYPE_NS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MF:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_CNAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_SOA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->soa");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_RECORD_SOA_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->soa = *(struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MB:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MG:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_PTR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ptr");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ptr = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_HINFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->hinfo");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->hinfo = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->mx");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_RECORD_NAME_PREFERENCE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mx = *(struct DNS_RPC_RECORD_NAME_PREFERENCE *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_TXT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->txt");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_RECORD_STRING_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->txt = *(struct DNS_RPC_RECORD_STRING *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_AAAA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ipv6");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ipv6 = talloc_str;
			}
			break;

		case DNS_TYPE_SRV:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->srv");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_RECORD_SRV_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->srv = *(struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_DNAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_DNS_RPC_RECORD_DATA_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union DNS_RPC_RECORD_DATA *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union DNS_RPC_RECORD_DATA *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union DNS_RPC_RECORD_DATA!");
		return NULL;
	}

	return py_import_DNS_RPC_RECORD_DATA(mem_ctx, level, in);
}

static PyObject *py_DNS_RPC_RECORD_DATA_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union DNS_RPC_RECORD_DATA *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_DNS_RPC_RECORD_DATA(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_DNS_RPC_RECORD_DATA_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_RECORD_DATA_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_RECORD_DATA_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_DNS_RPC_RECORD_DATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject DNS_RPC_RECORD_DATA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORD_DATA",
	.tp_getset = NULL,
	.tp_methods = py_DNS_RPC_RECORD_DATA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORD_DATA_new,
};


static PyObject *py_DNS_RPC_RECORD_get_wDataLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(obj);
	PyObject *py_wDataLength;
	py_wDataLength = PyLong_FromLong((uint16_t)(object->wDataLength));
	return py_wDataLength;
}

static int py_DNS_RPC_RECORD_set_wDataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wDataLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wDataLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wDataLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_wType(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(obj);
	PyObject *py_wType;
	py_wType = PyLong_FromLong((uint16_t)(object->wType));
	return py_wType;
}

static int py_DNS_RPC_RECORD_set_wType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFlags));
	return py_dwFlags;
}

static int py_DNS_RPC_RECORD_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwSerial(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(obj);
	PyObject *py_dwSerial;
	py_dwSerial = PyLong_FromUnsignedLongLong((uint32_t)(object->dwSerial));
	return py_dwSerial;
}

static int py_DNS_RPC_RECORD_set_dwSerial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwSerial");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwSerial));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwSerial = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwTtlSeconds(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTtlSeconds;
	py_dwTtlSeconds = PyLong_FromUnsignedLongLong((uint32_t)(object->dwTtlSeconds));
	return py_dwTtlSeconds;
}

static int py_DNS_RPC_RECORD_set_dwTtlSeconds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwTtlSeconds");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwTtlSeconds));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwTtlSeconds = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwTimeStamp(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTimeStamp;
	py_dwTimeStamp = PyLong_FromUnsignedLongLong((uint32_t)(object->dwTimeStamp));
	return py_dwTimeStamp;
}

static int py_DNS_RPC_RECORD_set_dwTimeStamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwTimeStamp");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwTimeStamp));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwTimeStamp = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved));
	return py_dwReserved;
}

static int py_DNS_RPC_RECORD_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_data(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pyrpc_import_union(&DNS_RPC_RECORD_DATA_Type, pytalloc_get_mem_ctx(obj), object->wType, &object->data, "union DNS_RPC_RECORD_DATA");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_DNS_RPC_RECORD_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	{
		union DNS_RPC_RECORD_DATA *data_switch_1;
		data_switch_1 = (union DNS_RPC_RECORD_DATA *)pyrpc_export_union(&DNS_RPC_RECORD_DATA_Type, pytalloc_get_mem_ctx(py_obj), object->wType, value, "union DNS_RPC_RECORD_DATA");
		if (data_switch_1 == NULL) {
			return -1;
		}
		object->data = *data_switch_1;
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_getsetters[] = {
	{
		.name = discard_const_p(char, "wDataLength"),
		.get = py_DNS_RPC_RECORD_get_wDataLength,
		.set = py_DNS_RPC_RECORD_set_wDataLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wType"),
		.get = py_DNS_RPC_RECORD_get_wType,
		.set = py_DNS_RPC_RECORD_set_wType,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_record_type")
	},
	{
		.name = discard_const_p(char, "dwFlags"),
		.get = py_DNS_RPC_RECORD_get_dwFlags,
		.set = py_DNS_RPC_RECORD_set_dwFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwSerial"),
		.get = py_DNS_RPC_RECORD_get_dwSerial,
		.set = py_DNS_RPC_RECORD_set_dwSerial,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwTtlSeconds"),
		.get = py_DNS_RPC_RECORD_get_dwTtlSeconds,
		.set = py_DNS_RPC_RECORD_set_dwTtlSeconds,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwTimeStamp"),
		.get = py_DNS_RPC_RECORD_get_dwTimeStamp,
		.set = py_DNS_RPC_RECORD_set_dwTimeStamp,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved"),
		.get = py_DNS_RPC_RECORD_get_dwReserved,
		.set = py_DNS_RPC_RECORD_set_dwReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_DNS_RPC_RECORD_get_data,
		.set = py_DNS_RPC_RECORD_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_RECORD_DATA")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_RECORD_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD, type);
}

static PyObject *py_DNS_RPC_RECORD_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORD);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_DNS_RPC_RECORD_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORD);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORD);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_RECORD_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORD *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORD, "DNS_RPC_RECORD", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORD, "DNS_RPC_RECORD", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_RECORD_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_RECORD_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_RECORD_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_RECORD_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_RECORD_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORD",
	.tp_getset = py_DNS_RPC_RECORD_getsetters,
	.tp_methods = py_DNS_RPC_RECORD_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORD_new,
};


static PyObject *py_DNS_RPC_RECORD_BUF_get_wContextLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_BUF *object = pytalloc_get_ptr(obj);
	PyObject *py_wContextLength;
	py_wContextLength = PyLong_FromUnsignedLongLong((uint32_t)(object->wContextLength));
	return py_wContextLength;
}

static int py_DNS_RPC_RECORD_BUF_set_wContextLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_BUF *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wContextLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wContextLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wContextLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_BUF_get_rec(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_BUF *object = pytalloc_get_ptr(obj);
	PyObject *py_rec;
	py_rec = pytalloc_reference_ex(&DNS_RPC_RECORD_Type, pytalloc_get_mem_ctx(obj), &object->rec);
	return py_rec;
}

static int py_DNS_RPC_RECORD_BUF_set_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_BUF *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rec");
		return -1;
	}
	PY_CHECK_TYPE(&DNS_RPC_RECORD_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->rec = *(struct DNS_RPC_RECORD *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_BUF_getsetters[] = {
	{
		.name = discard_const_p(char, "wContextLength"),
		.get = py_DNS_RPC_RECORD_BUF_get_wContextLength,
		.set = py_DNS_RPC_RECORD_BUF_set_wContextLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint3264")
	},
	{
		.name = discard_const_p(char, "rec"),
		.get = py_DNS_RPC_RECORD_BUF_get_rec,
		.set = py_DNS_RPC_RECORD_BUF_set_rec,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_RECORD")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_RECORD_BUF_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_BUF, type);
}


static PyTypeObject DNS_RPC_RECORD_BUF_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORD_BUF",
	.tp_getset = py_DNS_RPC_RECORD_BUF_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORD_BUF_new,
};


static PyObject *py_IP4_ARRAY_get_AddrCount(PyObject *obj, void *closure)
{
	struct IP4_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_AddrCount;
	py_AddrCount = PyLong_FromUnsignedLongLong((uint32_t)(object->AddrCount));
	return py_AddrCount;
}

static int py_IP4_ARRAY_set_AddrCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct IP4_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AddrCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AddrCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AddrCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_IP4_ARRAY_get_AddrArray(PyObject *obj, void *closure)
{
	struct IP4_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_AddrArray;
	py_AddrArray = PyList_New(object->AddrCount);
	if (py_AddrArray == NULL) {
		return NULL;
	}
	{
		int AddrArray_cntr_0;
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < (object->AddrCount); AddrArray_cntr_0++) {
			PyObject *py_AddrArray_0;
			py_AddrArray_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->AddrArray)[AddrArray_cntr_0]));
			PyList_SetItem(py_AddrArray, AddrArray_cntr_0, py_AddrArray_0);
		}
	}
	return py_AddrArray;
}

static int py_IP4_ARRAY_set_AddrArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct IP4_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AddrArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int AddrArray_cntr_0;
		object->AddrArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->AddrArray, PyList_GET_SIZE(value));
		if (!object->AddrArray) { return -1; }
		talloc_set_name_const(object->AddrArray, "ARRAY: object->AddrArray");
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < PyList_GET_SIZE(value); AddrArray_cntr_0++) {
			if (PyList_GET_ITEM(value, AddrArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->AddrArray)[AddrArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->AddrArray)[AddrArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, AddrArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, AddrArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->AddrArray)[AddrArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_IP4_ARRAY_getsetters[] = {
	{
		.name = discard_const_p(char, "AddrCount"),
		.get = py_IP4_ARRAY_get_AddrCount,
		.set = py_IP4_ARRAY_set_AddrCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "AddrArray"),
		.get = py_IP4_ARRAY_get_AddrArray,
		.set = py_IP4_ARRAY_set_AddrArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_IP4_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct IP4_ARRAY, type);
}


static PyTypeObject IP4_ARRAY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.IP4_ARRAY",
	.tp_getset = py_IP4_ARRAY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_IP4_ARRAY_new,
};


static PyObject *py_DNS_ADDR_get_MaxSa(PyObject *obj, void *closure)
{
	struct DNS_ADDR *object = pytalloc_get_ptr(obj);
	PyObject *py_MaxSa;
	py_MaxSa = PyList_New(32);
	if (py_MaxSa == NULL) {
		return NULL;
	}
	{
		int MaxSa_cntr_0;
		for (MaxSa_cntr_0 = 0; MaxSa_cntr_0 < (32); MaxSa_cntr_0++) {
			PyObject *py_MaxSa_0;
			py_MaxSa_0 = PyLong_FromLong((uint16_t)((object->MaxSa)[MaxSa_cntr_0]));
			PyList_SetItem(py_MaxSa, MaxSa_cntr_0, py_MaxSa_0);
		}
	}
	return py_MaxSa;
}

static int py_DNS_ADDR_set_MaxSa(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MaxSa");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int MaxSa_cntr_0;
		if (ARRAY_SIZE(object->MaxSa) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->MaxSa),  PyList_GET_SIZE(value));
			return -1;
		}
		for (MaxSa_cntr_0 = 0; MaxSa_cntr_0 < PyList_GET_SIZE(value); MaxSa_cntr_0++) {
			if (PyList_GET_ITEM(value, MaxSa_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->MaxSa)[MaxSa_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->MaxSa)[MaxSa_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, MaxSa_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, MaxSa_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->MaxSa)[MaxSa_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_get_DnsAddrUserDword(PyObject *obj, void *closure)
{
	struct DNS_ADDR *object = pytalloc_get_ptr(obj);
	PyObject *py_DnsAddrUserDword;
	py_DnsAddrUserDword = PyList_New(8);
	if (py_DnsAddrUserDword == NULL) {
		return NULL;
	}
	{
		int DnsAddrUserDword_cntr_0;
		for (DnsAddrUserDword_cntr_0 = 0; DnsAddrUserDword_cntr_0 < (8); DnsAddrUserDword_cntr_0++) {
			PyObject *py_DnsAddrUserDword_0;
			py_DnsAddrUserDword_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->DnsAddrUserDword)[DnsAddrUserDword_cntr_0]));
			PyList_SetItem(py_DnsAddrUserDword, DnsAddrUserDword_cntr_0, py_DnsAddrUserDword_0);
		}
	}
	return py_DnsAddrUserDword;
}

static int py_DNS_ADDR_set_DnsAddrUserDword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DnsAddrUserDword");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int DnsAddrUserDword_cntr_0;
		if (ARRAY_SIZE(object->DnsAddrUserDword) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->DnsAddrUserDword),  PyList_GET_SIZE(value));
			return -1;
		}
		for (DnsAddrUserDword_cntr_0 = 0; DnsAddrUserDword_cntr_0 < PyList_GET_SIZE(value); DnsAddrUserDword_cntr_0++) {
			if (PyList_GET_ITEM(value, DnsAddrUserDword_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->DnsAddrUserDword)[DnsAddrUserDword_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->DnsAddrUserDword)[DnsAddrUserDword_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, DnsAddrUserDword_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, DnsAddrUserDword_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->DnsAddrUserDword)[DnsAddrUserDword_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_ADDR_getsetters[] = {
	{
		.name = discard_const_p(char, "MaxSa"),
		.get = py_DNS_ADDR_get_MaxSa,
		.set = py_DNS_ADDR_set_MaxSa,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "DnsAddrUserDword"),
		.get = py_DNS_ADDR_get_DnsAddrUserDword,
		.set = py_DNS_ADDR_set_DnsAddrUserDword,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_ADDR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_ADDR, type);
}


static PyTypeObject DNS_ADDR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_ADDR",
	.tp_getset = py_DNS_ADDR_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_ADDR_new,
};


static PyObject *py_DNS_ADDR_ARRAY_get_MaxCount(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_MaxCount;
	py_MaxCount = PyLong_FromUnsignedLongLong((uint32_t)(object->MaxCount));
	return py_MaxCount;
}

static int py_DNS_ADDR_ARRAY_set_MaxCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MaxCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MaxCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MaxCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_AddrCount(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_AddrCount;
	py_AddrCount = PyLong_FromUnsignedLongLong((uint32_t)(object->AddrCount));
	return py_AddrCount;
}

static int py_DNS_ADDR_ARRAY_set_AddrCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AddrCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AddrCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AddrCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Tag(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_Tag;
	py_Tag = PyLong_FromUnsignedLongLong((uint32_t)(object->Tag));
	return py_Tag;
}

static int py_DNS_ADDR_ARRAY_set_Tag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Tag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Tag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Tag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Family(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_Family;
	py_Family = PyLong_FromLong((uint16_t)(object->Family));
	return py_Family;
}

static int py_DNS_ADDR_ARRAY_set_Family(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Family");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Family));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Family = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_WordReserved(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_WordReserved;
	py_WordReserved = PyLong_FromLong((uint16_t)(object->WordReserved));
	return py_WordReserved;
}

static int py_DNS_ADDR_ARRAY_set_WordReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->WordReserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->WordReserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->WordReserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Flags(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromUnsignedLongLong((uint32_t)(object->Flags));
	return py_Flags;
}

static int py_DNS_ADDR_ARRAY_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_MatchFlag(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_MatchFlag;
	py_MatchFlag = PyLong_FromUnsignedLongLong((uint32_t)(object->MatchFlag));
	return py_MatchFlag;
}

static int py_DNS_ADDR_ARRAY_set_MatchFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MatchFlag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MatchFlag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MatchFlag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Reserved1(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved1;
	py_Reserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->Reserved1));
	return py_Reserved1;
}

static int py_DNS_ADDR_ARRAY_set_Reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Reserved2(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved2;
	py_Reserved2 = PyLong_FromUnsignedLongLong((uint32_t)(object->Reserved2));
	return py_Reserved2;
}

static int py_DNS_ADDR_ARRAY_set_Reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_AddrArray(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_AddrArray;
	py_AddrArray = PyList_New(object->AddrCount);
	if (py_AddrArray == NULL) {
		return NULL;
	}
	{
		int AddrArray_cntr_0;
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < (object->AddrCount); AddrArray_cntr_0++) {
			PyObject *py_AddrArray_0;
			py_AddrArray_0 = pytalloc_reference_ex(&DNS_ADDR_Type, object->AddrArray, &(object->AddrArray)[AddrArray_cntr_0]);
			PyList_SetItem(py_AddrArray, AddrArray_cntr_0, py_AddrArray_0);
		}
	}
	return py_AddrArray;
}

static int py_DNS_ADDR_ARRAY_set_AddrArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AddrArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int AddrArray_cntr_0;
		object->AddrArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->AddrArray, PyList_GET_SIZE(value));
		if (!object->AddrArray) { return -1; }
		talloc_set_name_const(object->AddrArray, "ARRAY: object->AddrArray");
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < PyList_GET_SIZE(value); AddrArray_cntr_0++) {
			if (PyList_GET_ITEM(value, AddrArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->AddrArray)[AddrArray_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&DNS_ADDR_Type, PyList_GET_ITEM(value, AddrArray_cntr_0), return -1;);
			if (talloc_reference(object->AddrArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, AddrArray_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->AddrArray)[AddrArray_cntr_0] = *(struct DNS_ADDR *)pytalloc_get_ptr(PyList_GET_ITEM(value, AddrArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_ADDR_ARRAY_getsetters[] = {
	{
		.name = discard_const_p(char, "MaxCount"),
		.get = py_DNS_ADDR_ARRAY_get_MaxCount,
		.set = py_DNS_ADDR_ARRAY_set_MaxCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "AddrCount"),
		.get = py_DNS_ADDR_ARRAY_get_AddrCount,
		.set = py_DNS_ADDR_ARRAY_set_AddrCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Tag"),
		.get = py_DNS_ADDR_ARRAY_get_Tag,
		.set = py_DNS_ADDR_ARRAY_set_Tag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Family"),
		.get = py_DNS_ADDR_ARRAY_get_Family,
		.set = py_DNS_ADDR_ARRAY_set_Family,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "WordReserved"),
		.get = py_DNS_ADDR_ARRAY_get_WordReserved,
		.set = py_DNS_ADDR_ARRAY_set_WordReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_DNS_ADDR_ARRAY_get_Flags,
		.set = py_DNS_ADDR_ARRAY_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "MatchFlag"),
		.get = py_DNS_ADDR_ARRAY_get_MatchFlag,
		.set = py_DNS_ADDR_ARRAY_set_MatchFlag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Reserved1"),
		.get = py_DNS_ADDR_ARRAY_get_Reserved1,
		.set = py_DNS_ADDR_ARRAY_set_Reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Reserved2"),
		.get = py_DNS_ADDR_ARRAY_get_Reserved2,
		.set = py_DNS_ADDR_ARRAY_set_Reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "AddrArray"),
		.get = py_DNS_ADDR_ARRAY_get_AddrArray,
		.set = py_DNS_ADDR_ARRAY_set_AddrArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_ADDR_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_ADDR_ARRAY, type);
}


static PyTypeObject DNS_ADDR_ARRAY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_ADDR_ARRAY",
	.tp_getset = py_DNS_ADDR_ARRAY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_ADDR_ARRAY_new,
};


static PyObject *py_DNS_RPC_IP_VALIDATE_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_IP_VALIDATE_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_IP_VALIDATE_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_dwContext(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwContext;
	py_dwContext = PyLong_FromUnsignedLongLong((uint32_t)(object->dwContext));
	return py_dwContext;
}

static int py_DNS_RPC_IP_VALIDATE_set_dwContext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwContext");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwContext));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwContext = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_dwReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved1;
	py_dwReserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved1));
	return py_dwReserved1;
}

static int py_DNS_RPC_IP_VALIDATE_set_dwReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_pszContextName(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(obj);
	PyObject *py_pszContextName;
	if (object->pszContextName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszContextName == NULL) {
		py_pszContextName = Py_None;
		Py_INCREF(py_pszContextName);
	} else {
		if (object->pszContextName == NULL) {
			py_pszContextName = Py_None;
			Py_INCREF(py_pszContextName);
		} else {
			py_pszContextName = PyUnicode_Decode(object->pszContextName, strlen(object->pszContextName), "utf-8", "ignore");
		}
	}
	return py_pszContextName;
}

static int py_DNS_RPC_IP_VALIDATE_set_pszContextName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszContextName");
		return -1;
	}
	if (value == Py_None) {
		object->pszContextName = NULL;
	} else {
		object->pszContextName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszContextName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_aipValidateAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(obj);
	PyObject *py_aipValidateAddrs;
	if (object->aipValidateAddrs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipValidateAddrs == NULL) {
		py_aipValidateAddrs = Py_None;
		Py_INCREF(py_aipValidateAddrs);
	} else {
		py_aipValidateAddrs = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipValidateAddrs, object->aipValidateAddrs);
	}
	return py_aipValidateAddrs;
}

static int py_DNS_RPC_IP_VALIDATE_set_aipValidateAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipValidateAddrs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipValidateAddrs");
		return -1;
	}
	if (value == Py_None) {
		object->aipValidateAddrs = NULL;
	} else {
		object->aipValidateAddrs = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipValidateAddrs = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_IP_VALIDATE_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_IP_VALIDATE_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_IP_VALIDATE_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_IP_VALIDATE_get_dwReserved0,
		.set = py_DNS_RPC_IP_VALIDATE_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwContext"),
		.get = py_DNS_RPC_IP_VALIDATE_get_dwContext,
		.set = py_DNS_RPC_IP_VALIDATE_set_dwContext,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved1"),
		.get = py_DNS_RPC_IP_VALIDATE_get_dwReserved1,
		.set = py_DNS_RPC_IP_VALIDATE_set_dwReserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszContextName"),
		.get = py_DNS_RPC_IP_VALIDATE_get_pszContextName,
		.set = py_DNS_RPC_IP_VALIDATE_set_pszContextName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "aipValidateAddrs"),
		.get = py_DNS_RPC_IP_VALIDATE_get_aipValidateAddrs,
		.set = py_DNS_RPC_IP_VALIDATE_set_aipValidateAddrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_IP_VALIDATE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_IP_VALIDATE, type);
}


static PyTypeObject DNS_RPC_IP_VALIDATE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_IP_VALIDATE",
	.tp_getset = py_DNS_RPC_IP_VALIDATE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_IP_VALIDATE_new,
};


static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwVersion;
	py_dwVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwVersion));
	return py_dwVersion;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fBootMethod(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fBootMethod;
	py_fBootMethod = PyLong_FromLong((uint16_t)(object->fBootMethod));
	return py_fBootMethod;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fBootMethod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fBootMethod");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fBootMethod));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fBootMethod = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fAdminConfigured(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAdminConfigured;
	py_fAdminConfigured = PyLong_FromLong((uint16_t)(object->fAdminConfigured));
	return py_fAdminConfigured;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fAdminConfigured(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAdminConfigured");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAdminConfigured));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAdminConfigured = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fDsAvailable(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fDsAvailable;
	py_fDsAvailable = PyLong_FromLong((uint16_t)(object->fDsAvailable));
	return py_fDsAvailable;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fDsAvailable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDsAvailable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDsAvailable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDsAvailable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pszServerName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszServerName;
	if (object->pszServerName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszServerName == NULL) {
		py_pszServerName = Py_None;
		Py_INCREF(py_pszServerName);
	} else {
		if (object->pszServerName == NULL) {
			py_pszServerName = Py_None;
			Py_INCREF(py_pszServerName);
		} else {
			py_pszServerName = PyUnicode_Decode(object->pszServerName, strlen(object->pszServerName), "utf-8", "ignore");
		}
	}
	return py_pszServerName;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszServerName");
		return -1;
	}
	if (value == Py_None) {
		object->pszServerName = NULL;
	} else {
		object->pszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszServerName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pszDsContainer(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDsContainer;
	if (object->pszDsContainer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDsContainer == NULL) {
		py_pszDsContainer = Py_None;
		Py_INCREF(py_pszDsContainer);
	} else {
		if (object->pszDsContainer == NULL) {
			py_pszDsContainer = Py_None;
			Py_INCREF(py_pszDsContainer);
		} else {
			py_pszDsContainer = PyUnicode_Decode(object->pszDsContainer, strlen(object->pszDsContainer), "utf-8", "ignore");
		}
	}
	return py_pszDsContainer;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pszDsContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDsContainer");
		return -1;
	}
	if (value == Py_None) {
		object->pszDsContainer = NULL;
	} else {
		object->pszDsContainer = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDsContainer = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_aipServerAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipServerAddrs;
	if (object->aipServerAddrs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipServerAddrs == NULL) {
		py_aipServerAddrs = Py_None;
		Py_INCREF(py_aipServerAddrs);
	} else {
		py_aipServerAddrs = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipServerAddrs, object->aipServerAddrs);
	}
	return py_aipServerAddrs;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_aipServerAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipServerAddrs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipServerAddrs");
		return -1;
	}
	if (value == Py_None) {
		object->aipServerAddrs = NULL;
	} else {
		object->aipServerAddrs = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipServerAddrs = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_aipListenAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipListenAddrs;
	if (object->aipListenAddrs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipListenAddrs == NULL) {
		py_aipListenAddrs = Py_None;
		Py_INCREF(py_aipListenAddrs);
	} else {
		py_aipListenAddrs = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipListenAddrs, object->aipListenAddrs);
	}
	return py_aipListenAddrs;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_aipListenAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipListenAddrs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipListenAddrs");
		return -1;
	}
	if (value == Py_None) {
		object->aipListenAddrs = NULL;
	} else {
		object->aipListenAddrs = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipListenAddrs = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipForwarders));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipForwarders");
		return -1;
	}
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension1(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pExtension1;
	if (object->pExtension1 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pExtension1 == NULL) {
		py_pExtension1 = Py_None;
		Py_INCREF(py_pExtension1);
	} else {
		py_pExtension1 = PyLong_FromUnsignedLongLong((uint32_t)(*object->pExtension1));
	}
	return py_pExtension1;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pExtension1));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pExtension1");
		return -1;
	}
	if (value == Py_None) {
		object->pExtension1 = NULL;
	} else {
		object->pExtension1 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension1);
		if (object->pExtension1 == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->pExtension1));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->pExtension1 = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension2(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pExtension2;
	if (object->pExtension2 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pExtension2 == NULL) {
		py_pExtension2 = Py_None;
		Py_INCREF(py_pExtension2);
	} else {
		py_pExtension2 = PyLong_FromUnsignedLongLong((uint32_t)(*object->pExtension2));
	}
	return py_pExtension2;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pExtension2));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pExtension2");
		return -1;
	}
	if (value == Py_None) {
		object->pExtension2 = NULL;
	} else {
		object->pExtension2 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension2);
		if (object->pExtension2 == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->pExtension2));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->pExtension2 = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension3(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pExtension3;
	if (object->pExtension3 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pExtension3 == NULL) {
		py_pExtension3 = Py_None;
		Py_INCREF(py_pExtension3);
	} else {
		py_pExtension3 = PyLong_FromUnsignedLongLong((uint32_t)(*object->pExtension3));
	}
	return py_pExtension3;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pExtension3));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pExtension3");
		return -1;
	}
	if (value == Py_None) {
		object->pExtension3 = NULL;
	} else {
		object->pExtension3 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension3);
		if (object->pExtension3 == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->pExtension3));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->pExtension3 = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension4(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pExtension4;
	if (object->pExtension4 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pExtension4 == NULL) {
		py_pExtension4 = Py_None;
		Py_INCREF(py_pExtension4);
	} else {
		py_pExtension4 = PyLong_FromUnsignedLongLong((uint32_t)(*object->pExtension4));
	}
	return py_pExtension4;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pExtension4));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pExtension4");
		return -1;
	}
	if (value == Py_None) {
		object->pExtension4 = NULL;
	} else {
		object->pExtension4 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension4);
		if (object->pExtension4 == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->pExtension4));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->pExtension4 = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension5(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pExtension5;
	if (object->pExtension5 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pExtension5 == NULL) {
		py_pExtension5 = Py_None;
		Py_INCREF(py_pExtension5);
	} else {
		py_pExtension5 = PyLong_FromUnsignedLongLong((uint32_t)(*object->pExtension5));
	}
	return py_pExtension5;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pExtension5));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pExtension5");
		return -1;
	}
	if (value == Py_None) {
		object->pExtension5 = NULL;
	} else {
		object->pExtension5 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension5);
		if (object->pExtension5 == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->pExtension5));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->pExtension5 = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLogLevel;
	py_dwLogLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLogLevel));
	return py_dwLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLogLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLogLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLogLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwDebugLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDebugLevel;
	py_dwDebugLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDebugLevel));
	return py_dwDebugLevel;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwDebugLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDebugLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDebugLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDebugLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwForwardTimeout));
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwForwardTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwForwardTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwForwardTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwRpcProtocol(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcProtocol;
	py_dwRpcProtocol = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcProtocol));
	return py_dwRpcProtocol;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwRpcProtocol(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcProtocol");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcProtocol));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcProtocol = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwNameCheckFlag(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNameCheckFlag;
	py_dwNameCheckFlag = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNameCheckFlag));
	return py_dwNameCheckFlag;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwNameCheckFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwNameCheckFlag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNameCheckFlag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNameCheckFlag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_cAddressAnswerLimit(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_cAddressAnswerLimit;
	py_cAddressAnswerLimit = PyLong_FromUnsignedLongLong((uint32_t)(object->cAddressAnswerLimit));
	return py_cAddressAnswerLimit;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_cAddressAnswerLimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cAddressAnswerLimit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cAddressAnswerLimit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cAddressAnswerLimit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwRecursionRetry(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionRetry;
	py_dwRecursionRetry = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRecursionRetry));
	return py_dwRecursionRetry;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwRecursionRetry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRecursionRetry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRecursionRetry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRecursionRetry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwRecursionTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionTimeout;
	py_dwRecursionTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRecursionTimeout));
	return py_dwRecursionTimeout;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwRecursionTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRecursionTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRecursionTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRecursionTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwMaxCacheTtl(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwMaxCacheTtl;
	py_dwMaxCacheTtl = PyLong_FromUnsignedLongLong((uint32_t)(object->dwMaxCacheTtl));
	return py_dwMaxCacheTtl;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwMaxCacheTtl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwMaxCacheTtl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwMaxCacheTtl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwMaxCacheTtl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwDsPollingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsPollingInterval;
	py_dwDsPollingInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsPollingInterval));
	return py_dwDsPollingInterval;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwDsPollingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsPollingInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsPollingInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsPollingInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwScavengingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwScavengingInterval;
	py_dwScavengingInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwScavengingInterval));
	return py_dwScavengingInterval;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwScavengingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwScavengingInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwScavengingInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwScavengingInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwDefaultRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultRefreshInterval;
	py_dwDefaultRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDefaultRefreshInterval));
	return py_dwDefaultRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwDefaultRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDefaultRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDefaultRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDefaultRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwDefaultNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultNoRefreshInterval;
	py_dwDefaultNoRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDefaultNoRefreshInterval));
	return py_dwDefaultNoRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwDefaultNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDefaultNoRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDefaultNoRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDefaultNoRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserveArray;
	py_dwReserveArray = PyList_New(10);
	if (py_dwReserveArray == NULL) {
		return NULL;
	}
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < (10); dwReserveArray_cntr_0++) {
			PyObject *py_dwReserveArray_0;
			py_dwReserveArray_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->dwReserveArray)[dwReserveArray_cntr_0]));
			PyList_SetItem(py_dwReserveArray, dwReserveArray_cntr_0, py_dwReserveArray_0);
		}
	}
	return py_dwReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserveArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserveArray_cntr_0;
		if (ARRAY_SIZE(object->dwReserveArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->dwReserveArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < PyList_GET_SIZE(value); dwReserveArray_cntr_0++) {
			if (PyList_GET_ITEM(value, dwReserveArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->dwReserveArray)[dwReserveArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->dwReserveArray)[dwReserveArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, dwReserveArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, dwReserveArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->dwReserveArray)[dwReserveArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fAutoReverseZones(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoReverseZones;
	py_fAutoReverseZones = PyLong_FromLong((uint16_t)(object->fAutoReverseZones));
	return py_fAutoReverseZones;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fAutoReverseZones(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoReverseZones");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoReverseZones));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoReverseZones = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fAutoCacheUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoCacheUpdate;
	py_fAutoCacheUpdate = PyLong_FromLong((uint16_t)(object->fAutoCacheUpdate));
	return py_fAutoCacheUpdate;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fAutoCacheUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoCacheUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoCacheUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoCacheUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyLong_FromLong((uint16_t)(object->fRecurseAfterForwarding));
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRecurseAfterForwarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRecurseAfterForwarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRecurseAfterForwarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fForwardDelegations(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fForwardDelegations;
	py_fForwardDelegations = PyLong_FromLong((uint16_t)(object->fForwardDelegations));
	return py_fForwardDelegations;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fForwardDelegations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fForwardDelegations");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fForwardDelegations));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fForwardDelegations = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fNoRecursion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fNoRecursion;
	py_fNoRecursion = PyLong_FromLong((uint16_t)(object->fNoRecursion));
	return py_fNoRecursion;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fNoRecursion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNoRecursion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNoRecursion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNoRecursion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fSecureResponses(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureResponses;
	py_fSecureResponses = PyLong_FromLong((uint16_t)(object->fSecureResponses));
	return py_fSecureResponses;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fSecureResponses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureResponses");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureResponses));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureResponses = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fRoundRobin(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fRoundRobin;
	py_fRoundRobin = PyLong_FromLong((uint16_t)(object->fRoundRobin));
	return py_fRoundRobin;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fRoundRobin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRoundRobin");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRoundRobin));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRoundRobin = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fLocalNetPriority(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fLocalNetPriority;
	py_fLocalNetPriority = PyLong_FromLong((uint16_t)(object->fLocalNetPriority));
	return py_fLocalNetPriority;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fLocalNetPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLocalNetPriority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLocalNetPriority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLocalNetPriority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fBindSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fBindSecondaries;
	py_fBindSecondaries = PyLong_FromLong((uint16_t)(object->fBindSecondaries));
	return py_fBindSecondaries;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fBindSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fBindSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fBindSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fBindSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fWriteAuthorityNs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fWriteAuthorityNs;
	py_fWriteAuthorityNs = PyLong_FromLong((uint16_t)(object->fWriteAuthorityNs));
	return py_fWriteAuthorityNs;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fWriteAuthorityNs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fWriteAuthorityNs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fWriteAuthorityNs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fWriteAuthorityNs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fStrictFileParsing(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fStrictFileParsing;
	py_fStrictFileParsing = PyLong_FromLong((uint16_t)(object->fStrictFileParsing));
	return py_fStrictFileParsing;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fStrictFileParsing(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fStrictFileParsing");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fStrictFileParsing));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fStrictFileParsing = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fLooseWildcarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fLooseWildcarding;
	py_fLooseWildcarding = PyLong_FromLong((uint16_t)(object->fLooseWildcarding));
	return py_fLooseWildcarding;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fLooseWildcarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLooseWildcarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLooseWildcarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLooseWildcarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fDefaultAgingState(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fDefaultAgingState;
	py_fDefaultAgingState = PyLong_FromLong((uint16_t)(object->fDefaultAgingState));
	return py_fDefaultAgingState;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fDefaultAgingState(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDefaultAgingState");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDefaultAgingState));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDefaultAgingState = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fReserveArray;
	py_fReserveArray = PyList_New(15);
	if (py_fReserveArray == NULL) {
		return NULL;
	}
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < (15); fReserveArray_cntr_0++) {
			PyObject *py_fReserveArray_0;
			py_fReserveArray_0 = PyLong_FromLong((uint16_t)((object->fReserveArray)[fReserveArray_cntr_0]));
			PyList_SetItem(py_fReserveArray, fReserveArray_cntr_0, py_fReserveArray_0);
		}
	}
	return py_fReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReserveArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int fReserveArray_cntr_0;
		if (ARRAY_SIZE(object->fReserveArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->fReserveArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < PyList_GET_SIZE(value); fReserveArray_cntr_0++) {
			if (PyList_GET_ITEM(value, fReserveArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->fReserveArray)[fReserveArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->fReserveArray)[fReserveArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, fReserveArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, fReserveArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->fReserveArray)[fReserveArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_SERVER_INFO_W2K_getsetters[] = {
	{
		.name = discard_const_p(char, "dwVersion"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwVersion,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fBootMethod"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fBootMethod,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fBootMethod,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_BOOT_METHOD")
	},
	{
		.name = discard_const_p(char, "fAdminConfigured"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fAdminConfigured,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fAdminConfigured,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fAllowUpdate,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDsAvailable"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fDsAvailable,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fDsAvailable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszServerName"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_pszServerName,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_pszServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszDsContainer"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_pszDsContainer,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_pszDsContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "aipServerAddrs"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_aipServerAddrs,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_aipServerAddrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipListenAddrs"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_aipListenAddrs,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_aipListenAddrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipForwarders"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_aipForwarders,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_aipForwarders,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "pExtension1"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_pExtension1,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_pExtension1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pExtension2"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_pExtension2,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_pExtension2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pExtension3"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_pExtension3,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_pExtension3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pExtension4"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_pExtension4,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_pExtension4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pExtension5"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_pExtension5,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_pExtension5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLogLevel"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwLogLevel,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwLogLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDebugLevel"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwDebugLevel,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwDebugLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwForwardTimeout"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwForwardTimeout,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwForwardTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRpcProtocol"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwRpcProtocol,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwRpcProtocol,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwNameCheckFlag"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwNameCheckFlag,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwNameCheckFlag,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_NAME_CHECK_FLAG")
	},
	{
		.name = discard_const_p(char, "cAddressAnswerLimit"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_cAddressAnswerLimit,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_cAddressAnswerLimit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRecursionRetry"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwRecursionRetry,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwRecursionRetry,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRecursionTimeout"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwRecursionTimeout,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwRecursionTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwMaxCacheTtl"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwMaxCacheTtl,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwMaxCacheTtl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsPollingInterval"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwDsPollingInterval,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwDsPollingInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwScavengingInterval"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwScavengingInterval,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwScavengingInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDefaultRefreshInterval"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwDefaultRefreshInterval,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwDefaultRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDefaultNoRefreshInterval"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwDefaultNoRefreshInterval,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwDefaultNoRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserveArray"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_dwReserveArray,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_dwReserveArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAutoReverseZones"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fAutoReverseZones,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fAutoReverseZones,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fAutoCacheUpdate"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fAutoCacheUpdate,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fAutoCacheUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fRecurseAfterForwarding"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fRecurseAfterForwarding,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fRecurseAfterForwarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fForwardDelegations"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fForwardDelegations,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fForwardDelegations,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fNoRecursion"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fNoRecursion,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fNoRecursion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fSecureResponses"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fSecureResponses,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fSecureResponses,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fRoundRobin"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fRoundRobin,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fRoundRobin,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fLocalNetPriority"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fLocalNetPriority,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fLocalNetPriority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fBindSecondaries"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fBindSecondaries,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fBindSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fWriteAuthorityNs"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fWriteAuthorityNs,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fWriteAuthorityNs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fStrictFileParsing"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fStrictFileParsing,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fStrictFileParsing,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fLooseWildcarding"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fLooseWildcarding,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fLooseWildcarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDefaultAgingState"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fDefaultAgingState,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fDefaultAgingState,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fReserveArray"),
		.get = py_DNS_RPC_SERVER_INFO_W2K_get_fReserveArray,
		.set = py_DNS_RPC_SERVER_INFO_W2K_set_fReserveArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_SERVER_INFO_W2K, type);
}


static PyTypeObject DNS_RPC_SERVER_INFO_W2K_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_SERVER_INFO_W2K",
	.tp_getset = py_DNS_RPC_SERVER_INFO_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_SERVER_INFO_W2K_new,
};


static PyObject *py_DNS_EXTENSION_get_extension(PyObject *obj, void *closure)
{
	struct DNS_EXTENSION *object = pytalloc_get_ptr(obj);
	PyObject *py_extension;
	if (object->extension == NULL) {
		Py_RETURN_NONE;
	}
	if (object->extension == NULL) {
		py_extension = Py_None;
		Py_INCREF(py_extension);
	} else {
		if (object->extension == NULL) {
			py_extension = Py_None;
			Py_INCREF(py_extension);
		} else {
			py_extension = PyUnicode_Decode(object->extension, strlen(object->extension), "utf-8", "ignore");
		}
	}
	return py_extension;
}

static int py_DNS_EXTENSION_set_extension(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_EXTENSION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extension");
		return -1;
	}
	if (value == Py_None) {
		object->extension = NULL;
	} else {
		object->extension = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->extension = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_EXTENSION_getsetters[] = {
	{
		.name = discard_const_p(char, "extension"),
		.get = py_DNS_EXTENSION_get_extension,
		.set = py_DNS_EXTENSION_set_extension,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_EXTENSION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_EXTENSION, type);
}


static PyTypeObject DNS_EXTENSION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_EXTENSION",
	.tp_getset = py_DNS_EXTENSION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_EXTENSION_new,
};


static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwVersion;
	py_dwVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwVersion));
	return py_dwVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fBootMethod(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fBootMethod;
	py_fBootMethod = PyLong_FromLong((uint16_t)(object->fBootMethod));
	return py_fBootMethod;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fBootMethod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fBootMethod");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fBootMethod));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fBootMethod = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fAdminConfigured(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAdminConfigured;
	py_fAdminConfigured = PyLong_FromLong((uint16_t)(object->fAdminConfigured));
	return py_fAdminConfigured;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fAdminConfigured(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAdminConfigured");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAdminConfigured));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAdminConfigured = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fDsAvailable(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fDsAvailable;
	py_fDsAvailable = PyLong_FromLong((uint16_t)(object->fDsAvailable));
	return py_fDsAvailable;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fDsAvailable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDsAvailable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDsAvailable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDsAvailable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszServerName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszServerName;
	if (object->pszServerName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszServerName == NULL) {
		py_pszServerName = Py_None;
		Py_INCREF(py_pszServerName);
	} else {
		if (object->pszServerName == NULL) {
			py_pszServerName = Py_None;
			Py_INCREF(py_pszServerName);
		} else {
			py_pszServerName = PyUnicode_Decode(object->pszServerName, strlen(object->pszServerName), "utf-8", "ignore");
		}
	}
	return py_pszServerName;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszServerName");
		return -1;
	}
	if (value == Py_None) {
		object->pszServerName = NULL;
	} else {
		object->pszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszServerName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDsContainer(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDsContainer;
	if (object->pszDsContainer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDsContainer == NULL) {
		py_pszDsContainer = Py_None;
		Py_INCREF(py_pszDsContainer);
	} else {
		if (object->pszDsContainer == NULL) {
			py_pszDsContainer = Py_None;
			Py_INCREF(py_pszDsContainer);
		} else {
			py_pszDsContainer = PyUnicode_Decode(object->pszDsContainer, strlen(object->pszDsContainer), "utf-8", "ignore");
		}
	}
	return py_pszDsContainer;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDsContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDsContainer");
		return -1;
	}
	if (value == Py_None) {
		object->pszDsContainer = NULL;
	} else {
		object->pszDsContainer = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDsContainer = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_aipServerAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipServerAddrs;
	if (object->aipServerAddrs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipServerAddrs == NULL) {
		py_aipServerAddrs = Py_None;
		Py_INCREF(py_aipServerAddrs);
	} else {
		py_aipServerAddrs = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipServerAddrs, object->aipServerAddrs);
	}
	return py_aipServerAddrs;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_aipServerAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipServerAddrs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipServerAddrs");
		return -1;
	}
	if (value == Py_None) {
		object->aipServerAddrs = NULL;
	} else {
		object->aipServerAddrs = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipServerAddrs = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_aipListenAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipListenAddrs;
	if (object->aipListenAddrs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipListenAddrs == NULL) {
		py_aipListenAddrs = Py_None;
		Py_INCREF(py_aipListenAddrs);
	} else {
		py_aipListenAddrs = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipListenAddrs, object->aipListenAddrs);
	}
	return py_aipListenAddrs;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_aipListenAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipListenAddrs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipListenAddrs");
		return -1;
	}
	if (value == Py_None) {
		object->aipListenAddrs = NULL;
	} else {
		object->aipListenAddrs = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipListenAddrs = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipForwarders));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipForwarders");
		return -1;
	}
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_aipLogFilter(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipLogFilter;
	if (object->aipLogFilter == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipLogFilter == NULL) {
		py_aipLogFilter = Py_None;
		Py_INCREF(py_aipLogFilter);
	} else {
		py_aipLogFilter = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipLogFilter, object->aipLogFilter);
	}
	return py_aipLogFilter;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_aipLogFilter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipLogFilter));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipLogFilter");
		return -1;
	}
	if (value == Py_None) {
		object->aipLogFilter = NULL;
	} else {
		object->aipLogFilter = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipLogFilter = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pwszLogFilePath(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszLogFilePath;
	if (object->pwszLogFilePath == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pwszLogFilePath == NULL) {
		py_pwszLogFilePath = Py_None;
		Py_INCREF(py_pwszLogFilePath);
	} else {
		if (object->pwszLogFilePath == NULL) {
			py_pwszLogFilePath = Py_None;
			Py_INCREF(py_pwszLogFilePath);
		} else {
			py_pwszLogFilePath = PyUnicode_Decode(object->pwszLogFilePath, strlen(object->pwszLogFilePath), "utf-8", "ignore");
		}
	}
	return py_pwszLogFilePath;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pwszLogFilePath(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwszLogFilePath");
		return -1;
	}
	if (value == Py_None) {
		object->pwszLogFilePath = NULL;
	} else {
		object->pwszLogFilePath = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pwszLogFilePath = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDomainName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDomainName;
	if (object->pszDomainName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDomainName == NULL) {
		py_pszDomainName = Py_None;
		Py_INCREF(py_pszDomainName);
	} else {
		if (object->pszDomainName == NULL) {
			py_pszDomainName = Py_None;
			Py_INCREF(py_pszDomainName);
		} else {
			py_pszDomainName = PyUnicode_Decode(object->pszDomainName, strlen(object->pszDomainName), "utf-8", "ignore");
		}
	}
	return py_pszDomainName;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDomainName");
		return -1;
	}
	if (value == Py_None) {
		object->pszDomainName = NULL;
	} else {
		object->pszDomainName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDomainName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszForestName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszForestName;
	if (object->pszForestName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszForestName == NULL) {
		py_pszForestName = Py_None;
		Py_INCREF(py_pszForestName);
	} else {
		if (object->pszForestName == NULL) {
			py_pszForestName = Py_None;
			Py_INCREF(py_pszForestName);
		} else {
			py_pszForestName = PyUnicode_Decode(object->pszForestName, strlen(object->pszForestName), "utf-8", "ignore");
		}
	}
	return py_pszForestName;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszForestName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszForestName");
		return -1;
	}
	if (value == Py_None) {
		object->pszForestName = NULL;
	} else {
		object->pszForestName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszForestName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDomainDirectoryPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDomainDirectoryPartition;
	if (object->pszDomainDirectoryPartition == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDomainDirectoryPartition == NULL) {
		py_pszDomainDirectoryPartition = Py_None;
		Py_INCREF(py_pszDomainDirectoryPartition);
	} else {
		if (object->pszDomainDirectoryPartition == NULL) {
			py_pszDomainDirectoryPartition = Py_None;
			Py_INCREF(py_pszDomainDirectoryPartition);
		} else {
			py_pszDomainDirectoryPartition = PyUnicode_Decode(object->pszDomainDirectoryPartition, strlen(object->pszDomainDirectoryPartition), "utf-8", "ignore");
		}
	}
	return py_pszDomainDirectoryPartition;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDomainDirectoryPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDomainDirectoryPartition");
		return -1;
	}
	if (value == Py_None) {
		object->pszDomainDirectoryPartition = NULL;
	} else {
		object->pszDomainDirectoryPartition = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDomainDirectoryPartition = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszForestDirectoryPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszForestDirectoryPartition;
	if (object->pszForestDirectoryPartition == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszForestDirectoryPartition == NULL) {
		py_pszForestDirectoryPartition = Py_None;
		Py_INCREF(py_pszForestDirectoryPartition);
	} else {
		if (object->pszForestDirectoryPartition == NULL) {
			py_pszForestDirectoryPartition = Py_None;
			Py_INCREF(py_pszForestDirectoryPartition);
		} else {
			py_pszForestDirectoryPartition = PyUnicode_Decode(object->pszForestDirectoryPartition, strlen(object->pszForestDirectoryPartition), "utf-8", "ignore");
		}
	}
	return py_pszForestDirectoryPartition;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszForestDirectoryPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszForestDirectoryPartition");
		return -1;
	}
	if (value == Py_None) {
		object->pszForestDirectoryPartition = NULL;
	} else {
		object->pszForestDirectoryPartition = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszForestDirectoryPartition = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pExtensions(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pExtensions;
	py_pExtensions = PyList_New(6);
	if (py_pExtensions == NULL) {
		return NULL;
	}
	{
		int pExtensions_cntr_0;
		for (pExtensions_cntr_0 = 0; pExtensions_cntr_0 < (6); pExtensions_cntr_0++) {
			PyObject *py_pExtensions_0;
			py_pExtensions_0 = pytalloc_reference_ex(&DNS_EXTENSION_Type, pytalloc_get_mem_ctx(obj), &(object->pExtensions)[pExtensions_cntr_0]);
			PyList_SetItem(py_pExtensions, pExtensions_cntr_0, py_pExtensions_0);
		}
	}
	return py_pExtensions;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pExtensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pExtensions");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pExtensions_cntr_0;
		if (ARRAY_SIZE(object->pExtensions) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->pExtensions),  PyList_GET_SIZE(value));
			return -1;
		}
		for (pExtensions_cntr_0 = 0; pExtensions_cntr_0 < PyList_GET_SIZE(value); pExtensions_cntr_0++) {
			if (PyList_GET_ITEM(value, pExtensions_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->pExtensions)[pExtensions_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&DNS_EXTENSION_Type, PyList_GET_ITEM(value, pExtensions_cntr_0), return -1;);
			if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pExtensions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->pExtensions)[pExtensions_cntr_0] = *(struct DNS_EXTENSION *)pytalloc_get_ptr(PyList_GET_ITEM(value, pExtensions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLogLevel;
	py_dwLogLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLogLevel));
	return py_dwLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLogLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLogLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLogLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDebugLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDebugLevel;
	py_dwDebugLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDebugLevel));
	return py_dwDebugLevel;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDebugLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDebugLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDebugLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDebugLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwForwardTimeout));
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwForwardTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwForwardTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwForwardTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRpcProtocol(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcProtocol;
	py_dwRpcProtocol = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcProtocol));
	return py_dwRpcProtocol;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRpcProtocol(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcProtocol");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcProtocol));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcProtocol = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwNameCheckFlag(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNameCheckFlag;
	py_dwNameCheckFlag = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNameCheckFlag));
	return py_dwNameCheckFlag;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwNameCheckFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwNameCheckFlag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNameCheckFlag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNameCheckFlag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_cAddressAnswerLimit(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_cAddressAnswerLimit;
	py_cAddressAnswerLimit = PyLong_FromUnsignedLongLong((uint32_t)(object->cAddressAnswerLimit));
	return py_cAddressAnswerLimit;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_cAddressAnswerLimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cAddressAnswerLimit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cAddressAnswerLimit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cAddressAnswerLimit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRecursionRetry(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionRetry;
	py_dwRecursionRetry = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRecursionRetry));
	return py_dwRecursionRetry;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRecursionRetry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRecursionRetry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRecursionRetry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRecursionRetry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRecursionTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionTimeout;
	py_dwRecursionTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRecursionTimeout));
	return py_dwRecursionTimeout;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRecursionTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRecursionTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRecursionTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRecursionTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwMaxCacheTtl(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwMaxCacheTtl;
	py_dwMaxCacheTtl = PyLong_FromUnsignedLongLong((uint32_t)(object->dwMaxCacheTtl));
	return py_dwMaxCacheTtl;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwMaxCacheTtl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwMaxCacheTtl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwMaxCacheTtl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwMaxCacheTtl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsPollingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsPollingInterval;
	py_dwDsPollingInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsPollingInterval));
	return py_dwDsPollingInterval;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsPollingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsPollingInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsPollingInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsPollingInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLocalNetPriorityNetMask(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLocalNetPriorityNetMask;
	py_dwLocalNetPriorityNetMask = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLocalNetPriorityNetMask));
	return py_dwLocalNetPriorityNetMask;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLocalNetPriorityNetMask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLocalNetPriorityNetMask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLocalNetPriorityNetMask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLocalNetPriorityNetMask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwScavengingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwScavengingInterval;
	py_dwScavengingInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwScavengingInterval));
	return py_dwScavengingInterval;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwScavengingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwScavengingInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwScavengingInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwScavengingInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDefaultRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultRefreshInterval;
	py_dwDefaultRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDefaultRefreshInterval));
	return py_dwDefaultRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDefaultRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDefaultRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDefaultRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDefaultRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDefaultNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultNoRefreshInterval;
	py_dwDefaultNoRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDefaultNoRefreshInterval));
	return py_dwDefaultNoRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDefaultNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDefaultNoRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDefaultNoRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDefaultNoRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLastScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLastScavengeTime;
	py_dwLastScavengeTime = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLastScavengeTime));
	return py_dwLastScavengeTime;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLastScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLastScavengeTime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLastScavengeTime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLastScavengeTime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwEventLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwEventLogLevel;
	py_dwEventLogLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwEventLogLevel));
	return py_dwEventLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwEventLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwEventLogLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwEventLogLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwEventLogLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLogFileMaxSize(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLogFileMaxSize;
	py_dwLogFileMaxSize = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLogFileMaxSize));
	return py_dwLogFileMaxSize;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLogFileMaxSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLogFileMaxSize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLogFileMaxSize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLogFileMaxSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsForestVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsForestVersion;
	py_dwDsForestVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsForestVersion));
	return py_dwDsForestVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsForestVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsForestVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsForestVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsForestVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsDomainVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsDomainVersion;
	py_dwDsDomainVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsDomainVersion));
	return py_dwDsDomainVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsDomainVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsDomainVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsDomainVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsDomainVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsDsaVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsDsaVersion;
	py_dwDsDsaVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsDsaVersion));
	return py_dwDsDsaVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsDsaVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsDsaVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsDsaVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsDsaVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserveArray;
	py_dwReserveArray = PyList_New(4);
	if (py_dwReserveArray == NULL) {
		return NULL;
	}
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < (4); dwReserveArray_cntr_0++) {
			PyObject *py_dwReserveArray_0;
			py_dwReserveArray_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->dwReserveArray)[dwReserveArray_cntr_0]));
			PyList_SetItem(py_dwReserveArray, dwReserveArray_cntr_0, py_dwReserveArray_0);
		}
	}
	return py_dwReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserveArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserveArray_cntr_0;
		if (ARRAY_SIZE(object->dwReserveArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->dwReserveArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < PyList_GET_SIZE(value); dwReserveArray_cntr_0++) {
			if (PyList_GET_ITEM(value, dwReserveArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->dwReserveArray)[dwReserveArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->dwReserveArray)[dwReserveArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, dwReserveArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, dwReserveArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->dwReserveArray)[dwReserveArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fAutoReverseZones(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoReverseZones;
	py_fAutoReverseZones = PyLong_FromLong((uint16_t)(object->fAutoReverseZones));
	return py_fAutoReverseZones;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fAutoReverseZones(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoReverseZones");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoReverseZones));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoReverseZones = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fAutoCacheUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoCacheUpdate;
	py_fAutoCacheUpdate = PyLong_FromLong((uint16_t)(object->fAutoCacheUpdate));
	return py_fAutoCacheUpdate;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fAutoCacheUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoCacheUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoCacheUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoCacheUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyLong_FromLong((uint16_t)(object->fRecurseAfterForwarding));
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRecurseAfterForwarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRecurseAfterForwarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRecurseAfterForwarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fForwardDelegations(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fForwardDelegations;
	py_fForwardDelegations = PyLong_FromLong((uint16_t)(object->fForwardDelegations));
	return py_fForwardDelegations;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fForwardDelegations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fForwardDelegations");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fForwardDelegations));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fForwardDelegations = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fNoRecursion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fNoRecursion;
	py_fNoRecursion = PyLong_FromLong((uint16_t)(object->fNoRecursion));
	return py_fNoRecursion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fNoRecursion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNoRecursion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNoRecursion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNoRecursion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fSecureResponses(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureResponses;
	py_fSecureResponses = PyLong_FromLong((uint16_t)(object->fSecureResponses));
	return py_fSecureResponses;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fSecureResponses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureResponses");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureResponses));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureResponses = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fRoundRobin(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fRoundRobin;
	py_fRoundRobin = PyLong_FromLong((uint16_t)(object->fRoundRobin));
	return py_fRoundRobin;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fRoundRobin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRoundRobin");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRoundRobin));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRoundRobin = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fLocalNetPriority(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fLocalNetPriority;
	py_fLocalNetPriority = PyLong_FromLong((uint16_t)(object->fLocalNetPriority));
	return py_fLocalNetPriority;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fLocalNetPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLocalNetPriority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLocalNetPriority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLocalNetPriority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fBindSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fBindSecondaries;
	py_fBindSecondaries = PyLong_FromLong((uint16_t)(object->fBindSecondaries));
	return py_fBindSecondaries;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fBindSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fBindSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fBindSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fBindSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fWriteAuthorityNs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fWriteAuthorityNs;
	py_fWriteAuthorityNs = PyLong_FromLong((uint16_t)(object->fWriteAuthorityNs));
	return py_fWriteAuthorityNs;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fWriteAuthorityNs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fWriteAuthorityNs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fWriteAuthorityNs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fWriteAuthorityNs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fStrictFileParsing(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fStrictFileParsing;
	py_fStrictFileParsing = PyLong_FromLong((uint16_t)(object->fStrictFileParsing));
	return py_fStrictFileParsing;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fStrictFileParsing(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fStrictFileParsing");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fStrictFileParsing));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fStrictFileParsing = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fLooseWildcarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fLooseWildcarding;
	py_fLooseWildcarding = PyLong_FromLong((uint16_t)(object->fLooseWildcarding));
	return py_fLooseWildcarding;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fLooseWildcarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLooseWildcarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLooseWildcarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLooseWildcarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fDefaultAgingState(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fDefaultAgingState;
	py_fDefaultAgingState = PyLong_FromLong((uint16_t)(object->fDefaultAgingState));
	return py_fDefaultAgingState;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fDefaultAgingState(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDefaultAgingState");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDefaultAgingState));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDefaultAgingState = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fReserveArray;
	py_fReserveArray = PyList_New(15);
	if (py_fReserveArray == NULL) {
		return NULL;
	}
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < (15); fReserveArray_cntr_0++) {
			PyObject *py_fReserveArray_0;
			py_fReserveArray_0 = PyLong_FromLong((uint16_t)((object->fReserveArray)[fReserveArray_cntr_0]));
			PyList_SetItem(py_fReserveArray, fReserveArray_cntr_0, py_fReserveArray_0);
		}
	}
	return py_fReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReserveArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int fReserveArray_cntr_0;
		if (ARRAY_SIZE(object->fReserveArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->fReserveArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < PyList_GET_SIZE(value); fReserveArray_cntr_0++) {
			if (PyList_GET_ITEM(value, fReserveArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->fReserveArray)[fReserveArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->fReserveArray)[fReserveArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, fReserveArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, fReserveArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->fReserveArray)[fReserveArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_SERVER_INFO_DOTNET_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwReserved0,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwVersion"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwVersion,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fBootMethod"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fBootMethod,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fBootMethod,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_BOOT_METHOD")
	},
	{
		.name = discard_const_p(char, "fAdminConfigured"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fAdminConfigured,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fAdminConfigured,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fAllowUpdate,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDsAvailable"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fDsAvailable,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fDsAvailable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszServerName"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_pszServerName,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_pszServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszDsContainer"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDsContainer,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDsContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "aipServerAddrs"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_aipServerAddrs,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_aipServerAddrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipListenAddrs"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_aipListenAddrs,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_aipListenAddrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipForwarders"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_aipForwarders,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_aipForwarders,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipLogFilter"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_aipLogFilter,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_aipLogFilter,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "pwszLogFilePath"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_pwszLogFilePath,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_pwszLogFilePath,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "pszDomainName"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDomainName,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDomainName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszForestName"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_pszForestName,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_pszForestName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszDomainDirectoryPartition"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDomainDirectoryPartition,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDomainDirectoryPartition,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszForestDirectoryPartition"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_pszForestDirectoryPartition,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_pszForestDirectoryPartition,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pExtensions"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_pExtensions,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_pExtensions,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_EXTENSION")
	},
	{
		.name = discard_const_p(char, "dwLogLevel"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLogLevel,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLogLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDebugLevel"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDebugLevel,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDebugLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwForwardTimeout"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwForwardTimeout,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwForwardTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRpcProtocol"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRpcProtocol,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRpcProtocol,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwNameCheckFlag"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwNameCheckFlag,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwNameCheckFlag,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_NAME_CHECK_FLAG")
	},
	{
		.name = discard_const_p(char, "cAddressAnswerLimit"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_cAddressAnswerLimit,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_cAddressAnswerLimit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRecursionRetry"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRecursionRetry,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRecursionRetry,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRecursionTimeout"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRecursionTimeout,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRecursionTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwMaxCacheTtl"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwMaxCacheTtl,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwMaxCacheTtl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsPollingInterval"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsPollingInterval,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsPollingInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLocalNetPriorityNetMask"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLocalNetPriorityNetMask,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLocalNetPriorityNetMask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwScavengingInterval"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwScavengingInterval,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwScavengingInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDefaultRefreshInterval"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDefaultRefreshInterval,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDefaultRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDefaultNoRefreshInterval"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDefaultNoRefreshInterval,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDefaultNoRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLastScavengeTime"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLastScavengeTime,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLastScavengeTime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwEventLogLevel"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwEventLogLevel,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwEventLogLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLogFileMaxSize"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLogFileMaxSize,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLogFileMaxSize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsForestVersion"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsForestVersion,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsForestVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsDomainVersion"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsDomainVersion,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsDomainVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsDsaVersion"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsDsaVersion,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsDsaVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserveArray"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_dwReserveArray,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_dwReserveArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAutoReverseZones"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fAutoReverseZones,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fAutoReverseZones,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fAutoCacheUpdate"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fAutoCacheUpdate,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fAutoCacheUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fRecurseAfterForwarding"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fRecurseAfterForwarding,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fRecurseAfterForwarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fForwardDelegations"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fForwardDelegations,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fForwardDelegations,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fNoRecursion"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fNoRecursion,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fNoRecursion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fSecureResponses"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fSecureResponses,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fSecureResponses,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fRoundRobin"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fRoundRobin,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fRoundRobin,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fLocalNetPriority"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fLocalNetPriority,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fLocalNetPriority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fBindSecondaries"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fBindSecondaries,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fBindSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fWriteAuthorityNs"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fWriteAuthorityNs,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fWriteAuthorityNs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fStrictFileParsing"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fStrictFileParsing,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fStrictFileParsing,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fLooseWildcarding"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fLooseWildcarding,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fLooseWildcarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDefaultAgingState"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fDefaultAgingState,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fDefaultAgingState,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fReserveArray"),
		.get = py_DNS_RPC_SERVER_INFO_DOTNET_get_fReserveArray,
		.set = py_DNS_RPC_SERVER_INFO_DOTNET_set_fReserveArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_SERVER_INFO_DOTNET, type);
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_SERVER_INFO_DOTNET);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_SERVER_INFO_DOTNET);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_SERVER_INFO_DOTNET);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_SERVER_INFO_DOTNET, "DNS_RPC_SERVER_INFO_DOTNET", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_SERVER_INFO_DOTNET, "DNS_RPC_SERVER_INFO_DOTNET", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_SERVER_INFO_DOTNET_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_SERVER_INFO_DOTNET_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_SERVER_INFO_DOTNET_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_SERVER_INFO_DOTNET_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_SERVER_INFO_DOTNET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_SERVER_INFO_DOTNET",
	.tp_getset = py_DNS_RPC_SERVER_INFO_DOTNET_getsetters,
	.tp_methods = py_DNS_RPC_SERVER_INFO_DOTNET_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_SERVER_INFO_DOTNET_new,
};


static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwVersion;
	py_dwVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwVersion));
	return py_dwVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fBootMethod(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fBootMethod;
	py_fBootMethod = PyLong_FromLong((uint16_t)(object->fBootMethod));
	return py_fBootMethod;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fBootMethod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fBootMethod");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fBootMethod));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fBootMethod = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAdminConfigured(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAdminConfigured;
	py_fAdminConfigured = PyLong_FromLong((uint16_t)(object->fAdminConfigured));
	return py_fAdminConfigured;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAdminConfigured(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAdminConfigured");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAdminConfigured));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAdminConfigured = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fDsAvailable(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fDsAvailable;
	py_fDsAvailable = PyLong_FromLong((uint16_t)(object->fDsAvailable));
	return py_fDsAvailable;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fDsAvailable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDsAvailable");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDsAvailable));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDsAvailable = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszServerName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszServerName;
	if (object->pszServerName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszServerName == NULL) {
		py_pszServerName = Py_None;
		Py_INCREF(py_pszServerName);
	} else {
		if (object->pszServerName == NULL) {
			py_pszServerName = Py_None;
			Py_INCREF(py_pszServerName);
		} else {
			py_pszServerName = PyUnicode_Decode(object->pszServerName, strlen(object->pszServerName), "utf-8", "ignore");
		}
	}
	return py_pszServerName;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszServerName");
		return -1;
	}
	if (value == Py_None) {
		object->pszServerName = NULL;
	} else {
		object->pszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszServerName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDsContainer(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDsContainer;
	if (object->pszDsContainer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDsContainer == NULL) {
		py_pszDsContainer = Py_None;
		Py_INCREF(py_pszDsContainer);
	} else {
		if (object->pszDsContainer == NULL) {
			py_pszDsContainer = Py_None;
			Py_INCREF(py_pszDsContainer);
		} else {
			py_pszDsContainer = PyUnicode_Decode(object->pszDsContainer, strlen(object->pszDsContainer), "utf-8", "ignore");
		}
	}
	return py_pszDsContainer;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDsContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDsContainer");
		return -1;
	}
	if (value == Py_None) {
		object->pszDsContainer = NULL;
	} else {
		object->pszDsContainer = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDsContainer = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipServerAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipServerAddrs;
	if (object->aipServerAddrs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipServerAddrs == NULL) {
		py_aipServerAddrs = Py_None;
		Py_INCREF(py_aipServerAddrs);
	} else {
		py_aipServerAddrs = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipServerAddrs, object->aipServerAddrs);
	}
	return py_aipServerAddrs;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipServerAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipServerAddrs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipServerAddrs");
		return -1;
	}
	if (value == Py_None) {
		object->aipServerAddrs = NULL;
	} else {
		object->aipServerAddrs = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipServerAddrs = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipListenAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipListenAddrs;
	if (object->aipListenAddrs == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipListenAddrs == NULL) {
		py_aipListenAddrs = Py_None;
		Py_INCREF(py_aipListenAddrs);
	} else {
		py_aipListenAddrs = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipListenAddrs, object->aipListenAddrs);
	}
	return py_aipListenAddrs;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipListenAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipListenAddrs));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipListenAddrs");
		return -1;
	}
	if (value == Py_None) {
		object->aipListenAddrs = NULL;
	} else {
		object->aipListenAddrs = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipListenAddrs = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipForwarders));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipForwarders");
		return -1;
	}
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipLogFilter(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipLogFilter;
	if (object->aipLogFilter == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipLogFilter == NULL) {
		py_aipLogFilter = Py_None;
		Py_INCREF(py_aipLogFilter);
	} else {
		py_aipLogFilter = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipLogFilter, object->aipLogFilter);
	}
	return py_aipLogFilter;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipLogFilter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipLogFilter));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipLogFilter");
		return -1;
	}
	if (value == Py_None) {
		object->aipLogFilter = NULL;
	} else {
		object->aipLogFilter = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipLogFilter = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pwszLogFilePath(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszLogFilePath;
	if (object->pwszLogFilePath == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pwszLogFilePath == NULL) {
		py_pwszLogFilePath = Py_None;
		Py_INCREF(py_pwszLogFilePath);
	} else {
		if (object->pwszLogFilePath == NULL) {
			py_pwszLogFilePath = Py_None;
			Py_INCREF(py_pwszLogFilePath);
		} else {
			py_pwszLogFilePath = PyUnicode_Decode(object->pwszLogFilePath, strlen(object->pwszLogFilePath), "utf-8", "ignore");
		}
	}
	return py_pwszLogFilePath;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pwszLogFilePath(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwszLogFilePath");
		return -1;
	}
	if (value == Py_None) {
		object->pwszLogFilePath = NULL;
	} else {
		object->pwszLogFilePath = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pwszLogFilePath = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDomainName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDomainName;
	if (object->pszDomainName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDomainName == NULL) {
		py_pszDomainName = Py_None;
		Py_INCREF(py_pszDomainName);
	} else {
		if (object->pszDomainName == NULL) {
			py_pszDomainName = Py_None;
			Py_INCREF(py_pszDomainName);
		} else {
			py_pszDomainName = PyUnicode_Decode(object->pszDomainName, strlen(object->pszDomainName), "utf-8", "ignore");
		}
	}
	return py_pszDomainName;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDomainName");
		return -1;
	}
	if (value == Py_None) {
		object->pszDomainName = NULL;
	} else {
		object->pszDomainName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDomainName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszForestName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszForestName;
	if (object->pszForestName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszForestName == NULL) {
		py_pszForestName = Py_None;
		Py_INCREF(py_pszForestName);
	} else {
		if (object->pszForestName == NULL) {
			py_pszForestName = Py_None;
			Py_INCREF(py_pszForestName);
		} else {
			py_pszForestName = PyUnicode_Decode(object->pszForestName, strlen(object->pszForestName), "utf-8", "ignore");
		}
	}
	return py_pszForestName;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszForestName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszForestName");
		return -1;
	}
	if (value == Py_None) {
		object->pszForestName = NULL;
	} else {
		object->pszForestName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszForestName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDomainDirectoryPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDomainDirectoryPartition;
	if (object->pszDomainDirectoryPartition == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDomainDirectoryPartition == NULL) {
		py_pszDomainDirectoryPartition = Py_None;
		Py_INCREF(py_pszDomainDirectoryPartition);
	} else {
		if (object->pszDomainDirectoryPartition == NULL) {
			py_pszDomainDirectoryPartition = Py_None;
			Py_INCREF(py_pszDomainDirectoryPartition);
		} else {
			py_pszDomainDirectoryPartition = PyUnicode_Decode(object->pszDomainDirectoryPartition, strlen(object->pszDomainDirectoryPartition), "utf-8", "ignore");
		}
	}
	return py_pszDomainDirectoryPartition;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDomainDirectoryPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDomainDirectoryPartition");
		return -1;
	}
	if (value == Py_None) {
		object->pszDomainDirectoryPartition = NULL;
	} else {
		object->pszDomainDirectoryPartition = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDomainDirectoryPartition = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszForestDirectoryPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszForestDirectoryPartition;
	if (object->pszForestDirectoryPartition == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszForestDirectoryPartition == NULL) {
		py_pszForestDirectoryPartition = Py_None;
		Py_INCREF(py_pszForestDirectoryPartition);
	} else {
		if (object->pszForestDirectoryPartition == NULL) {
			py_pszForestDirectoryPartition = Py_None;
			Py_INCREF(py_pszForestDirectoryPartition);
		} else {
			py_pszForestDirectoryPartition = PyUnicode_Decode(object->pszForestDirectoryPartition, strlen(object->pszForestDirectoryPartition), "utf-8", "ignore");
		}
	}
	return py_pszForestDirectoryPartition;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszForestDirectoryPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszForestDirectoryPartition");
		return -1;
	}
	if (value == Py_None) {
		object->pszForestDirectoryPartition = NULL;
	} else {
		object->pszForestDirectoryPartition = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszForestDirectoryPartition = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pExtensions(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pExtensions;
	py_pExtensions = PyList_New(6);
	if (py_pExtensions == NULL) {
		return NULL;
	}
	{
		int pExtensions_cntr_0;
		for (pExtensions_cntr_0 = 0; pExtensions_cntr_0 < (6); pExtensions_cntr_0++) {
			PyObject *py_pExtensions_0;
			py_pExtensions_0 = pytalloc_reference_ex(&DNS_EXTENSION_Type, pytalloc_get_mem_ctx(obj), &(object->pExtensions)[pExtensions_cntr_0]);
			PyList_SetItem(py_pExtensions, pExtensions_cntr_0, py_pExtensions_0);
		}
	}
	return py_pExtensions;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pExtensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pExtensions");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pExtensions_cntr_0;
		if (ARRAY_SIZE(object->pExtensions) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->pExtensions),  PyList_GET_SIZE(value));
			return -1;
		}
		for (pExtensions_cntr_0 = 0; pExtensions_cntr_0 < PyList_GET_SIZE(value); pExtensions_cntr_0++) {
			if (PyList_GET_ITEM(value, pExtensions_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->pExtensions)[pExtensions_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&DNS_EXTENSION_Type, PyList_GET_ITEM(value, pExtensions_cntr_0), return -1;);
			if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pExtensions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->pExtensions)[pExtensions_cntr_0] = *(struct DNS_EXTENSION *)pytalloc_get_ptr(PyList_GET_ITEM(value, pExtensions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLogLevel;
	py_dwLogLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLogLevel));
	return py_dwLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLogLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLogLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLogLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDebugLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDebugLevel;
	py_dwDebugLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDebugLevel));
	return py_dwDebugLevel;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDebugLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDebugLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDebugLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDebugLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwForwardTimeout));
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwForwardTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwForwardTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwForwardTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRpcProtocol(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcProtocol;
	py_dwRpcProtocol = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcProtocol));
	return py_dwRpcProtocol;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRpcProtocol(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcProtocol");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcProtocol));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcProtocol = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwNameCheckFlag(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNameCheckFlag;
	py_dwNameCheckFlag = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNameCheckFlag));
	return py_dwNameCheckFlag;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwNameCheckFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwNameCheckFlag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNameCheckFlag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNameCheckFlag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_cAddressAnswerLimit(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_cAddressAnswerLimit;
	py_cAddressAnswerLimit = PyLong_FromUnsignedLongLong((uint32_t)(object->cAddressAnswerLimit));
	return py_cAddressAnswerLimit;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_cAddressAnswerLimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cAddressAnswerLimit");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cAddressAnswerLimit));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cAddressAnswerLimit = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRecursionRetry(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionRetry;
	py_dwRecursionRetry = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRecursionRetry));
	return py_dwRecursionRetry;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRecursionRetry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRecursionRetry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRecursionRetry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRecursionRetry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRecursionTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionTimeout;
	py_dwRecursionTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRecursionTimeout));
	return py_dwRecursionTimeout;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRecursionTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRecursionTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRecursionTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRecursionTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwMaxCacheTtl(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwMaxCacheTtl;
	py_dwMaxCacheTtl = PyLong_FromUnsignedLongLong((uint32_t)(object->dwMaxCacheTtl));
	return py_dwMaxCacheTtl;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwMaxCacheTtl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwMaxCacheTtl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwMaxCacheTtl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwMaxCacheTtl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsPollingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsPollingInterval;
	py_dwDsPollingInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsPollingInterval));
	return py_dwDsPollingInterval;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsPollingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsPollingInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsPollingInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsPollingInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLocalNetPriorityNetMask(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLocalNetPriorityNetMask;
	py_dwLocalNetPriorityNetMask = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLocalNetPriorityNetMask));
	return py_dwLocalNetPriorityNetMask;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLocalNetPriorityNetMask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLocalNetPriorityNetMask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLocalNetPriorityNetMask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLocalNetPriorityNetMask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwScavengingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwScavengingInterval;
	py_dwScavengingInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwScavengingInterval));
	return py_dwScavengingInterval;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwScavengingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwScavengingInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwScavengingInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwScavengingInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDefaultRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultRefreshInterval;
	py_dwDefaultRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDefaultRefreshInterval));
	return py_dwDefaultRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDefaultRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDefaultRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDefaultRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDefaultRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDefaultNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultNoRefreshInterval;
	py_dwDefaultNoRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDefaultNoRefreshInterval));
	return py_dwDefaultNoRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDefaultNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDefaultNoRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDefaultNoRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDefaultNoRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLastScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLastScavengeTime;
	py_dwLastScavengeTime = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLastScavengeTime));
	return py_dwLastScavengeTime;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLastScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLastScavengeTime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLastScavengeTime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLastScavengeTime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwEventLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwEventLogLevel;
	py_dwEventLogLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->dwEventLogLevel));
	return py_dwEventLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwEventLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwEventLogLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwEventLogLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwEventLogLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLogFileMaxSize(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLogFileMaxSize;
	py_dwLogFileMaxSize = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLogFileMaxSize));
	return py_dwLogFileMaxSize;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLogFileMaxSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLogFileMaxSize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLogFileMaxSize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLogFileMaxSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsForestVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsForestVersion;
	py_dwDsForestVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsForestVersion));
	return py_dwDsForestVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsForestVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsForestVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsForestVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsForestVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsDomainVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsDomainVersion;
	py_dwDsDomainVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsDomainVersion));
	return py_dwDsDomainVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsDomainVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsDomainVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsDomainVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsDomainVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsDsaVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDsDsaVersion;
	py_dwDsDsaVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDsDsaVersion));
	return py_dwDsDsaVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsDsaVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDsDsaVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDsDsaVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDsDsaVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fReadOnlyDC(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fReadOnlyDC;
	py_fReadOnlyDC = PyLong_FromLong((uint16_t)(object->fReadOnlyDC));
	return py_fReadOnlyDC;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fReadOnlyDC(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReadOnlyDC");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fReadOnlyDC));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fReadOnlyDC = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserveArray;
	py_dwReserveArray = PyList_New(3);
	if (py_dwReserveArray == NULL) {
		return NULL;
	}
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < (3); dwReserveArray_cntr_0++) {
			PyObject *py_dwReserveArray_0;
			py_dwReserveArray_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->dwReserveArray)[dwReserveArray_cntr_0]));
			PyList_SetItem(py_dwReserveArray, dwReserveArray_cntr_0, py_dwReserveArray_0);
		}
	}
	return py_dwReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserveArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserveArray_cntr_0;
		if (ARRAY_SIZE(object->dwReserveArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->dwReserveArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < PyList_GET_SIZE(value); dwReserveArray_cntr_0++) {
			if (PyList_GET_ITEM(value, dwReserveArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->dwReserveArray)[dwReserveArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->dwReserveArray)[dwReserveArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, dwReserveArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, dwReserveArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->dwReserveArray)[dwReserveArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAutoReverseZones(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoReverseZones;
	py_fAutoReverseZones = PyLong_FromLong((uint16_t)(object->fAutoReverseZones));
	return py_fAutoReverseZones;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAutoReverseZones(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoReverseZones");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoReverseZones));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoReverseZones = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAutoCacheUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoCacheUpdate;
	py_fAutoCacheUpdate = PyLong_FromLong((uint16_t)(object->fAutoCacheUpdate));
	return py_fAutoCacheUpdate;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAutoCacheUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoCacheUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoCacheUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoCacheUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyLong_FromLong((uint16_t)(object->fRecurseAfterForwarding));
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRecurseAfterForwarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRecurseAfterForwarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRecurseAfterForwarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fForwardDelegations(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fForwardDelegations;
	py_fForwardDelegations = PyLong_FromLong((uint16_t)(object->fForwardDelegations));
	return py_fForwardDelegations;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fForwardDelegations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fForwardDelegations");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fForwardDelegations));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fForwardDelegations = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fNoRecursion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fNoRecursion;
	py_fNoRecursion = PyLong_FromLong((uint16_t)(object->fNoRecursion));
	return py_fNoRecursion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fNoRecursion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNoRecursion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNoRecursion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNoRecursion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fSecureResponses(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureResponses;
	py_fSecureResponses = PyLong_FromLong((uint16_t)(object->fSecureResponses));
	return py_fSecureResponses;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fSecureResponses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureResponses");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureResponses));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureResponses = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fRoundRobin(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fRoundRobin;
	py_fRoundRobin = PyLong_FromLong((uint16_t)(object->fRoundRobin));
	return py_fRoundRobin;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fRoundRobin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRoundRobin");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRoundRobin));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRoundRobin = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fLocalNetPriority(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fLocalNetPriority;
	py_fLocalNetPriority = PyLong_FromLong((uint16_t)(object->fLocalNetPriority));
	return py_fLocalNetPriority;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fLocalNetPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLocalNetPriority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLocalNetPriority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLocalNetPriority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fBindSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fBindSecondaries;
	py_fBindSecondaries = PyLong_FromLong((uint16_t)(object->fBindSecondaries));
	return py_fBindSecondaries;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fBindSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fBindSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fBindSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fBindSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fWriteAuthorityNs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fWriteAuthorityNs;
	py_fWriteAuthorityNs = PyLong_FromLong((uint16_t)(object->fWriteAuthorityNs));
	return py_fWriteAuthorityNs;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fWriteAuthorityNs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fWriteAuthorityNs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fWriteAuthorityNs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fWriteAuthorityNs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fStrictFileParsing(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fStrictFileParsing;
	py_fStrictFileParsing = PyLong_FromLong((uint16_t)(object->fStrictFileParsing));
	return py_fStrictFileParsing;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fStrictFileParsing(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fStrictFileParsing");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fStrictFileParsing));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fStrictFileParsing = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fLooseWildcarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fLooseWildcarding;
	py_fLooseWildcarding = PyLong_FromLong((uint16_t)(object->fLooseWildcarding));
	return py_fLooseWildcarding;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fLooseWildcarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLooseWildcarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLooseWildcarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLooseWildcarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fDefaultAgingState(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fDefaultAgingState;
	py_fDefaultAgingState = PyLong_FromLong((uint16_t)(object->fDefaultAgingState));
	return py_fDefaultAgingState;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fDefaultAgingState(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDefaultAgingState");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDefaultAgingState));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDefaultAgingState = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fReserveArray;
	py_fReserveArray = PyList_New(15);
	if (py_fReserveArray == NULL) {
		return NULL;
	}
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < (15); fReserveArray_cntr_0++) {
			PyObject *py_fReserveArray_0;
			py_fReserveArray_0 = PyLong_FromLong((uint16_t)((object->fReserveArray)[fReserveArray_cntr_0]));
			PyList_SetItem(py_fReserveArray, fReserveArray_cntr_0, py_fReserveArray_0);
		}
	}
	return py_fReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReserveArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int fReserveArray_cntr_0;
		if (ARRAY_SIZE(object->fReserveArray) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->fReserveArray),  PyList_GET_SIZE(value));
			return -1;
		}
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < PyList_GET_SIZE(value); fReserveArray_cntr_0++) {
			if (PyList_GET_ITEM(value, fReserveArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->fReserveArray)[fReserveArray_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->fReserveArray)[fReserveArray_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, fReserveArray_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, fReserveArray_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->fReserveArray)[fReserveArray_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_SERVER_INFO_LONGHORN_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwReserved0,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwVersion"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwVersion,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fBootMethod"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fBootMethod,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fBootMethod,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_BOOT_METHOD")
	},
	{
		.name = discard_const_p(char, "fAdminConfigured"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAdminConfigured,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAdminConfigured,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAllowUpdate,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDsAvailable"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fDsAvailable,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fDsAvailable,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszServerName"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszServerName,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszDsContainer"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDsContainer,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDsContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "aipServerAddrs"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipServerAddrs,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipServerAddrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipListenAddrs"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipListenAddrs,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipListenAddrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipForwarders"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipForwarders,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipForwarders,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipLogFilter"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipLogFilter,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipLogFilter,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "pwszLogFilePath"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_pwszLogFilePath,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_pwszLogFilePath,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "pszDomainName"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDomainName,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDomainName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszForestName"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszForestName,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszForestName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszDomainDirectoryPartition"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDomainDirectoryPartition,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDomainDirectoryPartition,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszForestDirectoryPartition"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszForestDirectoryPartition,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszForestDirectoryPartition,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pExtensions"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_pExtensions,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_pExtensions,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_EXTENSION")
	},
	{
		.name = discard_const_p(char, "dwLogLevel"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLogLevel,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLogLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDebugLevel"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDebugLevel,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDebugLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwForwardTimeout"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwForwardTimeout,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwForwardTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRpcProtocol"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRpcProtocol,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRpcProtocol,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwNameCheckFlag"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwNameCheckFlag,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwNameCheckFlag,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_NAME_CHECK_FLAG")
	},
	{
		.name = discard_const_p(char, "cAddressAnswerLimit"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_cAddressAnswerLimit,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_cAddressAnswerLimit,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRecursionRetry"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRecursionRetry,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRecursionRetry,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRecursionTimeout"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRecursionTimeout,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRecursionTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwMaxCacheTtl"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwMaxCacheTtl,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwMaxCacheTtl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsPollingInterval"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsPollingInterval,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsPollingInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLocalNetPriorityNetMask"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLocalNetPriorityNetMask,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLocalNetPriorityNetMask,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwScavengingInterval"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwScavengingInterval,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwScavengingInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDefaultRefreshInterval"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDefaultRefreshInterval,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDefaultRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDefaultNoRefreshInterval"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDefaultNoRefreshInterval,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDefaultNoRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLastScavengeTime"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLastScavengeTime,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLastScavengeTime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwEventLogLevel"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwEventLogLevel,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwEventLogLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLogFileMaxSize"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLogFileMaxSize,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLogFileMaxSize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsForestVersion"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsForestVersion,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsForestVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsDomainVersion"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsDomainVersion,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsDomainVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDsDsaVersion"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsDsaVersion,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsDsaVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fReadOnlyDC"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fReadOnlyDC,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fReadOnlyDC,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwReserveArray"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwReserveArray,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwReserveArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAutoReverseZones"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAutoReverseZones,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAutoReverseZones,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fAutoCacheUpdate"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAutoCacheUpdate,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAutoCacheUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fRecurseAfterForwarding"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fRecurseAfterForwarding,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fRecurseAfterForwarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fForwardDelegations"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fForwardDelegations,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fForwardDelegations,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fNoRecursion"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fNoRecursion,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fNoRecursion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fSecureResponses"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fSecureResponses,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fSecureResponses,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fRoundRobin"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fRoundRobin,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fRoundRobin,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fLocalNetPriority"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fLocalNetPriority,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fLocalNetPriority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fBindSecondaries"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fBindSecondaries,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fBindSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fWriteAuthorityNs"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fWriteAuthorityNs,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fWriteAuthorityNs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fStrictFileParsing"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fStrictFileParsing,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fStrictFileParsing,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fLooseWildcarding"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fLooseWildcarding,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fLooseWildcarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDefaultAgingState"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fDefaultAgingState,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fDefaultAgingState,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fReserveArray"),
		.get = py_DNS_RPC_SERVER_INFO_LONGHORN_get_fReserveArray,
		.set = py_DNS_RPC_SERVER_INFO_LONGHORN_set_fReserveArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_SERVER_INFO_LONGHORN, type);
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_SERVER_INFO_LONGHORN);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_SERVER_INFO_LONGHORN);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_SERVER_INFO_LONGHORN);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_SERVER_INFO_LONGHORN, "DNS_RPC_SERVER_INFO_LONGHORN", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_SERVER_INFO_LONGHORN, "DNS_RPC_SERVER_INFO_LONGHORN", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_SERVER_INFO_LONGHORN_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_SERVER_INFO_LONGHORN_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_SERVER_INFO_LONGHORN",
	.tp_getset = py_DNS_RPC_SERVER_INFO_LONGHORN_getsetters,
	.tp_methods = py_DNS_RPC_SERVER_INFO_LONGHORN_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_SERVER_INFO_LONGHORN_new,
};


static PyObject *py_DNS_RPC_DP_REPLICA_get_pszReplicaDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_REPLICA *object = pytalloc_get_ptr(obj);
	PyObject *py_pszReplicaDn;
	if (object->pszReplicaDn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszReplicaDn == NULL) {
		py_pszReplicaDn = Py_None;
		Py_INCREF(py_pszReplicaDn);
	} else {
		if (object->pszReplicaDn == NULL) {
			py_pszReplicaDn = Py_None;
			Py_INCREF(py_pszReplicaDn);
		} else {
			py_pszReplicaDn = PyUnicode_Decode(object->pszReplicaDn, strlen(object->pszReplicaDn), "utf-8", "ignore");
		}
	}
	return py_pszReplicaDn;
}

static int py_DNS_RPC_DP_REPLICA_set_pszReplicaDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_REPLICA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszReplicaDn");
		return -1;
	}
	if (value == Py_None) {
		object->pszReplicaDn = NULL;
	} else {
		object->pszReplicaDn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszReplicaDn = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_DP_REPLICA_getsetters[] = {
	{
		.name = discard_const_p(char, "pszReplicaDn"),
		.get = py_DNS_RPC_DP_REPLICA_get_pszReplicaDn,
		.set = py_DNS_RPC_DP_REPLICA_set_pszReplicaDn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_DP_REPLICA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_DP_REPLICA, type);
}


static PyTypeObject DNS_RPC_DP_REPLICA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_DP_REPLICA",
	.tp_getset = py_DNS_RPC_DP_REPLICA_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_DP_REPLICA_new,
};


static PyObject *py_DNS_RPC_DP_INFO_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_DP_INFO_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_DP_INFO_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_DP_INFO_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpFqdn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_pszDpDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpDn;
	if (object->pszDpDn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpDn == NULL) {
		py_pszDpDn = Py_None;
		Py_INCREF(py_pszDpDn);
	} else {
		if (object->pszDpDn == NULL) {
			py_pszDpDn = Py_None;
			Py_INCREF(py_pszDpDn);
		} else {
			py_pszDpDn = PyUnicode_Decode(object->pszDpDn, strlen(object->pszDpDn), "utf-8", "ignore");
		}
	}
	return py_pszDpDn;
}

static int py_DNS_RPC_DP_INFO_set_pszDpDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpDn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpDn = NULL;
	} else {
		object->pszDpDn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpDn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_pszCrDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_pszCrDn;
	if (object->pszCrDn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszCrDn == NULL) {
		py_pszCrDn = Py_None;
		Py_INCREF(py_pszCrDn);
	} else {
		if (object->pszCrDn == NULL) {
			py_pszCrDn = Py_None;
			Py_INCREF(py_pszCrDn);
		} else {
			py_pszCrDn = PyUnicode_Decode(object->pszCrDn, strlen(object->pszCrDn), "utf-8", "ignore");
		}
	}
	return py_pszCrDn;
}

static int py_DNS_RPC_DP_INFO_set_pszCrDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszCrDn");
		return -1;
	}
	if (value == Py_None) {
		object->pszCrDn = NULL;
	} else {
		object->pszCrDn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszCrDn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFlags));
	return py_dwFlags;
}

static int py_DNS_RPC_DP_INFO_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwZoneCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneCount;
	py_dwZoneCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneCount));
	return py_dwZoneCount;
}

static int py_DNS_RPC_DP_INFO_set_dwZoneCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwState(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwState;
	py_dwState = PyLong_FromUnsignedLongLong((uint32_t)(object->dwState));
	return py_dwState;
}

static int py_DNS_RPC_DP_INFO_set_dwState(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwState");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwState));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwState = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyList_New(3);
	if (py_dwReserved == NULL) {
		return NULL;
	}
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < (3); dwReserved_cntr_0++) {
			PyObject *py_dwReserved_0;
			py_dwReserved_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->dwReserved)[dwReserved_cntr_0]));
			PyList_SetItem(py_dwReserved, dwReserved_cntr_0, py_dwReserved_0);
		}
	}
	return py_dwReserved;
}

static int py_DNS_RPC_DP_INFO_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserved_cntr_0;
		if (ARRAY_SIZE(object->dwReserved) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->dwReserved),  PyList_GET_SIZE(value));
			return -1;
		}
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < PyList_GET_SIZE(value); dwReserved_cntr_0++) {
			if (PyList_GET_ITEM(value, dwReserved_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->dwReserved)[dwReserved_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->dwReserved)[dwReserved_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, dwReserved_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, dwReserved_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->dwReserved)[dwReserved_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_pwszReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszReserved;
	py_pwszReserved = PyList_New(3);
	if (py_pwszReserved == NULL) {
		return NULL;
	}
	{
		int pwszReserved_cntr_0;
		for (pwszReserved_cntr_0 = 0; pwszReserved_cntr_0 < (3); pwszReserved_cntr_0++) {
			PyObject *py_pwszReserved_0;
			py_pwszReserved_0 = pytalloc_reference_ex(&DNS_EXTENSION_Type, pytalloc_get_mem_ctx(obj), &(object->pwszReserved)[pwszReserved_cntr_0]);
			PyList_SetItem(py_pwszReserved, pwszReserved_cntr_0, py_pwszReserved_0);
		}
	}
	return py_pwszReserved;
}

static int py_DNS_RPC_DP_INFO_set_pwszReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwszReserved");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pwszReserved_cntr_0;
		if (ARRAY_SIZE(object->pwszReserved) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->pwszReserved),  PyList_GET_SIZE(value));
			return -1;
		}
		for (pwszReserved_cntr_0 = 0; pwszReserved_cntr_0 < PyList_GET_SIZE(value); pwszReserved_cntr_0++) {
			if (PyList_GET_ITEM(value, pwszReserved_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->pwszReserved)[pwszReserved_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&DNS_EXTENSION_Type, PyList_GET_ITEM(value, pwszReserved_cntr_0), return -1;);
			if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pwszReserved_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->pwszReserved)[pwszReserved_cntr_0] = *(struct DNS_EXTENSION *)pytalloc_get_ptr(PyList_GET_ITEM(value, pwszReserved_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwReplicaCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReplicaCount;
	py_dwReplicaCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReplicaCount));
	return py_dwReplicaCount;
}

static int py_DNS_RPC_DP_INFO_set_dwReplicaCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReplicaCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReplicaCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReplicaCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_ReplicaArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_ReplicaArray;
	py_ReplicaArray = PyList_New(object->dwReplicaCount);
	if (py_ReplicaArray == NULL) {
		return NULL;
	}
	{
		int ReplicaArray_cntr_0;
		for (ReplicaArray_cntr_0 = 0; ReplicaArray_cntr_0 < (object->dwReplicaCount); ReplicaArray_cntr_0++) {
			PyObject *py_ReplicaArray_0;
			if ((object->ReplicaArray)[ReplicaArray_cntr_0] == NULL) {
				py_ReplicaArray_0 = Py_None;
				Py_INCREF(py_ReplicaArray_0);
			} else {
				py_ReplicaArray_0 = pytalloc_reference_ex(&DNS_RPC_DP_REPLICA_Type, (object->ReplicaArray)[ReplicaArray_cntr_0], (object->ReplicaArray)[ReplicaArray_cntr_0]);
			}
			PyList_SetItem(py_ReplicaArray, ReplicaArray_cntr_0, py_ReplicaArray_0);
		}
	}
	return py_ReplicaArray;
}

static int py_DNS_RPC_DP_INFO_set_ReplicaArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ReplicaArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ReplicaArray_cntr_0;
		object->ReplicaArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ReplicaArray, PyList_GET_SIZE(value));
		if (!object->ReplicaArray) { return -1; }
		talloc_set_name_const(object->ReplicaArray, "ARRAY: object->ReplicaArray");
		for (ReplicaArray_cntr_0 = 0; ReplicaArray_cntr_0 < PyList_GET_SIZE(value); ReplicaArray_cntr_0++) {
			if (PyList_GET_ITEM(value, ReplicaArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ReplicaArray)[ReplicaArray_cntr_0]");
				return -1;
			}
			if (PyList_GET_ITEM(value, ReplicaArray_cntr_0) == Py_None) {
				(object->ReplicaArray)[ReplicaArray_cntr_0] = NULL;
			} else {
				(object->ReplicaArray)[ReplicaArray_cntr_0] = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_REPLICA_Type, PyList_GET_ITEM(value, ReplicaArray_cntr_0), return -1;);
				if (talloc_reference(object->ReplicaArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ReplicaArray_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->ReplicaArray)[ReplicaArray_cntr_0] = (struct DNS_RPC_DP_REPLICA *)pytalloc_get_ptr(PyList_GET_ITEM(value, ReplicaArray_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_DP_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_DP_INFO_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_DP_INFO_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_DP_INFO_get_dwReserved0,
		.set = py_DNS_RPC_DP_INFO_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDpFqdn"),
		.get = py_DNS_RPC_DP_INFO_get_pszDpFqdn,
		.set = py_DNS_RPC_DP_INFO_set_pszDpFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszDpDn"),
		.get = py_DNS_RPC_DP_INFO_get_pszDpDn,
		.set = py_DNS_RPC_DP_INFO_set_pszDpDn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "pszCrDn"),
		.get = py_DNS_RPC_DP_INFO_get_pszCrDn,
		.set = py_DNS_RPC_DP_INFO_set_pszCrDn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dwFlags"),
		.get = py_DNS_RPC_DP_INFO_get_dwFlags,
		.set = py_DNS_RPC_DP_INFO_set_dwFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwZoneCount"),
		.get = py_DNS_RPC_DP_INFO_get_dwZoneCount,
		.set = py_DNS_RPC_DP_INFO_set_dwZoneCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwState"),
		.get = py_DNS_RPC_DP_INFO_get_dwState,
		.set = py_DNS_RPC_DP_INFO_set_dwState,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_DP_STATE")
	},
	{
		.name = discard_const_p(char, "dwReserved"),
		.get = py_DNS_RPC_DP_INFO_get_dwReserved,
		.set = py_DNS_RPC_DP_INFO_set_dwReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pwszReserved"),
		.get = py_DNS_RPC_DP_INFO_get_pwszReserved,
		.set = py_DNS_RPC_DP_INFO_set_pwszReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_EXTENSION")
	},
	{
		.name = discard_const_p(char, "dwReplicaCount"),
		.get = py_DNS_RPC_DP_INFO_get_dwReplicaCount,
		.set = py_DNS_RPC_DP_INFO_set_dwReplicaCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ReplicaArray"),
		.get = py_DNS_RPC_DP_INFO_get_ReplicaArray,
		.set = py_DNS_RPC_DP_INFO_set_ReplicaArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_DP_REPLICA")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_DP_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_DP_INFO, type);
}


static PyTypeObject DNS_RPC_DP_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_DP_INFO",
	.tp_getset = py_DNS_RPC_DP_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_DP_INFO_new,
};


static PyObject *py_DNS_RPC_DP_ENUM_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_DP_ENUM_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_ENUM_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_DP_ENUM_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_ENUM_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_DP_ENUM_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpFqdn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_ENUM_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFlags));
	return py_dwFlags;
}

static int py_DNS_RPC_DP_ENUM_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_ENUM_get_dwZoneCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneCount;
	py_dwZoneCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneCount));
	return py_dwZoneCount;
}

static int py_DNS_RPC_DP_ENUM_set_dwZoneCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_DP_ENUM_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_DP_ENUM_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_DP_ENUM_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_DP_ENUM_get_dwReserved0,
		.set = py_DNS_RPC_DP_ENUM_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDpFqdn"),
		.get = py_DNS_RPC_DP_ENUM_get_pszDpFqdn,
		.set = py_DNS_RPC_DP_ENUM_set_pszDpFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwFlags"),
		.get = py_DNS_RPC_DP_ENUM_get_dwFlags,
		.set = py_DNS_RPC_DP_ENUM_set_dwFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwZoneCount"),
		.get = py_DNS_RPC_DP_ENUM_get_dwZoneCount,
		.set = py_DNS_RPC_DP_ENUM_set_dwZoneCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_DP_ENUM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_DP_ENUM, type);
}


static PyTypeObject DNS_RPC_DP_ENUM_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_DP_ENUM",
	.tp_getset = py_DNS_RPC_DP_ENUM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_DP_ENUM_new,
};


static PyObject *py_DNS_RPC_DP_LIST_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_DP_LIST_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_LIST_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_DP_LIST_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_LIST_get_dwDpCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDpCount;
	py_dwDpCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDpCount));
	return py_dwDpCount;
}

static int py_DNS_RPC_DP_LIST_set_dwDpCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDpCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDpCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDpCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_LIST_get_DpArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_LIST *object = pytalloc_get_ptr(obj);
	PyObject *py_DpArray;
	py_DpArray = PyList_New(object->dwDpCount);
	if (py_DpArray == NULL) {
		return NULL;
	}
	{
		int DpArray_cntr_0;
		for (DpArray_cntr_0 = 0; DpArray_cntr_0 < (object->dwDpCount); DpArray_cntr_0++) {
			PyObject *py_DpArray_0;
			if ((object->DpArray)[DpArray_cntr_0] == NULL) {
				py_DpArray_0 = Py_None;
				Py_INCREF(py_DpArray_0);
			} else {
				py_DpArray_0 = pytalloc_reference_ex(&DNS_RPC_DP_ENUM_Type, (object->DpArray)[DpArray_cntr_0], (object->DpArray)[DpArray_cntr_0]);
			}
			PyList_SetItem(py_DpArray, DpArray_cntr_0, py_DpArray_0);
		}
	}
	return py_DpArray;
}

static int py_DNS_RPC_DP_LIST_set_DpArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_LIST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->DpArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int DpArray_cntr_0;
		object->DpArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->DpArray, PyList_GET_SIZE(value));
		if (!object->DpArray) { return -1; }
		talloc_set_name_const(object->DpArray, "ARRAY: object->DpArray");
		for (DpArray_cntr_0 = 0; DpArray_cntr_0 < PyList_GET_SIZE(value); DpArray_cntr_0++) {
			if (PyList_GET_ITEM(value, DpArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->DpArray)[DpArray_cntr_0]");
				return -1;
			}
			if (PyList_GET_ITEM(value, DpArray_cntr_0) == Py_None) {
				(object->DpArray)[DpArray_cntr_0] = NULL;
			} else {
				(object->DpArray)[DpArray_cntr_0] = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_ENUM_Type, PyList_GET_ITEM(value, DpArray_cntr_0), return -1;);
				if (talloc_reference(object->DpArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, DpArray_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->DpArray)[DpArray_cntr_0] = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(PyList_GET_ITEM(value, DpArray_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_DP_LIST_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_DP_LIST_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_DP_LIST_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_DP_LIST_get_dwReserved0,
		.set = py_DNS_RPC_DP_LIST_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDpCount"),
		.get = py_DNS_RPC_DP_LIST_get_dwDpCount,
		.set = py_DNS_RPC_DP_LIST_set_dwDpCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "DpArray"),
		.get = py_DNS_RPC_DP_LIST_get_DpArray,
		.set = py_DNS_RPC_DP_LIST_set_DpArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_DP_ENUM")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_DP_LIST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_DP_LIST, type);
}


static PyTypeObject DNS_RPC_DP_LIST_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_DP_LIST",
	.tp_getset = py_DNS_RPC_DP_LIST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_DP_LIST_new,
};


static PyObject *py_DNS_RPC_ENLIST_DP_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ENLIST_DP_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENLIST_DP_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ENLIST_DP_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENLIST_DP_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ENLIST_DP_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpFqdn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENLIST_DP_get_dwOperation(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = pytalloc_get_ptr(obj);
	PyObject *py_dwOperation;
	py_dwOperation = PyLong_FromUnsignedLongLong((uint32_t)(object->dwOperation));
	return py_dwOperation;
}

static int py_DNS_RPC_ENLIST_DP_set_dwOperation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwOperation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwOperation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwOperation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ENLIST_DP_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ENLIST_DP_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ENLIST_DP_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ENLIST_DP_get_dwReserved0,
		.set = py_DNS_RPC_ENLIST_DP_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDpFqdn"),
		.get = py_DNS_RPC_ENLIST_DP_get_pszDpFqdn,
		.set = py_DNS_RPC_ENLIST_DP_set_pszDpFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwOperation"),
		.get = py_DNS_RPC_ENLIST_DP_get_dwOperation,
		.set = py_DNS_RPC_ENLIST_DP_set_dwOperation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ENLIST_DP_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ENLIST_DP, type);
}


static PyTypeObject DNS_RPC_ENLIST_DP_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ENLIST_DP",
	.tp_getset = py_DNS_RPC_ENLIST_DP_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ENLIST_DP_new,
};


static PyObject *py_DNS_RPC_ZONE_CHANGE_DP_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_CHANGE_DP_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CHANGE_DP_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_CHANGE_DP_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CHANGE_DP_get_pszDestPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDestPartition;
	if (object->pszDestPartition == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDestPartition == NULL) {
		py_pszDestPartition = Py_None;
		Py_INCREF(py_pszDestPartition);
	} else {
		if (object->pszDestPartition == NULL) {
			py_pszDestPartition = Py_None;
			Py_INCREF(py_pszDestPartition);
		} else {
			py_pszDestPartition = PyUnicode_Decode(object->pszDestPartition, strlen(object->pszDestPartition), "utf-8", "ignore");
		}
	}
	return py_pszDestPartition;
}

static int py_DNS_RPC_ZONE_CHANGE_DP_set_pszDestPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDestPartition");
		return -1;
	}
	if (value == Py_None) {
		object->pszDestPartition = NULL;
	} else {
		object->pszDestPartition = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDestPartition = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_CHANGE_DP_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_CHANGE_DP_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_CHANGE_DP_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_CHANGE_DP_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_CHANGE_DP_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDestPartition"),
		.get = py_DNS_RPC_ZONE_CHANGE_DP_get_pszDestPartition,
		.set = py_DNS_RPC_ZONE_CHANGE_DP_set_pszDestPartition,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_CHANGE_DP_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_CHANGE_DP, type);
}


static PyTypeObject DNS_RPC_ZONE_CHANGE_DP_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_CHANGE_DP",
	.tp_getset = py_DNS_RPC_ZONE_CHANGE_DP_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_CHANGE_DP_new,
};


static PyObject *py_DNS_RPC_ZONE_W2K_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_W2K_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneName");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_W2K_get_Flags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromUnsignedLongLong((uint32_t)(object->Flags));
	return py_Flags;
}

static int py_DNS_RPC_ZONE_W2K_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_W2K_get_ZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_ZoneType;
	py_ZoneType = PyLong_FromLong((uint16_t)(object->ZoneType));
	return py_ZoneType;
}

static int py_DNS_RPC_ZONE_W2K_set_ZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ZoneType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ZoneType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ZoneType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_W2K_get_Version(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyLong_FromLong((uint16_t)(object->Version));
	return py_Version;
}

static int py_DNS_RPC_ZONE_W2K_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_W2K_getsetters[] = {
	{
		.name = discard_const_p(char, "pszZoneName"),
		.get = py_DNS_RPC_ZONE_W2K_get_pszZoneName,
		.set = py_DNS_RPC_ZONE_W2K_set_pszZoneName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_DNS_RPC_ZONE_W2K_get_Flags,
		.set = py_DNS_RPC_ZONE_W2K_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_ZONE_FLAGS")
	},
	{
		.name = discard_const_p(char, "ZoneType"),
		.get = py_DNS_RPC_ZONE_W2K_get_ZoneType,
		.set = py_DNS_RPC_ZONE_W2K_set_ZoneType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Version"),
		.get = py_DNS_RPC_ZONE_W2K_get_Version,
		.set = py_DNS_RPC_ZONE_W2K_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_W2K_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_W2K",
	.tp_getset = py_DNS_RPC_ZONE_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_DOTNET_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneName");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_Flags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromUnsignedLongLong((uint32_t)(object->Flags));
	return py_Flags;
}

static int py_DNS_RPC_ZONE_DOTNET_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_ZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_ZoneType;
	py_ZoneType = PyLong_FromLong((uint16_t)(object->ZoneType));
	return py_ZoneType;
}

static int py_DNS_RPC_ZONE_DOTNET_set_ZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ZoneType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ZoneType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ZoneType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_Version(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyLong_FromLong((uint16_t)(object->Version));
	return py_Version;
}

static int py_DNS_RPC_ZONE_DOTNET_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDpFlags));
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_DOTNET_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDpFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDpFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDpFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_DOTNET_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpFqdn = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_DOTNET_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_DOTNET_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_DOTNET_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_DOTNET_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_DOTNET_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszZoneName"),
		.get = py_DNS_RPC_ZONE_DOTNET_get_pszZoneName,
		.set = py_DNS_RPC_ZONE_DOTNET_set_pszZoneName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_DNS_RPC_ZONE_DOTNET_get_Flags,
		.set = py_DNS_RPC_ZONE_DOTNET_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_ZONE_FLAGS")
	},
	{
		.name = discard_const_p(char, "ZoneType"),
		.get = py_DNS_RPC_ZONE_DOTNET_get_ZoneType,
		.set = py_DNS_RPC_ZONE_DOTNET_set_ZoneType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Version"),
		.get = py_DNS_RPC_ZONE_DOTNET_get_Version,
		.set = py_DNS_RPC_ZONE_DOTNET_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwDpFlags"),
		.get = py_DNS_RPC_ZONE_DOTNET_get_dwDpFlags,
		.set = py_DNS_RPC_ZONE_DOTNET_set_dwDpFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_DP_FLAGS")
	},
	{
		.name = discard_const_p(char, "pszDpFqdn"),
		.get = py_DNS_RPC_ZONE_DOTNET_get_pszDpFqdn,
		.set = py_DNS_RPC_ZONE_DOTNET_set_pszDpFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_DOTNET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_LIST_W2K_get_dwZoneCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneCount;
	py_dwZoneCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneCount));
	return py_dwZoneCount;
}

static int py_DNS_RPC_ZONE_LIST_W2K_set_dwZoneCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_LIST_W2K_get_ZoneArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_ZoneArray;
	py_ZoneArray = PyList_New(object->dwZoneCount);
	if (py_ZoneArray == NULL) {
		return NULL;
	}
	{
		int ZoneArray_cntr_0;
		for (ZoneArray_cntr_0 = 0; ZoneArray_cntr_0 < (object->dwZoneCount); ZoneArray_cntr_0++) {
			PyObject *py_ZoneArray_0;
			if ((object->ZoneArray)[ZoneArray_cntr_0] == NULL) {
				py_ZoneArray_0 = Py_None;
				Py_INCREF(py_ZoneArray_0);
			} else {
				py_ZoneArray_0 = pytalloc_reference_ex(&DNS_RPC_ZONE_W2K_Type, (object->ZoneArray)[ZoneArray_cntr_0], (object->ZoneArray)[ZoneArray_cntr_0]);
			}
			PyList_SetItem(py_ZoneArray, ZoneArray_cntr_0, py_ZoneArray_0);
		}
	}
	return py_ZoneArray;
}

static int py_DNS_RPC_ZONE_LIST_W2K_set_ZoneArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ZoneArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ZoneArray_cntr_0;
		object->ZoneArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ZoneArray, PyList_GET_SIZE(value));
		if (!object->ZoneArray) { return -1; }
		talloc_set_name_const(object->ZoneArray, "ARRAY: object->ZoneArray");
		for (ZoneArray_cntr_0 = 0; ZoneArray_cntr_0 < PyList_GET_SIZE(value); ZoneArray_cntr_0++) {
			if (PyList_GET_ITEM(value, ZoneArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ZoneArray)[ZoneArray_cntr_0]");
				return -1;
			}
			if (PyList_GET_ITEM(value, ZoneArray_cntr_0) == Py_None) {
				(object->ZoneArray)[ZoneArray_cntr_0] = NULL;
			} else {
				(object->ZoneArray)[ZoneArray_cntr_0] = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_W2K_Type, PyList_GET_ITEM(value, ZoneArray_cntr_0), return -1;);
				if (talloc_reference(object->ZoneArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ZoneArray_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->ZoneArray)[ZoneArray_cntr_0] = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(PyList_GET_ITEM(value, ZoneArray_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_LIST_W2K_getsetters[] = {
	{
		.name = discard_const_p(char, "dwZoneCount"),
		.get = py_DNS_RPC_ZONE_LIST_W2K_get_dwZoneCount,
		.set = py_DNS_RPC_ZONE_LIST_W2K_set_dwZoneCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ZoneArray"),
		.get = py_DNS_RPC_ZONE_LIST_W2K_get_ZoneArray,
		.set = py_DNS_RPC_ZONE_LIST_W2K_set_ZoneArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_ZONE_W2K")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_LIST_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_LIST_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_LIST_W2K_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_LIST_W2K",
	.tp_getset = py_DNS_RPC_ZONE_LIST_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_LIST_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_LIST_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_LIST_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_get_dwZoneCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneCount;
	py_dwZoneCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneCount));
	return py_dwZoneCount;
}

static int py_DNS_RPC_ZONE_LIST_DOTNET_set_dwZoneCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_get_ZoneArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_ZoneArray;
	py_ZoneArray = PyList_New(object->dwZoneCount);
	if (py_ZoneArray == NULL) {
		return NULL;
	}
	{
		int ZoneArray_cntr_0;
		for (ZoneArray_cntr_0 = 0; ZoneArray_cntr_0 < (object->dwZoneCount); ZoneArray_cntr_0++) {
			PyObject *py_ZoneArray_0;
			if ((object->ZoneArray)[ZoneArray_cntr_0] == NULL) {
				py_ZoneArray_0 = Py_None;
				Py_INCREF(py_ZoneArray_0);
			} else {
				py_ZoneArray_0 = pytalloc_reference_ex(&DNS_RPC_ZONE_DOTNET_Type, (object->ZoneArray)[ZoneArray_cntr_0], (object->ZoneArray)[ZoneArray_cntr_0]);
			}
			PyList_SetItem(py_ZoneArray, ZoneArray_cntr_0, py_ZoneArray_0);
		}
	}
	return py_ZoneArray;
}

static int py_DNS_RPC_ZONE_LIST_DOTNET_set_ZoneArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ZoneArray");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ZoneArray_cntr_0;
		object->ZoneArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ZoneArray, PyList_GET_SIZE(value));
		if (!object->ZoneArray) { return -1; }
		talloc_set_name_const(object->ZoneArray, "ARRAY: object->ZoneArray");
		for (ZoneArray_cntr_0 = 0; ZoneArray_cntr_0 < PyList_GET_SIZE(value); ZoneArray_cntr_0++) {
			if (PyList_GET_ITEM(value, ZoneArray_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ZoneArray)[ZoneArray_cntr_0]");
				return -1;
			}
			if (PyList_GET_ITEM(value, ZoneArray_cntr_0) == Py_None) {
				(object->ZoneArray)[ZoneArray_cntr_0] = NULL;
			} else {
				(object->ZoneArray)[ZoneArray_cntr_0] = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_DOTNET_Type, PyList_GET_ITEM(value, ZoneArray_cntr_0), return -1;);
				if (talloc_reference(object->ZoneArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ZoneArray_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->ZoneArray)[ZoneArray_cntr_0] = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(PyList_GET_ITEM(value, ZoneArray_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_LIST_DOTNET_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_LIST_DOTNET_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_LIST_DOTNET_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_LIST_DOTNET_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_LIST_DOTNET_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwZoneCount"),
		.get = py_DNS_RPC_ZONE_LIST_DOTNET_get_dwZoneCount,
		.set = py_DNS_RPC_ZONE_LIST_DOTNET_set_dwZoneCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ZoneArray"),
		.get = py_DNS_RPC_ZONE_LIST_DOTNET_get_ZoneArray,
		.set = py_DNS_RPC_ZONE_LIST_DOTNET_set_ZoneArray,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_ZONE_DOTNET")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_LIST_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_LIST_DOTNET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_LIST_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_LIST_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_LIST_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneName");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneType));
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fReverse(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fReverse;
	py_fReverse = PyLong_FromUnsignedLongLong((uint32_t)(object->fReverse));
	return py_fReverse;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fReverse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReverse");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fReverse));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fReverse = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fPaused(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fPaused;
	py_fPaused = PyLong_FromUnsignedLongLong((uint32_t)(object->fPaused));
	return py_fPaused;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fPaused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fPaused");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fPaused));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fPaused = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fShutdown(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fShutdown;
	py_fShutdown = PyLong_FromUnsignedLongLong((uint32_t)(object->fShutdown));
	return py_fShutdown;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fShutdown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fShutdown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fShutdown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fShutdown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fAutoCreated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoCreated;
	py_fAutoCreated = PyLong_FromUnsignedLongLong((uint32_t)(object->fAutoCreated));
	return py_fAutoCreated;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fAutoCreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoCreated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoCreated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoCreated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fUseDatabase(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseDatabase;
	py_fUseDatabase = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseDatabase));
	return py_fUseDatabase;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fUseDatabase(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseDatabase");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseDatabase));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseDatabase = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDataFile");
		return -1;
	}
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDataFile = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipMasters));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipMasters");
		return -1;
	}
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipNotify));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipNotify");
		return -1;
	}
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fUseWins(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseWins;
	py_fUseWins = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseWins));
	return py_fUseWins;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fUseWins(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseWins");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseWins));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseWins = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fUseNbstat(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseNbstat;
	py_fUseNbstat = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseNbstat));
	return py_fUseNbstat;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fUseNbstat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseNbstat");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseNbstat));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseNbstat = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyLong_FromUnsignedLongLong((uint32_t)(object->fAging));
	return py_fAging;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAging");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAging));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAging = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_dwNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNoRefreshInterval;
	py_dwNoRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNoRefreshInterval));
	return py_dwNoRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_dwNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwNoRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNoRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNoRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_dwRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRefreshInterval;
	py_dwRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRefreshInterval));
	return py_dwRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_dwRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_dwAvailForScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwAvailForScavengeTime;
	py_dwAvailForScavengeTime = PyLong_FromUnsignedLongLong((uint32_t)(object->dwAvailForScavengeTime));
	return py_dwAvailForScavengeTime;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_dwAvailForScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwAvailForScavengeTime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwAvailForScavengeTime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwAvailForScavengeTime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_aipScavengeServers(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipScavengeServers;
	if (object->aipScavengeServers == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipScavengeServers == NULL) {
		py_aipScavengeServers = Py_None;
		Py_INCREF(py_aipScavengeServers);
	} else {
		py_aipScavengeServers = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipScavengeServers, object->aipScavengeServers);
	}
	return py_aipScavengeServers;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_aipScavengeServers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipScavengeServers));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipScavengeServers");
		return -1;
	}
	if (value == Py_None) {
		object->aipScavengeServers = NULL;
	} else {
		object->aipScavengeServers = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipScavengeServers = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved1;
	py_pvReserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->pvReserved1));
	return py_pvReserved1;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pvReserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pvReserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved2;
	py_pvReserved2 = PyLong_FromUnsignedLongLong((uint32_t)(object->pvReserved2));
	return py_pvReserved2;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pvReserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pvReserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved3;
	py_pvReserved3 = PyLong_FromUnsignedLongLong((uint32_t)(object->pvReserved3));
	return py_pvReserved3;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pvReserved3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pvReserved3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved4;
	py_pvReserved4 = PyLong_FromUnsignedLongLong((uint32_t)(object->pvReserved4));
	return py_pvReserved4;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pvReserved4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pvReserved4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_INFO_W2K_getsetters[] = {
	{
		.name = discard_const_p(char, "pszZoneName"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_pszZoneName,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_pszZoneName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwZoneType"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_dwZoneType,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_dwZoneType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fReverse"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fReverse,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fReverse,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fAllowUpdate,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_zone_update")
	},
	{
		.name = discard_const_p(char, "fPaused"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fPaused,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fPaused,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fShutdown"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fShutdown,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fShutdown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAutoCreated"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fAutoCreated,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fAutoCreated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fUseDatabase"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fUseDatabase,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fUseDatabase,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDataFile"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_pszDataFile,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_pszDataFile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "aipMasters"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_aipMasters,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_aipMasters,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipNotify"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_aipNotify,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_aipNotify,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "fUseWins"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fUseWins,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fUseWins,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fUseNbstat"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fUseNbstat,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fUseNbstat,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAging"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_fAging,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_fAging,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwNoRefreshInterval"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_dwNoRefreshInterval,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_dwNoRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRefreshInterval"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_dwRefreshInterval,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_dwRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwAvailForScavengeTime"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_dwAvailForScavengeTime,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_dwAvailForScavengeTime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aipScavengeServers"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_aipScavengeServers,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_aipScavengeServers,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "pvReserved1"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved1,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pvReserved2"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved2,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pvReserved3"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved3,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pvReserved4"),
		.get = py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved4,
		.set = py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_INFO_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_INFO_W2K_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_INFO_W2K",
	.tp_getset = py_DNS_RPC_ZONE_INFO_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_INFO_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneName");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneType));
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fReverse(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fReverse;
	py_fReverse = PyLong_FromUnsignedLongLong((uint32_t)(object->fReverse));
	return py_fReverse;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fReverse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReverse");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fReverse));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fReverse = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fPaused(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fPaused;
	py_fPaused = PyLong_FromUnsignedLongLong((uint32_t)(object->fPaused));
	return py_fPaused;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fPaused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fPaused");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fPaused));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fPaused = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fShutdown(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fShutdown;
	py_fShutdown = PyLong_FromUnsignedLongLong((uint32_t)(object->fShutdown));
	return py_fShutdown;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fShutdown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fShutdown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fShutdown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fShutdown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fAutoCreated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoCreated;
	py_fAutoCreated = PyLong_FromUnsignedLongLong((uint32_t)(object->fAutoCreated));
	return py_fAutoCreated;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fAutoCreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoCreated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoCreated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoCreated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseDatabase(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseDatabase;
	py_fUseDatabase = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseDatabase));
	return py_fUseDatabase;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseDatabase(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseDatabase");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseDatabase));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseDatabase = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDataFile");
		return -1;
	}
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDataFile = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipMasters));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipMasters");
		return -1;
	}
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipNotify));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipNotify");
		return -1;
	}
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseWins(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseWins;
	py_fUseWins = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseWins));
	return py_fUseWins;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseWins(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseWins");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseWins));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseWins = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseNbstat(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseNbstat;
	py_fUseNbstat = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseNbstat));
	return py_fUseNbstat;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseNbstat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseNbstat");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseNbstat));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseNbstat = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyLong_FromUnsignedLongLong((uint32_t)(object->fAging));
	return py_fAging;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAging");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAging));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAging = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNoRefreshInterval;
	py_dwNoRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNoRefreshInterval));
	return py_dwNoRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwNoRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNoRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNoRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRefreshInterval;
	py_dwRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRefreshInterval));
	return py_dwRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwAvailForScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwAvailForScavengeTime;
	py_dwAvailForScavengeTime = PyLong_FromUnsignedLongLong((uint32_t)(object->dwAvailForScavengeTime));
	return py_dwAvailForScavengeTime;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwAvailForScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwAvailForScavengeTime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwAvailForScavengeTime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwAvailForScavengeTime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipScavengeServers(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipScavengeServers;
	if (object->aipScavengeServers == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipScavengeServers == NULL) {
		py_aipScavengeServers = Py_None;
		Py_INCREF(py_aipScavengeServers);
	} else {
		py_aipScavengeServers = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipScavengeServers, object->aipScavengeServers);
	}
	return py_aipScavengeServers;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipScavengeServers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipScavengeServers));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipScavengeServers");
		return -1;
	}
	if (value == Py_None) {
		object->aipScavengeServers = NULL;
	} else {
		object->aipScavengeServers = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipScavengeServers = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwForwarderTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwForwarderTimeout;
	py_dwForwarderTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwForwarderTimeout));
	return py_dwForwarderTimeout;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwForwarderTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwForwarderTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwForwarderTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwForwarderTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fForwarderSlave(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fForwarderSlave;
	py_fForwarderSlave = PyLong_FromUnsignedLongLong((uint32_t)(object->fForwarderSlave));
	return py_fForwarderSlave;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fForwarderSlave(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fForwarderSlave");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fForwarderSlave));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fForwarderSlave = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipLocalMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipLocalMasters;
	if (object->aipLocalMasters == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipLocalMasters == NULL) {
		py_aipLocalMasters = Py_None;
		Py_INCREF(py_aipLocalMasters);
	} else {
		py_aipLocalMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipLocalMasters, object->aipLocalMasters);
	}
	return py_aipLocalMasters;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipLocalMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipLocalMasters));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipLocalMasters");
		return -1;
	}
	if (value == Py_None) {
		object->aipLocalMasters = NULL;
	} else {
		object->aipLocalMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipLocalMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDpFlags));
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDpFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDpFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDpFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpFqdn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pwszZoneDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszZoneDn;
	if (object->pwszZoneDn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pwszZoneDn == NULL) {
		py_pwszZoneDn = Py_None;
		Py_INCREF(py_pwszZoneDn);
	} else {
		if (object->pwszZoneDn == NULL) {
			py_pwszZoneDn = Py_None;
			Py_INCREF(py_pwszZoneDn);
		} else {
			py_pwszZoneDn = PyUnicode_Decode(object->pwszZoneDn, strlen(object->pwszZoneDn), "utf-8", "ignore");
		}
	}
	return py_pwszZoneDn;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pwszZoneDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwszZoneDn");
		return -1;
	}
	if (value == Py_None) {
		object->pwszZoneDn = NULL;
	} else {
		object->pwszZoneDn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pwszZoneDn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwLastSuccessfulSoaCheck(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLastSuccessfulSoaCheck;
	py_dwLastSuccessfulSoaCheck = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLastSuccessfulSoaCheck));
	return py_dwLastSuccessfulSoaCheck;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwLastSuccessfulSoaCheck(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLastSuccessfulSoaCheck");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLastSuccessfulSoaCheck));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLastSuccessfulSoaCheck = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwLastSuccessfulXfr(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLastSuccessfulXfr;
	py_dwLastSuccessfulXfr = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLastSuccessfulXfr));
	return py_dwLastSuccessfulXfr;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwLastSuccessfulXfr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLastSuccessfulXfr");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLastSuccessfulXfr));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLastSuccessfulXfr = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved1;
	py_dwReserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved1));
	return py_dwReserved1;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved2;
	py_dwReserved2 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved2));
	return py_dwReserved2;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved3;
	py_dwReserved3 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved3));
	return py_dwReserved3;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved4;
	py_dwReserved4 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved4));
	return py_dwReserved4;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved5(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved5;
	py_dwReserved5 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved5));
	return py_dwReserved5;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pReserved1;
	if (object->pReserved1 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pReserved1 == NULL) {
		py_pReserved1 = Py_None;
		Py_INCREF(py_pReserved1);
	} else {
		if (object->pReserved1 == NULL) {
			py_pReserved1 = Py_None;
			Py_INCREF(py_pReserved1);
		} else {
			py_pReserved1 = PyUnicode_Decode(object->pReserved1, strlen(object->pReserved1), "utf-8", "ignore");
		}
	}
	return py_pReserved1;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pReserved1");
		return -1;
	}
	if (value == Py_None) {
		object->pReserved1 = NULL;
	} else {
		object->pReserved1 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pReserved1 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pReserved2;
	if (object->pReserved2 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pReserved2 == NULL) {
		py_pReserved2 = Py_None;
		Py_INCREF(py_pReserved2);
	} else {
		if (object->pReserved2 == NULL) {
			py_pReserved2 = Py_None;
			Py_INCREF(py_pReserved2);
		} else {
			py_pReserved2 = PyUnicode_Decode(object->pReserved2, strlen(object->pReserved2), "utf-8", "ignore");
		}
	}
	return py_pReserved2;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pReserved2");
		return -1;
	}
	if (value == Py_None) {
		object->pReserved2 = NULL;
	} else {
		object->pReserved2 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pReserved2 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pReserved3;
	if (object->pReserved3 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pReserved3 == NULL) {
		py_pReserved3 = Py_None;
		Py_INCREF(py_pReserved3);
	} else {
		if (object->pReserved3 == NULL) {
			py_pReserved3 = Py_None;
			Py_INCREF(py_pReserved3);
		} else {
			py_pReserved3 = PyUnicode_Decode(object->pReserved3, strlen(object->pReserved3), "utf-8", "ignore");
		}
	}
	return py_pReserved3;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pReserved3");
		return -1;
	}
	if (value == Py_None) {
		object->pReserved3 = NULL;
	} else {
		object->pReserved3 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pReserved3 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pReserved4;
	if (object->pReserved4 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pReserved4 == NULL) {
		py_pReserved4 = Py_None;
		Py_INCREF(py_pReserved4);
	} else {
		if (object->pReserved4 == NULL) {
			py_pReserved4 = Py_None;
			Py_INCREF(py_pReserved4);
		} else {
			py_pReserved4 = PyUnicode_Decode(object->pReserved4, strlen(object->pReserved4), "utf-8", "ignore");
		}
	}
	return py_pReserved4;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pReserved4");
		return -1;
	}
	if (value == Py_None) {
		object->pReserved4 = NULL;
	} else {
		object->pReserved4 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pReserved4 = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_INFO_DOTNET_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszZoneName"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_pszZoneName,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_pszZoneName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwZoneType"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwZoneType,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwZoneType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fReverse"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fReverse,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fReverse,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fAllowUpdate,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_zone_update")
	},
	{
		.name = discard_const_p(char, "fPaused"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fPaused,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fPaused,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fShutdown"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fShutdown,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fShutdown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAutoCreated"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fAutoCreated,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fAutoCreated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fUseDatabase"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseDatabase,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseDatabase,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDataFile"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_pszDataFile,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_pszDataFile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "aipMasters"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_aipMasters,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_aipMasters,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipNotify"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_aipNotify,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_aipNotify,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "fUseWins"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseWins,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseWins,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fUseNbstat"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseNbstat,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseNbstat,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAging"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fAging,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fAging,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwNoRefreshInterval"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwNoRefreshInterval,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwNoRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRefreshInterval"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwRefreshInterval,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwAvailForScavengeTime"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwAvailForScavengeTime,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwAvailForScavengeTime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aipScavengeServers"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_aipScavengeServers,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_aipScavengeServers,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "dwForwarderTimeout"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwForwarderTimeout,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwForwarderTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fForwarderSlave"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_fForwarderSlave,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_fForwarderSlave,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aipLocalMasters"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_aipLocalMasters,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_aipLocalMasters,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "dwDpFlags"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwDpFlags,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwDpFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDpFqdn"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_pszDpFqdn,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_pszDpFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pwszZoneDn"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_pwszZoneDn,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_pwszZoneDn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dwLastSuccessfulSoaCheck"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwLastSuccessfulSoaCheck,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwLastSuccessfulSoaCheck,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLastSuccessfulXfr"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwLastSuccessfulXfr,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwLastSuccessfulXfr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved1"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved1,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved2"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved2,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved3"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved3,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved4"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved4,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved5"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved5,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pReserved1"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved1,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pReserved2"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved2,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pReserved3"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved3,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pReserved4"),
		.get = py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved4,
		.set = py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_INFO_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_INFO_DOTNET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_INFO_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_INFO_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_INFO_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneName");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneType));
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fReverse(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fReverse;
	py_fReverse = PyLong_FromUnsignedLongLong((uint32_t)(object->fReverse));
	return py_fReverse;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fReverse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReverse");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fReverse));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fReverse = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fPaused(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fPaused;
	py_fPaused = PyLong_FromUnsignedLongLong((uint32_t)(object->fPaused));
	return py_fPaused;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fPaused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fPaused");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fPaused));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fPaused = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fShutdown(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fShutdown;
	py_fShutdown = PyLong_FromUnsignedLongLong((uint32_t)(object->fShutdown));
	return py_fShutdown;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fShutdown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fShutdown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fShutdown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fShutdown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAutoCreated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAutoCreated;
	py_fAutoCreated = PyLong_FromUnsignedLongLong((uint32_t)(object->fAutoCreated));
	return py_fAutoCreated;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAutoCreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAutoCreated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAutoCreated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAutoCreated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseDatabase(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseDatabase;
	py_fUseDatabase = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseDatabase));
	return py_fUseDatabase;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseDatabase(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseDatabase");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseDatabase));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseDatabase = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDataFile");
		return -1;
	}
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDataFile = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipMasters));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipMasters");
		return -1;
	}
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipNotify));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipNotify");
		return -1;
	}
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseWins(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseWins;
	py_fUseWins = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseWins));
	return py_fUseWins;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseWins(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseWins");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseWins));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseWins = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseNbstat(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fUseNbstat;
	py_fUseNbstat = PyLong_FromUnsignedLongLong((uint32_t)(object->fUseNbstat));
	return py_fUseNbstat;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseNbstat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fUseNbstat");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fUseNbstat));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fUseNbstat = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyLong_FromUnsignedLongLong((uint32_t)(object->fAging));
	return py_fAging;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAging");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAging));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAging = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwNoRefreshInterval;
	py_dwNoRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwNoRefreshInterval));
	return py_dwNoRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwNoRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwNoRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwNoRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRefreshInterval;
	py_dwRefreshInterval = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRefreshInterval));
	return py_dwRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRefreshInterval");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRefreshInterval));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRefreshInterval = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwAvailForScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwAvailForScavengeTime;
	py_dwAvailForScavengeTime = PyLong_FromUnsignedLongLong((uint32_t)(object->dwAvailForScavengeTime));
	return py_dwAvailForScavengeTime;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwAvailForScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwAvailForScavengeTime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwAvailForScavengeTime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwAvailForScavengeTime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipScavengeServers(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipScavengeServers;
	if (object->aipScavengeServers == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipScavengeServers == NULL) {
		py_aipScavengeServers = Py_None;
		Py_INCREF(py_aipScavengeServers);
	} else {
		py_aipScavengeServers = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipScavengeServers, object->aipScavengeServers);
	}
	return py_aipScavengeServers;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipScavengeServers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipScavengeServers));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipScavengeServers");
		return -1;
	}
	if (value == Py_None) {
		object->aipScavengeServers = NULL;
	} else {
		object->aipScavengeServers = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipScavengeServers = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwForwarderTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwForwarderTimeout;
	py_dwForwarderTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwForwarderTimeout));
	return py_dwForwarderTimeout;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwForwarderTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwForwarderTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwForwarderTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwForwarderTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fForwarderSlave(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fForwarderSlave;
	py_fForwarderSlave = PyLong_FromUnsignedLongLong((uint32_t)(object->fForwarderSlave));
	return py_fForwarderSlave;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fForwarderSlave(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fForwarderSlave");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fForwarderSlave));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fForwarderSlave = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipLocalMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipLocalMasters;
	if (object->aipLocalMasters == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipLocalMasters == NULL) {
		py_aipLocalMasters = Py_None;
		Py_INCREF(py_aipLocalMasters);
	} else {
		py_aipLocalMasters = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipLocalMasters, object->aipLocalMasters);
	}
	return py_aipLocalMasters;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipLocalMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipLocalMasters));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipLocalMasters");
		return -1;
	}
	if (value == Py_None) {
		object->aipLocalMasters = NULL;
	} else {
		object->aipLocalMasters = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipLocalMasters = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDpFlags));
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDpFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDpFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDpFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpFqdn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_pwszZoneDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszZoneDn;
	if (object->pwszZoneDn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pwszZoneDn == NULL) {
		py_pwszZoneDn = Py_None;
		Py_INCREF(py_pwszZoneDn);
	} else {
		if (object->pwszZoneDn == NULL) {
			py_pwszZoneDn = Py_None;
			Py_INCREF(py_pwszZoneDn);
		} else {
			py_pwszZoneDn = PyUnicode_Decode(object->pwszZoneDn, strlen(object->pwszZoneDn), "utf-8", "ignore");
		}
	}
	return py_pwszZoneDn;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_pwszZoneDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwszZoneDn");
		return -1;
	}
	if (value == Py_None) {
		object->pwszZoneDn = NULL;
	} else {
		object->pwszZoneDn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pwszZoneDn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastSuccessfulSoaCheck(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLastSuccessfulSoaCheck;
	py_dwLastSuccessfulSoaCheck = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLastSuccessfulSoaCheck));
	return py_dwLastSuccessfulSoaCheck;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastSuccessfulSoaCheck(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLastSuccessfulSoaCheck");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLastSuccessfulSoaCheck));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLastSuccessfulSoaCheck = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastSuccessfulXfr(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLastSuccessfulXfr;
	py_dwLastSuccessfulXfr = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLastSuccessfulXfr));
	return py_dwLastSuccessfulXfr;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastSuccessfulXfr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLastSuccessfulXfr");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLastSuccessfulXfr));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLastSuccessfulXfr = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fQueuedForBackgroundLoad(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fQueuedForBackgroundLoad;
	py_fQueuedForBackgroundLoad = PyLong_FromUnsignedLongLong((uint32_t)(object->fQueuedForBackgroundLoad));
	return py_fQueuedForBackgroundLoad;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fQueuedForBackgroundLoad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fQueuedForBackgroundLoad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fQueuedForBackgroundLoad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fQueuedForBackgroundLoad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fBackgroundLoadInProgress(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fBackgroundLoadInProgress;
	py_fBackgroundLoadInProgress = PyLong_FromUnsignedLongLong((uint32_t)(object->fBackgroundLoadInProgress));
	return py_fBackgroundLoadInProgress;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fBackgroundLoadInProgress(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fBackgroundLoadInProgress");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fBackgroundLoadInProgress));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fBackgroundLoadInProgress = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fReadOnlyZone(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fReadOnlyZone;
	py_fReadOnlyZone = PyLong_FromUnsignedLongLong((uint32_t)(object->fReadOnlyZone));
	return py_fReadOnlyZone;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fReadOnlyZone(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReadOnlyZone");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fReadOnlyZone));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fReadOnlyZone = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastXfrAttempt(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLastXfrAttempt;
	py_dwLastXfrAttempt = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLastXfrAttempt));
	return py_dwLastXfrAttempt;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastXfrAttempt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLastXfrAttempt");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLastXfrAttempt));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLastXfrAttempt = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastXfrResult(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwLastXfrResult;
	py_dwLastXfrResult = PyLong_FromUnsignedLongLong((uint32_t)(object->dwLastXfrResult));
	return py_dwLastXfrResult;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastXfrResult(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwLastXfrResult");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwLastXfrResult));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwLastXfrResult = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_INFO_LONGHORN_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszZoneName"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszZoneName,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszZoneName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwZoneType"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwZoneType,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwZoneType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fReverse"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fReverse,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fReverse,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAllowUpdate,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_zone_update")
	},
	{
		.name = discard_const_p(char, "fPaused"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fPaused,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fPaused,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fShutdown"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fShutdown,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fShutdown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAutoCreated"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAutoCreated,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAutoCreated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fUseDatabase"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseDatabase,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseDatabase,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDataFile"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszDataFile,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszDataFile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "aipMasters"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipMasters,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipMasters,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipNotify"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipNotify,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipNotify,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "fUseWins"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseWins,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseWins,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fUseNbstat"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseNbstat,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseNbstat,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAging"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAging,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAging,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwNoRefreshInterval"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwNoRefreshInterval,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwNoRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwRefreshInterval"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwRefreshInterval,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwRefreshInterval,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwAvailForScavengeTime"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwAvailForScavengeTime,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwAvailForScavengeTime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aipScavengeServers"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipScavengeServers,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipScavengeServers,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "dwForwarderTimeout"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwForwarderTimeout,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwForwarderTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fForwarderSlave"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fForwarderSlave,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fForwarderSlave,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aipLocalMasters"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipLocalMasters,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipLocalMasters,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "dwDpFlags"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwDpFlags,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwDpFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDpFqdn"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszDpFqdn,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszDpFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pwszZoneDn"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_pwszZoneDn,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_pwszZoneDn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dwLastSuccessfulSoaCheck"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastSuccessfulSoaCheck,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastSuccessfulSoaCheck,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLastSuccessfulXfr"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastSuccessfulXfr,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastSuccessfulXfr,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fQueuedForBackgroundLoad"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fQueuedForBackgroundLoad,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fQueuedForBackgroundLoad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fBackgroundLoadInProgress"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fBackgroundLoadInProgress,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fBackgroundLoadInProgress,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fReadOnlyZone"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_fReadOnlyZone,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_fReadOnlyZone,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLastXfrAttempt"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastXfrAttempt,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastXfrAttempt,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwLastXfrResult"),
		.get = py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastXfrResult,
		.set = py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastXfrResult,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_INFO_LONGHORN, type);
}


static PyTypeObject DNS_RPC_ZONE_INFO_LONGHORN_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_INFO_LONGHORN",
	.tp_getset = py_DNS_RPC_ZONE_INFO_LONGHORN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_INFO_LONGHORN_new,
};


static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_W2K_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_SECONDARIES_W2K_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_W2K_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_SECONDARIES_W2K_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipNotify));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipNotify");
		return -1;
	}
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_SECONDARIES_W2K_getsetters[] = {
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_W2K_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_SECONDARIES_W2K_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_W2K_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_SECONDARIES_W2K_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_W2K_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_SECONDARIES_W2K_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipNotify"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_W2K_get_aipNotify,
		.set = py_DNS_RPC_ZONE_SECONDARIES_W2K_set_aipNotify,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_SECONDARIES_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_SECONDARIES_W2K_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_SECONDARIES_W2K",
	.tp_getset = py_DNS_RPC_ZONE_SECONDARIES_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_SECONDARIES_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipNotify));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipNotify");
		return -1;
	}
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_SECONDARIES_DOTNET_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipNotify"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_aipNotify,
		.set = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_aipNotify,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_SECONDARIES_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_SECONDARIES_DOTNET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_SECONDARIES_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipNotify));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipNotify");
		return -1;
	}
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipNotify"),
		.get = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_aipNotify,
		.set = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_aipNotify,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_SECONDARIES_LONGHORN, type);
}


static PyTypeObject DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_SECONDARIES_LONGHORN",
	.tp_getset = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_new,
};


static PyObject *py_DNS_RPC_ZONE_DATABASE_W2K_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyLong_FromUnsignedLongLong((uint32_t)(object->fDsIntegrated));
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_DATABASE_W2K_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDsIntegrated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDsIntegrated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDsIntegrated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DATABASE_W2K_get_pszFileName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszFileName;
	if (object->pszFileName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszFileName == NULL) {
		py_pszFileName = Py_None;
		Py_INCREF(py_pszFileName);
	} else {
		if (object->pszFileName == NULL) {
			py_pszFileName = Py_None;
			Py_INCREF(py_pszFileName);
		} else {
			py_pszFileName = PyUnicode_Decode(object->pszFileName, strlen(object->pszFileName), "utf-8", "ignore");
		}
	}
	return py_pszFileName;
}

static int py_DNS_RPC_ZONE_DATABASE_W2K_set_pszFileName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszFileName");
		return -1;
	}
	if (value == Py_None) {
		object->pszFileName = NULL;
	} else {
		object->pszFileName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszFileName = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_DATABASE_W2K_getsetters[] = {
	{
		.name = discard_const_p(char, "fDsIntegrated"),
		.get = py_DNS_RPC_ZONE_DATABASE_W2K_get_fDsIntegrated,
		.set = py_DNS_RPC_ZONE_DATABASE_W2K_set_fDsIntegrated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszFileName"),
		.get = py_DNS_RPC_ZONE_DATABASE_W2K_get_pszFileName,
		.set = py_DNS_RPC_ZONE_DATABASE_W2K_set_pszFileName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_DATABASE_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_DATABASE_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_DATABASE_W2K_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_DATABASE_W2K",
	.tp_getset = py_DNS_RPC_ZONE_DATABASE_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_DATABASE_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_DATABASE_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_DATABASE_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyLong_FromUnsignedLongLong((uint32_t)(object->fDsIntegrated));
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_DATABASE_DOTNET_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDsIntegrated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDsIntegrated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDsIntegrated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_get_pszFileName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszFileName;
	if (object->pszFileName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszFileName == NULL) {
		py_pszFileName = Py_None;
		Py_INCREF(py_pszFileName);
	} else {
		if (object->pszFileName == NULL) {
			py_pszFileName = Py_None;
			Py_INCREF(py_pszFileName);
		} else {
			py_pszFileName = PyUnicode_Decode(object->pszFileName, strlen(object->pszFileName), "utf-8", "ignore");
		}
	}
	return py_pszFileName;
}

static int py_DNS_RPC_ZONE_DATABASE_DOTNET_set_pszFileName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszFileName");
		return -1;
	}
	if (value == Py_None) {
		object->pszFileName = NULL;
	} else {
		object->pszFileName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszFileName = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_DATABASE_DOTNET_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_DATABASE_DOTNET_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_DATABASE_DOTNET_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_DATABASE_DOTNET_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_DATABASE_DOTNET_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fDsIntegrated"),
		.get = py_DNS_RPC_ZONE_DATABASE_DOTNET_get_fDsIntegrated,
		.set = py_DNS_RPC_ZONE_DATABASE_DOTNET_set_fDsIntegrated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszFileName"),
		.get = py_DNS_RPC_ZONE_DATABASE_DOTNET_get_pszFileName,
		.set = py_DNS_RPC_ZONE_DATABASE_DOTNET_set_pszFileName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_DATABASE_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_DATABASE_DOTNET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_DATABASE_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_DATABASE_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_DATABASE_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneName");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneType));
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyLong_FromUnsignedLongLong((uint32_t)(object->fAging));
	return py_fAging;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAging");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAging));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAging = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFlags));
	return py_dwFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDataFile");
		return -1;
	}
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDataFile = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyLong_FromUnsignedLongLong((uint32_t)(object->fDsIntegrated));
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDsIntegrated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDsIntegrated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDsIntegrated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fLoadExisting(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fLoadExisting;
	py_fLoadExisting = PyLong_FromUnsignedLongLong((uint32_t)(object->fLoadExisting));
	return py_fLoadExisting;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fLoadExisting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLoadExisting");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLoadExisting));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLoadExisting = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszAdmin(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pszAdmin;
	if (object->pszAdmin == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszAdmin == NULL) {
		py_pszAdmin = Py_None;
		Py_INCREF(py_pszAdmin);
	} else {
		if (object->pszAdmin == NULL) {
			py_pszAdmin = Py_None;
			Py_INCREF(py_pszAdmin);
		} else {
			py_pszAdmin = PyUnicode_Decode(object->pszAdmin, strlen(object->pszAdmin), "utf-8", "ignore");
		}
	}
	return py_pszAdmin;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszAdmin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszAdmin");
		return -1;
	}
	if (value == Py_None) {
		object->pszAdmin = NULL;
	} else {
		object->pszAdmin = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszAdmin = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipMasters));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipMasters");
		return -1;
	}
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved1;
	if (object->pvReserved1 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pvReserved1 == NULL) {
		py_pvReserved1 = Py_None;
		Py_INCREF(py_pvReserved1);
	} else {
		if (object->pvReserved1 == NULL) {
			py_pvReserved1 = Py_None;
			Py_INCREF(py_pvReserved1);
		} else {
			py_pvReserved1 = PyUnicode_Decode(object->pvReserved1, strlen(object->pvReserved1), "utf-8", "ignore");
		}
	}
	return py_pvReserved1;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved1");
		return -1;
	}
	if (value == Py_None) {
		object->pvReserved1 = NULL;
	} else {
		object->pvReserved1 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pvReserved1 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved2;
	if (object->pvReserved2 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pvReserved2 == NULL) {
		py_pvReserved2 = Py_None;
		Py_INCREF(py_pvReserved2);
	} else {
		if (object->pvReserved2 == NULL) {
			py_pvReserved2 = Py_None;
			Py_INCREF(py_pvReserved2);
		} else {
			py_pvReserved2 = PyUnicode_Decode(object->pvReserved2, strlen(object->pvReserved2), "utf-8", "ignore");
		}
	}
	return py_pvReserved2;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved2");
		return -1;
	}
	if (value == Py_None) {
		object->pvReserved2 = NULL;
	} else {
		object->pvReserved2 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pvReserved2 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved3;
	if (object->pvReserved3 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pvReserved3 == NULL) {
		py_pvReserved3 = Py_None;
		Py_INCREF(py_pvReserved3);
	} else {
		if (object->pvReserved3 == NULL) {
			py_pvReserved3 = Py_None;
			Py_INCREF(py_pvReserved3);
		} else {
			py_pvReserved3 = PyUnicode_Decode(object->pvReserved3, strlen(object->pvReserved3), "utf-8", "ignore");
		}
	}
	return py_pvReserved3;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved3");
		return -1;
	}
	if (value == Py_None) {
		object->pvReserved3 = NULL;
	} else {
		object->pvReserved3 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pvReserved3 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved4;
	if (object->pvReserved4 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pvReserved4 == NULL) {
		py_pvReserved4 = Py_None;
		Py_INCREF(py_pvReserved4);
	} else {
		if (object->pvReserved4 == NULL) {
			py_pvReserved4 = Py_None;
			Py_INCREF(py_pvReserved4);
		} else {
			py_pvReserved4 = PyUnicode_Decode(object->pvReserved4, strlen(object->pvReserved4), "utf-8", "ignore");
		}
	}
	return py_pvReserved4;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved4");
		return -1;
	}
	if (value == Py_None) {
		object->pvReserved4 = NULL;
	} else {
		object->pvReserved4 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pvReserved4 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved5(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved5;
	if (object->pvReserved5 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pvReserved5 == NULL) {
		py_pvReserved5 = Py_None;
		Py_INCREF(py_pvReserved5);
	} else {
		if (object->pvReserved5 == NULL) {
			py_pvReserved5 = Py_None;
			Py_INCREF(py_pvReserved5);
		} else {
			py_pvReserved5 = PyUnicode_Decode(object->pvReserved5, strlen(object->pvReserved5), "utf-8", "ignore");
		}
	}
	return py_pvReserved5;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved5");
		return -1;
	}
	if (value == Py_None) {
		object->pvReserved5 = NULL;
	} else {
		object->pvReserved5 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pvReserved5 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved6(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved6;
	if (object->pvReserved6 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pvReserved6 == NULL) {
		py_pvReserved6 = Py_None;
		Py_INCREF(py_pvReserved6);
	} else {
		if (object->pvReserved6 == NULL) {
			py_pvReserved6 = Py_None;
			Py_INCREF(py_pvReserved6);
		} else {
			py_pvReserved6 = PyUnicode_Decode(object->pvReserved6, strlen(object->pvReserved6), "utf-8", "ignore");
		}
	}
	return py_pvReserved6;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved6");
		return -1;
	}
	if (value == Py_None) {
		object->pvReserved6 = NULL;
	} else {
		object->pvReserved6 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pvReserved6 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved7(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved7;
	if (object->pvReserved7 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pvReserved7 == NULL) {
		py_pvReserved7 = Py_None;
		Py_INCREF(py_pvReserved7);
	} else {
		if (object->pvReserved7 == NULL) {
			py_pvReserved7 = Py_None;
			Py_INCREF(py_pvReserved7);
		} else {
			py_pvReserved7 = PyUnicode_Decode(object->pvReserved7, strlen(object->pvReserved7), "utf-8", "ignore");
		}
	}
	return py_pvReserved7;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved7");
		return -1;
	}
	if (value == Py_None) {
		object->pvReserved7 = NULL;
	} else {
		object->pvReserved7 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pvReserved7 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved8(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_pvReserved8;
	if (object->pvReserved8 == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pvReserved8 == NULL) {
		py_pvReserved8 = Py_None;
		Py_INCREF(py_pvReserved8);
	} else {
		if (object->pvReserved8 == NULL) {
			py_pvReserved8 = Py_None;
			Py_INCREF(py_pvReserved8);
		} else {
			py_pvReserved8 = PyUnicode_Decode(object->pvReserved8, strlen(object->pvReserved8), "utf-8", "ignore");
		}
	}
	return py_pvReserved8;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pvReserved8");
		return -1;
	}
	if (value == Py_None) {
		object->pvReserved8 = NULL;
	} else {
		object->pvReserved8 = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pvReserved8 = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved1;
	py_dwReserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved1));
	return py_dwReserved1;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved2;
	py_dwReserved2 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved2));
	return py_dwReserved2;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved3;
	py_dwReserved3 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved3));
	return py_dwReserved3;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved4;
	py_dwReserved4 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved4));
	return py_dwReserved4;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved4");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved4));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved4 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved5(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved5;
	py_dwReserved5 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved5));
	return py_dwReserved5;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved5");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved5));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved5 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved6(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved6;
	py_dwReserved6 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved6));
	return py_dwReserved6;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved6");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved6));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved6 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved7(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved7;
	py_dwReserved7 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved7));
	return py_dwReserved7;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved7");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved7));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved7 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved8(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved8;
	py_dwReserved8 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved8));
	return py_dwReserved8;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved8");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved8));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved8 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_CREATE_INFO_W2K_getsetters[] = {
	{
		.name = discard_const_p(char, "pszZoneName"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszZoneName,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszZoneName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwZoneType"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwZoneType,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwZoneType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fAllowUpdate,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_zone_update")
	},
	{
		.name = discard_const_p(char, "fAging"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fAging,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fAging,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwFlags"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwFlags,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDataFile"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszDataFile,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszDataFile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDsIntegrated"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fDsIntegrated,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fDsIntegrated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fLoadExisting"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fLoadExisting,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fLoadExisting,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszAdmin"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszAdmin,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszAdmin,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "aipMasters"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_aipMasters,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_aipMasters,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "pvReserved1"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved1,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pvReserved2"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved2,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pvReserved3"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved3,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pvReserved4"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved4,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pvReserved5"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved5,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pvReserved6"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved6,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pvReserved7"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved7,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pvReserved8"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved8,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwReserved1"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved1,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved2"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved2,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved3"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved3,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved4"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved4,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved4,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved5"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved5,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved5,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved6"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved6,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved6,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved7"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved7,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved7,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved8"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved8,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved8,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_CREATE_INFO_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_W2K_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_CREATE_INFO_W2K",
	.tp_getset = py_DNS_RPC_ZONE_CREATE_INFO_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_CREATE_INFO_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneName");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneType));
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyLong_FromUnsignedLongLong((uint32_t)(object->fAging));
	return py_fAging;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAging");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAging));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAging = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFlags));
	return py_dwFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDataFile");
		return -1;
	}
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDataFile = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyLong_FromUnsignedLongLong((uint32_t)(object->fDsIntegrated));
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDsIntegrated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDsIntegrated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDsIntegrated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fLoadExisting(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fLoadExisting;
	py_fLoadExisting = PyLong_FromUnsignedLongLong((uint32_t)(object->fLoadExisting));
	return py_fLoadExisting;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fLoadExisting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLoadExisting");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLoadExisting));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLoadExisting = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszAdmin(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszAdmin;
	if (object->pszAdmin == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszAdmin == NULL) {
		py_pszAdmin = Py_None;
		Py_INCREF(py_pszAdmin);
	} else {
		if (object->pszAdmin == NULL) {
			py_pszAdmin = Py_None;
			Py_INCREF(py_pszAdmin);
		} else {
			py_pszAdmin = PyUnicode_Decode(object->pszAdmin, strlen(object->pszAdmin), "utf-8", "ignore");
		}
	}
	return py_pszAdmin;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszAdmin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszAdmin");
		return -1;
	}
	if (value == Py_None) {
		object->pszAdmin = NULL;
	} else {
		object->pszAdmin = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszAdmin = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipMasters));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipMasters");
		return -1;
	}
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTimeout;
	py_dwTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwTimeout));
	return py_dwTimeout;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyLong_FromUnsignedLongLong((uint32_t)(object->fRecurseAfterForwarding));
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRecurseAfterForwarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRecurseAfterForwarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRecurseAfterForwarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDpFlags));
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDpFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDpFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDpFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpFqdn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyList_New(32);
	if (py_dwReserved == NULL) {
		return NULL;
	}
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < (32); dwReserved_cntr_0++) {
			PyObject *py_dwReserved_0;
			py_dwReserved_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->dwReserved)[dwReserved_cntr_0]));
			PyList_SetItem(py_dwReserved, dwReserved_cntr_0, py_dwReserved_0);
		}
	}
	return py_dwReserved;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserved_cntr_0;
		if (ARRAY_SIZE(object->dwReserved) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->dwReserved),  PyList_GET_SIZE(value));
			return -1;
		}
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < PyList_GET_SIZE(value); dwReserved_cntr_0++) {
			if (PyList_GET_ITEM(value, dwReserved_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->dwReserved)[dwReserved_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->dwReserved)[dwReserved_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, dwReserved_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, dwReserved_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->dwReserved)[dwReserved_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszZoneName"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszZoneName,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszZoneName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwZoneType"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwZoneType,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwZoneType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fAllowUpdate,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_zone_update")
	},
	{
		.name = discard_const_p(char, "fAging"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fAging,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fAging,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwFlags"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwFlags,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDataFile"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszDataFile,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszDataFile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDsIntegrated"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fDsIntegrated,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fDsIntegrated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fLoadExisting"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fLoadExisting,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fLoadExisting,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszAdmin"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszAdmin,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszAdmin,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "aipMasters"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_aipMasters,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_aipMasters,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "dwTimeout"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwTimeout,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fRecurseAfterForwarding"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fRecurseAfterForwarding,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fRecurseAfterForwarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDpFlags"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwDpFlags,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwDpFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDpFqdn"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszDpFqdn,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszDpFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwReserved"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwReserved,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_CREATE_INFO_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_CREATE_INFO_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneName");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyLong_FromUnsignedLongLong((uint32_t)(object->dwZoneType));
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwZoneType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwZoneType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwZoneType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyLong_FromLong((uint16_t)(object->fAllowUpdate));
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAllowUpdate");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAllowUpdate));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAllowUpdate = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyLong_FromUnsignedLongLong((uint32_t)(object->fAging));
	return py_fAging;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fAging");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fAging));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fAging = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFlags));
	return py_dwFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDataFile");
		return -1;
	}
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDataFile = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyLong_FromUnsignedLongLong((uint32_t)(object->fDsIntegrated));
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fDsIntegrated");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fDsIntegrated));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fDsIntegrated = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fLoadExisting(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fLoadExisting;
	py_fLoadExisting = PyLong_FromUnsignedLongLong((uint32_t)(object->fLoadExisting));
	return py_fLoadExisting;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fLoadExisting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fLoadExisting");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fLoadExisting));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fLoadExisting = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszAdmin(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszAdmin;
	if (object->pszAdmin == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszAdmin == NULL) {
		py_pszAdmin = Py_None;
		Py_INCREF(py_pszAdmin);
	} else {
		if (object->pszAdmin == NULL) {
			py_pszAdmin = Py_None;
			Py_INCREF(py_pszAdmin);
		} else {
			py_pszAdmin = PyUnicode_Decode(object->pszAdmin, strlen(object->pszAdmin), "utf-8", "ignore");
		}
	}
	return py_pszAdmin;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszAdmin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszAdmin");
		return -1;
	}
	if (value == Py_None) {
		object->pszAdmin = NULL;
	} else {
		object->pszAdmin = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszAdmin = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipMasters));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipMasters");
		return -1;
	}
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipSecondaries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipSecondaries");
		return -1;
	}
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyLong_FromUnsignedLongLong((uint32_t)(object->fSecureSecondaries));
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fSecureSecondaries");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fSecureSecondaries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fSecureSecondaries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyLong_FromUnsignedLongLong((uint32_t)(object->fNotifyLevel));
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fNotifyLevel");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fNotifyLevel));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fNotifyLevel = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTimeout;
	py_dwTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwTimeout));
	return py_dwTimeout;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyLong_FromUnsignedLongLong((uint32_t)(object->fRecurseAfterForwarding));
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRecurseAfterForwarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRecurseAfterForwarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRecurseAfterForwarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwDpFlags));
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwDpFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwDpFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwDpFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszDpFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszDpFqdn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyList_New(32);
	if (py_dwReserved == NULL) {
		return NULL;
	}
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < (32); dwReserved_cntr_0++) {
			PyObject *py_dwReserved_0;
			py_dwReserved_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->dwReserved)[dwReserved_cntr_0]));
			PyList_SetItem(py_dwReserved, dwReserved_cntr_0, py_dwReserved_0);
		}
	}
	return py_dwReserved;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserved_cntr_0;
		if (ARRAY_SIZE(object->dwReserved) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->dwReserved),  PyList_GET_SIZE(value));
			return -1;
		}
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < PyList_GET_SIZE(value); dwReserved_cntr_0++) {
			if (PyList_GET_ITEM(value, dwReserved_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->dwReserved)[dwReserved_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->dwReserved)[dwReserved_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, dwReserved_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, dwReserved_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->dwReserved)[dwReserved_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszZoneName"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszZoneName,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszZoneName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwZoneType"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwZoneType,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwZoneType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fAllowUpdate"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fAllowUpdate,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fAllowUpdate,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_zone_update")
	},
	{
		.name = discard_const_p(char, "fAging"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fAging,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fAging,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwFlags"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwFlags,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDataFile"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszDataFile,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszDataFile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fDsIntegrated"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fDsIntegrated,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fDsIntegrated,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fLoadExisting"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fLoadExisting,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fLoadExisting,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszAdmin"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszAdmin,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszAdmin,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "aipMasters"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_aipMasters,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_aipMasters,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "aipSecondaries"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_aipSecondaries,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_aipSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{
		.name = discard_const_p(char, "fSecureSecondaries"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fSecureSecondaries,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fSecureSecondaries,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_SECONDARY_SECURITY")
	},
	{
		.name = discard_const_p(char, "fNotifyLevel"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fNotifyLevel,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fNotifyLevel,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ZONE_NOTIFY_LEVEL")
	},
	{
		.name = discard_const_p(char, "dwTimeout"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwTimeout,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fRecurseAfterForwarding"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fRecurseAfterForwarding,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fRecurseAfterForwarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwDpFlags"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwDpFlags,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwDpFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszDpFqdn"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszDpFqdn,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszDpFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dwReserved"),
		.get = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwReserved,
		.set = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN, type);
}


static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_CREATE_INFO_LONGHORN",
	.tp_getset = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_new,
};


static PyObject *py_DNS_RPC_ZONE_EXPORT_INFO_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_EXPORT_INFO_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_EXPORT_INFO_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_EXPORT_INFO_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_EXPORT_INFO_get_pszZoneExportFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZoneExportFile;
	if (object->pszZoneExportFile == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszZoneExportFile == NULL) {
		py_pszZoneExportFile = Py_None;
		Py_INCREF(py_pszZoneExportFile);
	} else {
		if (object->pszZoneExportFile == NULL) {
			py_pszZoneExportFile = Py_None;
			Py_INCREF(py_pszZoneExportFile);
		} else {
			py_pszZoneExportFile = PyUnicode_Decode(object->pszZoneExportFile, strlen(object->pszZoneExportFile), "utf-8", "ignore");
		}
	}
	return py_pszZoneExportFile;
}

static int py_DNS_RPC_ZONE_EXPORT_INFO_set_pszZoneExportFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszZoneExportFile");
		return -1;
	}
	if (value == Py_None) {
		object->pszZoneExportFile = NULL;
	} else {
		object->pszZoneExportFile = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszZoneExportFile = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_EXPORT_INFO_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ZONE_EXPORT_INFO_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ZONE_EXPORT_INFO_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ZONE_EXPORT_INFO_get_dwReserved0,
		.set = py_DNS_RPC_ZONE_EXPORT_INFO_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszZoneExportFile"),
		.get = py_DNS_RPC_ZONE_EXPORT_INFO_get_pszZoneExportFile,
		.set = py_DNS_RPC_ZONE_EXPORT_INFO_set_pszZoneExportFile,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ZONE_EXPORT_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_EXPORT_INFO, type);
}


static PyTypeObject DNS_RPC_ZONE_EXPORT_INFO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ZONE_EXPORT_INFO",
	.tp_getset = py_DNS_RPC_ZONE_EXPORT_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ZONE_EXPORT_INFO_new,
};


static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_dwFilter(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFilter;
	py_dwFilter = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFilter));
	return py_dwFilter;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_dwFilter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFilter");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFilter));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFilter = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_pszPartitionFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(obj);
	PyObject *py_pszPartitionFqdn;
	if (object->pszPartitionFqdn == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszPartitionFqdn == NULL) {
		py_pszPartitionFqdn = Py_None;
		Py_INCREF(py_pszPartitionFqdn);
	} else {
		if (object->pszPartitionFqdn == NULL) {
			py_pszPartitionFqdn = Py_None;
			Py_INCREF(py_pszPartitionFqdn);
		} else {
			py_pszPartitionFqdn = PyUnicode_Decode(object->pszPartitionFqdn, strlen(object->pszPartitionFqdn), "utf-8", "ignore");
		}
	}
	return py_pszPartitionFqdn;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_pszPartitionFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszPartitionFqdn");
		return -1;
	}
	if (value == Py_None) {
		object->pszPartitionFqdn = NULL;
	} else {
		object->pszPartitionFqdn = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszPartitionFqdn = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_pszQueryString(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(obj);
	PyObject *py_pszQueryString;
	if (object->pszQueryString == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszQueryString == NULL) {
		py_pszQueryString = Py_None;
		Py_INCREF(py_pszQueryString);
	} else {
		if (object->pszQueryString == NULL) {
			py_pszQueryString = Py_None;
			Py_INCREF(py_pszQueryString);
		} else {
			py_pszQueryString = PyUnicode_Decode(object->pszQueryString, strlen(object->pszQueryString), "utf-8", "ignore");
		}
	}
	return py_pszQueryString;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_pszQueryString(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszQueryString");
		return -1;
	}
	if (value == Py_None) {
		object->pszQueryString = NULL;
	} else {
		object->pszQueryString = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszQueryString = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_pszReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(obj);
	PyObject *py_pszReserved;
	py_pszReserved = PyList_New(6);
	if (py_pszReserved == NULL) {
		return NULL;
	}
	{
		int pszReserved_cntr_0;
		for (pszReserved_cntr_0 = 0; pszReserved_cntr_0 < (6); pszReserved_cntr_0++) {
			PyObject *py_pszReserved_0;
			py_pszReserved_0 = pytalloc_reference_ex(&DNS_EXTENSION_Type, pytalloc_get_mem_ctx(obj), &(object->pszReserved)[pszReserved_cntr_0]);
			PyList_SetItem(py_pszReserved, pszReserved_cntr_0, py_pszReserved_0);
		}
	}
	return py_pszReserved;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_pszReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszReserved");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pszReserved_cntr_0;
		if (ARRAY_SIZE(object->pszReserved) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->pszReserved),  PyList_GET_SIZE(value));
			return -1;
		}
		for (pszReserved_cntr_0 = 0; pszReserved_cntr_0 < PyList_GET_SIZE(value); pszReserved_cntr_0++) {
			if (PyList_GET_ITEM(value, pszReserved_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->pszReserved)[pszReserved_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&DNS_EXTENSION_Type, PyList_GET_ITEM(value, pszReserved_cntr_0), return -1;);
			if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pszReserved_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->pszReserved)[pszReserved_cntr_0] = *(struct DNS_EXTENSION *)pytalloc_get_ptr(PyList_GET_ITEM(value, pszReserved_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ENUM_ZONES_FILTER_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_ENUM_ZONES_FILTER_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_ENUM_ZONES_FILTER_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_ENUM_ZONES_FILTER_get_dwReserved0,
		.set = py_DNS_RPC_ENUM_ZONES_FILTER_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwFilter"),
		.get = py_DNS_RPC_ENUM_ZONES_FILTER_get_dwFilter,
		.set = py_DNS_RPC_ENUM_ZONES_FILTER_set_dwFilter,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszPartitionFqdn"),
		.get = py_DNS_RPC_ENUM_ZONES_FILTER_get_pszPartitionFqdn,
		.set = py_DNS_RPC_ENUM_ZONES_FILTER_set_pszPartitionFqdn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszQueryString"),
		.get = py_DNS_RPC_ENUM_ZONES_FILTER_get_pszQueryString,
		.set = py_DNS_RPC_ENUM_ZONES_FILTER_set_pszQueryString,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pszReserved"),
		.get = py_DNS_RPC_ENUM_ZONES_FILTER_get_pszReserved,
		.set = py_DNS_RPC_ENUM_ZONES_FILTER_set_pszReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_EXTENSION")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ENUM_ZONES_FILTER, type);
}


static PyTypeObject DNS_RPC_ENUM_ZONES_FILTER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_ENUM_ZONES_FILTER",
	.tp_getset = py_DNS_RPC_ENUM_ZONES_FILTER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_ENUM_ZONES_FILTER_new,
};


static PyObject *py_DNS_RPC_FORWARDERS_W2K_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyLong_FromUnsignedLongLong((uint32_t)(object->fRecurseAfterForwarding));
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_FORWARDERS_W2K_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRecurseAfterForwarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRecurseAfterForwarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRecurseAfterForwarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_W2K_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwForwardTimeout));
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_FORWARDERS_W2K_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwForwardTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwForwardTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwForwardTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_W2K_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_FORWARDERS_W2K_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipForwarders));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipForwarders");
		return -1;
	}
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_FORWARDERS_W2K_getsetters[] = {
	{
		.name = discard_const_p(char, "fRecurseAfterForwarding"),
		.get = py_DNS_RPC_FORWARDERS_W2K_get_fRecurseAfterForwarding,
		.set = py_DNS_RPC_FORWARDERS_W2K_set_fRecurseAfterForwarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwForwardTimeout"),
		.get = py_DNS_RPC_FORWARDERS_W2K_get_dwForwardTimeout,
		.set = py_DNS_RPC_FORWARDERS_W2K_set_dwForwardTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aipForwarders"),
		.get = py_DNS_RPC_FORWARDERS_W2K_get_aipForwarders,
		.set = py_DNS_RPC_FORWARDERS_W2K_set_aipForwarders,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_FORWARDERS_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_FORWARDERS_W2K, type);
}


static PyTypeObject DNS_RPC_FORWARDERS_W2K_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_FORWARDERS_W2K",
	.tp_getset = py_DNS_RPC_FORWARDERS_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_FORWARDERS_W2K_new,
};


static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyLong_FromUnsignedLongLong((uint32_t)(object->fRecurseAfterForwarding));
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRecurseAfterForwarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRecurseAfterForwarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRecurseAfterForwarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwForwardTimeout));
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwForwardTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwForwardTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwForwardTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipForwarders));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipForwarders");
		return -1;
	}
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_FORWARDERS_DOTNET_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_FORWARDERS_DOTNET_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_FORWARDERS_DOTNET_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_FORWARDERS_DOTNET_get_dwReserved0,
		.set = py_DNS_RPC_FORWARDERS_DOTNET_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fRecurseAfterForwarding"),
		.get = py_DNS_RPC_FORWARDERS_DOTNET_get_fRecurseAfterForwarding,
		.set = py_DNS_RPC_FORWARDERS_DOTNET_set_fRecurseAfterForwarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwForwardTimeout"),
		.get = py_DNS_RPC_FORWARDERS_DOTNET_get_dwForwardTimeout,
		.set = py_DNS_RPC_FORWARDERS_DOTNET_set_dwForwardTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aipForwarders"),
		.get = py_DNS_RPC_FORWARDERS_DOTNET_get_aipForwarders,
		.set = py_DNS_RPC_FORWARDERS_DOTNET_set_aipForwarders,
		.doc = discard_const_p(char, "PIDL-generated element of base type IP4_ARRAY")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_FORWARDERS_DOTNET, type);
}


static PyTypeObject DNS_RPC_FORWARDERS_DOTNET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_FORWARDERS_DOTNET",
	.tp_getset = py_DNS_RPC_FORWARDERS_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_FORWARDERS_DOTNET_new,
};


static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyLong_FromUnsignedLongLong((uint32_t)(object->fRecurseAfterForwarding));
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fRecurseAfterForwarding");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fRecurseAfterForwarding));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fRecurseAfterForwarding = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->dwForwardTimeout));
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwForwardTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwForwardTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwForwardTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		Py_RETURN_NONE;
	}
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->aipForwarders));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->aipForwarders");
		return -1;
	}
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_FORWARDERS_LONGHORN_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_FORWARDERS_LONGHORN_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_FORWARDERS_LONGHORN_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_FORWARDERS_LONGHORN_get_dwReserved0,
		.set = py_DNS_RPC_FORWARDERS_LONGHORN_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fRecurseAfterForwarding"),
		.get = py_DNS_RPC_FORWARDERS_LONGHORN_get_fRecurseAfterForwarding,
		.set = py_DNS_RPC_FORWARDERS_LONGHORN_set_fRecurseAfterForwarding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwForwardTimeout"),
		.get = py_DNS_RPC_FORWARDERS_LONGHORN_get_dwForwardTimeout,
		.set = py_DNS_RPC_FORWARDERS_LONGHORN_set_dwForwardTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "aipForwarders"),
		.get = py_DNS_RPC_FORWARDERS_LONGHORN_get_aipForwarders,
		.set = py_DNS_RPC_FORWARDERS_LONGHORN_set_aipForwarders,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_ADDR_ARRAY")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_FORWARDERS_LONGHORN, type);
}


static PyTypeObject DNS_RPC_FORWARDERS_LONGHORN_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_FORWARDERS_LONGHORN",
	.tp_getset = py_DNS_RPC_FORWARDERS_LONGHORN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_FORWARDERS_LONGHORN_new,
};


static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->dwRpcStructureVersion));
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwRpcStructureVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwRpcStructureVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwRpcStructureVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved0));
	return py_dwReserved0;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved0");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved0));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved0 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_dwAutoConfigFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwAutoConfigFlags;
	py_dwAutoConfigFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwAutoConfigFlags));
	return py_dwAutoConfigFlags;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_dwAutoConfigFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwAutoConfigFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwAutoConfigFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwAutoConfigFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_dwReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(obj);
	PyObject *py_dwReserved1;
	py_dwReserved1 = PyLong_FromUnsignedLongLong((uint32_t)(object->dwReserved1));
	return py_dwReserved1;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_dwReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwReserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwReserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwReserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_pszNewDomainName(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(obj);
	PyObject *py_pszNewDomainName;
	if (object->pszNewDomainName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pszNewDomainName == NULL) {
		py_pszNewDomainName = Py_None;
		Py_INCREF(py_pszNewDomainName);
	} else {
		if (object->pszNewDomainName == NULL) {
			py_pszNewDomainName = Py_None;
			Py_INCREF(py_pszNewDomainName);
		} else {
			py_pszNewDomainName = PyUnicode_Decode(object->pszNewDomainName, strlen(object->pszNewDomainName), "utf-8", "ignore");
		}
	}
	return py_pszNewDomainName;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_pszNewDomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pszNewDomainName");
		return -1;
	}
	if (value == Py_None) {
		object->pszNewDomainName = NULL;
	} else {
		object->pszNewDomainName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszNewDomainName = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_AUTOCONFIGURE_getsetters[] = {
	{
		.name = discard_const_p(char, "dwRpcStructureVersion"),
		.get = py_DNS_RPC_AUTOCONFIGURE_get_dwRpcStructureVersion,
		.set = py_DNS_RPC_AUTOCONFIGURE_set_dwRpcStructureVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwReserved0"),
		.get = py_DNS_RPC_AUTOCONFIGURE_get_dwReserved0,
		.set = py_DNS_RPC_AUTOCONFIGURE_set_dwReserved0,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwAutoConfigFlags"),
		.get = py_DNS_RPC_AUTOCONFIGURE_get_dwAutoConfigFlags,
		.set = py_DNS_RPC_AUTOCONFIGURE_set_dwAutoConfigFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_AUTOCONFIG")
	},
	{
		.name = discard_const_p(char, "dwReserved1"),
		.get = py_DNS_RPC_AUTOCONFIGURE_get_dwReserved1,
		.set = py_DNS_RPC_AUTOCONFIGURE_set_dwReserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pszNewDomainName"),
		.get = py_DNS_RPC_AUTOCONFIGURE_get_pszNewDomainName,
		.set = py_DNS_RPC_AUTOCONFIGURE_set_pszNewDomainName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_AUTOCONFIGURE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_AUTOCONFIGURE, type);
}


static PyTypeObject DNS_RPC_AUTOCONFIGURE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_AUTOCONFIGURE",
	.tp_getset = py_DNS_RPC_AUTOCONFIGURE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_AUTOCONFIGURE_new,
};


static PyObject *py_DNSSRV_STAT_HEADER_get_StatId(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = pytalloc_get_ptr(obj);
	PyObject *py_StatId;
	py_StatId = PyLong_FromUnsignedLongLong((uint32_t)(object->StatId));
	return py_StatId;
}

static int py_DNSSRV_STAT_HEADER_set_StatId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->StatId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->StatId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->StatId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNSSRV_STAT_HEADER_get_wLength(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = pytalloc_get_ptr(obj);
	PyObject *py_wLength;
	py_wLength = PyLong_FromLong((uint16_t)(object->wLength));
	return py_wLength;
}

static int py_DNSSRV_STAT_HEADER_set_wLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNSSRV_STAT_HEADER_get_fClear(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = pytalloc_get_ptr(obj);
	PyObject *py_fClear;
	py_fClear = PyLong_FromLong((uint16_t)(object->fClear));
	return py_fClear;
}

static int py_DNSSRV_STAT_HEADER_set_fClear(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fClear");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fClear));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fClear = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNSSRV_STAT_HEADER_get_fReserved(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = pytalloc_get_ptr(obj);
	PyObject *py_fReserved;
	py_fReserved = PyLong_FromLong((uint16_t)(object->fReserved));
	return py_fReserved;
}

static int py_DNSSRV_STAT_HEADER_set_fReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fReserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fReserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fReserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNSSRV_STAT_HEADER_getsetters[] = {
	{
		.name = discard_const_p(char, "StatId"),
		.get = py_DNSSRV_STAT_HEADER_get_StatId,
		.set = py_DNSSRV_STAT_HEADER_set_StatId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "wLength"),
		.get = py_DNSSRV_STAT_HEADER_get_wLength,
		.set = py_DNSSRV_STAT_HEADER_set_wLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "fClear"),
		.get = py_DNSSRV_STAT_HEADER_get_fClear,
		.set = py_DNSSRV_STAT_HEADER_set_fClear,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fReserved"),
		.get = py_DNSSRV_STAT_HEADER_get_fReserved,
		.set = py_DNSSRV_STAT_HEADER_set_fReserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNSSRV_STAT_HEADER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNSSRV_STAT_HEADER, type);
}


static PyTypeObject DNSSRV_STAT_HEADER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNSSRV_STAT_HEADER",
	.tp_getset = py_DNSSRV_STAT_HEADER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNSSRV_STAT_HEADER_new,
};


static PyObject *py_DNSSRV_STAT_get_Header(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT *object = pytalloc_get_ptr(obj);
	PyObject *py_Header;
	py_Header = pytalloc_reference_ex(&DNSSRV_STAT_HEADER_Type, pytalloc_get_mem_ctx(obj), &object->Header);
	return py_Header;
}

static int py_DNSSRV_STAT_set_Header(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Header");
		return -1;
	}
	PY_CHECK_TYPE(&DNSSRV_STAT_HEADER_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Header = *(struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_DNSSRV_STAT_get_Buffer(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT *object = pytalloc_get_ptr(obj);
	PyObject *py_Buffer;
	py_Buffer = PyList_New(1);
	if (py_Buffer == NULL) {
		return NULL;
	}
	{
		int Buffer_cntr_0;
		for (Buffer_cntr_0 = 0; Buffer_cntr_0 < (1); Buffer_cntr_0++) {
			PyObject *py_Buffer_0;
			py_Buffer_0 = PyLong_FromLong((uint16_t)((object->Buffer)[Buffer_cntr_0]));
			PyList_SetItem(py_Buffer, Buffer_cntr_0, py_Buffer_0);
		}
	}
	return py_Buffer;
}

static int py_DNSSRV_STAT_set_Buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Buffer");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Buffer_cntr_0;
		if (ARRAY_SIZE(object->Buffer) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Buffer),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Buffer_cntr_0 = 0; Buffer_cntr_0 < PyList_GET_SIZE(value); Buffer_cntr_0++) {
			if (PyList_GET_ITEM(value, Buffer_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Buffer)[Buffer_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Buffer)[Buffer_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Buffer_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Buffer_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Buffer)[Buffer_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNSSRV_STAT_getsetters[] = {
	{
		.name = discard_const_p(char, "Header"),
		.get = py_DNSSRV_STAT_get_Header,
		.set = py_DNSSRV_STAT_set_Header,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNSSRV_STAT_HEADER")
	},
	{
		.name = discard_const_p(char, "Buffer"),
		.get = py_DNSSRV_STAT_get_Buffer,
		.set = py_DNSSRV_STAT_set_Buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_DNSSRV_STAT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNSSRV_STAT, type);
}


static PyTypeObject DNSSRV_STAT_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNSSRV_STAT",
	.tp_getset = py_DNSSRV_STAT_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNSSRV_STAT_new,
};

static PyObject *py_import_DNSSRV_RPC_UNION(TALLOC_CTX *mem_ctx, int level, union DNSSRV_RPC_UNION *in)
{
	PyObject *ret;

	switch (level) {
		case DNSSRV_TYPEID_NULL:
			if (in->Null == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromLong((uint16_t)(*in->Null));
			}
			return ret;

		case DNSSRV_TYPEID_DWORD:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->Dword));
			return ret;

		case DNSSRV_TYPEID_LPSTR:
			if (in->String == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->String == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->String, strlen(in->String), "utf-8", "ignore");
				}
			}
			return ret;

		case DNSSRV_TYPEID_LPWSTR:
			if (in->WideString == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->WideString == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->WideString, strlen(in->WideString), "utf-8", "ignore");
				}
			}
			return ret;

		case DNSSRV_TYPEID_IPARRAY:
			if (in->IpArray == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&IP4_ARRAY_Type, in->IpArray, in->IpArray);
			}
			return ret;

		case DNSSRV_TYPEID_BUFFER:
			if (in->Buffer == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_BUFFER_Type, in->Buffer, in->Buffer);
			}
			return ret;

		case DNSSRV_TYPEID_SERVER_INFO_W2K:
			if (in->ServerInfoW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_SERVER_INFO_W2K_Type, in->ServerInfoW2K, in->ServerInfoW2K);
			}
			return ret;

		case DNSSRV_TYPEID_STATS:
			if (in->Stats == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNSSRV_STAT_Type, in->Stats, in->Stats);
			}
			return ret;

		case DNSSRV_TYPEID_FORWARDERS_W2K:
			if (in->ForwardersW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_FORWARDERS_W2K_Type, in->ForwardersW2K, in->ForwardersW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_W2K:
			if (in->ZoneW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_W2K_Type, in->ZoneW2K, in->ZoneW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_INFO_W2K:
			if (in->ZoneInfoW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_INFO_W2K_Type, in->ZoneInfoW2K, in->ZoneInfoW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K:
			if (in->SecondariesW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_SECONDARIES_W2K_Type, in->SecondariesW2K, in->SecondariesW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_DATABASE_W2K:
			if (in->DatabaseW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_DATABASE_W2K_Type, in->DatabaseW2K, in->DatabaseW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_CREATE_W2K:
			if (in->ZoneCreateW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_CREATE_INFO_W2K_Type, in->ZoneCreateW2K, in->ZoneCreateW2K);
			}
			return ret;

		case DNSSRV_TYPEID_NAME_AND_PARAM:
			if (in->NameAndParam == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_NAME_AND_PARAM_Type, in->NameAndParam, in->NameAndParam);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_LIST_W2K:
			if (in->ZoneListW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_LIST_W2K_Type, in->ZoneListW2K, in->ZoneListW2K);
			}
			return ret;

		case DNSSRV_TYPEID_SERVER_INFO_DOTNET:
			if (in->ServerInfoDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_SERVER_INFO_DOTNET_Type, in->ServerInfoDotNet, in->ServerInfoDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_FORWARDERS_DOTNET:
			if (in->ForwardersDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_FORWARDERS_DOTNET_Type, in->ForwardersDotNet, in->ForwardersDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE:
			if (in->Zone == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_DOTNET_Type, in->Zone, in->Zone);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_INFO_DOTNET:
			if (in->ZoneInfoDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_INFO_DOTNET_Type, in->ZoneInfoDotNet, in->ZoneInfoDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET:
			if (in->SecondariesDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_SECONDARIES_DOTNET_Type, in->SecondariesDotNet, in->SecondariesDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_DATABASE:
			if (in->Database == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_DATABASE_DOTNET_Type, in->Database, in->Database);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_CREATE_DOTNET:
			if (in->ZoneCreateDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type, in->ZoneCreateDotNet, in->ZoneCreateDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_LIST:
			if (in->ZoneList == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_LIST_DOTNET_Type, in->ZoneList, in->ZoneList);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_EXPORT:
			if (in->ZoneExport == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_EXPORT_INFO_Type, in->ZoneExport, in->ZoneExport);
			}
			return ret;

		case DNSSRV_TYPEID_DP_INFO:
			if (in->DirectoryPartition == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_DP_INFO_Type, in->DirectoryPartition, in->DirectoryPartition);
			}
			return ret;

		case DNSSRV_TYPEID_DP_ENUM:
			if (in->DirectoryPartitionEnum == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_DP_ENUM_Type, in->DirectoryPartitionEnum, in->DirectoryPartitionEnum);
			}
			return ret;

		case DNSSRV_TYPEID_DP_LIST:
			if (in->DirectoryPartitionList == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_DP_LIST_Type, in->DirectoryPartitionList, in->DirectoryPartitionList);
			}
			return ret;

		case DNSSRV_TYPEID_ENLIST_DP:
			if (in->EnlistDirectoryPartition == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ENLIST_DP_Type, in->EnlistDirectoryPartition, in->EnlistDirectoryPartition);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_CHANGE_DP:
			if (in->ZoneChangeDirectoryPartition == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_CHANGE_DP_Type, in->ZoneChangeDirectoryPartition, in->ZoneChangeDirectoryPartition);
			}
			return ret;

		case DNSSRV_TYPEID_ENUM_ZONES_FILTER:
			if (in->EnumZonesFilter == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ENUM_ZONES_FILTER_Type, in->EnumZonesFilter, in->EnumZonesFilter);
			}
			return ret;

		case DNSSRV_TYPEID_ADDRARRAY:
			if (in->AddrArray == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, in->AddrArray, in->AddrArray);
			}
			return ret;

		case DNSSRV_TYPEID_SERVER_INFO:
			if (in->ServerInfo == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_SERVER_INFO_LONGHORN_Type, in->ServerInfo, in->ServerInfo);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_CREATE:
			if (in->ZoneCreate == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type, in->ZoneCreate, in->ZoneCreate);
			}
			return ret;

		case DNSSRV_TYPEID_FORWARDERS:
			if (in->Forwarders == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_FORWARDERS_LONGHORN_Type, in->Forwarders, in->Forwarders);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_SECONDARIES:
			if (in->Secondaries == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type, in->Secondaries, in->Secondaries);
			}
			return ret;

		case DNSSRV_TYPEID_IP_VALIDATE:
			if (in->IpValidate == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_IP_VALIDATE_Type, in->IpValidate, in->IpValidate);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_INFO:
			if (in->ZoneInfo == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_INFO_LONGHORN_Type, in->ZoneInfo, in->ZoneInfo);
			}
			return ret;

		case DNSSRV_TYPEID_AUTOCONFIGURE:
			if (in->AutoConfigure == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_AUTOCONFIGURE_Type, in->AutoConfigure, in->AutoConfigure);
			}
			return ret;

		case DNSSRV_TYPEID_UTF8_STRING_LIST:
			if (in->Utf8StringList == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_UTF8_STRING_LIST_Type, in->Utf8StringList, in->Utf8StringList);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union DNSSRV_RPC_UNION *py_export_DNSSRV_RPC_UNION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union DNSSRV_RPC_UNION *ret = talloc_zero(mem_ctx, union DNSSRV_RPC_UNION);
	switch (level) {
		case DNSSRV_TYPEID_NULL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Null");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->Null = NULL;
			} else {
				ret->Null = talloc_ptrtype(mem_ctx, ret->Null);
				if (ret->Null == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*ret->Null));
					if (PyLong_Check(in)) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(in);
						if (PyErr_Occurred() != NULL) {
							talloc_free(ret); return NULL;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							talloc_free(ret); return NULL;
						}
						*ret->Null = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						talloc_free(ret); return NULL;
					}
				}
			}
			break;

		case DNSSRV_TYPEID_DWORD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Dword");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->Dword));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->Dword = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DNSSRV_TYPEID_LPSTR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->String");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->String = NULL;
			} else {
				ret->String = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->String = talloc_str;
				}
			}
			break;

		case DNSSRV_TYPEID_LPWSTR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->WideString");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->WideString = NULL;
			} else {
				ret->WideString = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->WideString = talloc_str;
				}
			}
			break;

		case DNSSRV_TYPEID_IPARRAY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->IpArray");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->IpArray = NULL;
			} else {
				ret->IpArray = NULL;
				PY_CHECK_TYPE(&IP4_ARRAY_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->IpArray = (struct IP4_ARRAY *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_BUFFER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Buffer");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->Buffer = NULL;
			} else {
				ret->Buffer = NULL;
				PY_CHECK_TYPE(&DNS_RPC_BUFFER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Buffer = (struct DNS_RPC_BUFFER *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_SERVER_INFO_W2K:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ServerInfoW2K");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ServerInfoW2K = NULL;
			} else {
				ret->ServerInfoW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_SERVER_INFO_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ServerInfoW2K = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_STATS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Stats");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->Stats = NULL;
			} else {
				ret->Stats = NULL;
				PY_CHECK_TYPE(&DNSSRV_STAT_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Stats = (struct DNSSRV_STAT *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_FORWARDERS_W2K:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ForwardersW2K");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ForwardersW2K = NULL;
			} else {
				ret->ForwardersW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_FORWARDERS_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ForwardersW2K = (struct DNS_RPC_FORWARDERS_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_W2K:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneW2K");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneW2K = NULL;
			} else {
				ret->ZoneW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneW2K = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_INFO_W2K:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneInfoW2K");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneInfoW2K = NULL;
			} else {
				ret->ZoneInfoW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_INFO_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneInfoW2K = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->SecondariesW2K");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->SecondariesW2K = NULL;
			} else {
				ret->SecondariesW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_SECONDARIES_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->SecondariesW2K = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_DATABASE_W2K:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->DatabaseW2K");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->DatabaseW2K = NULL;
			} else {
				ret->DatabaseW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_DATABASE_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->DatabaseW2K = (struct DNS_RPC_ZONE_DATABASE_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_CREATE_W2K:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneCreateW2K");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneCreateW2K = NULL;
			} else {
				ret->ZoneCreateW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_CREATE_INFO_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneCreateW2K = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_NAME_AND_PARAM:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->NameAndParam");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->NameAndParam = NULL;
			} else {
				ret->NameAndParam = NULL;
				PY_CHECK_TYPE(&DNS_RPC_NAME_AND_PARAM_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->NameAndParam = (struct DNS_RPC_NAME_AND_PARAM *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_LIST_W2K:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneListW2K");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneListW2K = NULL;
			} else {
				ret->ZoneListW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_LIST_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneListW2K = (struct DNS_RPC_ZONE_LIST_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_SERVER_INFO_DOTNET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ServerInfoDotNet");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ServerInfoDotNet = NULL;
			} else {
				ret->ServerInfoDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_SERVER_INFO_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ServerInfoDotNet = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_FORWARDERS_DOTNET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ForwardersDotNet");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ForwardersDotNet = NULL;
			} else {
				ret->ForwardersDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_FORWARDERS_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ForwardersDotNet = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Zone");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->Zone = NULL;
			} else {
				ret->Zone = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Zone = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_INFO_DOTNET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneInfoDotNet");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneInfoDotNet = NULL;
			} else {
				ret->ZoneInfoDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_INFO_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneInfoDotNet = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->SecondariesDotNet");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->SecondariesDotNet = NULL;
			} else {
				ret->SecondariesDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_SECONDARIES_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->SecondariesDotNet = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_DATABASE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Database");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->Database = NULL;
			} else {
				ret->Database = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_DATABASE_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Database = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_CREATE_DOTNET:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneCreateDotNet");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneCreateDotNet = NULL;
			} else {
				ret->ZoneCreateDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneCreateDotNet = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_LIST:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneList");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneList = NULL;
			} else {
				ret->ZoneList = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_LIST_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneList = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_EXPORT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneExport");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneExport = NULL;
			} else {
				ret->ZoneExport = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_EXPORT_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneExport = (struct DNS_RPC_ZONE_EXPORT_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_DP_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->DirectoryPartition");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->DirectoryPartition = NULL;
			} else {
				ret->DirectoryPartition = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->DirectoryPartition = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_DP_ENUM:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->DirectoryPartitionEnum");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->DirectoryPartitionEnum = NULL;
			} else {
				ret->DirectoryPartitionEnum = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_ENUM_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->DirectoryPartitionEnum = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_DP_LIST:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->DirectoryPartitionList");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->DirectoryPartitionList = NULL;
			} else {
				ret->DirectoryPartitionList = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_LIST_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->DirectoryPartitionList = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ENLIST_DP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->EnlistDirectoryPartition");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->EnlistDirectoryPartition = NULL;
			} else {
				ret->EnlistDirectoryPartition = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ENLIST_DP_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->EnlistDirectoryPartition = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_CHANGE_DP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneChangeDirectoryPartition");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneChangeDirectoryPartition = NULL;
			} else {
				ret->ZoneChangeDirectoryPartition = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_CHANGE_DP_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneChangeDirectoryPartition = (struct DNS_RPC_ZONE_CHANGE_DP *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ENUM_ZONES_FILTER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->EnumZonesFilter");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->EnumZonesFilter = NULL;
			} else {
				ret->EnumZonesFilter = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ENUM_ZONES_FILTER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->EnumZonesFilter = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ADDRARRAY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AddrArray");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->AddrArray = NULL;
			} else {
				ret->AddrArray = NULL;
				PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AddrArray = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_SERVER_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ServerInfo");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ServerInfo = NULL;
			} else {
				ret->ServerInfo = NULL;
				PY_CHECK_TYPE(&DNS_RPC_SERVER_INFO_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ServerInfo = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_CREATE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneCreate");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneCreate = NULL;
			} else {
				ret->ZoneCreate = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneCreate = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_FORWARDERS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Forwarders");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->Forwarders = NULL;
			} else {
				ret->Forwarders = NULL;
				PY_CHECK_TYPE(&DNS_RPC_FORWARDERS_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Forwarders = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Secondaries");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->Secondaries = NULL;
			} else {
				ret->Secondaries = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Secondaries = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_IP_VALIDATE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->IpValidate");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->IpValidate = NULL;
			} else {
				ret->IpValidate = NULL;
				PY_CHECK_TYPE(&DNS_RPC_IP_VALIDATE_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->IpValidate = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_INFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ZoneInfo");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->ZoneInfo = NULL;
			} else {
				ret->ZoneInfo = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_INFO_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneInfo = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_AUTOCONFIGURE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AutoConfigure");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->AutoConfigure = NULL;
			} else {
				ret->AutoConfigure = NULL;
				PY_CHECK_TYPE(&DNS_RPC_AUTOCONFIGURE_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AutoConfigure = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_UTF8_STRING_LIST:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Utf8StringList");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->Utf8StringList = NULL;
			} else {
				ret->Utf8StringList = NULL;
				PY_CHECK_TYPE(&DNS_RPC_UTF8_STRING_LIST_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Utf8StringList = (struct DNS_RPC_UTF8_STRING_LIST *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_DNSSRV_RPC_UNION_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union DNSSRV_RPC_UNION *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union DNSSRV_RPC_UNION *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union DNSSRV_RPC_UNION!");
		return NULL;
	}

	return py_import_DNSSRV_RPC_UNION(mem_ctx, level, in);
}

static PyObject *py_DNSSRV_RPC_UNION_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union DNSSRV_RPC_UNION *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_DNSSRV_RPC_UNION(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_DNSSRV_RPC_UNION_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNSSRV_RPC_UNION_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNSSRV_RPC_UNION_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_DNSSRV_RPC_UNION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject DNSSRV_RPC_UNION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNSSRV_RPC_UNION",
	.tp_getset = NULL,
	.tp_methods = py_DNSSRV_RPC_UNION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNSSRV_RPC_UNION_new,
};


static PyObject *py_DNS_RPC_RECORDS_get_wLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_wLength;
	py_wLength = PyLong_FromLong((uint16_t)(object->wLength));
	return py_wLength;
}

static int py_DNS_RPC_RECORDS_set_wLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wLength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_wRecordCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_wRecordCount;
	py_wRecordCount = PyLong_FromLong((uint16_t)(object->wRecordCount));
	return py_wRecordCount;
}

static int py_DNS_RPC_RECORDS_set_wRecordCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wRecordCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wRecordCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wRecordCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->dwFlags));
	return py_dwFlags;
}

static int py_DNS_RPC_RECORDS_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_dwChildCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_dwChildCount;
	py_dwChildCount = PyLong_FromUnsignedLongLong((uint32_t)(object->dwChildCount));
	return py_dwChildCount;
}

static int py_DNS_RPC_RECORDS_set_dwChildCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dwChildCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dwChildCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dwChildCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_dnsNodeName(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_dnsNodeName;
	py_dnsNodeName = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->dnsNodeName);
	return py_dnsNodeName;
}

static int py_DNS_RPC_RECORDS_set_dnsNodeName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dnsNodeName");
		return -1;
	}
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dnsNodeName = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_records(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(obj);
	PyObject *py_records;
	py_records = PyList_New(object->wRecordCount);
	if (py_records == NULL) {
		return NULL;
	}
	{
		int records_cntr_0;
		for (records_cntr_0 = 0; records_cntr_0 < (object->wRecordCount); records_cntr_0++) {
			PyObject *py_records_0;
			py_records_0 = pytalloc_reference_ex(&DNS_RPC_RECORD_Type, object->records, &(object->records)[records_cntr_0]);
			PyList_SetItem(py_records, records_cntr_0, py_records_0);
		}
	}
	return py_records;
}

static int py_DNS_RPC_RECORDS_set_records(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->records");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int records_cntr_0;
		object->records = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->records, PyList_GET_SIZE(value));
		if (!object->records) { return -1; }
		talloc_set_name_const(object->records, "ARRAY: object->records");
		for (records_cntr_0 = 0; records_cntr_0 < PyList_GET_SIZE(value); records_cntr_0++) {
			if (PyList_GET_ITEM(value, records_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->records)[records_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&DNS_RPC_RECORD_Type, PyList_GET_ITEM(value, records_cntr_0), return -1;);
			if (talloc_reference(object->records, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, records_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->records)[records_cntr_0] = *(struct DNS_RPC_RECORD *)pytalloc_get_ptr(PyList_GET_ITEM(value, records_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORDS_getsetters[] = {
	{
		.name = discard_const_p(char, "wLength"),
		.get = py_DNS_RPC_RECORDS_get_wLength,
		.set = py_DNS_RPC_RECORDS_set_wLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "wRecordCount"),
		.get = py_DNS_RPC_RECORDS_get_wRecordCount,
		.set = py_DNS_RPC_RECORDS_set_wRecordCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "dwFlags"),
		.get = py_DNS_RPC_RECORDS_get_dwFlags,
		.set = py_DNS_RPC_RECORDS_set_dwFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dwChildCount"),
		.get = py_DNS_RPC_RECORDS_get_dwChildCount,
		.set = py_DNS_RPC_RECORDS_set_dwChildCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dnsNodeName"),
		.get = py_DNS_RPC_RECORDS_get_dnsNodeName,
		.set = py_DNS_RPC_RECORDS_set_dnsNodeName,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_NAME")
	},
	{
		.name = discard_const_p(char, "records"),
		.get = py_DNS_RPC_RECORDS_get_records,
		.set = py_DNS_RPC_RECORDS_set_records,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_RECORD")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_RECORDS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORDS, type);
}

static PyObject *py_DNS_RPC_RECORDS_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORDS);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_DNS_RPC_RECORDS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORDS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORDS);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_RECORDS_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORDS *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORDS, "DNS_RPC_RECORDS", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORDS, "DNS_RPC_RECORDS", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_RECORDS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_RECORDS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_RECORDS_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_RECORDS_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_RECORDS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORDS",
	.tp_getset = py_DNS_RPC_RECORDS_getsetters,
	.tp_methods = py_DNS_RPC_RECORDS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORDS_new,
};


static PyObject *py_DNS_RPC_RECORDS_ARRAY_get_count(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_DNS_RPC_RECORDS_ARRAY_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_ARRAY_get_rec(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_rec;
	py_rec = PyList_New(object->count);
	if (py_rec == NULL) {
		return NULL;
	}
	{
		int rec_cntr_0;
		for (rec_cntr_0 = 0; rec_cntr_0 < (object->count); rec_cntr_0++) {
			PyObject *py_rec_0;
			py_rec_0 = pytalloc_reference_ex(&DNS_RPC_RECORDS_Type, object->rec, &(object->rec)[rec_cntr_0]);
			PyList_SetItem(py_rec, rec_cntr_0, py_rec_0);
		}
	}
	return py_rec;
}

static int py_DNS_RPC_RECORDS_ARRAY_set_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rec");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int rec_cntr_0;
		object->rec = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->rec, PyList_GET_SIZE(value));
		if (!object->rec) { return -1; }
		talloc_set_name_const(object->rec, "ARRAY: object->rec");
		for (rec_cntr_0 = 0; rec_cntr_0 < PyList_GET_SIZE(value); rec_cntr_0++) {
			if (PyList_GET_ITEM(value, rec_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->rec)[rec_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&DNS_RPC_RECORDS_Type, PyList_GET_ITEM(value, rec_cntr_0), return -1;);
			if (talloc_reference(object->rec, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, rec_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->rec)[rec_cntr_0] = *(struct DNS_RPC_RECORDS *)pytalloc_get_ptr(PyList_GET_ITEM(value, rec_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORDS_ARRAY_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_DNS_RPC_RECORDS_ARRAY_get_count,
		.set = py_DNS_RPC_RECORDS_ARRAY_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rec"),
		.get = py_DNS_RPC_RECORDS_ARRAY_get_rec,
		.set = py_DNS_RPC_RECORDS_ARRAY_set_rec,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_RECORDS")
	},
	{ .name = NULL }
};

static PyObject *py_DNS_RPC_RECORDS_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORDS_ARRAY, type);
}

static PyObject *py_DNS_RPC_RECORDS_ARRAY_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct DNS_RPC_RECORDS_ARRAY *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORDS_ARRAY);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_DNS_RPC_RECORDS_ARRAY_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORDS_ARRAY *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORDS_ARRAY);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORDS_ARRAY);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_RECORDS_ARRAY_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORDS_ARRAY *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORDS_ARRAY, "DNS_RPC_RECORDS_ARRAY", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORDS_ARRAY, "DNS_RPC_RECORDS_ARRAY", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_RECORDS_ARRAY_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_RECORDS_ARRAY_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_RECORDS_ARRAY_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DNS_RPC_RECORDS_ARRAY_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_RECORDS_ARRAY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DNS_RPC_RECORDS_ARRAY",
	.tp_getset = py_DNS_RPC_RECORDS_ARRAY_getsetters,
	.tp_methods = py_DNS_RPC_RECORDS_ARRAY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DNS_RPC_RECORDS_ARRAY_new,
};



static PyObject *py_DnssrvOperation_in_get_pwszServerName(PyObject *obj, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszServerName;
	if (object->in.pwszServerName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pwszServerName == NULL) {
		py_pwszServerName = Py_None;
		Py_INCREF(py_pwszServerName);
	} else {
		if (object->in.pwszServerName == NULL) {
			py_pwszServerName = Py_None;
			Py_INCREF(py_pwszServerName);
		} else {
			py_pwszServerName = PyUnicode_Decode(object->in.pwszServerName, strlen(object->in.pwszServerName), "utf-8", "ignore");
		}
	}
	return py_pwszServerName;
}

static int py_DnssrvOperation_in_set_pwszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pwszServerName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pwszServerName = NULL;
	} else {
		object->in.pwszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pwszServerName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvOperation_in_get_pszZone(PyObject *obj, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZone;
	if (object->in.pszZone == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszZone == NULL) {
		py_pszZone = Py_None;
		Py_INCREF(py_pszZone);
	} else {
		if (object->in.pszZone == NULL) {
			py_pszZone = Py_None;
			Py_INCREF(py_pszZone);
		} else {
			py_pszZone = PyUnicode_Decode(object->in.pszZone, strlen(object->in.pszZone), "utf-8", "ignore");
		}
	}
	return py_pszZone;
}

static int py_DnssrvOperation_in_set_pszZone(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszZone");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszZone = NULL;
	} else {
		object->in.pszZone = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszZone = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvOperation_in_get_dwContext(PyObject *obj, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_dwContext;
	py_dwContext = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwContext));
	return py_dwContext;
}

static int py_DnssrvOperation_in_set_dwContext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dwContext");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwContext));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwContext = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DnssrvOperation_in_get_pszOperation(PyObject *obj, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pszOperation;
	if (object->in.pszOperation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszOperation == NULL) {
		py_pszOperation = Py_None;
		Py_INCREF(py_pszOperation);
	} else {
		if (object->in.pszOperation == NULL) {
			py_pszOperation = Py_None;
			Py_INCREF(py_pszOperation);
		} else {
			py_pszOperation = PyUnicode_Decode(object->in.pszOperation, strlen(object->in.pszOperation), "utf-8", "ignore");
		}
	}
	return py_pszOperation;
}

static int py_DnssrvOperation_in_set_pszOperation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszOperation");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszOperation = NULL;
	} else {
		object->in.pszOperation = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszOperation = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvOperation_in_get_dwTypeId(PyObject *obj, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTypeId;
	py_dwTypeId = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwTypeId));
	return py_dwTypeId;
}

static int py_DnssrvOperation_in_set_dwTypeId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dwTypeId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwTypeId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwTypeId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DnssrvOperation_in_get_pData(PyObject *obj, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pData;
	py_pData = pyrpc_import_union(&DNSSRV_RPC_UNION_Type, pytalloc_get_mem_ctx(obj), object->in.dwTypeId, &object->in.pData, "union DNSSRV_RPC_UNION");
	if (py_pData == NULL) {
		return NULL;
	}
	return py_pData;
}

static int py_DnssrvOperation_in_set_pData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pData");
		return -1;
	}
	{
		union DNSSRV_RPC_UNION *pData_switch_0;
		pData_switch_0 = (union DNSSRV_RPC_UNION *)pyrpc_export_union(&DNSSRV_RPC_UNION_Type, pytalloc_get_mem_ctx(py_obj), object->in.dwTypeId, value, "union DNSSRV_RPC_UNION");
		if (pData_switch_0 == NULL) {
			return -1;
		}
		object->in.pData = *pData_switch_0;
	}
	return 0;
}

static PyObject *py_DnssrvOperation_get_result(PyObject *obj, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_DnssrvOperation_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_DnssrvOperation_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pwszServerName"),
		.get = py_DnssrvOperation_in_get_pwszServerName,
		.set = py_DnssrvOperation_in_set_pwszServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pszZone"),
		.get = py_DnssrvOperation_in_get_pszZone,
		.set = py_DnssrvOperation_in_set_pszZone,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_dwContext"),
		.get = py_DnssrvOperation_in_get_dwContext,
		.set = py_DnssrvOperation_in_set_dwContext,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pszOperation"),
		.get = py_DnssrvOperation_in_get_pszOperation,
		.set = py_DnssrvOperation_in_set_pszOperation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_dwTypeId"),
		.get = py_DnssrvOperation_in_get_dwTypeId,
		.set = py_DnssrvOperation_in_set_dwTypeId,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_TYPEID")
	},
	{
		.name = discard_const_p(char, "in_pData"),
		.get = py_DnssrvOperation_in_get_pData,
		.set = py_DnssrvOperation_in_set_pData,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNSSRV_RPC_UNION")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_DnssrvOperation_get_result,
		.set = py_DnssrvOperation_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_DnssrvOperation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct DnssrvOperation, type);
	return self;
}

static PyObject *py_DnssrvOperation_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_DnssrvOperation_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_dnsserver.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvOperation_ndr_pack");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_DnssrvOperation_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_DnssrvOperation_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_DnssrvOperation_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_DnssrvOperation_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_DnssrvOperation_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_dnsserver.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvOperation_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_DnssrvOperation_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_DnssrvOperation_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_DnssrvOperation_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_DnssrvOperation_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_DnssrvOperation_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvOperation *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_dnsserver.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvOperation_ndr_print");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_DnssrvOperation_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_DnssrvOperation_ndr_print(py_obj, args, kwargs, "DnssrvOperation_in", NDR_IN);
}

static PyObject *py_DnssrvOperation_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_DnssrvOperation_ndr_print(py_obj, args, kwargs, "DnssrvOperation_out", NDR_OUT);
}

static PyMethodDef py_DnssrvOperation_methods[] = {
	{ "opnum", (PyCFunction)py_DnssrvOperation_ndr_opnum, METH_NOARGS|METH_CLASS,
		"dnsserver.DnssrvOperation.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvOperation_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvOperation_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvOperation_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvOperation_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvOperation_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvOperation_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DnssrvOperation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DnssrvOperation",
	.tp_getset = py_DnssrvOperation_getsetters,
	.tp_methods = py_DnssrvOperation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DnssrvOperation_new,
};

static bool pack_py_DnssrvOperation_args_in(PyObject *args, PyObject *kwargs, struct DnssrvOperation *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_dwContext;
	PyObject *py_pszOperation;
	PyObject *py_dwTypeId;
	PyObject *py_pData;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "dwContext", "pszOperation", "dwTypeId", "pData", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:DnssrvOperation", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_dwContext, &py_pszOperation, &py_dwTypeId, &py_pData)) {
		return false;
	}

	if (py_pwszServerName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pwszServerName");
		return false;
	}
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pwszServerName)) {
				unicode = PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pwszServerName)) {
				test_str = PyBytes_AS_STRING(py_pwszServerName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pwszServerName = talloc_str;
		}
	}
	if (py_pszZone == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszZone");
		return false;
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pszZone)) {
				unicode = PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pszZone)) {
				test_str = PyBytes_AS_STRING(py_pszZone);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pszZone = talloc_str;
		}
	}
	if (py_dwContext == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dwContext");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dwContext));
		if (PyLong_Check(py_dwContext)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dwContext);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dwContext = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pszOperation == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszOperation");
		return false;
	}
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pszOperation)) {
				unicode = PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pszOperation)) {
				test_str = PyBytes_AS_STRING(py_pszOperation);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pszOperation = talloc_str;
		}
	}
	if (py_dwTypeId == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dwTypeId");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dwTypeId));
		if (PyLong_Check(py_dwTypeId)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dwTypeId);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dwTypeId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pData == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pData");
		return false;
	}
	{
		union DNSSRV_RPC_UNION *pData_switch_0;
		pData_switch_0 = (union DNSSRV_RPC_UNION *)pyrpc_export_union(&DNSSRV_RPC_UNION_Type, r, r->in.dwTypeId, py_pData, "union DNSSRV_RPC_UNION");
		if (pData_switch_0 == NULL) {
			return false;
		}
		r->in.pData = *pData_switch_0;
	}
	return true;
}

static PyObject *unpack_py_DnssrvOperation_args_out(struct DnssrvOperation *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_DnssrvQuery_in_get_pwszServerName(PyObject *obj, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszServerName;
	if (object->in.pwszServerName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pwszServerName == NULL) {
		py_pwszServerName = Py_None;
		Py_INCREF(py_pwszServerName);
	} else {
		if (object->in.pwszServerName == NULL) {
			py_pwszServerName = Py_None;
			Py_INCREF(py_pwszServerName);
		} else {
			py_pwszServerName = PyUnicode_Decode(object->in.pwszServerName, strlen(object->in.pwszServerName), "utf-8", "ignore");
		}
	}
	return py_pwszServerName;
}

static int py_DnssrvQuery_in_set_pwszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pwszServerName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pwszServerName = NULL;
	} else {
		object->in.pwszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pwszServerName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvQuery_in_get_pszZone(PyObject *obj, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZone;
	if (object->in.pszZone == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszZone == NULL) {
		py_pszZone = Py_None;
		Py_INCREF(py_pszZone);
	} else {
		if (object->in.pszZone == NULL) {
			py_pszZone = Py_None;
			Py_INCREF(py_pszZone);
		} else {
			py_pszZone = PyUnicode_Decode(object->in.pszZone, strlen(object->in.pszZone), "utf-8", "ignore");
		}
	}
	return py_pszZone;
}

static int py_DnssrvQuery_in_set_pszZone(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszZone");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszZone = NULL;
	} else {
		object->in.pszZone = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszZone = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvQuery_in_get_pszOperation(PyObject *obj, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(obj);
	PyObject *py_pszOperation;
	if (object->in.pszOperation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszOperation == NULL) {
		py_pszOperation = Py_None;
		Py_INCREF(py_pszOperation);
	} else {
		if (object->in.pszOperation == NULL) {
			py_pszOperation = Py_None;
			Py_INCREF(py_pszOperation);
		} else {
			py_pszOperation = PyUnicode_Decode(object->in.pszOperation, strlen(object->in.pszOperation), "utf-8", "ignore");
		}
	}
	return py_pszOperation;
}

static int py_DnssrvQuery_in_set_pszOperation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszOperation");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszOperation = NULL;
	} else {
		object->in.pszOperation = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszOperation = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvQuery_out_get_pdwTypeId(PyObject *obj, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(obj);
	PyObject *py_pdwTypeId;
	if (object->out.pdwTypeId == NULL) {
		Py_RETURN_NONE;
	}
	py_pdwTypeId = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pdwTypeId));
	return py_pdwTypeId;
}

static int py_DnssrvQuery_out_set_pdwTypeId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pdwTypeId));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pdwTypeId");
		return -1;
	}
	object->out.pdwTypeId = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pdwTypeId);
	if (object->out.pdwTypeId == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pdwTypeId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pdwTypeId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DnssrvQuery_out_get_ppData(PyObject *obj, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(obj);
	PyObject *py_ppData;
	if (object->out.ppData == NULL) {
		Py_RETURN_NONE;
	}
	py_ppData = pyrpc_import_union(&DNSSRV_RPC_UNION_Type, object->out.ppData, *object->out.pdwTypeId, object->out.ppData, "union DNSSRV_RPC_UNION");
	if (py_ppData == NULL) {
		return NULL;
	}
	return py_ppData;
}

static int py_DnssrvQuery_out_set_ppData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.ppData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.ppData");
		return -1;
	}
	object->out.ppData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.ppData);
	if (object->out.ppData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union DNSSRV_RPC_UNION *ppData_switch_1;
		ppData_switch_1 = (union DNSSRV_RPC_UNION *)pyrpc_export_union(&DNSSRV_RPC_UNION_Type, pytalloc_get_mem_ctx(py_obj), *object->out.pdwTypeId, value, "union DNSSRV_RPC_UNION");
		if (ppData_switch_1 == NULL) {
			return -1;
		}
		object->out.ppData = ppData_switch_1;
	}
	return 0;
}

static PyObject *py_DnssrvQuery_get_result(PyObject *obj, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_DnssrvQuery_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_DnssrvQuery_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pwszServerName"),
		.get = py_DnssrvQuery_in_get_pwszServerName,
		.set = py_DnssrvQuery_in_set_pwszServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pszZone"),
		.get = py_DnssrvQuery_in_get_pszZone,
		.set = py_DnssrvQuery_in_set_pszZone,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_pszOperation"),
		.get = py_DnssrvQuery_in_get_pszOperation,
		.set = py_DnssrvQuery_in_set_pszOperation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pdwTypeId"),
		.get = py_DnssrvQuery_out_get_pdwTypeId,
		.set = py_DnssrvQuery_out_set_pdwTypeId,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_TYPEID")
	},
	{
		.name = discard_const_p(char, "out_ppData"),
		.get = py_DnssrvQuery_out_get_ppData,
		.set = py_DnssrvQuery_out_set_ppData,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNSSRV_RPC_UNION")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_DnssrvQuery_get_result,
		.set = py_DnssrvQuery_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_DnssrvQuery_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct DnssrvQuery, type);
	struct DnssrvQuery *_self = (struct DnssrvQuery *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pdwTypeId = talloc_zero(mem_ctx, enum DNS_RPC_TYPEID);
	_self->out.ppData = talloc_zero(mem_ctx, union DNSSRV_RPC_UNION);
	return self;
}

static PyObject *py_DnssrvQuery_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_DnssrvQuery_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_dnsserver.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvQuery_ndr_pack");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_DnssrvQuery_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_DnssrvQuery_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_DnssrvQuery_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_DnssrvQuery_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_DnssrvQuery_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_dnsserver.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvQuery_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_DnssrvQuery_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_DnssrvQuery_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_DnssrvQuery_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_DnssrvQuery_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_DnssrvQuery_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvQuery *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_dnsserver.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvQuery_ndr_print");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_DnssrvQuery_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_DnssrvQuery_ndr_print(py_obj, args, kwargs, "DnssrvQuery_in", NDR_IN);
}

static PyObject *py_DnssrvQuery_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_DnssrvQuery_ndr_print(py_obj, args, kwargs, "DnssrvQuery_out", NDR_OUT);
}

static PyMethodDef py_DnssrvQuery_methods[] = {
	{ "opnum", (PyCFunction)py_DnssrvQuery_ndr_opnum, METH_NOARGS|METH_CLASS,
		"dnsserver.DnssrvQuery.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvQuery_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvQuery_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvQuery_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvQuery_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvQuery_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvQuery_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DnssrvQuery_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DnssrvQuery",
	.tp_getset = py_DnssrvQuery_getsetters,
	.tp_methods = py_DnssrvQuery_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DnssrvQuery_new,
};

static bool pack_py_DnssrvQuery_args_in(PyObject *args, PyObject *kwargs, struct DnssrvQuery *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszOperation;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "pszOperation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:DnssrvQuery", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_pszOperation)) {
		return false;
	}

	if (py_pwszServerName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pwszServerName");
		return false;
	}
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pwszServerName)) {
				unicode = PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pwszServerName)) {
				test_str = PyBytes_AS_STRING(py_pwszServerName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pwszServerName = talloc_str;
		}
	}
	if (py_pszZone == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszZone");
		return false;
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pszZone)) {
				unicode = PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pszZone)) {
				test_str = PyBytes_AS_STRING(py_pszZone);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pszZone = talloc_str;
		}
	}
	if (py_pszOperation == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszOperation");
		return false;
	}
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pszOperation)) {
				unicode = PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pszOperation)) {
				test_str = PyBytes_AS_STRING(py_pszOperation);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pszOperation = talloc_str;
		}
	}
	return true;
}

static PyObject *unpack_py_DnssrvQuery_args_out(struct DnssrvQuery *r, bool raise_result_exception)
{
	PyObject *py_pdwTypeId = NULL;
	PyObject *py_ppData = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pdwTypeId = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pdwTypeId));
	PyTuple_SetItem(result, 0, py_pdwTypeId);

	py_ppData = pyrpc_import_union(&DNSSRV_RPC_UNION_Type, r->out.ppData, *r->out.pdwTypeId, r->out.ppData, "union DNSSRV_RPC_UNION");
	if (py_ppData == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_ppData);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_DnssrvComplexOperation_in_get_pwszServerName(PyObject *obj, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszServerName;
	if (object->in.pwszServerName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pwszServerName == NULL) {
		py_pwszServerName = Py_None;
		Py_INCREF(py_pwszServerName);
	} else {
		if (object->in.pwszServerName == NULL) {
			py_pwszServerName = Py_None;
			Py_INCREF(py_pwszServerName);
		} else {
			py_pwszServerName = PyUnicode_Decode(object->in.pwszServerName, strlen(object->in.pwszServerName), "utf-8", "ignore");
		}
	}
	return py_pwszServerName;
}

static int py_DnssrvComplexOperation_in_set_pwszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pwszServerName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pwszServerName = NULL;
	} else {
		object->in.pwszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pwszServerName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvComplexOperation_in_get_pszZone(PyObject *obj, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZone;
	if (object->in.pszZone == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszZone == NULL) {
		py_pszZone = Py_None;
		Py_INCREF(py_pszZone);
	} else {
		if (object->in.pszZone == NULL) {
			py_pszZone = Py_None;
			Py_INCREF(py_pszZone);
		} else {
			py_pszZone = PyUnicode_Decode(object->in.pszZone, strlen(object->in.pszZone), "utf-8", "ignore");
		}
	}
	return py_pszZone;
}

static int py_DnssrvComplexOperation_in_set_pszZone(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszZone");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszZone = NULL;
	} else {
		object->in.pszZone = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszZone = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvComplexOperation_in_get_pszOperation(PyObject *obj, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pszOperation;
	if (object->in.pszOperation == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszOperation == NULL) {
		py_pszOperation = Py_None;
		Py_INCREF(py_pszOperation);
	} else {
		if (object->in.pszOperation == NULL) {
			py_pszOperation = Py_None;
			Py_INCREF(py_pszOperation);
		} else {
			py_pszOperation = PyUnicode_Decode(object->in.pszOperation, strlen(object->in.pszOperation), "utf-8", "ignore");
		}
	}
	return py_pszOperation;
}

static int py_DnssrvComplexOperation_in_set_pszOperation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszOperation");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszOperation = NULL;
	} else {
		object->in.pszOperation = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszOperation = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvComplexOperation_in_get_dwTypeIn(PyObject *obj, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_dwTypeIn;
	py_dwTypeIn = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwTypeIn));
	return py_dwTypeIn;
}

static int py_DnssrvComplexOperation_in_set_dwTypeIn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dwTypeIn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwTypeIn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwTypeIn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DnssrvComplexOperation_in_get_pDataIn(PyObject *obj, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pDataIn;
	py_pDataIn = pyrpc_import_union(&DNSSRV_RPC_UNION_Type, pytalloc_get_mem_ctx(obj), object->in.dwTypeIn, &object->in.pDataIn, "union DNSSRV_RPC_UNION");
	if (py_pDataIn == NULL) {
		return NULL;
	}
	return py_pDataIn;
}

static int py_DnssrvComplexOperation_in_set_pDataIn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDataIn");
		return -1;
	}
	{
		union DNSSRV_RPC_UNION *pDataIn_switch_0;
		pDataIn_switch_0 = (union DNSSRV_RPC_UNION *)pyrpc_export_union(&DNSSRV_RPC_UNION_Type, pytalloc_get_mem_ctx(py_obj), object->in.dwTypeIn, value, "union DNSSRV_RPC_UNION");
		if (pDataIn_switch_0 == NULL) {
			return -1;
		}
		object->in.pDataIn = *pDataIn_switch_0;
	}
	return 0;
}

static PyObject *py_DnssrvComplexOperation_out_get_pdwTypeOut(PyObject *obj, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_pdwTypeOut;
	if (object->out.pdwTypeOut == NULL) {
		Py_RETURN_NONE;
	}
	py_pdwTypeOut = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pdwTypeOut));
	return py_pdwTypeOut;
}

static int py_DnssrvComplexOperation_out_set_pdwTypeOut(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pdwTypeOut));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pdwTypeOut");
		return -1;
	}
	object->out.pdwTypeOut = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pdwTypeOut);
	if (object->out.pdwTypeOut == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pdwTypeOut));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pdwTypeOut = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DnssrvComplexOperation_out_get_ppDataOut(PyObject *obj, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_ppDataOut;
	if (object->out.ppDataOut == NULL) {
		Py_RETURN_NONE;
	}
	py_ppDataOut = pyrpc_import_union(&DNSSRV_RPC_UNION_Type, object->out.ppDataOut, *object->out.pdwTypeOut, object->out.ppDataOut, "union DNSSRV_RPC_UNION");
	if (py_ppDataOut == NULL) {
		return NULL;
	}
	return py_ppDataOut;
}

static int py_DnssrvComplexOperation_out_set_ppDataOut(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.ppDataOut));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.ppDataOut");
		return -1;
	}
	object->out.ppDataOut = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.ppDataOut);
	if (object->out.ppDataOut == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union DNSSRV_RPC_UNION *ppDataOut_switch_1;
		ppDataOut_switch_1 = (union DNSSRV_RPC_UNION *)pyrpc_export_union(&DNSSRV_RPC_UNION_Type, pytalloc_get_mem_ctx(py_obj), *object->out.pdwTypeOut, value, "union DNSSRV_RPC_UNION");
		if (ppDataOut_switch_1 == NULL) {
			return -1;
		}
		object->out.ppDataOut = ppDataOut_switch_1;
	}
	return 0;
}

static PyObject *py_DnssrvComplexOperation_get_result(PyObject *obj, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_DnssrvComplexOperation_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_DnssrvComplexOperation_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pwszServerName"),
		.get = py_DnssrvComplexOperation_in_get_pwszServerName,
		.set = py_DnssrvComplexOperation_in_set_pwszServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pszZone"),
		.get = py_DnssrvComplexOperation_in_get_pszZone,
		.set = py_DnssrvComplexOperation_in_set_pszZone,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_pszOperation"),
		.get = py_DnssrvComplexOperation_in_get_pszOperation,
		.set = py_DnssrvComplexOperation_in_set_pszOperation,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_dwTypeIn"),
		.get = py_DnssrvComplexOperation_in_get_dwTypeIn,
		.set = py_DnssrvComplexOperation_in_set_dwTypeIn,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_TYPEID")
	},
	{
		.name = discard_const_p(char, "in_pDataIn"),
		.get = py_DnssrvComplexOperation_in_get_pDataIn,
		.set = py_DnssrvComplexOperation_in_set_pDataIn,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNSSRV_RPC_UNION")
	},
	{
		.name = discard_const_p(char, "out_pdwTypeOut"),
		.get = py_DnssrvComplexOperation_out_get_pdwTypeOut,
		.set = py_DnssrvComplexOperation_out_set_pdwTypeOut,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_TYPEID")
	},
	{
		.name = discard_const_p(char, "out_ppDataOut"),
		.get = py_DnssrvComplexOperation_out_get_ppDataOut,
		.set = py_DnssrvComplexOperation_out_set_ppDataOut,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNSSRV_RPC_UNION")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_DnssrvComplexOperation_get_result,
		.set = py_DnssrvComplexOperation_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_DnssrvComplexOperation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct DnssrvComplexOperation, type);
	struct DnssrvComplexOperation *_self = (struct DnssrvComplexOperation *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pdwTypeOut = talloc_zero(mem_ctx, enum DNS_RPC_TYPEID);
	_self->out.ppDataOut = talloc_zero(mem_ctx, union DNSSRV_RPC_UNION);
	return self;
}

static PyObject *py_DnssrvComplexOperation_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_DnssrvComplexOperation_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_dnsserver.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvComplexOperation_ndr_pack");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_DnssrvComplexOperation_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_DnssrvComplexOperation_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_DnssrvComplexOperation_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_DnssrvComplexOperation_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_DnssrvComplexOperation_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_dnsserver.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvComplexOperation_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_DnssrvComplexOperation_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_DnssrvComplexOperation_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_DnssrvComplexOperation_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_DnssrvComplexOperation_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_DnssrvComplexOperation_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvComplexOperation *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_dnsserver.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvComplexOperation_ndr_print");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_DnssrvComplexOperation_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_DnssrvComplexOperation_ndr_print(py_obj, args, kwargs, "DnssrvComplexOperation_in", NDR_IN);
}

static PyObject *py_DnssrvComplexOperation_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_DnssrvComplexOperation_ndr_print(py_obj, args, kwargs, "DnssrvComplexOperation_out", NDR_OUT);
}

static PyMethodDef py_DnssrvComplexOperation_methods[] = {
	{ "opnum", (PyCFunction)py_DnssrvComplexOperation_ndr_opnum, METH_NOARGS|METH_CLASS,
		"dnsserver.DnssrvComplexOperation.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvComplexOperation_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvComplexOperation_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvComplexOperation_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvComplexOperation_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvComplexOperation_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvComplexOperation_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DnssrvComplexOperation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DnssrvComplexOperation",
	.tp_getset = py_DnssrvComplexOperation_getsetters,
	.tp_methods = py_DnssrvComplexOperation_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DnssrvComplexOperation_new,
};

static bool pack_py_DnssrvComplexOperation_args_in(PyObject *args, PyObject *kwargs, struct DnssrvComplexOperation *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszOperation;
	PyObject *py_dwTypeIn;
	PyObject *py_pDataIn;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "pszOperation", "dwTypeIn", "pDataIn", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:DnssrvComplexOperation", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_pszOperation, &py_dwTypeIn, &py_pDataIn)) {
		return false;
	}

	if (py_pwszServerName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pwszServerName");
		return false;
	}
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pwszServerName)) {
				unicode = PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pwszServerName)) {
				test_str = PyBytes_AS_STRING(py_pwszServerName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pwszServerName = talloc_str;
		}
	}
	if (py_pszZone == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszZone");
		return false;
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pszZone)) {
				unicode = PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pszZone)) {
				test_str = PyBytes_AS_STRING(py_pszZone);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pszZone = talloc_str;
		}
	}
	if (py_pszOperation == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszOperation");
		return false;
	}
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pszOperation)) {
				unicode = PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pszOperation)) {
				test_str = PyBytes_AS_STRING(py_pszOperation);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pszOperation = talloc_str;
		}
	}
	if (py_dwTypeIn == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dwTypeIn");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dwTypeIn));
		if (PyLong_Check(py_dwTypeIn)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dwTypeIn);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dwTypeIn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pDataIn == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDataIn");
		return false;
	}
	{
		union DNSSRV_RPC_UNION *pDataIn_switch_0;
		pDataIn_switch_0 = (union DNSSRV_RPC_UNION *)pyrpc_export_union(&DNSSRV_RPC_UNION_Type, r, r->in.dwTypeIn, py_pDataIn, "union DNSSRV_RPC_UNION");
		if (pDataIn_switch_0 == NULL) {
			return false;
		}
		r->in.pDataIn = *pDataIn_switch_0;
	}
	return true;
}

static PyObject *unpack_py_DnssrvComplexOperation_args_out(struct DnssrvComplexOperation *r, bool raise_result_exception)
{
	PyObject *py_pdwTypeOut = NULL;
	PyObject *py_ppDataOut = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pdwTypeOut = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pdwTypeOut));
	PyTuple_SetItem(result, 0, py_pdwTypeOut);

	py_ppDataOut = pyrpc_import_union(&DNSSRV_RPC_UNION_Type, r->out.ppDataOut, *r->out.pdwTypeOut, r->out.ppDataOut, "union DNSSRV_RPC_UNION");
	if (py_ppDataOut == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_ppDataOut);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_DnssrvEnumRecords_in_get_pwszServerName(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_pwszServerName;
	if (object->in.pwszServerName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pwszServerName == NULL) {
		py_pwszServerName = Py_None;
		Py_INCREF(py_pwszServerName);
	} else {
		if (object->in.pwszServerName == NULL) {
			py_pwszServerName = Py_None;
			Py_INCREF(py_pwszServerName);
		} else {
			py_pwszServerName = PyUnicode_Decode(object->in.pwszServerName, strlen(object->in.pwszServerName), "utf-8", "ignore");
		}
	}
	return py_pwszServerName;
}

static int py_DnssrvEnumRecords_in_set_pwszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pwszServerName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pwszServerName = NULL;
	} else {
		object->in.pwszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pwszServerName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_in_get_pszZone(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_pszZone;
	if (object->in.pszZone == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszZone == NULL) {
		py_pszZone = Py_None;
		Py_INCREF(py_pszZone);
	} else {
		if (object->in.pszZone == NULL) {
			py_pszZone = Py_None;
			Py_INCREF(py_pszZone);
		} else {
			py_pszZone = PyUnicode_Decode(object->in.pszZone, strlen(object->in.pszZone), "utf-8", "ignore");
		}
	}
	return py_pszZone;
}

static int py_DnssrvEnumRecords_in_set_pszZone(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszZone");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszZone = NULL;
	} else {
		object->in.pszZone = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszZone = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_in_get_pszNodeName(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_pszNodeName;
	if (object->in.pszNodeName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszNodeName == NULL) {
		py_pszNodeName = Py_None;
		Py_INCREF(py_pszNodeName);
	} else {
		if (object->in.pszNodeName == NULL) {
			py_pszNodeName = Py_None;
			Py_INCREF(py_pszNodeName);
		} else {
			py_pszNodeName = PyUnicode_Decode(object->in.pszNodeName, strlen(object->in.pszNodeName), "utf-8", "ignore");
		}
	}
	return py_pszNodeName;
}

static int py_DnssrvEnumRecords_in_set_pszNodeName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszNodeName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszNodeName = NULL;
	} else {
		object->in.pszNodeName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszNodeName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_in_get_pszStartChild(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_pszStartChild;
	if (object->in.pszStartChild == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszStartChild == NULL) {
		py_pszStartChild = Py_None;
		Py_INCREF(py_pszStartChild);
	} else {
		if (object->in.pszStartChild == NULL) {
			py_pszStartChild = Py_None;
			Py_INCREF(py_pszStartChild);
		} else {
			py_pszStartChild = PyUnicode_Decode(object->in.pszStartChild, strlen(object->in.pszStartChild), "utf-8", "ignore");
		}
	}
	return py_pszStartChild;
}

static int py_DnssrvEnumRecords_in_set_pszStartChild(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszStartChild");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszStartChild = NULL;
	} else {
		object->in.pszStartChild = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszStartChild = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_in_get_wRecordType(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_wRecordType;
	py_wRecordType = PyLong_FromLong((uint16_t)(object->in.wRecordType));
	return py_wRecordType;
}

static int py_DnssrvEnumRecords_in_set_wRecordType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.wRecordType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.wRecordType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.wRecordType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_in_get_fSelectFlag(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_fSelectFlag;
	py_fSelectFlag = PyLong_FromUnsignedLongLong((uint32_t)(object->in.fSelectFlag));
	return py_fSelectFlag;
}

static int py_DnssrvEnumRecords_in_set_fSelectFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.fSelectFlag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.fSelectFlag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.fSelectFlag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_in_get_pszFilterStart(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_pszFilterStart;
	if (object->in.pszFilterStart == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszFilterStart == NULL) {
		py_pszFilterStart = Py_None;
		Py_INCREF(py_pszFilterStart);
	} else {
		if (object->in.pszFilterStart == NULL) {
			py_pszFilterStart = Py_None;
			Py_INCREF(py_pszFilterStart);
		} else {
			py_pszFilterStart = PyUnicode_Decode(object->in.pszFilterStart, strlen(object->in.pszFilterStart), "utf-8", "ignore");
		}
	}
	return py_pszFilterStart;
}

static int py_DnssrvEnumRecords_in_set_pszFilterStart(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszFilterStart");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszFilterStart = NULL;
	} else {
		object->in.pszFilterStart = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszFilterStart = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_in_get_pszFilterStop(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_pszFilterStop;
	if (object->in.pszFilterStop == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszFilterStop == NULL) {
		py_pszFilterStop = Py_None;
		Py_INCREF(py_pszFilterStop);
	} else {
		if (object->in.pszFilterStop == NULL) {
			py_pszFilterStop = Py_None;
			Py_INCREF(py_pszFilterStop);
		} else {
			py_pszFilterStop = PyUnicode_Decode(object->in.pszFilterStop, strlen(object->in.pszFilterStop), "utf-8", "ignore");
		}
	}
	return py_pszFilterStop;
}

static int py_DnssrvEnumRecords_in_set_pszFilterStop(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszFilterStop");
		return -1;
	}
	if (value == Py_None) {
		object->in.pszFilterStop = NULL;
	} else {
		object->in.pszFilterStop = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pszFilterStop = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_out_get_pdwBufferLength(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_pdwBufferLength;
	if (object->out.pdwBufferLength == NULL) {
		Py_RETURN_NONE;
	}
	py_pdwBufferLength = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pdwBufferLength));
	return py_pdwBufferLength;
}

static int py_DnssrvEnumRecords_out_set_pdwBufferLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pdwBufferLength));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pdwBufferLength");
		return -1;
	}
	object->out.pdwBufferLength = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pdwBufferLength);
	if (object->out.pdwBufferLength == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pdwBufferLength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pdwBufferLength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_out_get_pBuffer(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_pBuffer;
	if (object->out.pBuffer == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.pBuffer == NULL) {
		py_pBuffer = Py_None;
		Py_INCREF(py_pBuffer);
	} else {
		py_pBuffer = pytalloc_reference_ex(&DNS_RPC_RECORDS_ARRAY_Type, *object->out.pBuffer, *object->out.pBuffer);
	}
	return py_pBuffer;
}

static int py_DnssrvEnumRecords_out_set_pBuffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pBuffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pBuffer");
		return -1;
	}
	object->out.pBuffer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pBuffer);
	if (object->out.pBuffer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.pBuffer = NULL;
	} else {
		*object->out.pBuffer = NULL;
		PY_CHECK_TYPE(&DNS_RPC_RECORDS_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.pBuffer = (struct DNS_RPC_RECORDS_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DnssrvEnumRecords_get_result(PyObject *obj, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_DnssrvEnumRecords_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_DnssrvEnumRecords_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pwszServerName"),
		.get = py_DnssrvEnumRecords_in_get_pwszServerName,
		.set = py_DnssrvEnumRecords_in_set_pwszServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pszZone"),
		.get = py_DnssrvEnumRecords_in_get_pszZone,
		.set = py_DnssrvEnumRecords_in_set_pszZone,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_pszNodeName"),
		.get = py_DnssrvEnumRecords_in_get_pszNodeName,
		.set = py_DnssrvEnumRecords_in_set_pszNodeName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_pszStartChild"),
		.get = py_DnssrvEnumRecords_in_get_pszStartChild,
		.set = py_DnssrvEnumRecords_in_set_pszStartChild,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_wRecordType"),
		.get = py_DnssrvEnumRecords_in_get_wRecordType,
		.set = py_DnssrvEnumRecords_in_set_wRecordType,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_record_type")
	},
	{
		.name = discard_const_p(char, "in_fSelectFlag"),
		.get = py_DnssrvEnumRecords_in_get_fSelectFlag,
		.set = py_DnssrvEnumRecords_in_set_fSelectFlag,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_SELECT_FLAGS")
	},
	{
		.name = discard_const_p(char, "in_pszFilterStart"),
		.get = py_DnssrvEnumRecords_in_get_pszFilterStart,
		.set = py_DnssrvEnumRecords_in_set_pszFilterStart,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_pszFilterStop"),
		.get = py_DnssrvEnumRecords_in_get_pszFilterStop,
		.set = py_DnssrvEnumRecords_in_set_pszFilterStop,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pdwBufferLength"),
		.get = py_DnssrvEnumRecords_out_get_pdwBufferLength,
		.set = py_DnssrvEnumRecords_out_set_pdwBufferLength,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pBuffer"),
		.get = py_DnssrvEnumRecords_out_get_pBuffer,
		.set = py_DnssrvEnumRecords_out_set_pBuffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type DNS_RPC_RECORDS_ARRAY")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_DnssrvEnumRecords_get_result,
		.set = py_DnssrvEnumRecords_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_DnssrvEnumRecords_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct DnssrvEnumRecords, type);
	struct DnssrvEnumRecords *_self = (struct DnssrvEnumRecords *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pdwBufferLength = talloc_zero(mem_ctx, uint32_t);
	/* a pointer to a NULL pointer */
	_self->out.pBuffer = talloc_zero(mem_ctx, struct DNS_RPC_RECORDS_ARRAY *);
	return self;
}

static PyObject *py_DnssrvEnumRecords_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_DnssrvEnumRecords_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_dnsserver.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvEnumRecords_ndr_pack");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_DnssrvEnumRecords_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_DnssrvEnumRecords_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_DnssrvEnumRecords_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_DnssrvEnumRecords_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_DnssrvEnumRecords_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_dnsserver.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvEnumRecords_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_DnssrvEnumRecords_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_DnssrvEnumRecords_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_DnssrvEnumRecords_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_DnssrvEnumRecords_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_DnssrvEnumRecords_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct DnssrvEnumRecords *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_dnsserver.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_DnssrvEnumRecords_ndr_print");
		return NULL;
	}
	call = &ndr_table_dnsserver.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_DnssrvEnumRecords_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_DnssrvEnumRecords_ndr_print(py_obj, args, kwargs, "DnssrvEnumRecords_in", NDR_IN);
}

static PyObject *py_DnssrvEnumRecords_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_DnssrvEnumRecords_ndr_print(py_obj, args, kwargs, "DnssrvEnumRecords_out", NDR_OUT);
}

static PyMethodDef py_DnssrvEnumRecords_methods[] = {
	{ "opnum", (PyCFunction)py_DnssrvEnumRecords_ndr_opnum, METH_NOARGS|METH_CLASS,
		"dnsserver.DnssrvEnumRecords.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvEnumRecords_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvEnumRecords_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvEnumRecords_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvEnumRecords_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvEnumRecords_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_DnssrvEnumRecords_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DnssrvEnumRecords_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dnsserver.DnssrvEnumRecords",
	.tp_getset = py_DnssrvEnumRecords_getsetters,
	.tp_methods = py_DnssrvEnumRecords_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_DnssrvEnumRecords_new,
};

static bool pack_py_DnssrvEnumRecords_args_in(PyObject *args, PyObject *kwargs, struct DnssrvEnumRecords *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszNodeName;
	PyObject *py_pszStartChild;
	PyObject *py_wRecordType;
	PyObject *py_fSelectFlag;
	PyObject *py_pszFilterStart;
	PyObject *py_pszFilterStop;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "pszNodeName", "pszStartChild", "wRecordType", "fSelectFlag", "pszFilterStart", "pszFilterStop", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:DnssrvEnumRecords", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_pszNodeName, &py_pszStartChild, &py_wRecordType, &py_fSelectFlag, &py_pszFilterStart, &py_pszFilterStop)) {
		return false;
	}

	if (py_pwszServerName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pwszServerName");
		return false;
	}
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pwszServerName)) {
				unicode = PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pwszServerName)) {
				test_str = PyBytes_AS_STRING(py_pwszServerName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pwszServerName = talloc_str;
		}
	}
	if (py_pszZone == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszZone");
		return false;
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pszZone)) {
				unicode = PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pszZone)) {
				test_str = PyBytes_AS_STRING(py_pszZone);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pszZone = talloc_str;
		}
	}
	if (py_pszNodeName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszNodeName");
		return false;
	}
	if (py_pszNodeName == Py_None) {
		r->in.pszNodeName = NULL;
	} else {
		r->in.pszNodeName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pszNodeName)) {
				unicode = PyUnicode_AsEncodedString(py_pszNodeName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_C