/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	types "github.com/traefik/traefik/v3/pkg/types"
)

// TLSTCPApplyConfiguration represents a declarative configuration of the TLSTCP type for use
// with apply.
type TLSTCPApplyConfiguration struct {
	SecretName   *string                            `json:"secretName,omitempty"`
	Passthrough  *bool                              `json:"passthrough,omitempty"`
	Options      *ObjectReferenceApplyConfiguration `json:"options,omitempty"`
	Store        *ObjectReferenceApplyConfiguration `json:"store,omitempty"`
	CertResolver *string                            `json:"certResolver,omitempty"`
	Domains      []types.Domain                     `json:"domains,omitempty"`
}

// TLSTCPApplyConfiguration constructs a declarative configuration of the TLSTCP type for use with
// apply.
func TLSTCP() *TLSTCPApplyConfiguration {
	return &TLSTCPApplyConfiguration{}
}

// WithSecretName sets the SecretName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretName field is set to the value of the last call.
func (b *TLSTCPApplyConfiguration) WithSecretName(value string) *TLSTCPApplyConfiguration {
	b.SecretName = &value
	return b
}

// WithPassthrough sets the Passthrough field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Passthrough field is set to the value of the last call.
func (b *TLSTCPApplyConfiguration) WithPassthrough(value bool) *TLSTCPApplyConfiguration {
	b.Passthrough = &value
	return b
}

// WithOptions sets the Options field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Options field is set to the value of the last call.
func (b *TLSTCPApplyConfiguration) WithOptions(value *ObjectReferenceApplyConfiguration) *TLSTCPApplyConfiguration {
	b.Options = value
	return b
}

// WithStore sets the Store field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Store field is set to the value of the last call.
func (b *TLSTCPApplyConfiguration) WithStore(value *ObjectReferenceApplyConfiguration) *TLSTCPApplyConfiguration {
	b.Store = value
	return b
}

// WithCertResolver sets the CertResolver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CertResolver field is set to the value of the last call.
func (b *TLSTCPApplyConfiguration) WithCertResolver(value string) *TLSTCPApplyConfiguration {
	b.CertResolver = &value
	return b
}

// WithDomains adds the given value to the Domains field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Domains field.
func (b *TLSTCPApplyConfiguration) WithDomains(values ...types.Domain) *TLSTCPApplyConfiguration {
	for i := range values {
		b.Domains = append(b.Domains, values[i])
	}
	return b
}
