#ifndef ORG_VARLINK_SERVICE_H
#define ORG_VARLINK_SERVICE_H

#include <stdbool.h>
#include <stddef.h>

struct json_object;
struct vali_client;
struct vali_error;
struct vali_service_call;
struct vali_registry;

/**
 * The Varlink Service Interface is provided by every varlink service. It
 * describes the service and the interfaces it implements.
 */

/**
 * The requested interface was not found.
 */
struct org_varlink_service_error_InterfaceNotFound {
	char *interface;
};
/** Try to convert a struct vali_error into a InterfaceNotFound error. */
bool org_varlink_service_error_InterfaceNotFound_from(struct org_varlink_service_error_InterfaceNotFound *out, const struct vali_error *err);
/** Close a service call with a InterfaceNotFound error. */
void org_varlink_service_error_InterfaceNotFound_close_service_call(struct vali_service_call *call, const struct org_varlink_service_error_InterfaceNotFound *params);

/**
 * The requested method was not found
 */
struct org_varlink_service_error_MethodNotFound {
	char *method;
};
/** Try to convert a struct vali_error into a MethodNotFound error. */
bool org_varlink_service_error_MethodNotFound_from(struct org_varlink_service_error_MethodNotFound *out, const struct vali_error *err);
/** Close a service call with a MethodNotFound error. */
void org_varlink_service_error_MethodNotFound_close_service_call(struct vali_service_call *call, const struct org_varlink_service_error_MethodNotFound *params);

/**
 * The interface defines the requested method, but the service does not
 * implement it.
 */
struct org_varlink_service_error_MethodNotImplemented {
	char *method;
};
/** Try to convert a struct vali_error into a MethodNotImplemented error. */
bool org_varlink_service_error_MethodNotImplemented_from(struct org_varlink_service_error_MethodNotImplemented *out, const struct vali_error *err);
/** Close a service call with a MethodNotImplemented error. */
void org_varlink_service_error_MethodNotImplemented_close_service_call(struct vali_service_call *call, const struct org_varlink_service_error_MethodNotImplemented *params);

/**
 * One of the passed parameters is invalid.
 */
struct org_varlink_service_error_InvalidParameter {
	char *parameter;
};
/** Try to convert a struct vali_error into a InvalidParameter error. */
bool org_varlink_service_error_InvalidParameter_from(struct org_varlink_service_error_InvalidParameter *out, const struct vali_error *err);
/** Close a service call with a InvalidParameter error. */
void org_varlink_service_error_InvalidParameter_close_service_call(struct vali_service_call *call, const struct org_varlink_service_error_InvalidParameter *params);

/**
 * Client is denied access
 */
struct org_varlink_service_error_PermissionDenied {
	char _;
};
/** Try to convert a struct vali_error into a PermissionDenied error. */
bool org_varlink_service_error_PermissionDenied_from(struct org_varlink_service_error_PermissionDenied *out, const struct vali_error *err);
/** Close a service call with a PermissionDenied error. */
void org_varlink_service_error_PermissionDenied_close_service_call(struct vali_service_call *call, const struct org_varlink_service_error_PermissionDenied *params);

/**
 * Method is expected to be called with 'more' set to true, but wasn't
 */
struct org_varlink_service_error_ExpectedMore {
	char _;
};
/** Try to convert a struct vali_error into a ExpectedMore error. */
bool org_varlink_service_error_ExpectedMore_from(struct org_varlink_service_error_ExpectedMore *out, const struct vali_error *err);
/** Close a service call with a ExpectedMore error. */
void org_varlink_service_error_ExpectedMore_close_service_call(struct vali_service_call *call, const struct org_varlink_service_error_ExpectedMore *params);

/** Input for GetInfo calls. */
struct org_varlink_service_GetInfo_in {
	char _;
};
/** Output for GetInfo calls. */
struct org_varlink_service_GetInfo_out {
	char *vendor;
	char *product;
	char *version;
	char *url;
	struct org_varlink_service_GetInfo_out_interfaces {
		char **data;
		size_t len;
	} interfaces;
};
/** Release resources held by GetInfo call output. */
void org_varlink_service_GetInfo_out_finish(struct org_varlink_service_GetInfo_out *v);
/**
 * Get a list of all the interfaces a service provides and information
 * about the implementation.
 */
bool org_varlink_service_GetInfo(struct vali_client *c, const struct org_varlink_service_GetInfo_in *in, struct org_varlink_service_GetInfo_out *out, struct vali_error *err);
/** A GetInfo call for a client. */
struct org_varlink_service_GetInfo_client_call {
	struct vali_client_call *base;
};
/** Send a request for a GetInfo client call, indicating that multiple replies are expected. */
struct org_varlink_service_GetInfo_client_call org_varlink_service_GetInfo_more(struct vali_client *c, const struct org_varlink_service_GetInfo_in *in);
/** Wait for a GetInfo reply. */
bool org_varlink_service_GetInfo_client_call_wait(struct org_varlink_service_GetInfo_client_call call, struct org_varlink_service_GetInfo_out *out, struct vali_error *err);
/** Send a request for a GetInfo client call, indicating that no reply is expected. */bool org_varlink_service_GetInfo_oneway(struct vali_client *c, const struct org_varlink_service_GetInfo_in *in);
/** A GetInfo call for a service. */
struct org_varlink_service_GetInfo_service_call {
	struct vali_service_call *base;
};
/** Close a GetInfo service call with a final reply. */
void org_varlink_service_GetInfo_close_with_reply(struct org_varlink_service_GetInfo_service_call call, const struct org_varlink_service_GetInfo_out *params);
/** Send a reply for a GetInfo service call, indicating that more replies will be sent. */
void org_varlink_service_GetInfo_reply(struct org_varlink_service_GetInfo_service_call call, const struct org_varlink_service_GetInfo_out *params);

/** Input for GetInterfaceDescription calls. */
struct org_varlink_service_GetInterfaceDescription_in {
	char *interface;
};
/** Output for GetInterfaceDescription calls. */
struct org_varlink_service_GetInterfaceDescription_out {
	char *description;
};
/** Release resources held by GetInterfaceDescription call output. */
void org_varlink_service_GetInterfaceDescription_out_finish(struct org_varlink_service_GetInterfaceDescription_out *v);
/**
 * Get the description of an interface that is implemented by this service.
 */
bool org_varlink_service_GetInterfaceDescription(struct vali_client *c, const struct org_varlink_service_GetInterfaceDescription_in *in, struct org_varlink_service_GetInterfaceDescription_out *out, struct vali_error *err);
/** A GetInterfaceDescription call for a client. */
struct org_varlink_service_GetInterfaceDescription_client_call {
	struct vali_client_call *base;
};
/** Send a request for a GetInterfaceDescription client call, indicating that multiple replies are expected. */
struct org_varlink_service_GetInterfaceDescription_client_call org_varlink_service_GetInterfaceDescription_more(struct vali_client *c, const struct org_varlink_service_GetInterfaceDescription_in *in);
/** Wait for a GetInterfaceDescription reply. */
bool org_varlink_service_GetInterfaceDescription_client_call_wait(struct org_varlink_service_GetInterfaceDescription_client_call call, struct org_varlink_service_GetInterfaceDescription_out *out, struct vali_error *err);
/** Send a request for a GetInterfaceDescription client call, indicating that no reply is expected. */bool org_varlink_service_GetInterfaceDescription_oneway(struct vali_client *c, const struct org_varlink_service_GetInterfaceDescription_in *in);
/** A GetInterfaceDescription call for a service. */
struct org_varlink_service_GetInterfaceDescription_service_call {
	struct vali_service_call *base;
};
/** Close a GetInterfaceDescription service call with a final reply. */
void org_varlink_service_GetInterfaceDescription_close_with_reply(struct org_varlink_service_GetInterfaceDescription_service_call call, const struct org_varlink_service_GetInterfaceDescription_out *params);
/** Send a reply for a GetInterfaceDescription service call, indicating that more replies will be sent. */
void org_varlink_service_GetInterfaceDescription_reply(struct org_varlink_service_GetInterfaceDescription_service_call call, const struct org_varlink_service_GetInterfaceDescription_out *params);

/** Handler for org.varlink.service. */
struct org_varlink_service_handler {
	/**
	 * Get a list of all the interfaces a service provides and information
	 * about the implementation.
	 */
	void (*GetInfo)(struct org_varlink_service_GetInfo_service_call call, const struct org_varlink_service_GetInfo_in *in);
	/**
	 * Get the description of an interface that is implemented by this service.
	 */
	void (*GetInterfaceDescription)(struct org_varlink_service_GetInterfaceDescription_service_call call, const struct org_varlink_service_GetInterfaceDescription_in *in);
};

/** Get a service call handler from a org.varlink.service handler. */
struct vali_service_call_handler org_varlink_service_get_call_handler(const struct org_varlink_service_handler *handler);

/** Description of the org.varlink.service interface. */
extern const struct vali_registry_interface org_varlink_service_interface;

#endif
