// Code generated by Microsoft Kiota - DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package models

import (
    i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e "time"
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
)

type ReflectCheckInResponse struct {
    Entity
}
// NewReflectCheckInResponse instantiates a new ReflectCheckInResponse and sets the default values.
func NewReflectCheckInResponse()(*ReflectCheckInResponse) {
    m := &ReflectCheckInResponse{
        Entity: *NewEntity(),
    }
    return m
}
// CreateReflectCheckInResponseFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
// returns a Parsable when successful
func CreateReflectCheckInResponseFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewReflectCheckInResponse(), nil
}
// GetCheckInId gets the checkInId property value. Identifier for the Reflect check-in.
// returns a *string when successful
func (m *ReflectCheckInResponse) GetCheckInId()(*string) {
    val, err := m.GetBackingStore().Get("checkInId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetCheckInTitle gets the checkInTitle property value. The question or prompt of the Reflect check-in that this response addresses.
// returns a *string when successful
func (m *ReflectCheckInResponse) GetCheckInTitle()(*string) {
    val, err := m.GetBackingStore().Get("checkInTitle")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetClassId gets the classId property value. ID of the class associated with the Reflect check-in.
// returns a *string when successful
func (m *ReflectCheckInResponse) GetClassId()(*string) {
    val, err := m.GetBackingStore().Get("classId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetCreatedDateTime gets the createdDateTime property value. Date and time when the Reflect check-in was created. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
// returns a *Time when successful
func (m *ReflectCheckInResponse) GetCreatedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("createdDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetCreatorId gets the creatorId property value. ID of the user who created the Reflect check-in.
// returns a *string when successful
func (m *ReflectCheckInResponse) GetCreatorId()(*string) {
    val, err := m.GetBackingStore().Get("creatorId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
// returns a map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error) when successful
func (m *ReflectCheckInResponse) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.Entity.GetFieldDeserializers()
    res["checkInId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCheckInId(val)
        }
        return nil
    }
    res["checkInTitle"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCheckInTitle(val)
        }
        return nil
    }
    res["classId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetClassId(val)
        }
        return nil
    }
    res["createdDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCreatedDateTime(val)
        }
        return nil
    }
    res["creatorId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCreatorId(val)
        }
        return nil
    }
    res["isClosed"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetBoolValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetIsClosed(val)
        }
        return nil
    }
    res["responderId"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetResponderId(val)
        }
        return nil
    }
    res["responseEmotion"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseResponseEmotionType)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetResponseEmotion(val.(*ResponseEmotionType))
        }
        return nil
    }
    res["responseFeedback"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseResponseFeedbackType)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetResponseFeedback(val.(*ResponseFeedbackType))
        }
        return nil
    }
    res["submitDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetSubmitDateTime(val)
        }
        return nil
    }
    return res
}
// GetIsClosed gets the isClosed property value. Indicates whether the Reflect check-in is closed (true) or open (false).
// returns a *bool when successful
func (m *ReflectCheckInResponse) GetIsClosed()(*bool) {
    val, err := m.GetBackingStore().Get("isClosed")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*bool)
    }
    return nil
}
// GetResponderId gets the responderId property value. ID of the user who responded to the Reflect check-in.
// returns a *string when successful
func (m *ReflectCheckInResponse) GetResponderId()(*string) {
    val, err := m.GetBackingStore().Get("responderId")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetResponseEmotion gets the responseEmotion property value. The responseEmotion property
// returns a *ResponseEmotionType when successful
func (m *ReflectCheckInResponse) GetResponseEmotion()(*ResponseEmotionType) {
    val, err := m.GetBackingStore().Get("responseEmotion")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*ResponseEmotionType)
    }
    return nil
}
// GetResponseFeedback gets the responseFeedback property value. The responseFeedback property
// returns a *ResponseFeedbackType when successful
func (m *ReflectCheckInResponse) GetResponseFeedback()(*ResponseFeedbackType) {
    val, err := m.GetBackingStore().Get("responseFeedback")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*ResponseFeedbackType)
    }
    return nil
}
// GetSubmitDateTime gets the submitDateTime property value. Date and time when the response to the Reflect check-in was submitted. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
// returns a *Time when successful
func (m *ReflectCheckInResponse) GetSubmitDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("submitDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// Serialize serializes information the current object
func (m *ReflectCheckInResponse) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.Entity.Serialize(writer)
    if err != nil {
        return err
    }
    {
        err = writer.WriteStringValue("checkInId", m.GetCheckInId())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("checkInTitle", m.GetCheckInTitle())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("classId", m.GetClassId())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("createdDateTime", m.GetCreatedDateTime())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("creatorId", m.GetCreatorId())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteBoolValue("isClosed", m.GetIsClosed())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("responderId", m.GetResponderId())
        if err != nil {
            return err
        }
    }
    if m.GetResponseEmotion() != nil {
        cast := (*m.GetResponseEmotion()).String()
        err = writer.WriteStringValue("responseEmotion", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetResponseFeedback() != nil {
        cast := (*m.GetResponseFeedback()).String()
        err = writer.WriteStringValue("responseFeedback", &cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("submitDateTime", m.GetSubmitDateTime())
        if err != nil {
            return err
        }
    }
    return nil
}
// SetCheckInId sets the checkInId property value. Identifier for the Reflect check-in.
func (m *ReflectCheckInResponse) SetCheckInId(value *string)() {
    err := m.GetBackingStore().Set("checkInId", value)
    if err != nil {
        panic(err)
    }
}
// SetCheckInTitle sets the checkInTitle property value. The question or prompt of the Reflect check-in that this response addresses.
func (m *ReflectCheckInResponse) SetCheckInTitle(value *string)() {
    err := m.GetBackingStore().Set("checkInTitle", value)
    if err != nil {
        panic(err)
    }
}
// SetClassId sets the classId property value. ID of the class associated with the Reflect check-in.
func (m *ReflectCheckInResponse) SetClassId(value *string)() {
    err := m.GetBackingStore().Set("classId", value)
    if err != nil {
        panic(err)
    }
}
// SetCreatedDateTime sets the createdDateTime property value. Date and time when the Reflect check-in was created. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
func (m *ReflectCheckInResponse) SetCreatedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("createdDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetCreatorId sets the creatorId property value. ID of the user who created the Reflect check-in.
func (m *ReflectCheckInResponse) SetCreatorId(value *string)() {
    err := m.GetBackingStore().Set("creatorId", value)
    if err != nil {
        panic(err)
    }
}
// SetIsClosed sets the isClosed property value. Indicates whether the Reflect check-in is closed (true) or open (false).
func (m *ReflectCheckInResponse) SetIsClosed(value *bool)() {
    err := m.GetBackingStore().Set("isClosed", value)
    if err != nil {
        panic(err)
    }
}
// SetResponderId sets the responderId property value. ID of the user who responded to the Reflect check-in.
func (m *ReflectCheckInResponse) SetResponderId(value *string)() {
    err := m.GetBackingStore().Set("responderId", value)
    if err != nil {
        panic(err)
    }
}
// SetResponseEmotion sets the responseEmotion property value. The responseEmotion property
func (m *ReflectCheckInResponse) SetResponseEmotion(value *ResponseEmotionType)() {
    err := m.GetBackingStore().Set("responseEmotion", value)
    if err != nil {
        panic(err)
    }
}
// SetResponseFeedback sets the responseFeedback property value. The responseFeedback property
func (m *ReflectCheckInResponse) SetResponseFeedback(value *ResponseFeedbackType)() {
    err := m.GetBackingStore().Set("responseFeedback", value)
    if err != nil {
        panic(err)
    }
}
// SetSubmitDateTime sets the submitDateTime property value. Date and time when the response to the Reflect check-in was submitted. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
func (m *ReflectCheckInResponse) SetSubmitDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("submitDateTime", value)
    if err != nil {
        panic(err)
    }
}
type ReflectCheckInResponseable interface {
    Entityable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetCheckInId()(*string)
    GetCheckInTitle()(*string)
    GetClassId()(*string)
    GetCreatedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetCreatorId()(*string)
    GetIsClosed()(*bool)
    GetResponderId()(*string)
    GetResponseEmotion()(*ResponseEmotionType)
    GetResponseFeedback()(*ResponseFeedbackType)
    GetSubmitDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    SetCheckInId(value *string)()
    SetCheckInTitle(value *string)()
    SetClassId(value *string)()
    SetCreatedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetCreatorId(value *string)()
    SetIsClosed(value *bool)()
    SetResponderId(value *string)()
    SetResponseEmotion(value *ResponseEmotionType)()
    SetResponseFeedback(value *ResponseFeedbackType)()
    SetSubmitDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
}
