// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetAuditLogStatusParams creates a new GetAuditLogStatusParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAuditLogStatusParams() *GetAuditLogStatusParams {
	return &GetAuditLogStatusParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAuditLogStatusParamsWithTimeout creates a new GetAuditLogStatusParams object
// with the ability to set a timeout on a request.
func NewGetAuditLogStatusParamsWithTimeout(timeout time.Duration) *GetAuditLogStatusParams {
	return &GetAuditLogStatusParams{
		timeout: timeout,
	}
}

// NewGetAuditLogStatusParamsWithContext creates a new GetAuditLogStatusParams object
// with the ability to set a context for a request.
func NewGetAuditLogStatusParamsWithContext(ctx context.Context) *GetAuditLogStatusParams {
	return &GetAuditLogStatusParams{
		Context: ctx,
	}
}

// NewGetAuditLogStatusParamsWithHTTPClient creates a new GetAuditLogStatusParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAuditLogStatusParamsWithHTTPClient(client *http.Client) *GetAuditLogStatusParams {
	return &GetAuditLogStatusParams{
		HTTPClient: client,
	}
}

/*
GetAuditLogStatusParams contains all the parameters to send to the API endpoint

	for the get audit log status operation.

	Typically these are written to a http.Request.
*/
type GetAuditLogStatusParams struct {

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	// LogID.
	LogID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get audit log status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAuditLogStatusParams) WithDefaults() *GetAuditLogStatusParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get audit log status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAuditLogStatusParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get audit log status params
func (o *GetAuditLogStatusParams) WithTimeout(timeout time.Duration) *GetAuditLogStatusParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get audit log status params
func (o *GetAuditLogStatusParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get audit log status params
func (o *GetAuditLogStatusParams) WithContext(ctx context.Context) *GetAuditLogStatusParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get audit log status params
func (o *GetAuditLogStatusParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get audit log status params
func (o *GetAuditLogStatusParams) WithHTTPClient(client *http.Client) *GetAuditLogStatusParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get audit log status params
func (o *GetAuditLogStatusParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the get audit log status params
func (o *GetAuditLogStatusParams) WithClusterID(clusterID string) *GetAuditLogStatusParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the get audit log status params
func (o *GetAuditLogStatusParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the get audit log status params
func (o *GetAuditLogStatusParams) WithLocationOrganizationID(locationOrganizationID string) *GetAuditLogStatusParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get audit log status params
func (o *GetAuditLogStatusParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get audit log status params
func (o *GetAuditLogStatusParams) WithLocationProjectID(locationProjectID string) *GetAuditLogStatusParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get audit log status params
func (o *GetAuditLogStatusParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get audit log status params
func (o *GetAuditLogStatusParams) WithLocationRegionProvider(locationRegionProvider *string) *GetAuditLogStatusParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get audit log status params
func (o *GetAuditLogStatusParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get audit log status params
func (o *GetAuditLogStatusParams) WithLocationRegionRegion(locationRegionRegion *string) *GetAuditLogStatusParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get audit log status params
func (o *GetAuditLogStatusParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithLogID adds the logID to the get audit log status params
func (o *GetAuditLogStatusParams) WithLogID(logID string) *GetAuditLogStatusParams {
	o.SetLogID(logID)
	return o
}

// SetLogID adds the logId to the get audit log status params
func (o *GetAuditLogStatusParams) SetLogID(logID string) {
	o.LogID = logID
}

// WriteToRequest writes these params to a swagger request
func (o *GetAuditLogStatusParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param log_id
	if err := r.SetPathParam("log_id", o.LogID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
