/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSServiceWorkerUpdateViaCache.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ServiceWorkerUpdateViaCache enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("imports"),
        MAKE_STATIC_STRING_IMPL("all"),
        MAKE_STATIC_STRING_IMPL("none"),
    };
    static_assert(static_cast<size_t>(ServiceWorkerUpdateViaCache::Imports) == 0, "ServiceWorkerUpdateViaCache::Imports is not 0 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerUpdateViaCache::All) == 1, "ServiceWorkerUpdateViaCache::All is not 1 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerUpdateViaCache::None) == 2, "ServiceWorkerUpdateViaCache::None is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ServiceWorkerUpdateViaCache enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ServiceWorkerUpdateViaCache> parseEnumerationFromString<ServiceWorkerUpdateViaCache>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ServiceWorkerUpdateViaCache>, 3> mappings {
        std::pair<ComparableASCIILiteral, ServiceWorkerUpdateViaCache> { "all"_s, ServiceWorkerUpdateViaCache::All },
        std::pair<ComparableASCIILiteral, ServiceWorkerUpdateViaCache> { "imports"_s, ServiceWorkerUpdateViaCache::Imports },
        std::pair<ComparableASCIILiteral, ServiceWorkerUpdateViaCache> { "none"_s, ServiceWorkerUpdateViaCache::None },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ServiceWorkerUpdateViaCache> parseEnumeration<ServiceWorkerUpdateViaCache>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ServiceWorkerUpdateViaCache>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ServiceWorkerUpdateViaCache>()
{
    return "\"imports\", \"all\", \"none\""_s;
}

} // namespace WebCore

