#include "nv_push_clc86f.h"

#include <stdio.h>





const char *P_PARSE_NVC56F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC56F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC86F_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVC56F_MTHD(idx);

                                        case NVC86F_MEM_OP_A:
        return "NVC86F_MEM_OP_A";
            case NVC86F_MEM_OP_D:
        return "NVC86F_MEM_OP_D";
            case NVC86F_SEM_ADDR_HI:
        return "NVC86F_SEM_ADDR_HI";
                        
    }
}

void
P_DUMP_NVC86F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVC56F_MTHD_DATA(fp, idx, data, prefix);
    break;

                                      
    case NVC86F_MEM_OP_A:

    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_CLIENT_UNIT_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVALIDATION_SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 5) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_GPC_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVAL_SCOPE = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_ALL_TLBS:
            fprintf(fp, "ALL_TLBS\n");
            break;
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_LINK_TLBS:
            fprintf(fp, "LINK_TLBS\n");
            break;
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS:
            fprintf(fp, "NON_LINK_TLBS\n");
            break;
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_RSVRVD:
            fprintf(fp, "RSVRVD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_MMU_ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_SYSMEMBAR = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN:
            fprintf(fp, "EN\n");
            break;
        case NVC86F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
          
    case NVC86F_MEM_OP_D:

    
        parsed = (data >> 0) & ((1u << 27) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_HI = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC86F_MEM_OP_D_OPERATION_MEMBAR:
            fprintf(fp, "MEMBAR\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE:
            fprintf(fp, "MMU_TLB_INVALIDATE\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED:
            fprintf(fp, "MMU_TLB_INVALIDATE_TARGETED\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_MMU_OPERATION:
            fprintf(fp, "MMU_OPERATION\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE:
            fprintf(fp, "L2_PEERMEM_INVALIDATE\n");
            break;
        case NVC86F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE:
            fprintf(fp, "L2_SYSMEM_INVALIDATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
          
    case NVC86F_SEM_ADDR_HI:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                            }
}
