﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53-recovery-control-config/Route53RecoveryControlConfigRequest.h>
#include <aws/route53-recovery-control-config/Route53RecoveryControlConfig_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Route53RecoveryControlConfig {
namespace Model {

/**
 */
class ListAssociatedRoute53HealthChecksRequest : public Route53RecoveryControlConfigRequest {
 public:
  AWS_ROUTE53RECOVERYCONTROLCONFIG_API ListAssociatedRoute53HealthChecksRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListAssociatedRoute53HealthChecks"; }

  AWS_ROUTE53RECOVERYCONTROLCONFIG_API Aws::String SerializePayload() const override;

  AWS_ROUTE53RECOVERYCONTROLCONFIG_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The number of objects that you want to return with this call.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListAssociatedRoute53HealthChecksRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token that identifies which batch of results you want to see.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAssociatedRoute53HealthChecksRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the routing control.</p>
   */
  inline const Aws::String& GetRoutingControlArn() const { return m_routingControlArn; }
  inline bool RoutingControlArnHasBeenSet() const { return m_routingControlArnHasBeenSet; }
  template <typename RoutingControlArnT = Aws::String>
  void SetRoutingControlArn(RoutingControlArnT&& value) {
    m_routingControlArnHasBeenSet = true;
    m_routingControlArn = std::forward<RoutingControlArnT>(value);
  }
  template <typename RoutingControlArnT = Aws::String>
  ListAssociatedRoute53HealthChecksRequest& WithRoutingControlArn(RoutingControlArnT&& value) {
    SetRoutingControlArn(std::forward<RoutingControlArnT>(value));
    return *this;
  }
  ///@}
 private:
  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_routingControlArn;
  bool m_routingControlArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53RecoveryControlConfig
}  // namespace Aws
