/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.CmapFormat0;
import jogamp.graph.font.typecast.ot.table.CmapFormat12;
import jogamp.graph.font.typecast.ot.table.CmapFormat2;
import jogamp.graph.font.typecast.ot.table.CmapFormat4;
import jogamp.graph.font.typecast.ot.table.CmapFormat6;
import jogamp.graph.font.typecast.ot.table.CmapFormatUnknown;

public abstract class CmapFormat {
    static CmapFormat create(int n, DataInput dataInput) throws IOException {
        switch (n) {
            case 0: {
                return new CmapFormat0(dataInput);
            }
            case 2: {
                return new CmapFormat2(dataInput);
            }
            case 4: {
                return new CmapFormat4(dataInput);
            }
            case 6: {
                return new CmapFormat6(dataInput);
            }
            case 12: {
                return new CmapFormat12(dataInput);
            }
        }
        return new CmapFormatUnknown(n, dataInput);
    }

    protected abstract int getFormat();

    public abstract int getLength();

    protected abstract int getLanguage();

    public abstract int getRangeCount();

    public abstract Range getRange(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract int mapCharCode(int var1);

    public String toString() {
        return "    format:         " + this.getFormat() + "\n    length:         " + this.getLength() + "\n    language:       " + this.getLanguage() + "\n";
    }

    public static class Range {
        private final int _startCode;
        private final int _endCode;

        Range(int n, int n2) {
            this._startCode = n;
            this._endCode = n2;
        }

        public int getStartCode() {
            return this._startCode;
        }

        public int getEndCode() {
            return this._endCode;
        }
    }
}

