/* favourite-details.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from favourite-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "folks/folks.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksFavouriteDetailsChangeIsFavouriteData FolksFavouriteDetailsChangeIsFavouriteData;

struct _FolksFavouriteDetailsChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksFavouriteDetails* self;
	gboolean is_favourite;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static void folks_favourite_details_real_change_is_favourite_data_free (gpointer _data);
static void folks_favourite_details_real_change_is_favourite (FolksFavouriteDetails* self,
                                                       gboolean is_favourite,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean folks_favourite_details_real_change_is_favourite_co (FolksFavouriteDetailsChangeIsFavouriteData* _data_);
static GType folks_favourite_details_get_type_once (void);

static void
folks_favourite_details_real_change_is_favourite_data_free (gpointer _data)
{
	FolksFavouriteDetailsChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksFavouriteDetailsChangeIsFavouriteData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_favourite_details_real_change_is_favourite (FolksFavouriteDetails* self,
                                                  gboolean is_favourite,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	FolksFavouriteDetailsChangeIsFavouriteData* _data_;
	FolksFavouriteDetails* _tmp0_;
	_data_ = g_slice_new0 (FolksFavouriteDetailsChangeIsFavouriteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_favourite_details_real_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->is_favourite = is_favourite;
	folks_favourite_details_real_change_is_favourite_co (_data_);
}

static void
folks_favourite_details_real_change_is_favourite_finish (FolksFavouriteDetails* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	FolksFavouriteDetailsChangeIsFavouriteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change whether the contact is a user-defined favourite.
   *
   * It's preferred to call this rather than setting
   * {@link FavouriteDetails.is_favourite} directly, as this method gives error
   * notification and will only return once the favouriteness has been written
   * to the relevant backing store (or the operation's failed).
   *
   * @param is_favourite ``true`` if the contact is a favourite; ``false``
   * otherwise
   * @throws PropertyError if setting the favouriteness failed
   * @since 0.6.2
   */
static gboolean
folks_favourite_details_real_change_is_favourite_co (FolksFavouriteDetailsChangeIsFavouriteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Favorite status is not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_favourite_details_change_is_favourite (FolksFavouriteDetails* self,
                                             gboolean is_favourite,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	FolksFavouriteDetailsIface* _iface_;
	_iface_ = FOLKS_FAVOURITE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_is_favourite) {
		_iface_->change_is_favourite (self, is_favourite, _callback_, _user_data_);
	}
}

void
folks_favourite_details_change_is_favourite_finish (FolksFavouriteDetails* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	FolksFavouriteDetailsIface* _iface_;
	_iface_ = FOLKS_FAVOURITE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_is_favourite_finish) {
		_iface_->change_is_favourite_finish (self, _res_, error);
	}
}

gboolean
folks_favourite_details_get_is_favourite (FolksFavouriteDetails* self)
{
	FolksFavouriteDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = FOLKS_FAVOURITE_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_is_favourite) {
		return _iface_->get_is_favourite (self);
	}
	return FALSE;
}

void
folks_favourite_details_set_is_favourite (FolksFavouriteDetails* self,
                                          gboolean value)
{
	FolksFavouriteDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_FAVOURITE_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_is_favourite) {
		_iface_->set_is_favourite (self, value);
	}
}

static void
folks_favourite_details_default_init (FolksFavouriteDetailsIface * iface,
                                      gpointer iface_data)
{
	/**
	   * Whether this contact is a user-defined favourite.
	   */
	g_object_interface_install_property (iface, g_param_spec_boolean ("is-favourite", "is-favourite", "is-favourite", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_is_favourite = folks_favourite_details_real_change_is_favourite;
	iface->change_is_favourite_finish = folks_favourite_details_real_change_is_favourite_finish;
}

/**
 * Favourite status for a contact.
 *
 * This allows user-defined favourite contacts to be specified. A contact is a
 * favourite if the user has selected them as such; the semantics of 'favourite'
 * are left unspecified by folks. Typically, a user might select the contacts
 * that they talk to most frequently as their favourite contacts in an instant
 * messaging program, for example.
 */
static GType
folks_favourite_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksFavouriteDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_favourite_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_favourite_details_type_id;
	folks_favourite_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksFavouriteDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_favourite_details_type_id, G_TYPE_OBJECT);
	return folks_favourite_details_type_id;
}

GType
folks_favourite_details_get_type (void)
{
	static volatile gsize folks_favourite_details_type_id__once = 0;
	if (g_once_init_enter (&folks_favourite_details_type_id__once)) {
		GType folks_favourite_details_type_id;
		folks_favourite_details_type_id = folks_favourite_details_get_type_once ();
		g_once_init_leave (&folks_favourite_details_type_id__once, folks_favourite_details_type_id);
	}
	return folks_favourite_details_type_id__once;
}

