/* -*- Mode: C; c-basic-offset: 4 -*-
 * vim: tabstop=4 shiftwidth=4 expandtab
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PYGI_VALUE_H__
#define __PYGI_VALUE_H__

#include <girepository/girepository.h>
#include <pythoncapi_compat.h>

G_BEGIN_DECLS

GIArgument _pygi_argument_from_g_value (const GValue *value,
                                        GITypeInfo *type_info);

int pyg_value_from_pyobject (GValue *value, PyObject *obj);
int pyg_value_from_pyobject_with_error (GValue *value, PyObject *obj);
PyObject *pyg_value_to_pyobject (const GValue *value, gboolean copy_boxed);
int pyg_param_gvalue_from_pyobject (GValue *value, PyObject *py_obj,
                                    const GParamSpec *pspec);

PyObject *pygi_value_to_py_basic_type (const GValue *value, GType fundamental);

PyObject *pyg__gvalue_get (PyObject *module, PyObject *pygvalue);
PyObject *pyg__gvalue_set (PyObject *module, PyObject *args);
PyObject *pyg__gvalue_get_type (PyObject *module, PyObject *pygvalue);

G_END_DECLS

#endif /* __PYGI_VALUE_H__ */
