#include "nv_push_clc097.h"

#include <stdio.h>





const char *P_PARSE_NVB197_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVB197_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC097_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVB197_MTHD(idx);

                                                                                                                                case NVC097_SET_DST_ORIGIN_BYTES_X:
        return "NVC097_SET_DST_ORIGIN_BYTES_X";
    case NVC097_SET_DST_ORIGIN_SAMPLES_Y:
        return "NVC097_SET_DST_ORIGIN_SAMPLES_Y";
                                                                                    case NVC097_SET_ALPHA_CIRCULAR_BUFFER_SIZE:
        return "NVC097_SET_ALPHA_CIRCULAR_BUFFER_SIZE";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case NVC097_SET_SCREEN_STATE_MASK:
        return "NVC097_SET_SCREEN_STATE_MASK";
                                        case NVC097_SET_ZT_SIZE_B:
        return "NVC097_SET_ZT_SIZE_B";
                        case NVC097_SET_BACK_END_COPY_A:
        return "NVC097_SET_BACK_END_COPY_A";
    case NVC097_SET_BACK_END_COPY_B:
        return "NVC097_SET_BACK_END_COPY_B";
    case NVC097_SET_BACK_END_COPY_C:
        return "NVC097_SET_BACK_END_COPY_C";
    case NVC097_SET_BACK_END_COPY_D:
        return "NVC097_SET_BACK_END_COPY_D";
    case NVC097_SET_BACK_END_COPY_E:
        return "NVC097_SET_BACK_END_COPY_E";
    case NVC097_SET_CIRCULAR_BUFFER_SIZE:
        return "NVC097_SET_CIRCULAR_BUFFER_SIZE";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    case NVC097_SET_REPORT_SEMAPHORE_D:
        return "NVC097_SET_REPORT_SEMAPHORE_D";
                                                                                                                                                                                                                                                                                                                                        case NVC097_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
        return "NVC097_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER";
    case NVC097_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
        return "NVC097_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER";
            
    }
}

void
P_DUMP_NVC097_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVB197_MTHD_DATA(fp, idx, data, prefix);
    break;

                                                                                                                              
    case NVC097_SET_DST_ORIGIN_BYTES_X:

    
        parsed = (data >> 0) & ((1u << 21) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC097_SET_DST_ORIGIN_SAMPLES_Y:

    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                  
    case NVC097_SET_ALPHA_CIRCULAR_BUFFER_SIZE:

    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
    case NVC097_SET_SCREEN_STATE_MASK:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                      
    case NVC097_SET_ZT_SIZE_B:

    
        parsed = (data >> 0) & ((1u << 18) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                      
    case NVC097_SET_BACK_END_COPY_A:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.DWORDS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.SATURATE32_ENABLE = ", prefix);
        switch (parsed) {
        case NVC097_SET_BACK_END_COPY_A_SATURATE32_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC097_SET_BACK_END_COPY_A_SATURATE32_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.TIMESTAMP_ENABLE = ", prefix);
        switch (parsed) {
        case NVC097_SET_BACK_END_COPY_A_TIMESTAMP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC097_SET_BACK_END_COPY_A_TIMESTAMP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC097_SET_BACK_END_COPY_B:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SRC_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC097_SET_BACK_END_COPY_C:

    
        parsed = data;
        fprintf(fp, "%s.SRC_ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC097_SET_BACK_END_COPY_D:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.DEST_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC097_SET_BACK_END_COPY_E:

    
        parsed = data;
        fprintf(fp, "%s.DEST_ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC097_SET_CIRCULAR_BUFFER_SIZE:

    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    case NVC097_SET_REPORT_SEMAPHORE_D:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_OPERATION_REPORT_ONLY:
            fprintf(fp, "REPORT_ONLY\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE:
            fprintf(fp, "AFTER_ALL_PRECEEDING_READS_COMPLETE\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE:
            fprintf(fp, "AFTER_ALL_PRECEEDING_WRITES_COMPLETE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START:
            fprintf(fp, "BEFORE_ANY_FOLLOWING_WRITES_START\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START:
            fprintf(fp, "BEFORE_ANY_FOLLOWING_READS_START\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.PIPELINE_LOCATION = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DATA_ASSEMBLER:
            fprintf(fp, "DATA_ASSEMBLER\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VERTEX_SHADER:
            fprintf(fp, "VERTEX_SHADER\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_INIT_SHADER:
            fprintf(fp, "TESSELATION_INIT_SHADER\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_SHADER:
            fprintf(fp, "TESSELATION_SHADER\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_GEOMETRY_SHADER:
            fprintf(fp, "GEOMETRY_SHADER\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_STREAMING_OUTPUT:
            fprintf(fp, "STREAMING_OUTPUT\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VPC:
            fprintf(fp, "VPC\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ZCULL:
            fprintf(fp, "ZCULL\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_PIXEL_SHADER:
            fprintf(fp, "PIXEL_SHADER\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DEPTH_TEST:
            fprintf(fp, "DEPTH_TEST\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.COMPARISON = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_COMPARISON_EQ:
            fprintf(fp, "EQ\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_COMPARISON_GE:
            fprintf(fp, "GE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 23) & ((1u << 5) - 1);
        fprintf(fp, "%s.REPORT = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_DA_VERTICES_GENERATED:
            fprintf(fp, "DA_VERTICES_GENERATED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_DA_PRIMITIVES_GENERATED:
            fprintf(fp, "DA_PRIMITIVES_GENERATED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_VS_INVOCATIONS:
            fprintf(fp, "VS_INVOCATIONS\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_TI_INVOCATIONS:
            fprintf(fp, "TI_INVOCATIONS\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_TS_INVOCATIONS:
            fprintf(fp, "TS_INVOCATIONS\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_TS_PRIMITIVES_GENERATED:
            fprintf(fp, "TS_PRIMITIVES_GENERATED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_GS_INVOCATIONS:
            fprintf(fp, "GS_INVOCATIONS\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_GS_PRIMITIVES_GENERATED:
            fprintf(fp, "GS_PRIMITIVES_GENERATED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_ALPHA_BETA_CLOCKS:
            fprintf(fp, "ALPHA_BETA_CLOCKS\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_VTG_PRIMITIVES_OUT:
            fprintf(fp, "VTG_PRIMITIVES_OUT\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_SUCCEEDED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_BYTE_COUNT:
            fprintf(fp, "STREAMING_BYTE_COUNT\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_INVOCATIONS:
            fprintf(fp, "CLIPPER_INVOCATIONS\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_PRIMITIVES_GENERATED:
            fprintf(fp, "CLIPPER_PRIMITIVES_GENERATED\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS0:
            fprintf(fp, "ZCULL_STATS0\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS1:
            fprintf(fp, "ZCULL_STATS1\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS2:
            fprintf(fp, "ZCULL_STATS2\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS3:
            fprintf(fp, "ZCULL_STATS3\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_PS_INVOCATIONS:
            fprintf(fp, "PS_INVOCATIONS\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT:
            fprintf(fp, "ZPASS_PIXEL_CNT\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT64:
            fprintf(fp, "ZPASS_PIXEL_CNT64\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_TILED_ZPASS_PIXEL_CNT64:
            fprintf(fp, "TILED_ZPASS_PIXEL_CNT64\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_COLOR_TARGET:
            fprintf(fp, "IEEE_CLEAN_COLOR_TARGET\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_ZETA_TARGET:
            fprintf(fp, "IEEE_CLEAN_ZETA_TARGET\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REPORT_BOUNDING_RECTANGLE:
            fprintf(fp, "BOUNDING_RECTANGLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 3) - 1);
        fprintf(fp, "%s.SUB_REPORT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.REPORT_DWORD_NUMBER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC097_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                                                                                      
    case NVC097_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC097_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                }
}
