const char *sphere_ao_depth_fs =
  "//////////////////////////////////////////////////////////////////////\n"
  "//\n"
  "// Ambient occlusion shader for sphere impostors\n"
  "//\n"
  "// This fragment shader is used for rendering the depth texture from\n"
  "// the light source's view.\n"
  "//\n"
  "//////////////////////////////////////////////////////////////////////\n"
  "\n"
  "//\n"
  "// Input\n"
  "//\n"
  "\n"
  "// normalized corner: [-1, 1]\n"
  "#version 400\n"
  "precision highp float;\n"
  "\n"
  "in vec2 v_corner;\n"
  "\n"
  "out vec4 outColor;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  // figure out if we are inside our sphere\n"
  "  float zz = 1.0 - v_corner.x * v_corner.x - v_corner.y * v_corner.y;\n"
  "  if (zz <= 0.0)\n"
  "    discard;\n"
  "\n"
  "  // draw buffer is not attached, output any color\n"
  "  outColor = vec4(1.0, 1.0, 1.0, 1.0);\n"
  "}\n"
  "\n";
