// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	stderrors "errors"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// EndpointHealth Health of the endpoint
//
// +deepequal-gen=true
//
// swagger:model EndpointHealth
type EndpointHealth struct {

	// bpf
	Bpf EndpointHealthStatus `json:"bpf,omitempty"`

	// Is this endpoint reachable
	Connected bool `json:"connected,omitempty"`

	// overall health
	OverallHealth EndpointHealthStatus `json:"overallHealth,omitempty"`

	// policy
	Policy EndpointHealthStatus `json:"policy,omitempty"`
}

// Validate validates this endpoint health
func (m *EndpointHealth) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBpf(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOverallHealth(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EndpointHealth) validateBpf(formats strfmt.Registry) error {
	if swag.IsZero(m.Bpf) { // not required
		return nil
	}

	if err := m.Bpf.Validate(formats); err != nil {
		ve := new(errors.Validation)
		if stderrors.As(err, &ve) {
			return ve.ValidateName("bpf")
		}
		ce := new(errors.CompositeError)
		if stderrors.As(err, &ce) {
			return ce.ValidateName("bpf")
		}

		return err
	}

	return nil
}

func (m *EndpointHealth) validateOverallHealth(formats strfmt.Registry) error {
	if swag.IsZero(m.OverallHealth) { // not required
		return nil
	}

	if err := m.OverallHealth.Validate(formats); err != nil {
		ve := new(errors.Validation)
		if stderrors.As(err, &ve) {
			return ve.ValidateName("overallHealth")
		}
		ce := new(errors.CompositeError)
		if stderrors.As(err, &ce) {
			return ce.ValidateName("overallHealth")
		}

		return err
	}

	return nil
}

func (m *EndpointHealth) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if err := m.Policy.Validate(formats); err != nil {
		ve := new(errors.Validation)
		if stderrors.As(err, &ve) {
			return ve.ValidateName("policy")
		}
		ce := new(errors.CompositeError)
		if stderrors.As(err, &ce) {
			return ce.ValidateName("policy")
		}

		return err
	}

	return nil
}

// ContextValidate validate this endpoint health based on the context it is used
func (m *EndpointHealth) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBpf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverallHealth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EndpointHealth) contextValidateBpf(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Bpf) { // not required
		return nil
	}

	if err := m.Bpf.ContextValidate(ctx, formats); err != nil {
		ve := new(errors.Validation)
		if stderrors.As(err, &ve) {
			return ve.ValidateName("bpf")
		}
		ce := new(errors.CompositeError)
		if stderrors.As(err, &ce) {
			return ce.ValidateName("bpf")
		}

		return err
	}

	return nil
}

func (m *EndpointHealth) contextValidateOverallHealth(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.OverallHealth) { // not required
		return nil
	}

	if err := m.OverallHealth.ContextValidate(ctx, formats); err != nil {
		ve := new(errors.Validation)
		if stderrors.As(err, &ve) {
			return ve.ValidateName("overallHealth")
		}
		ce := new(errors.CompositeError)
		if stderrors.As(err, &ce) {
			return ce.ValidateName("overallHealth")
		}

		return err
	}

	return nil
}

func (m *EndpointHealth) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if err := m.Policy.ContextValidate(ctx, formats); err != nil {
		ve := new(errors.Validation)
		if stderrors.As(err, &ve) {
			return ve.ValidateName("policy")
		}
		ce := new(errors.CompositeError)
		if stderrors.As(err, &ce) {
			return ce.ValidateName("policy")
		}

		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EndpointHealth) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EndpointHealth) UnmarshalBinary(b []byte) error {
	var res EndpointHealth
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
